/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Overlay one or more videos on top of your input video. For more information, see
 * https://docs.aws.amazon.com/mediaconvert/latest/ug/video-overlays.html
 */
@Generated("software.amazon.awssdk:codegen")
public final class VideoOverlay implements SdkPojo, Serializable, ToCopyableBuilder<VideoOverlay.Builder, VideoOverlay> {
    private static final SdkField<String> END_TIMECODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EndTimecode").getter(getter(VideoOverlay::endTimecode)).setter(setter(Builder::endTimecode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTimecode").build()).build();

    private static final SdkField<VideoOverlayPosition> INITIAL_POSITION_FIELD = SdkField
            .<VideoOverlayPosition> builder(MarshallingType.SDK_POJO).memberName("InitialPosition")
            .getter(getter(VideoOverlay::initialPosition)).setter(setter(Builder::initialPosition))
            .constructor(VideoOverlayPosition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("initialPosition").build()).build();

    private static final SdkField<VideoOverlayInput> INPUT_FIELD = SdkField.<VideoOverlayInput> builder(MarshallingType.SDK_POJO)
            .memberName("Input").getter(getter(VideoOverlay::input)).setter(setter(Builder::input))
            .constructor(VideoOverlayInput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("input").build()).build();

    private static final SdkField<String> PLAYBACK_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Playback").getter(getter(VideoOverlay::playbackAsString)).setter(setter(Builder::playback))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("playback").build()).build();

    private static final SdkField<String> START_TIMECODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StartTimecode").getter(getter(VideoOverlay::startTimecode)).setter(setter(Builder::startTimecode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTimecode").build()).build();

    private static final SdkField<List<VideoOverlayTransition>> TRANSITIONS_FIELD = SdkField
            .<List<VideoOverlayTransition>> builder(MarshallingType.LIST)
            .memberName("Transitions")
            .getter(getter(VideoOverlay::transitions))
            .setter(setter(Builder::transitions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("transitions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<VideoOverlayTransition> builder(MarshallingType.SDK_POJO)
                                            .constructor(VideoOverlayTransition::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(END_TIMECODE_FIELD,
            INITIAL_POSITION_FIELD, INPUT_FIELD, PLAYBACK_FIELD, START_TIMECODE_FIELD, TRANSITIONS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String endTimecode;

    private final VideoOverlayPosition initialPosition;

    private final VideoOverlayInput input;

    private final String playback;

    private final String startTimecode;

    private final List<VideoOverlayTransition> transitions;

    private VideoOverlay(BuilderImpl builder) {
        this.endTimecode = builder.endTimecode;
        this.initialPosition = builder.initialPosition;
        this.input = builder.input;
        this.playback = builder.playback;
        this.startTimecode = builder.startTimecode;
        this.transitions = builder.transitions;
    }

    /**
     * Enter the end timecode in the base input video for this overlay. Your overlay will be active through this frame.
     * To display your video overlay for the duration of the base input video: Leave blank. Use the format HH:MM:SS:FF
     * or HH:MM:SS;FF, where HH is the hour, MM is the minute, SS isthe second, and FF is the frame number. When
     * entering this value, take into account your choice for the base input video's timecode source. For example, if
     * you have embedded timecodes that start at 01:00:00:00 and you want your overlay to end ten minutes into the
     * video, enter 01:10:00:00.
     * 
     * @return Enter the end timecode in the base input video for this overlay. Your overlay will be active through this
     *         frame. To display your video overlay for the duration of the base input video: Leave blank. Use the
     *         format HH:MM:SS:FF or HH:MM:SS;FF, where HH is the hour, MM is the minute, SS isthe second, and FF is the
     *         frame number. When entering this value, take into account your choice for the base input video's timecode
     *         source. For example, if you have embedded timecodes that start at 01:00:00:00 and you want your overlay
     *         to end ten minutes into the video, enter 01:10:00:00.
     */
    public final String endTimecode() {
        return endTimecode;
    }

    /**
     * Specify the Initial position of your video overlay. To specify the Initial position of your video overlay,
     * including distance from the left or top edge of the base input video's frame, or size: Enter a value for X
     * position, Y position, Width, or Height. To use the full frame of the base input video: Leave blank.
     * 
     * @return Specify the Initial position of your video overlay. To specify the Initial position of your video
     *         overlay, including distance from the left or top edge of the base input video's frame, or size: Enter a
     *         value for X position, Y position, Width, or Height. To use the full frame of the base input video: Leave
     *         blank.
     */
    public final VideoOverlayPosition initialPosition() {
        return initialPosition;
    }

    /**
     * Input settings for Video overlay. You can include one or more video overlays in sequence at different times that
     * you specify.
     * 
     * @return Input settings for Video overlay. You can include one or more video overlays in sequence at different
     *         times that you specify.
     */
    public final VideoOverlayInput input() {
        return input;
    }

    /**
     * Specify whether your video overlay repeats or plays only once. To repeat your video overlay on a loop: Keep the
     * default value, Repeat. Your overlay will repeat for the duration of the base input video. To playback your video
     * overlay only once: Choose Once. With either option, you can end playback at a time that you specify by entering a
     * value for End timecode.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #playback} will
     * return {@link VideoOverlayPlayBackMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #playbackAsString}.
     * </p>
     * 
     * @return Specify whether your video overlay repeats or plays only once. To repeat your video overlay on a loop:
     *         Keep the default value, Repeat. Your overlay will repeat for the duration of the base input video. To
     *         playback your video overlay only once: Choose Once. With either option, you can end playback at a time
     *         that you specify by entering a value for End timecode.
     * @see VideoOverlayPlayBackMode
     */
    public final VideoOverlayPlayBackMode playback() {
        return VideoOverlayPlayBackMode.fromValue(playback);
    }

    /**
     * Specify whether your video overlay repeats or plays only once. To repeat your video overlay on a loop: Keep the
     * default value, Repeat. Your overlay will repeat for the duration of the base input video. To playback your video
     * overlay only once: Choose Once. With either option, you can end playback at a time that you specify by entering a
     * value for End timecode.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #playback} will
     * return {@link VideoOverlayPlayBackMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #playbackAsString}.
     * </p>
     * 
     * @return Specify whether your video overlay repeats or plays only once. To repeat your video overlay on a loop:
     *         Keep the default value, Repeat. Your overlay will repeat for the duration of the base input video. To
     *         playback your video overlay only once: Choose Once. With either option, you can end playback at a time
     *         that you specify by entering a value for End timecode.
     * @see VideoOverlayPlayBackMode
     */
    public final String playbackAsString() {
        return playback;
    }

    /**
     * Enter the start timecode in the base input video for this overlay. Your overlay will be active starting with this
     * frame. To display your video overlay starting at the beginning of the base input video: Leave blank. Use the
     * format HH:MM:SS:FF or HH:MM:SS;FF, where HH is the hour, MM is the minute, SS is the second, and FF is the frame
     * number. When entering this value, take into account your choice for the base input video's timecode source. For
     * example, if you have embedded timecodes that start at 01:00:00:00 and you want your overlay to begin five minutes
     * into the video, enter 01:05:00:00.
     * 
     * @return Enter the start timecode in the base input video for this overlay. Your overlay will be active starting
     *         with this frame. To display your video overlay starting at the beginning of the base input video: Leave
     *         blank. Use the format HH:MM:SS:FF or HH:MM:SS;FF, where HH is the hour, MM is the minute, SS is the
     *         second, and FF is the frame number. When entering this value, take into account your choice for the base
     *         input video's timecode source. For example, if you have embedded timecodes that start at 01:00:00:00 and
     *         you want your overlay to begin five minutes into the video, enter 01:05:00:00.
     */
    public final String startTimecode() {
        return startTimecode;
    }

    /**
     * For responses, this returns true if the service returned a value for the Transitions property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTransitions() {
        return transitions != null && !(transitions instanceof SdkAutoConstructList);
    }

    /**
     * Specify one or more transitions for your video overlay. Use Transitions to reposition or resize your overlay over
     * time. To use the same position and size for the duration of your video overlay: Leave blank. To specify a
     * Transition: Enter a value for Start timecode, End Timecode, X Position, Y Position, Width, or Height.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTransitions} method.
     * </p>
     * 
     * @return Specify one or more transitions for your video overlay. Use Transitions to reposition or resize your
     *         overlay over time. To use the same position and size for the duration of your video overlay: Leave blank.
     *         To specify a Transition: Enter a value for Start timecode, End Timecode, X Position, Y Position, Width,
     *         or Height.
     */
    public final List<VideoOverlayTransition> transitions() {
        return transitions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(endTimecode());
        hashCode = 31 * hashCode + Objects.hashCode(initialPosition());
        hashCode = 31 * hashCode + Objects.hashCode(input());
        hashCode = 31 * hashCode + Objects.hashCode(playbackAsString());
        hashCode = 31 * hashCode + Objects.hashCode(startTimecode());
        hashCode = 31 * hashCode + Objects.hashCode(hasTransitions() ? transitions() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VideoOverlay)) {
            return false;
        }
        VideoOverlay other = (VideoOverlay) obj;
        return Objects.equals(endTimecode(), other.endTimecode()) && Objects.equals(initialPosition(), other.initialPosition())
                && Objects.equals(input(), other.input()) && Objects.equals(playbackAsString(), other.playbackAsString())
                && Objects.equals(startTimecode(), other.startTimecode()) && hasTransitions() == other.hasTransitions()
                && Objects.equals(transitions(), other.transitions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("VideoOverlay").add("EndTimecode", endTimecode()).add("InitialPosition", initialPosition())
                .add("Input", input()).add("Playback", playbackAsString()).add("StartTimecode", startTimecode())
                .add("Transitions", hasTransitions() ? transitions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EndTimecode":
            return Optional.ofNullable(clazz.cast(endTimecode()));
        case "InitialPosition":
            return Optional.ofNullable(clazz.cast(initialPosition()));
        case "Input":
            return Optional.ofNullable(clazz.cast(input()));
        case "Playback":
            return Optional.ofNullable(clazz.cast(playbackAsString()));
        case "StartTimecode":
            return Optional.ofNullable(clazz.cast(startTimecode()));
        case "Transitions":
            return Optional.ofNullable(clazz.cast(transitions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VideoOverlay, T> g) {
        return obj -> g.apply((VideoOverlay) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VideoOverlay> {
        /**
         * Enter the end timecode in the base input video for this overlay. Your overlay will be active through this
         * frame. To display your video overlay for the duration of the base input video: Leave blank. Use the format
         * HH:MM:SS:FF or HH:MM:SS;FF, where HH is the hour, MM is the minute, SS isthe second, and FF is the frame
         * number. When entering this value, take into account your choice for the base input video's timecode source.
         * For example, if you have embedded timecodes that start at 01:00:00:00 and you want your overlay to end ten
         * minutes into the video, enter 01:10:00:00.
         * 
         * @param endTimecode
         *        Enter the end timecode in the base input video for this overlay. Your overlay will be active through
         *        this frame. To display your video overlay for the duration of the base input video: Leave blank. Use
         *        the format HH:MM:SS:FF or HH:MM:SS;FF, where HH is the hour, MM is the minute, SS isthe second, and FF
         *        is the frame number. When entering this value, take into account your choice for the base input
         *        video's timecode source. For example, if you have embedded timecodes that start at 01:00:00:00 and you
         *        want your overlay to end ten minutes into the video, enter 01:10:00:00.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTimecode(String endTimecode);

        /**
         * Specify the Initial position of your video overlay. To specify the Initial position of your video overlay,
         * including distance from the left or top edge of the base input video's frame, or size: Enter a value for X
         * position, Y position, Width, or Height. To use the full frame of the base input video: Leave blank.
         * 
         * @param initialPosition
         *        Specify the Initial position of your video overlay. To specify the Initial position of your video
         *        overlay, including distance from the left or top edge of the base input video's frame, or size: Enter
         *        a value for X position, Y position, Width, or Height. To use the full frame of the base input video:
         *        Leave blank.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder initialPosition(VideoOverlayPosition initialPosition);

        /**
         * Specify the Initial position of your video overlay. To specify the Initial position of your video overlay,
         * including distance from the left or top edge of the base input video's frame, or size: Enter a value for X
         * position, Y position, Width, or Height. To use the full frame of the base input video: Leave blank. This is a
         * convenience method that creates an instance of the {@link VideoOverlayPosition.Builder} avoiding the need to
         * create one manually via {@link VideoOverlayPosition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VideoOverlayPosition.Builder#build()} is called immediately and
         * its result is passed to {@link #initialPosition(VideoOverlayPosition)}.
         * 
         * @param initialPosition
         *        a consumer that will call methods on {@link VideoOverlayPosition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #initialPosition(VideoOverlayPosition)
         */
        default Builder initialPosition(Consumer<VideoOverlayPosition.Builder> initialPosition) {
            return initialPosition(VideoOverlayPosition.builder().applyMutation(initialPosition).build());
        }

        /**
         * Input settings for Video overlay. You can include one or more video overlays in sequence at different times
         * that you specify.
         * 
         * @param input
         *        Input settings for Video overlay. You can include one or more video overlays in sequence at different
         *        times that you specify.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder input(VideoOverlayInput input);

        /**
         * Input settings for Video overlay. You can include one or more video overlays in sequence at different times
         * that you specify. This is a convenience method that creates an instance of the
         * {@link VideoOverlayInput.Builder} avoiding the need to create one manually via
         * {@link VideoOverlayInput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VideoOverlayInput.Builder#build()} is called immediately and its
         * result is passed to {@link #input(VideoOverlayInput)}.
         * 
         * @param input
         *        a consumer that will call methods on {@link VideoOverlayInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #input(VideoOverlayInput)
         */
        default Builder input(Consumer<VideoOverlayInput.Builder> input) {
            return input(VideoOverlayInput.builder().applyMutation(input).build());
        }

        /**
         * Specify whether your video overlay repeats or plays only once. To repeat your video overlay on a loop: Keep
         * the default value, Repeat. Your overlay will repeat for the duration of the base input video. To playback
         * your video overlay only once: Choose Once. With either option, you can end playback at a time that you
         * specify by entering a value for End timecode.
         * 
         * @param playback
         *        Specify whether your video overlay repeats or plays only once. To repeat your video overlay on a loop:
         *        Keep the default value, Repeat. Your overlay will repeat for the duration of the base input video. To
         *        playback your video overlay only once: Choose Once. With either option, you can end playback at a time
         *        that you specify by entering a value for End timecode.
         * @see VideoOverlayPlayBackMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VideoOverlayPlayBackMode
         */
        Builder playback(String playback);

        /**
         * Specify whether your video overlay repeats or plays only once. To repeat your video overlay on a loop: Keep
         * the default value, Repeat. Your overlay will repeat for the duration of the base input video. To playback
         * your video overlay only once: Choose Once. With either option, you can end playback at a time that you
         * specify by entering a value for End timecode.
         * 
         * @param playback
         *        Specify whether your video overlay repeats or plays only once. To repeat your video overlay on a loop:
         *        Keep the default value, Repeat. Your overlay will repeat for the duration of the base input video. To
         *        playback your video overlay only once: Choose Once. With either option, you can end playback at a time
         *        that you specify by entering a value for End timecode.
         * @see VideoOverlayPlayBackMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VideoOverlayPlayBackMode
         */
        Builder playback(VideoOverlayPlayBackMode playback);

        /**
         * Enter the start timecode in the base input video for this overlay. Your overlay will be active starting with
         * this frame. To display your video overlay starting at the beginning of the base input video: Leave blank. Use
         * the format HH:MM:SS:FF or HH:MM:SS;FF, where HH is the hour, MM is the minute, SS is the second, and FF is
         * the frame number. When entering this value, take into account your choice for the base input video's timecode
         * source. For example, if you have embedded timecodes that start at 01:00:00:00 and you want your overlay to
         * begin five minutes into the video, enter 01:05:00:00.
         * 
         * @param startTimecode
         *        Enter the start timecode in the base input video for this overlay. Your overlay will be active
         *        starting with this frame. To display your video overlay starting at the beginning of the base input
         *        video: Leave blank. Use the format HH:MM:SS:FF or HH:MM:SS;FF, where HH is the hour, MM is the minute,
         *        SS is the second, and FF is the frame number. When entering this value, take into account your choice
         *        for the base input video's timecode source. For example, if you have embedded timecodes that start at
         *        01:00:00:00 and you want your overlay to begin five minutes into the video, enter 01:05:00:00.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTimecode(String startTimecode);

        /**
         * Specify one or more transitions for your video overlay. Use Transitions to reposition or resize your overlay
         * over time. To use the same position and size for the duration of your video overlay: Leave blank. To specify
         * a Transition: Enter a value for Start timecode, End Timecode, X Position, Y Position, Width, or Height.
         * 
         * @param transitions
         *        Specify one or more transitions for your video overlay. Use Transitions to reposition or resize your
         *        overlay over time. To use the same position and size for the duration of your video overlay: Leave
         *        blank. To specify a Transition: Enter a value for Start timecode, End Timecode, X Position, Y
         *        Position, Width, or Height.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transitions(Collection<VideoOverlayTransition> transitions);

        /**
         * Specify one or more transitions for your video overlay. Use Transitions to reposition or resize your overlay
         * over time. To use the same position and size for the duration of your video overlay: Leave blank. To specify
         * a Transition: Enter a value for Start timecode, End Timecode, X Position, Y Position, Width, or Height.
         * 
         * @param transitions
         *        Specify one or more transitions for your video overlay. Use Transitions to reposition or resize your
         *        overlay over time. To use the same position and size for the duration of your video overlay: Leave
         *        blank. To specify a Transition: Enter a value for Start timecode, End Timecode, X Position, Y
         *        Position, Width, or Height.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transitions(VideoOverlayTransition... transitions);

        /**
         * Specify one or more transitions for your video overlay. Use Transitions to reposition or resize your overlay
         * over time. To use the same position and size for the duration of your video overlay: Leave blank. To specify
         * a Transition: Enter a value for Start timecode, End Timecode, X Position, Y Position, Width, or Height. This
         * is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.mediaconvert.model.VideoOverlayTransition.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.mediaconvert.model.VideoOverlayTransition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.mediaconvert.model.VideoOverlayTransition.Builder#build()} is called
         * immediately and its result is passed to {@link #transitions(List<VideoOverlayTransition>)}.
         * 
         * @param transitions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.mediaconvert.model.VideoOverlayTransition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #transitions(java.util.Collection<VideoOverlayTransition>)
         */
        Builder transitions(Consumer<VideoOverlayTransition.Builder>... transitions);
    }

    static final class BuilderImpl implements Builder {
        private String endTimecode;

        private VideoOverlayPosition initialPosition;

        private VideoOverlayInput input;

        private String playback;

        private String startTimecode;

        private List<VideoOverlayTransition> transitions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(VideoOverlay model) {
            endTimecode(model.endTimecode);
            initialPosition(model.initialPosition);
            input(model.input);
            playback(model.playback);
            startTimecode(model.startTimecode);
            transitions(model.transitions);
        }

        public final String getEndTimecode() {
            return endTimecode;
        }

        public final void setEndTimecode(String endTimecode) {
            this.endTimecode = endTimecode;
        }

        @Override
        public final Builder endTimecode(String endTimecode) {
            this.endTimecode = endTimecode;
            return this;
        }

        public final VideoOverlayPosition.Builder getInitialPosition() {
            return initialPosition != null ? initialPosition.toBuilder() : null;
        }

        public final void setInitialPosition(VideoOverlayPosition.BuilderImpl initialPosition) {
            this.initialPosition = initialPosition != null ? initialPosition.build() : null;
        }

        @Override
        public final Builder initialPosition(VideoOverlayPosition initialPosition) {
            this.initialPosition = initialPosition;
            return this;
        }

        public final VideoOverlayInput.Builder getInput() {
            return input != null ? input.toBuilder() : null;
        }

        public final void setInput(VideoOverlayInput.BuilderImpl input) {
            this.input = input != null ? input.build() : null;
        }

        @Override
        public final Builder input(VideoOverlayInput input) {
            this.input = input;
            return this;
        }

        public final String getPlayback() {
            return playback;
        }

        public final void setPlayback(String playback) {
            this.playback = playback;
        }

        @Override
        public final Builder playback(String playback) {
            this.playback = playback;
            return this;
        }

        @Override
        public final Builder playback(VideoOverlayPlayBackMode playback) {
            this.playback(playback == null ? null : playback.toString());
            return this;
        }

        public final String getStartTimecode() {
            return startTimecode;
        }

        public final void setStartTimecode(String startTimecode) {
            this.startTimecode = startTimecode;
        }

        @Override
        public final Builder startTimecode(String startTimecode) {
            this.startTimecode = startTimecode;
            return this;
        }

        public final List<VideoOverlayTransition.Builder> getTransitions() {
            List<VideoOverlayTransition.Builder> result = ___listOfVideoOverlayTransitionCopier.copyToBuilder(this.transitions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTransitions(Collection<VideoOverlayTransition.BuilderImpl> transitions) {
            this.transitions = ___listOfVideoOverlayTransitionCopier.copyFromBuilder(transitions);
        }

        @Override
        public final Builder transitions(Collection<VideoOverlayTransition> transitions) {
            this.transitions = ___listOfVideoOverlayTransitionCopier.copy(transitions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder transitions(VideoOverlayTransition... transitions) {
            transitions(Arrays.asList(transitions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder transitions(Consumer<VideoOverlayTransition.Builder>... transitions) {
            transitions(Stream.of(transitions).map(c -> VideoOverlayTransition.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public VideoOverlay build() {
            return new VideoOverlay(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
