/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Input settings for Video overlay. You can include one or more video overlays in sequence at different times that you
 * specify.
 */
@Generated("software.amazon.awssdk:codegen")
public final class VideoOverlayInput implements SdkPojo, Serializable,
        ToCopyableBuilder<VideoOverlayInput.Builder, VideoOverlayInput> {
    private static final SdkField<String> FILE_INPUT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FileInput").getter(getter(VideoOverlayInput::fileInput)).setter(setter(Builder::fileInput))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fileInput").build()).build();

    private static final SdkField<List<VideoOverlayInputClipping>> INPUT_CLIPPINGS_FIELD = SdkField
            .<List<VideoOverlayInputClipping>> builder(MarshallingType.LIST)
            .memberName("InputClippings")
            .getter(getter(VideoOverlayInput::inputClippings))
            .setter(setter(Builder::inputClippings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputClippings").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<VideoOverlayInputClipping> builder(MarshallingType.SDK_POJO)
                                            .constructor(VideoOverlayInputClipping::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> TIMECODE_SOURCE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TimecodeSource").getter(getter(VideoOverlayInput::timecodeSourceAsString))
            .setter(setter(Builder::timecodeSource))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timecodeSource").build()).build();

    private static final SdkField<String> TIMECODE_START_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TimecodeStart").getter(getter(VideoOverlayInput::timecodeStart)).setter(setter(Builder::timecodeStart))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timecodeStart").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILE_INPUT_FIELD,
            INPUT_CLIPPINGS_FIELD, TIMECODE_SOURCE_FIELD, TIMECODE_START_FIELD));

    private static final long serialVersionUID = 1L;

    private final String fileInput;

    private final List<VideoOverlayInputClipping> inputClippings;

    private final String timecodeSource;

    private final String timecodeStart;

    private VideoOverlayInput(BuilderImpl builder) {
        this.fileInput = builder.fileInput;
        this.inputClippings = builder.inputClippings;
        this.timecodeSource = builder.timecodeSource;
        this.timecodeStart = builder.timecodeStart;
    }

    /**
     * Specify the input file S3, HTTP, or HTTPS URL for your video overlay. To specify one or more Transitions for your
     * base input video instead: Leave blank.
     * 
     * @return Specify the input file S3, HTTP, or HTTPS URL for your video overlay. To specify one or more Transitions
     *         for your base input video instead: Leave blank.
     */
    public final String fileInput() {
        return fileInput;
    }

    /**
     * For responses, this returns true if the service returned a value for the InputClippings property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasInputClippings() {
        return inputClippings != null && !(inputClippings instanceof SdkAutoConstructList);
    }

    /**
     * Specify one or more clips to use from your video overlay. When you include an input clip, you must also specify
     * its start timecode, end timecode, or both start and end timecode.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInputClippings} method.
     * </p>
     * 
     * @return Specify one or more clips to use from your video overlay. When you include an input clip, you must also
     *         specify its start timecode, end timecode, or both start and end timecode.
     */
    public final List<VideoOverlayInputClipping> inputClippings() {
        return inputClippings;
    }

    /**
     * Specify the timecode source for your video overlay input clips. To use the timecode present in your video
     * overlay: Choose Embedded. To use a zerobased timecode: Choose Start at 0. To choose a timecode: Choose Specified
     * start. When you do, enter the starting timecode in Start timecode. If you don't specify a value for Timecode
     * source, MediaConvert uses Embedded by default.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #timecodeSource}
     * will return {@link InputTimecodeSource#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #timecodeSourceAsString}.
     * </p>
     * 
     * @return Specify the timecode source for your video overlay input clips. To use the timecode present in your video
     *         overlay: Choose Embedded. To use a zerobased timecode: Choose Start at 0. To choose a timecode: Choose
     *         Specified start. When you do, enter the starting timecode in Start timecode. If you don't specify a value
     *         for Timecode source, MediaConvert uses Embedded by default.
     * @see InputTimecodeSource
     */
    public final InputTimecodeSource timecodeSource() {
        return InputTimecodeSource.fromValue(timecodeSource);
    }

    /**
     * Specify the timecode source for your video overlay input clips. To use the timecode present in your video
     * overlay: Choose Embedded. To use a zerobased timecode: Choose Start at 0. To choose a timecode: Choose Specified
     * start. When you do, enter the starting timecode in Start timecode. If you don't specify a value for Timecode
     * source, MediaConvert uses Embedded by default.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #timecodeSource}
     * will return {@link InputTimecodeSource#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #timecodeSourceAsString}.
     * </p>
     * 
     * @return Specify the timecode source for your video overlay input clips. To use the timecode present in your video
     *         overlay: Choose Embedded. To use a zerobased timecode: Choose Start at 0. To choose a timecode: Choose
     *         Specified start. When you do, enter the starting timecode in Start timecode. If you don't specify a value
     *         for Timecode source, MediaConvert uses Embedded by default.
     * @see InputTimecodeSource
     */
    public final String timecodeSourceAsString() {
        return timecodeSource;
    }

    /**
     * Specify the starting timecode for this video overlay. To use this setting, you must set Timecode source to
     * Specified start.
     * 
     * @return Specify the starting timecode for this video overlay. To use this setting, you must set Timecode source
     *         to Specified start.
     */
    public final String timecodeStart() {
        return timecodeStart;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(fileInput());
        hashCode = 31 * hashCode + Objects.hashCode(hasInputClippings() ? inputClippings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(timecodeSourceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(timecodeStart());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VideoOverlayInput)) {
            return false;
        }
        VideoOverlayInput other = (VideoOverlayInput) obj;
        return Objects.equals(fileInput(), other.fileInput()) && hasInputClippings() == other.hasInputClippings()
                && Objects.equals(inputClippings(), other.inputClippings())
                && Objects.equals(timecodeSourceAsString(), other.timecodeSourceAsString())
                && Objects.equals(timecodeStart(), other.timecodeStart());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("VideoOverlayInput").add("FileInput", fileInput())
                .add("InputClippings", hasInputClippings() ? inputClippings() : null)
                .add("TimecodeSource", timecodeSourceAsString()).add("TimecodeStart", timecodeStart()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FileInput":
            return Optional.ofNullable(clazz.cast(fileInput()));
        case "InputClippings":
            return Optional.ofNullable(clazz.cast(inputClippings()));
        case "TimecodeSource":
            return Optional.ofNullable(clazz.cast(timecodeSourceAsString()));
        case "TimecodeStart":
            return Optional.ofNullable(clazz.cast(timecodeStart()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VideoOverlayInput, T> g) {
        return obj -> g.apply((VideoOverlayInput) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VideoOverlayInput> {
        /**
         * Specify the input file S3, HTTP, or HTTPS URL for your video overlay. To specify one or more Transitions for
         * your base input video instead: Leave blank.
         * 
         * @param fileInput
         *        Specify the input file S3, HTTP, or HTTPS URL for your video overlay. To specify one or more
         *        Transitions for your base input video instead: Leave blank.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileInput(String fileInput);

        /**
         * Specify one or more clips to use from your video overlay. When you include an input clip, you must also
         * specify its start timecode, end timecode, or both start and end timecode.
         * 
         * @param inputClippings
         *        Specify one or more clips to use from your video overlay. When you include an input clip, you must
         *        also specify its start timecode, end timecode, or both start and end timecode.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputClippings(Collection<VideoOverlayInputClipping> inputClippings);

        /**
         * Specify one or more clips to use from your video overlay. When you include an input clip, you must also
         * specify its start timecode, end timecode, or both start and end timecode.
         * 
         * @param inputClippings
         *        Specify one or more clips to use from your video overlay. When you include an input clip, you must
         *        also specify its start timecode, end timecode, or both start and end timecode.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputClippings(VideoOverlayInputClipping... inputClippings);

        /**
         * Specify one or more clips to use from your video overlay. When you include an input clip, you must also
         * specify its start timecode, end timecode, or both start and end timecode. This is a convenience method that
         * creates an instance of the
         * {@link software.amazon.awssdk.services.mediaconvert.model.VideoOverlayInputClipping.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.mediaconvert.model.VideoOverlayInputClipping#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.mediaconvert.model.VideoOverlayInputClipping.Builder#build()} is
         * called immediately and its result is passed to {@link #inputClippings(List<VideoOverlayInputClipping>)}.
         * 
         * @param inputClippings
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.mediaconvert.model.VideoOverlayInputClipping.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inputClippings(java.util.Collection<VideoOverlayInputClipping>)
         */
        Builder inputClippings(Consumer<VideoOverlayInputClipping.Builder>... inputClippings);

        /**
         * Specify the timecode source for your video overlay input clips. To use the timecode present in your video
         * overlay: Choose Embedded. To use a zerobased timecode: Choose Start at 0. To choose a timecode: Choose
         * Specified start. When you do, enter the starting timecode in Start timecode. If you don't specify a value for
         * Timecode source, MediaConvert uses Embedded by default.
         * 
         * @param timecodeSource
         *        Specify the timecode source for your video overlay input clips. To use the timecode present in your
         *        video overlay: Choose Embedded. To use a zerobased timecode: Choose Start at 0. To choose a timecode:
         *        Choose Specified start. When you do, enter the starting timecode in Start timecode. If you don't
         *        specify a value for Timecode source, MediaConvert uses Embedded by default.
         * @see InputTimecodeSource
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InputTimecodeSource
         */
        Builder timecodeSource(String timecodeSource);

        /**
         * Specify the timecode source for your video overlay input clips. To use the timecode present in your video
         * overlay: Choose Embedded. To use a zerobased timecode: Choose Start at 0. To choose a timecode: Choose
         * Specified start. When you do, enter the starting timecode in Start timecode. If you don't specify a value for
         * Timecode source, MediaConvert uses Embedded by default.
         * 
         * @param timecodeSource
         *        Specify the timecode source for your video overlay input clips. To use the timecode present in your
         *        video overlay: Choose Embedded. To use a zerobased timecode: Choose Start at 0. To choose a timecode:
         *        Choose Specified start. When you do, enter the starting timecode in Start timecode. If you don't
         *        specify a value for Timecode source, MediaConvert uses Embedded by default.
         * @see InputTimecodeSource
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InputTimecodeSource
         */
        Builder timecodeSource(InputTimecodeSource timecodeSource);

        /**
         * Specify the starting timecode for this video overlay. To use this setting, you must set Timecode source to
         * Specified start.
         * 
         * @param timecodeStart
         *        Specify the starting timecode for this video overlay. To use this setting, you must set Timecode
         *        source to Specified start.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timecodeStart(String timecodeStart);
    }

    static final class BuilderImpl implements Builder {
        private String fileInput;

        private List<VideoOverlayInputClipping> inputClippings = DefaultSdkAutoConstructList.getInstance();

        private String timecodeSource;

        private String timecodeStart;

        private BuilderImpl() {
        }

        private BuilderImpl(VideoOverlayInput model) {
            fileInput(model.fileInput);
            inputClippings(model.inputClippings);
            timecodeSource(model.timecodeSource);
            timecodeStart(model.timecodeStart);
        }

        public final String getFileInput() {
            return fileInput;
        }

        public final void setFileInput(String fileInput) {
            this.fileInput = fileInput;
        }

        @Override
        public final Builder fileInput(String fileInput) {
            this.fileInput = fileInput;
            return this;
        }

        public final List<VideoOverlayInputClipping.Builder> getInputClippings() {
            List<VideoOverlayInputClipping.Builder> result = ___listOfVideoOverlayInputClippingCopier
                    .copyToBuilder(this.inputClippings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInputClippings(Collection<VideoOverlayInputClipping.BuilderImpl> inputClippings) {
            this.inputClippings = ___listOfVideoOverlayInputClippingCopier.copyFromBuilder(inputClippings);
        }

        @Override
        public final Builder inputClippings(Collection<VideoOverlayInputClipping> inputClippings) {
            this.inputClippings = ___listOfVideoOverlayInputClippingCopier.copy(inputClippings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputClippings(VideoOverlayInputClipping... inputClippings) {
            inputClippings(Arrays.asList(inputClippings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputClippings(Consumer<VideoOverlayInputClipping.Builder>... inputClippings) {
            inputClippings(Stream.of(inputClippings).map(c -> VideoOverlayInputClipping.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getTimecodeSource() {
            return timecodeSource;
        }

        public final void setTimecodeSource(String timecodeSource) {
            this.timecodeSource = timecodeSource;
        }

        @Override
        public final Builder timecodeSource(String timecodeSource) {
            this.timecodeSource = timecodeSource;
            return this;
        }

        @Override
        public final Builder timecodeSource(InputTimecodeSource timecodeSource) {
            this.timecodeSource(timecodeSource == null ? null : timecodeSource.toString());
            return this;
        }

        public final String getTimecodeStart() {
            return timecodeStart;
        }

        public final void setTimecodeStart(String timecodeStart) {
            this.timecodeStart = timecodeStart;
        }

        @Override
        public final Builder timecodeStart(String timecodeStart) {
            this.timecodeStart = timecodeStart;
            return this;
        }

        @Override
        public VideoOverlayInput build() {
            return new VideoOverlayInput(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
