/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * position of video overlay
 */
@Generated("software.amazon.awssdk:codegen")
public final class VideoOverlayPosition implements SdkPojo, Serializable,
        ToCopyableBuilder<VideoOverlayPosition.Builder, VideoOverlayPosition> {
    private static final SdkField<Integer> HEIGHT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Height").getter(getter(VideoOverlayPosition::height)).setter(setter(Builder::height))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("height").build()).build();

    private static final SdkField<String> UNIT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Unit")
            .getter(getter(VideoOverlayPosition::unitAsString)).setter(setter(Builder::unit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("unit").build()).build();

    private static final SdkField<Integer> WIDTH_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Width")
            .getter(getter(VideoOverlayPosition::width)).setter(setter(Builder::width))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("width").build()).build();

    private static final SdkField<Integer> X_POSITION_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("XPosition").getter(getter(VideoOverlayPosition::xPosition)).setter(setter(Builder::xPosition))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("xPosition").build()).build();

    private static final SdkField<Integer> Y_POSITION_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("YPosition").getter(getter(VideoOverlayPosition::yPosition)).setter(setter(Builder::yPosition))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("yPosition").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HEIGHT_FIELD, UNIT_FIELD,
            WIDTH_FIELD, X_POSITION_FIELD, Y_POSITION_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer height;

    private final String unit;

    private final Integer width;

    private final Integer xPosition;

    private final Integer yPosition;

    private VideoOverlayPosition(BuilderImpl builder) {
        this.height = builder.height;
        this.unit = builder.unit;
        this.width = builder.width;
        this.xPosition = builder.xPosition;
        this.yPosition = builder.yPosition;
    }

    /**
     * To scale your video overlay to the same height as the base input video: Leave blank. To scale the height of your
     * video overlay to a different height: Enter an integer representing the Unit type that you choose, either Pixels
     * or Percentage. For example, when you enter 360 and choose Pixels, your video overlay will be rendered with a
     * height of 360. When you enter 50, choose Percentage, and your overlay's source has a height of 1080, your video
     * overlay will be rendered with a height of 540. To scale your overlay to a specific height while automatically
     * maintaining its original aspect ratio, enter a value for Height and leave Width blank.
     * 
     * @return To scale your video overlay to the same height as the base input video: Leave blank. To scale the height
     *         of your video overlay to a different height: Enter an integer representing the Unit type that you choose,
     *         either Pixels or Percentage. For example, when you enter 360 and choose Pixels, your video overlay will
     *         be rendered with a height of 360. When you enter 50, choose Percentage, and your overlay's source has a
     *         height of 1080, your video overlay will be rendered with a height of 540. To scale your overlay to a
     *         specific height while automatically maintaining its original aspect ratio, enter a value for Height and
     *         leave Width blank.
     */
    public final Integer height() {
        return height;
    }

    /**
     * Specify the Unit type to use when you enter a value for X position, Y position, Width, or Height. You can choose
     * Pixels or Percentage. Leave blank to use the default value, Pixels.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #unit} will return
     * {@link VideoOverlayUnit#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #unitAsString}.
     * </p>
     * 
     * @return Specify the Unit type to use when you enter a value for X position, Y position, Width, or Height. You can
     *         choose Pixels or Percentage. Leave blank to use the default value, Pixels.
     * @see VideoOverlayUnit
     */
    public final VideoOverlayUnit unit() {
        return VideoOverlayUnit.fromValue(unit);
    }

    /**
     * Specify the Unit type to use when you enter a value for X position, Y position, Width, or Height. You can choose
     * Pixels or Percentage. Leave blank to use the default value, Pixels.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #unit} will return
     * {@link VideoOverlayUnit#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #unitAsString}.
     * </p>
     * 
     * @return Specify the Unit type to use when you enter a value for X position, Y position, Width, or Height. You can
     *         choose Pixels or Percentage. Leave blank to use the default value, Pixels.
     * @see VideoOverlayUnit
     */
    public final String unitAsString() {
        return unit;
    }

    /**
     * To scale your video overlay to the same width as the base input video: Leave blank. To scale the width of your
     * video overlay to a different width: Enter an integer representing the Unit type that you choose, either Pixels or
     * Percentage. For example, when you enter 640 and choose Pixels, your video overlay will scale to a height of 640
     * pixels. When you enter 50, choose Percentage, and your overlay's source has a width of 1920, your video overlay
     * will scale to a width of 960. To scale your overlay to a specific width while automatically maintaining its
     * original aspect ratio, enter a value for Width and leave Height blank.
     * 
     * @return To scale your video overlay to the same width as the base input video: Leave blank. To scale the width of
     *         your video overlay to a different width: Enter an integer representing the Unit type that you choose,
     *         either Pixels or Percentage. For example, when you enter 640 and choose Pixels, your video overlay will
     *         scale to a height of 640 pixels. When you enter 50, choose Percentage, and your overlay's source has a
     *         width of 1920, your video overlay will scale to a width of 960. To scale your overlay to a specific width
     *         while automatically maintaining its original aspect ratio, enter a value for Width and leave Height
     *         blank.
     */
    public final Integer width() {
        return width;
    }

    /**
     * To position the left edge of your video overlay along the left edge of the base input video's frame: Keep blank,
     * or enter 0. To position the left edge of your video overlay to the right, relative to the left edge of the base
     * input video's frame: Enter an integer representing the Unit type that you choose, either Pixels or Percentage.
     * For example, when you enter 10 and choose Pixels, your video overlay will be positioned 10 pixels from the left
     * edge of the base input video's frame. When you enter 10, choose Percentage, and your base input video is
     * 1920x1080, your video overlay will be positioned 192 pixels from the left edge of the base input video's frame.
     * 
     * @return To position the left edge of your video overlay along the left edge of the base input video's frame: Keep
     *         blank, or enter 0. To position the left edge of your video overlay to the right, relative to the left
     *         edge of the base input video's frame: Enter an integer representing the Unit type that you choose, either
     *         Pixels or Percentage. For example, when you enter 10 and choose Pixels, your video overlay will be
     *         positioned 10 pixels from the left edge of the base input video's frame. When you enter 10, choose
     *         Percentage, and your base input video is 1920x1080, your video overlay will be positioned 192 pixels from
     *         the left edge of the base input video's frame.
     */
    public final Integer xPosition() {
        return xPosition;
    }

    /**
     * To position the top edge of your video overlay along the top edge of the base input video's frame: Keep blank, or
     * enter 0. To position the top edge of your video overlay down, relative to the top edge of the base input video's
     * frame: Enter an integer representing the Unit type that you choose, either Pixels or Percentage. For example,
     * when you enter 10 and choose Pixels, your video overlay will be positioned 10 pixels from the top edge of the
     * base input video's frame. When you enter 10, choose Percentage, and your underlying video is 1920x1080, your
     * video overlay will be positioned 108 pixels from the top edge of the base input video's frame.
     * 
     * @return To position the top edge of your video overlay along the top edge of the base input video's frame: Keep
     *         blank, or enter 0. To position the top edge of your video overlay down, relative to the top edge of the
     *         base input video's frame: Enter an integer representing the Unit type that you choose, either Pixels or
     *         Percentage. For example, when you enter 10 and choose Pixels, your video overlay will be positioned 10
     *         pixels from the top edge of the base input video's frame. When you enter 10, choose Percentage, and your
     *         underlying video is 1920x1080, your video overlay will be positioned 108 pixels from the top edge of the
     *         base input video's frame.
     */
    public final Integer yPosition() {
        return yPosition;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(height());
        hashCode = 31 * hashCode + Objects.hashCode(unitAsString());
        hashCode = 31 * hashCode + Objects.hashCode(width());
        hashCode = 31 * hashCode + Objects.hashCode(xPosition());
        hashCode = 31 * hashCode + Objects.hashCode(yPosition());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VideoOverlayPosition)) {
            return false;
        }
        VideoOverlayPosition other = (VideoOverlayPosition) obj;
        return Objects.equals(height(), other.height()) && Objects.equals(unitAsString(), other.unitAsString())
                && Objects.equals(width(), other.width()) && Objects.equals(xPosition(), other.xPosition())
                && Objects.equals(yPosition(), other.yPosition());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("VideoOverlayPosition").add("Height", height()).add("Unit", unitAsString()).add("Width", width())
                .add("XPosition", xPosition()).add("YPosition", yPosition()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Height":
            return Optional.ofNullable(clazz.cast(height()));
        case "Unit":
            return Optional.ofNullable(clazz.cast(unitAsString()));
        case "Width":
            return Optional.ofNullable(clazz.cast(width()));
        case "XPosition":
            return Optional.ofNullable(clazz.cast(xPosition()));
        case "YPosition":
            return Optional.ofNullable(clazz.cast(yPosition()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VideoOverlayPosition, T> g) {
        return obj -> g.apply((VideoOverlayPosition) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VideoOverlayPosition> {
        /**
         * To scale your video overlay to the same height as the base input video: Leave blank. To scale the height of
         * your video overlay to a different height: Enter an integer representing the Unit type that you choose, either
         * Pixels or Percentage. For example, when you enter 360 and choose Pixels, your video overlay will be rendered
         * with a height of 360. When you enter 50, choose Percentage, and your overlay's source has a height of 1080,
         * your video overlay will be rendered with a height of 540. To scale your overlay to a specific height while
         * automatically maintaining its original aspect ratio, enter a value for Height and leave Width blank.
         * 
         * @param height
         *        To scale your video overlay to the same height as the base input video: Leave blank. To scale the
         *        height of your video overlay to a different height: Enter an integer representing the Unit type that
         *        you choose, either Pixels or Percentage. For example, when you enter 360 and choose Pixels, your video
         *        overlay will be rendered with a height of 360. When you enter 50, choose Percentage, and your
         *        overlay's source has a height of 1080, your video overlay will be rendered with a height of 540. To
         *        scale your overlay to a specific height while automatically maintaining its original aspect ratio,
         *        enter a value for Height and leave Width blank.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder height(Integer height);

        /**
         * Specify the Unit type to use when you enter a value for X position, Y position, Width, or Height. You can
         * choose Pixels or Percentage. Leave blank to use the default value, Pixels.
         * 
         * @param unit
         *        Specify the Unit type to use when you enter a value for X position, Y position, Width, or Height. You
         *        can choose Pixels or Percentage. Leave blank to use the default value, Pixels.
         * @see VideoOverlayUnit
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VideoOverlayUnit
         */
        Builder unit(String unit);

        /**
         * Specify the Unit type to use when you enter a value for X position, Y position, Width, or Height. You can
         * choose Pixels or Percentage. Leave blank to use the default value, Pixels.
         * 
         * @param unit
         *        Specify the Unit type to use when you enter a value for X position, Y position, Width, or Height. You
         *        can choose Pixels or Percentage. Leave blank to use the default value, Pixels.
         * @see VideoOverlayUnit
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VideoOverlayUnit
         */
        Builder unit(VideoOverlayUnit unit);

        /**
         * To scale your video overlay to the same width as the base input video: Leave blank. To scale the width of
         * your video overlay to a different width: Enter an integer representing the Unit type that you choose, either
         * Pixels or Percentage. For example, when you enter 640 and choose Pixels, your video overlay will scale to a
         * height of 640 pixels. When you enter 50, choose Percentage, and your overlay's source has a width of 1920,
         * your video overlay will scale to a width of 960. To scale your overlay to a specific width while
         * automatically maintaining its original aspect ratio, enter a value for Width and leave Height blank.
         * 
         * @param width
         *        To scale your video overlay to the same width as the base input video: Leave blank. To scale the width
         *        of your video overlay to a different width: Enter an integer representing the Unit type that you
         *        choose, either Pixels or Percentage. For example, when you enter 640 and choose Pixels, your video
         *        overlay will scale to a height of 640 pixels. When you enter 50, choose Percentage, and your overlay's
         *        source has a width of 1920, your video overlay will scale to a width of 960. To scale your overlay to
         *        a specific width while automatically maintaining its original aspect ratio, enter a value for Width
         *        and leave Height blank.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder width(Integer width);

        /**
         * To position the left edge of your video overlay along the left edge of the base input video's frame: Keep
         * blank, or enter 0. To position the left edge of your video overlay to the right, relative to the left edge of
         * the base input video's frame: Enter an integer representing the Unit type that you choose, either Pixels or
         * Percentage. For example, when you enter 10 and choose Pixels, your video overlay will be positioned 10 pixels
         * from the left edge of the base input video's frame. When you enter 10, choose Percentage, and your base input
         * video is 1920x1080, your video overlay will be positioned 192 pixels from the left edge of the base input
         * video's frame.
         * 
         * @param xPosition
         *        To position the left edge of your video overlay along the left edge of the base input video's frame:
         *        Keep blank, or enter 0. To position the left edge of your video overlay to the right, relative to the
         *        left edge of the base input video's frame: Enter an integer representing the Unit type that you
         *        choose, either Pixels or Percentage. For example, when you enter 10 and choose Pixels, your video
         *        overlay will be positioned 10 pixels from the left edge of the base input video's frame. When you
         *        enter 10, choose Percentage, and your base input video is 1920x1080, your video overlay will be
         *        positioned 192 pixels from the left edge of the base input video's frame.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder xPosition(Integer xPosition);

        /**
         * To position the top edge of your video overlay along the top edge of the base input video's frame: Keep
         * blank, or enter 0. To position the top edge of your video overlay down, relative to the top edge of the base
         * input video's frame: Enter an integer representing the Unit type that you choose, either Pixels or
         * Percentage. For example, when you enter 10 and choose Pixels, your video overlay will be positioned 10 pixels
         * from the top edge of the base input video's frame. When you enter 10, choose Percentage, and your underlying
         * video is 1920x1080, your video overlay will be positioned 108 pixels from the top edge of the base input
         * video's frame.
         * 
         * @param yPosition
         *        To position the top edge of your video overlay along the top edge of the base input video's frame:
         *        Keep blank, or enter 0. To position the top edge of your video overlay down, relative to the top edge
         *        of the base input video's frame: Enter an integer representing the Unit type that you choose, either
         *        Pixels or Percentage. For example, when you enter 10 and choose Pixels, your video overlay will be
         *        positioned 10 pixels from the top edge of the base input video's frame. When you enter 10, choose
         *        Percentage, and your underlying video is 1920x1080, your video overlay will be positioned 108 pixels
         *        from the top edge of the base input video's frame.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder yPosition(Integer yPosition);
    }

    static final class BuilderImpl implements Builder {
        private Integer height;

        private String unit;

        private Integer width;

        private Integer xPosition;

        private Integer yPosition;

        private BuilderImpl() {
        }

        private BuilderImpl(VideoOverlayPosition model) {
            height(model.height);
            unit(model.unit);
            width(model.width);
            xPosition(model.xPosition);
            yPosition(model.yPosition);
        }

        public final Integer getHeight() {
            return height;
        }

        public final void setHeight(Integer height) {
            this.height = height;
        }

        @Override
        public final Builder height(Integer height) {
            this.height = height;
            return this;
        }

        public final String getUnit() {
            return unit;
        }

        public final void setUnit(String unit) {
            this.unit = unit;
        }

        @Override
        public final Builder unit(String unit) {
            this.unit = unit;
            return this;
        }

        @Override
        public final Builder unit(VideoOverlayUnit unit) {
            this.unit(unit == null ? null : unit.toString());
            return this;
        }

        public final Integer getWidth() {
            return width;
        }

        public final void setWidth(Integer width) {
            this.width = width;
        }

        @Override
        public final Builder width(Integer width) {
            this.width = width;
            return this;
        }

        public final Integer getXPosition() {
            return xPosition;
        }

        public final void setXPosition(Integer xPosition) {
            this.xPosition = xPosition;
        }

        @Override
        public final Builder xPosition(Integer xPosition) {
            this.xPosition = xPosition;
            return this;
        }

        public final Integer getYPosition() {
            return yPosition;
        }

        public final void setYPosition(Integer yPosition) {
            this.yPosition = yPosition;
        }

        @Override
        public final Builder yPosition(Integer yPosition) {
            this.yPosition = yPosition;
            return this;
        }

        @Override
        public VideoOverlayPosition build() {
            return new VideoOverlayPosition(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
