/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.mediaconvert.model.AutomatedAbrRule;
import software.amazon.awssdk.services.mediaconvert.model.___listOfAutomatedAbrRuleCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AutomatedAbrSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AutomatedAbrSettings> {
    private static final SdkField<Integer> MAX_ABR_BITRATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxAbrBitrate").getter(AutomatedAbrSettings.getter(AutomatedAbrSettings::maxAbrBitrate)).setter(AutomatedAbrSettings.setter(Builder::maxAbrBitrate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxAbrBitrate").build()}).build();
    private static final SdkField<Integer> MAX_RENDITIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxRenditions").getter(AutomatedAbrSettings.getter(AutomatedAbrSettings::maxRenditions)).setter(AutomatedAbrSettings.setter(Builder::maxRenditions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxRenditions").build()}).build();
    private static final SdkField<Integer> MIN_ABR_BITRATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MinAbrBitrate").getter(AutomatedAbrSettings.getter(AutomatedAbrSettings::minAbrBitrate)).setter(AutomatedAbrSettings.setter(Builder::minAbrBitrate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("minAbrBitrate").build()}).build();
    private static final SdkField<List<AutomatedAbrRule>> RULES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Rules").getter(AutomatedAbrSettings.getter(AutomatedAbrSettings::rules)).setter(AutomatedAbrSettings.setter(Builder::rules)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rules").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AutomatedAbrRule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAX_ABR_BITRATE_FIELD, MAX_RENDITIONS_FIELD, MIN_ABR_BITRATE_FIELD, RULES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AutomatedAbrSettings.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Integer maxAbrBitrate;
    private final Integer maxRenditions;
    private final Integer minAbrBitrate;
    private final List<AutomatedAbrRule> rules;

    private AutomatedAbrSettings(BuilderImpl builder) {
        this.maxAbrBitrate = builder.maxAbrBitrate;
        this.maxRenditions = builder.maxRenditions;
        this.minAbrBitrate = builder.minAbrBitrate;
        this.rules = builder.rules;
    }

    public final Integer maxAbrBitrate() {
        return this.maxAbrBitrate;
    }

    public final Integer maxRenditions() {
        return this.maxRenditions;
    }

    public final Integer minAbrBitrate() {
        return this.minAbrBitrate;
    }

    public final boolean hasRules() {
        return this.rules != null && !(this.rules instanceof SdkAutoConstructList);
    }

    public final List<AutomatedAbrRule> rules() {
        return this.rules;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.maxAbrBitrate());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxRenditions());
        hashCode = 31 * hashCode + Objects.hashCode(this.minAbrBitrate());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRules() ? this.rules() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutomatedAbrSettings)) {
            return false;
        }
        AutomatedAbrSettings other = (AutomatedAbrSettings)obj;
        return Objects.equals(this.maxAbrBitrate(), other.maxAbrBitrate()) && Objects.equals(this.maxRenditions(), other.maxRenditions()) && Objects.equals(this.minAbrBitrate(), other.minAbrBitrate()) && this.hasRules() == other.hasRules() && Objects.equals(this.rules(), other.rules());
    }

    public final String toString() {
        return ToString.builder((String)"AutomatedAbrSettings").add("MaxAbrBitrate", (Object)this.maxAbrBitrate()).add("MaxRenditions", (Object)this.maxRenditions()).add("MinAbrBitrate", (Object)this.minAbrBitrate()).add("Rules", this.hasRules() ? this.rules() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MaxAbrBitrate": {
                return Optional.ofNullable(clazz.cast(this.maxAbrBitrate()));
            }
            case "MaxRenditions": {
                return Optional.ofNullable(clazz.cast(this.maxRenditions()));
            }
            case "MinAbrBitrate": {
                return Optional.ofNullable(clazz.cast(this.minAbrBitrate()));
            }
            case "Rules": {
                return Optional.ofNullable(clazz.cast(this.rules()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("maxAbrBitrate", MAX_ABR_BITRATE_FIELD);
        map.put("maxRenditions", MAX_RENDITIONS_FIELD);
        map.put("minAbrBitrate", MIN_ABR_BITRATE_FIELD);
        map.put("rules", RULES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AutomatedAbrSettings, T> g) {
        return obj -> g.apply((AutomatedAbrSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer maxAbrBitrate;
        private Integer maxRenditions;
        private Integer minAbrBitrate;
        private List<AutomatedAbrRule> rules = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AutomatedAbrSettings model) {
            this.maxAbrBitrate(model.maxAbrBitrate);
            this.maxRenditions(model.maxRenditions);
            this.minAbrBitrate(model.minAbrBitrate);
            this.rules(model.rules);
        }

        public final Integer getMaxAbrBitrate() {
            return this.maxAbrBitrate;
        }

        public final void setMaxAbrBitrate(Integer maxAbrBitrate) {
            this.maxAbrBitrate = maxAbrBitrate;
        }

        @Override
        public final Builder maxAbrBitrate(Integer maxAbrBitrate) {
            this.maxAbrBitrate = maxAbrBitrate;
            return this;
        }

        public final Integer getMaxRenditions() {
            return this.maxRenditions;
        }

        public final void setMaxRenditions(Integer maxRenditions) {
            this.maxRenditions = maxRenditions;
        }

        @Override
        public final Builder maxRenditions(Integer maxRenditions) {
            this.maxRenditions = maxRenditions;
            return this;
        }

        public final Integer getMinAbrBitrate() {
            return this.minAbrBitrate;
        }

        public final void setMinAbrBitrate(Integer minAbrBitrate) {
            this.minAbrBitrate = minAbrBitrate;
        }

        @Override
        public final Builder minAbrBitrate(Integer minAbrBitrate) {
            this.minAbrBitrate = minAbrBitrate;
            return this;
        }

        public final List<AutomatedAbrRule.Builder> getRules() {
            List<AutomatedAbrRule.Builder> result = ___listOfAutomatedAbrRuleCopier.copyToBuilder(this.rules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRules(Collection<AutomatedAbrRule.BuilderImpl> rules) {
            this.rules = ___listOfAutomatedAbrRuleCopier.copyFromBuilder(rules);
        }

        @Override
        public final Builder rules(Collection<AutomatedAbrRule> rules) {
            this.rules = ___listOfAutomatedAbrRuleCopier.copy(rules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rules(AutomatedAbrRule ... rules) {
            this.rules(Arrays.asList(rules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rules(Consumer<AutomatedAbrRule.Builder> ... rules) {
            this.rules(Stream.of(rules).map(c -> (AutomatedAbrRule)((AutomatedAbrRule.Builder)AutomatedAbrRule.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public AutomatedAbrSettings build() {
            return new AutomatedAbrSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AutomatedAbrSettings> {
        public Builder maxAbrBitrate(Integer var1);

        public Builder maxRenditions(Integer var1);

        public Builder minAbrBitrate(Integer var1);

        public Builder rules(Collection<AutomatedAbrRule> var1);

        public Builder rules(AutomatedAbrRule ... var1);

        public Builder rules(Consumer<AutomatedAbrRule.Builder> ... var1);
    }
}

