/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Use automated ABR to have MediaConvert set up the renditions in your ABR package for you automatically, based on
 * characteristics of your input video. This feature optimizes video quality while minimizing the overall size of your
 * ABR package.
 */
@Generated("software.amazon.awssdk:codegen")
public final class AutomatedAbrSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<AutomatedAbrSettings.Builder, AutomatedAbrSettings> {
    private static final SdkField<Integer> MAX_ABR_BITRATE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxAbrBitrate").getter(getter(AutomatedAbrSettings::maxAbrBitrate))
            .setter(setter(Builder::maxAbrBitrate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxAbrBitrate").build()).build();

    private static final SdkField<Integer> MAX_RENDITIONS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxRenditions").getter(getter(AutomatedAbrSettings::maxRenditions))
            .setter(setter(Builder::maxRenditions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxRenditions").build()).build();

    private static final SdkField<Integer> MIN_ABR_BITRATE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MinAbrBitrate").getter(getter(AutomatedAbrSettings::minAbrBitrate))
            .setter(setter(Builder::minAbrBitrate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("minAbrBitrate").build()).build();

    private static final SdkField<List<AutomatedAbrRule>> RULES_FIELD = SdkField
            .<List<AutomatedAbrRule>> builder(MarshallingType.LIST)
            .memberName("Rules")
            .getter(getter(AutomatedAbrSettings::rules))
            .setter(setter(Builder::rules))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rules").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AutomatedAbrRule> builder(MarshallingType.SDK_POJO)
                                            .constructor(AutomatedAbrRule::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAX_ABR_BITRATE_FIELD,
            MAX_RENDITIONS_FIELD, MIN_ABR_BITRATE_FIELD, RULES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer maxAbrBitrate;

    private final Integer maxRenditions;

    private final Integer minAbrBitrate;

    private final List<AutomatedAbrRule> rules;

    private AutomatedAbrSettings(BuilderImpl builder) {
        this.maxAbrBitrate = builder.maxAbrBitrate;
        this.maxRenditions = builder.maxRenditions;
        this.minAbrBitrate = builder.minAbrBitrate;
        this.rules = builder.rules;
    }

    /**
     * Specify the maximum average bitrate for MediaConvert to use in your automated ABR stack. If you don't specify a
     * value, MediaConvert uses 8,000,000 (8 mb/s) by default. The average bitrate of your highest-quality rendition
     * will be equal to or below this value, depending on the quality, complexity, and resolution of your content. Note
     * that the instantaneous maximum bitrate may vary above the value that you specify.
     * 
     * @return Specify the maximum average bitrate for MediaConvert to use in your automated ABR stack. If you don't
     *         specify a value, MediaConvert uses 8,000,000 (8 mb/s) by default. The average bitrate of your
     *         highest-quality rendition will be equal to or below this value, depending on the quality, complexity, and
     *         resolution of your content. Note that the instantaneous maximum bitrate may vary above the value that you
     *         specify.
     */
    public final Integer maxAbrBitrate() {
        return maxAbrBitrate;
    }

    /**
     * Optional. The maximum number of renditions that MediaConvert will create in your automated ABR stack. The number
     * of renditions is determined automatically, based on analysis of each job, but will never exceed this limit. When
     * you set this to Auto in the console, which is equivalent to excluding it from your JSON job specification,
     * MediaConvert defaults to a limit of 15.
     * 
     * @return Optional. The maximum number of renditions that MediaConvert will create in your automated ABR stack. The
     *         number of renditions is determined automatically, based on analysis of each job, but will never exceed
     *         this limit. When you set this to Auto in the console, which is equivalent to excluding it from your JSON
     *         job specification, MediaConvert defaults to a limit of 15.
     */
    public final Integer maxRenditions() {
        return maxRenditions;
    }

    /**
     * Specify the minimum average bitrate for MediaConvert to use in your automated ABR stack. If you don't specify a
     * value, MediaConvert uses 600,000 (600 kb/s) by default. The average bitrate of your lowest-quality rendition will
     * be near this value. Note that the instantaneous minimum bitrate may vary below the value that you specify.
     * 
     * @return Specify the minimum average bitrate for MediaConvert to use in your automated ABR stack. If you don't
     *         specify a value, MediaConvert uses 600,000 (600 kb/s) by default. The average bitrate of your
     *         lowest-quality rendition will be near this value. Note that the instantaneous minimum bitrate may vary
     *         below the value that you specify.
     */
    public final Integer minAbrBitrate() {
        return minAbrBitrate;
    }

    /**
     * For responses, this returns true if the service returned a value for the Rules property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasRules() {
        return rules != null && !(rules instanceof SdkAutoConstructList);
    }

    /**
     * Optional. Use Automated ABR rules to specify restrictions for the rendition sizes MediaConvert will create in
     * your ABR stack. You can use these rules if your ABR workflow has specific rendition size requirements, but you
     * still want MediaConvert to optimize for video quality and overall file size.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRules} method.
     * </p>
     * 
     * @return Optional. Use Automated ABR rules to specify restrictions for the rendition sizes MediaConvert will
     *         create in your ABR stack. You can use these rules if your ABR workflow has specific rendition size
     *         requirements, but you still want MediaConvert to optimize for video quality and overall file size.
     */
    public final List<AutomatedAbrRule> rules() {
        return rules;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(maxAbrBitrate());
        hashCode = 31 * hashCode + Objects.hashCode(maxRenditions());
        hashCode = 31 * hashCode + Objects.hashCode(minAbrBitrate());
        hashCode = 31 * hashCode + Objects.hashCode(hasRules() ? rules() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutomatedAbrSettings)) {
            return false;
        }
        AutomatedAbrSettings other = (AutomatedAbrSettings) obj;
        return Objects.equals(maxAbrBitrate(), other.maxAbrBitrate()) && Objects.equals(maxRenditions(), other.maxRenditions())
                && Objects.equals(minAbrBitrate(), other.minAbrBitrate()) && hasRules() == other.hasRules()
                && Objects.equals(rules(), other.rules());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AutomatedAbrSettings").add("MaxAbrBitrate", maxAbrBitrate())
                .add("MaxRenditions", maxRenditions()).add("MinAbrBitrate", minAbrBitrate())
                .add("Rules", hasRules() ? rules() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MaxAbrBitrate":
            return Optional.ofNullable(clazz.cast(maxAbrBitrate()));
        case "MaxRenditions":
            return Optional.ofNullable(clazz.cast(maxRenditions()));
        case "MinAbrBitrate":
            return Optional.ofNullable(clazz.cast(minAbrBitrate()));
        case "Rules":
            return Optional.ofNullable(clazz.cast(rules()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("maxAbrBitrate", MAX_ABR_BITRATE_FIELD);
        map.put("maxRenditions", MAX_RENDITIONS_FIELD);
        map.put("minAbrBitrate", MIN_ABR_BITRATE_FIELD);
        map.put("rules", RULES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AutomatedAbrSettings, T> g) {
        return obj -> g.apply((AutomatedAbrSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AutomatedAbrSettings> {
        /**
         * Specify the maximum average bitrate for MediaConvert to use in your automated ABR stack. If you don't specify
         * a value, MediaConvert uses 8,000,000 (8 mb/s) by default. The average bitrate of your highest-quality
         * rendition will be equal to or below this value, depending on the quality, complexity, and resolution of your
         * content. Note that the instantaneous maximum bitrate may vary above the value that you specify.
         * 
         * @param maxAbrBitrate
         *        Specify the maximum average bitrate for MediaConvert to use in your automated ABR stack. If you don't
         *        specify a value, MediaConvert uses 8,000,000 (8 mb/s) by default. The average bitrate of your
         *        highest-quality rendition will be equal to or below this value, depending on the quality, complexity,
         *        and resolution of your content. Note that the instantaneous maximum bitrate may vary above the value
         *        that you specify.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxAbrBitrate(Integer maxAbrBitrate);

        /**
         * Optional. The maximum number of renditions that MediaConvert will create in your automated ABR stack. The
         * number of renditions is determined automatically, based on analysis of each job, but will never exceed this
         * limit. When you set this to Auto in the console, which is equivalent to excluding it from your JSON job
         * specification, MediaConvert defaults to a limit of 15.
         * 
         * @param maxRenditions
         *        Optional. The maximum number of renditions that MediaConvert will create in your automated ABR stack.
         *        The number of renditions is determined automatically, based on analysis of each job, but will never
         *        exceed this limit. When you set this to Auto in the console, which is equivalent to excluding it from
         *        your JSON job specification, MediaConvert defaults to a limit of 15.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxRenditions(Integer maxRenditions);

        /**
         * Specify the minimum average bitrate for MediaConvert to use in your automated ABR stack. If you don't specify
         * a value, MediaConvert uses 600,000 (600 kb/s) by default. The average bitrate of your lowest-quality
         * rendition will be near this value. Note that the instantaneous minimum bitrate may vary below the value that
         * you specify.
         * 
         * @param minAbrBitrate
         *        Specify the minimum average bitrate for MediaConvert to use in your automated ABR stack. If you don't
         *        specify a value, MediaConvert uses 600,000 (600 kb/s) by default. The average bitrate of your
         *        lowest-quality rendition will be near this value. Note that the instantaneous minimum bitrate may vary
         *        below the value that you specify.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minAbrBitrate(Integer minAbrBitrate);

        /**
         * Optional. Use Automated ABR rules to specify restrictions for the rendition sizes MediaConvert will create in
         * your ABR stack. You can use these rules if your ABR workflow has specific rendition size requirements, but
         * you still want MediaConvert to optimize for video quality and overall file size.
         * 
         * @param rules
         *        Optional. Use Automated ABR rules to specify restrictions for the rendition sizes MediaConvert will
         *        create in your ABR stack. You can use these rules if your ABR workflow has specific rendition size
         *        requirements, but you still want MediaConvert to optimize for video quality and overall file size.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rules(Collection<AutomatedAbrRule> rules);

        /**
         * Optional. Use Automated ABR rules to specify restrictions for the rendition sizes MediaConvert will create in
         * your ABR stack. You can use these rules if your ABR workflow has specific rendition size requirements, but
         * you still want MediaConvert to optimize for video quality and overall file size.
         * 
         * @param rules
         *        Optional. Use Automated ABR rules to specify restrictions for the rendition sizes MediaConvert will
         *        create in your ABR stack. You can use these rules if your ABR workflow has specific rendition size
         *        requirements, but you still want MediaConvert to optimize for video quality and overall file size.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rules(AutomatedAbrRule... rules);

        /**
         * Optional. Use Automated ABR rules to specify restrictions for the rendition sizes MediaConvert will create in
         * your ABR stack. You can use these rules if your ABR workflow has specific rendition size requirements, but
         * you still want MediaConvert to optimize for video quality and overall file size. This is a convenience method
         * that creates an instance of the
         * {@link software.amazon.awssdk.services.mediaconvert.model.AutomatedAbrRule.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.mediaconvert.model.AutomatedAbrRule#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.mediaconvert.model.AutomatedAbrRule.Builder#build()} is called
         * immediately and its result is passed to {@link #rules(List<AutomatedAbrRule>)}.
         * 
         * @param rules
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.mediaconvert.model.AutomatedAbrRule.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rules(java.util.Collection<AutomatedAbrRule>)
         */
        Builder rules(Consumer<AutomatedAbrRule.Builder>... rules);
    }

    static final class BuilderImpl implements Builder {
        private Integer maxAbrBitrate;

        private Integer maxRenditions;

        private Integer minAbrBitrate;

        private List<AutomatedAbrRule> rules = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AutomatedAbrSettings model) {
            maxAbrBitrate(model.maxAbrBitrate);
            maxRenditions(model.maxRenditions);
            minAbrBitrate(model.minAbrBitrate);
            rules(model.rules);
        }

        public final Integer getMaxAbrBitrate() {
            return maxAbrBitrate;
        }

        public final void setMaxAbrBitrate(Integer maxAbrBitrate) {
            this.maxAbrBitrate = maxAbrBitrate;
        }

        @Override
        public final Builder maxAbrBitrate(Integer maxAbrBitrate) {
            this.maxAbrBitrate = maxAbrBitrate;
            return this;
        }

        public final Integer getMaxRenditions() {
            return maxRenditions;
        }

        public final void setMaxRenditions(Integer maxRenditions) {
            this.maxRenditions = maxRenditions;
        }

        @Override
        public final Builder maxRenditions(Integer maxRenditions) {
            this.maxRenditions = maxRenditions;
            return this;
        }

        public final Integer getMinAbrBitrate() {
            return minAbrBitrate;
        }

        public final void setMinAbrBitrate(Integer minAbrBitrate) {
            this.minAbrBitrate = minAbrBitrate;
        }

        @Override
        public final Builder minAbrBitrate(Integer minAbrBitrate) {
            this.minAbrBitrate = minAbrBitrate;
            return this;
        }

        public final List<AutomatedAbrRule.Builder> getRules() {
            List<AutomatedAbrRule.Builder> result = ___listOfAutomatedAbrRuleCopier.copyToBuilder(this.rules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRules(Collection<AutomatedAbrRule.BuilderImpl> rules) {
            this.rules = ___listOfAutomatedAbrRuleCopier.copyFromBuilder(rules);
        }

        @Override
        public final Builder rules(Collection<AutomatedAbrRule> rules) {
            this.rules = ___listOfAutomatedAbrRuleCopier.copy(rules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rules(AutomatedAbrRule... rules) {
            rules(Arrays.asList(rules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rules(Consumer<AutomatedAbrRule.Builder>... rules) {
            rules(Stream.of(rules).map(c -> AutomatedAbrRule.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public AutomatedAbrSettings build() {
            return new AutomatedAbrSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
