/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * The Bandwidth reduction filter increases the video quality of your output relative to its bitrate. Use to lower the
 * bitrate of your constant quality QVBR output, with little or no perceptual decrease in quality. Or, use to increase
 * the video quality of outputs with other rate control modes relative to the bitrate that you specify. Bandwidth
 * reduction increases further when your input is low quality or noisy. Outputs that use this feature incur pro-tier
 * pricing. When you include Bandwidth reduction filter, you cannot include the Noise reducer preprocessor.
 */
@Generated("software.amazon.awssdk:codegen")
public final class BandwidthReductionFilter implements SdkPojo, Serializable,
        ToCopyableBuilder<BandwidthReductionFilter.Builder, BandwidthReductionFilter> {
    private static final SdkField<String> SHARPENING_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Sharpening").getter(getter(BandwidthReductionFilter::sharpeningAsString))
            .setter(setter(Builder::sharpening))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sharpening").build()).build();

    private static final SdkField<String> STRENGTH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Strength").getter(getter(BandwidthReductionFilter::strengthAsString)).setter(setter(Builder::strength))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("strength").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SHARPENING_FIELD,
            STRENGTH_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String sharpening;

    private final String strength;

    private BandwidthReductionFilter(BuilderImpl builder) {
        this.sharpening = builder.sharpening;
        this.strength = builder.strength;
    }

    /**
     * Optionally specify the level of sharpening to apply when you use the Bandwidth reduction filter. Sharpening adds
     * contrast to the edges of your video content and can reduce softness. Keep the default value Off to apply no
     * sharpening. Set Sharpening strength to Low to apply a minimal amount of sharpening, or High to apply a maximum
     * amount of sharpening.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sharpening} will
     * return {@link BandwidthReductionFilterSharpening#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #sharpeningAsString}.
     * </p>
     * 
     * @return Optionally specify the level of sharpening to apply when you use the Bandwidth reduction filter.
     *         Sharpening adds contrast to the edges of your video content and can reduce softness. Keep the default
     *         value Off to apply no sharpening. Set Sharpening strength to Low to apply a minimal amount of sharpening,
     *         or High to apply a maximum amount of sharpening.
     * @see BandwidthReductionFilterSharpening
     */
    public final BandwidthReductionFilterSharpening sharpening() {
        return BandwidthReductionFilterSharpening.fromValue(sharpening);
    }

    /**
     * Optionally specify the level of sharpening to apply when you use the Bandwidth reduction filter. Sharpening adds
     * contrast to the edges of your video content and can reduce softness. Keep the default value Off to apply no
     * sharpening. Set Sharpening strength to Low to apply a minimal amount of sharpening, or High to apply a maximum
     * amount of sharpening.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sharpening} will
     * return {@link BandwidthReductionFilterSharpening#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #sharpeningAsString}.
     * </p>
     * 
     * @return Optionally specify the level of sharpening to apply when you use the Bandwidth reduction filter.
     *         Sharpening adds contrast to the edges of your video content and can reduce softness. Keep the default
     *         value Off to apply no sharpening. Set Sharpening strength to Low to apply a minimal amount of sharpening,
     *         or High to apply a maximum amount of sharpening.
     * @see BandwidthReductionFilterSharpening
     */
    public final String sharpeningAsString() {
        return sharpening;
    }

    /**
     * Specify the strength of the Bandwidth reduction filter. For most workflows, we recommend that you choose Auto to
     * reduce the bandwidth of your output with little to no perceptual decrease in video quality. For high quality and
     * high bitrate outputs, choose Low. For the most bandwidth reduction, choose High. We recommend that you choose
     * High for low bitrate outputs. Note that High may incur a slight increase in the softness of your output.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #strength} will
     * return {@link BandwidthReductionFilterStrength#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #strengthAsString}.
     * </p>
     * 
     * @return Specify the strength of the Bandwidth reduction filter. For most workflows, we recommend that you choose
     *         Auto to reduce the bandwidth of your output with little to no perceptual decrease in video quality. For
     *         high quality and high bitrate outputs, choose Low. For the most bandwidth reduction, choose High. We
     *         recommend that you choose High for low bitrate outputs. Note that High may incur a slight increase in the
     *         softness of your output.
     * @see BandwidthReductionFilterStrength
     */
    public final BandwidthReductionFilterStrength strength() {
        return BandwidthReductionFilterStrength.fromValue(strength);
    }

    /**
     * Specify the strength of the Bandwidth reduction filter. For most workflows, we recommend that you choose Auto to
     * reduce the bandwidth of your output with little to no perceptual decrease in video quality. For high quality and
     * high bitrate outputs, choose Low. For the most bandwidth reduction, choose High. We recommend that you choose
     * High for low bitrate outputs. Note that High may incur a slight increase in the softness of your output.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #strength} will
     * return {@link BandwidthReductionFilterStrength#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #strengthAsString}.
     * </p>
     * 
     * @return Specify the strength of the Bandwidth reduction filter. For most workflows, we recommend that you choose
     *         Auto to reduce the bandwidth of your output with little to no perceptual decrease in video quality. For
     *         high quality and high bitrate outputs, choose Low. For the most bandwidth reduction, choose High. We
     *         recommend that you choose High for low bitrate outputs. Note that High may incur a slight increase in the
     *         softness of your output.
     * @see BandwidthReductionFilterStrength
     */
    public final String strengthAsString() {
        return strength;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sharpeningAsString());
        hashCode = 31 * hashCode + Objects.hashCode(strengthAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BandwidthReductionFilter)) {
            return false;
        }
        BandwidthReductionFilter other = (BandwidthReductionFilter) obj;
        return Objects.equals(sharpeningAsString(), other.sharpeningAsString())
                && Objects.equals(strengthAsString(), other.strengthAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BandwidthReductionFilter").add("Sharpening", sharpeningAsString())
                .add("Strength", strengthAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Sharpening":
            return Optional.ofNullable(clazz.cast(sharpeningAsString()));
        case "Strength":
            return Optional.ofNullable(clazz.cast(strengthAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("sharpening", SHARPENING_FIELD);
        map.put("strength", STRENGTH_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BandwidthReductionFilter, T> g) {
        return obj -> g.apply((BandwidthReductionFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BandwidthReductionFilter> {
        /**
         * Optionally specify the level of sharpening to apply when you use the Bandwidth reduction filter. Sharpening
         * adds contrast to the edges of your video content and can reduce softness. Keep the default value Off to apply
         * no sharpening. Set Sharpening strength to Low to apply a minimal amount of sharpening, or High to apply a
         * maximum amount of sharpening.
         * 
         * @param sharpening
         *        Optionally specify the level of sharpening to apply when you use the Bandwidth reduction filter.
         *        Sharpening adds contrast to the edges of your video content and can reduce softness. Keep the default
         *        value Off to apply no sharpening. Set Sharpening strength to Low to apply a minimal amount of
         *        sharpening, or High to apply a maximum amount of sharpening.
         * @see BandwidthReductionFilterSharpening
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BandwidthReductionFilterSharpening
         */
        Builder sharpening(String sharpening);

        /**
         * Optionally specify the level of sharpening to apply when you use the Bandwidth reduction filter. Sharpening
         * adds contrast to the edges of your video content and can reduce softness. Keep the default value Off to apply
         * no sharpening. Set Sharpening strength to Low to apply a minimal amount of sharpening, or High to apply a
         * maximum amount of sharpening.
         * 
         * @param sharpening
         *        Optionally specify the level of sharpening to apply when you use the Bandwidth reduction filter.
         *        Sharpening adds contrast to the edges of your video content and can reduce softness. Keep the default
         *        value Off to apply no sharpening. Set Sharpening strength to Low to apply a minimal amount of
         *        sharpening, or High to apply a maximum amount of sharpening.
         * @see BandwidthReductionFilterSharpening
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BandwidthReductionFilterSharpening
         */
        Builder sharpening(BandwidthReductionFilterSharpening sharpening);

        /**
         * Specify the strength of the Bandwidth reduction filter. For most workflows, we recommend that you choose Auto
         * to reduce the bandwidth of your output with little to no perceptual decrease in video quality. For high
         * quality and high bitrate outputs, choose Low. For the most bandwidth reduction, choose High. We recommend
         * that you choose High for low bitrate outputs. Note that High may incur a slight increase in the softness of
         * your output.
         * 
         * @param strength
         *        Specify the strength of the Bandwidth reduction filter. For most workflows, we recommend that you
         *        choose Auto to reduce the bandwidth of your output with little to no perceptual decrease in video
         *        quality. For high quality and high bitrate outputs, choose Low. For the most bandwidth reduction,
         *        choose High. We recommend that you choose High for low bitrate outputs. Note that High may incur a
         *        slight increase in the softness of your output.
         * @see BandwidthReductionFilterStrength
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BandwidthReductionFilterStrength
         */
        Builder strength(String strength);

        /**
         * Specify the strength of the Bandwidth reduction filter. For most workflows, we recommend that you choose Auto
         * to reduce the bandwidth of your output with little to no perceptual decrease in video quality. For high
         * quality and high bitrate outputs, choose Low. For the most bandwidth reduction, choose High. We recommend
         * that you choose High for low bitrate outputs. Note that High may incur a slight increase in the softness of
         * your output.
         * 
         * @param strength
         *        Specify the strength of the Bandwidth reduction filter. For most workflows, we recommend that you
         *        choose Auto to reduce the bandwidth of your output with little to no perceptual decrease in video
         *        quality. For high quality and high bitrate outputs, choose Low. For the most bandwidth reduction,
         *        choose High. We recommend that you choose High for low bitrate outputs. Note that High may incur a
         *        slight increase in the softness of your output.
         * @see BandwidthReductionFilterStrength
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BandwidthReductionFilterStrength
         */
        Builder strength(BandwidthReductionFilterStrength strength);
    }

    static final class BuilderImpl implements Builder {
        private String sharpening;

        private String strength;

        private BuilderImpl() {
        }

        private BuilderImpl(BandwidthReductionFilter model) {
            sharpening(model.sharpening);
            strength(model.strength);
        }

        public final String getSharpening() {
            return sharpening;
        }

        public final void setSharpening(String sharpening) {
            this.sharpening = sharpening;
        }

        @Override
        public final Builder sharpening(String sharpening) {
            this.sharpening = sharpening;
            return this;
        }

        @Override
        public final Builder sharpening(BandwidthReductionFilterSharpening sharpening) {
            this.sharpening(sharpening == null ? null : sharpening.toString());
            return this;
        }

        public final String getStrength() {
            return strength;
        }

        public final void setStrength(String strength) {
            this.strength = strength;
        }

        @Override
        public final Builder strength(String strength) {
            this.strength = strength;
            return this;
        }

        @Override
        public final Builder strength(BandwidthReductionFilterStrength strength) {
            this.strength(strength == null ? null : strength.toString());
            return this;
        }

        @Override
        public BandwidthReductionFilter build() {
            return new BandwidthReductionFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
