/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

/**
 * To use the available style, color, and position information from your input captions: Set Style passthrough to
 * Enabled. Note that MediaConvert uses default settings for any missing style or position information in your input
 * captions To ignore the style and position information from your input captions and use default settings: Leave blank
 * or keep the default value, Disabled. Default settings include white text with black outlining, bottom-center
 * positioning, and automatic sizing. Whether you set Style passthrough to enabled or not, you can also choose to
 * manually override any of the individual style and position settings. You can also override any fonts by manually
 * specifying custom font files.
 */
@Generated("software.amazon.awssdk:codegen")
public enum BurnInSubtitleStylePassthrough {
    ENABLED("ENABLED"),

    DISABLED("DISABLED"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, BurnInSubtitleStylePassthrough> VALUE_MAP = EnumUtils.uniqueIndex(
            BurnInSubtitleStylePassthrough.class, BurnInSubtitleStylePassthrough::toString);

    private final String value;

    private BurnInSubtitleStylePassthrough(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return BurnInSubtitleStylePassthrough corresponding to the value
     */
    public static BurnInSubtitleStylePassthrough fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link BurnInSubtitleStylePassthrough}s
     */
    public static Set<BurnInSubtitleStylePassthrough> knownValues() {
        Set<BurnInSubtitleStylePassthrough> knownValues = EnumSet.allOf(BurnInSubtitleStylePassthrough.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
