/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Use captions selectors to specify the captions data from your input that you use in your outputs. You can use up to
 * 100 captions selectors per input.
 */
@Generated("software.amazon.awssdk:codegen")
public final class CaptionSelector implements SdkPojo, Serializable, ToCopyableBuilder<CaptionSelector.Builder, CaptionSelector> {
    private static final SdkField<String> CUSTOM_LANGUAGE_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CustomLanguageCode").getter(getter(CaptionSelector::customLanguageCode))
            .setter(setter(Builder::customLanguageCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customLanguageCode").build())
            .build();

    private static final SdkField<String> LANGUAGE_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LanguageCode").getter(getter(CaptionSelector::languageCodeAsString))
            .setter(setter(Builder::languageCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("languageCode").build()).build();

    private static final SdkField<CaptionSourceSettings> SOURCE_SETTINGS_FIELD = SdkField
            .<CaptionSourceSettings> builder(MarshallingType.SDK_POJO).memberName("SourceSettings")
            .getter(getter(CaptionSelector::sourceSettings)).setter(setter(Builder::sourceSettings))
            .constructor(CaptionSourceSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceSettings").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CUSTOM_LANGUAGE_CODE_FIELD,
            LANGUAGE_CODE_FIELD, SOURCE_SETTINGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String customLanguageCode;

    private final String languageCode;

    private final CaptionSourceSettings sourceSettings;

    private CaptionSelector(BuilderImpl builder) {
        this.customLanguageCode = builder.customLanguageCode;
        this.languageCode = builder.languageCode;
        this.sourceSettings = builder.sourceSettings;
    }

    /**
     * The specific language to extract from source, using the ISO 639-2 or ISO 639-3 three-letter language code. If
     * input is SCTE-27, complete this field and/or PID to select the caption language to extract. If input is DVB-Sub
     * and output is Burn-in, complete this field and/or PID to select the caption language to extract. If input is
     * DVB-Sub that is being passed through, omit this field (and PID field); there is no way to extract a specific
     * language with pass-through captions.
     * 
     * @return The specific language to extract from source, using the ISO 639-2 or ISO 639-3 three-letter language
     *         code. If input is SCTE-27, complete this field and/or PID to select the caption language to extract. If
     *         input is DVB-Sub and output is Burn-in, complete this field and/or PID to select the caption language to
     *         extract. If input is DVB-Sub that is being passed through, omit this field (and PID field); there is no
     *         way to extract a specific language with pass-through captions.
     */
    public final String customLanguageCode() {
        return customLanguageCode;
    }

    /**
     * The specific language to extract from source. If input is SCTE-27, complete this field and/or PID to select the
     * caption language to extract. If input is DVB-Sub and output is Burn-in, complete this field and/or PID to select
     * the caption language to extract. If input is DVB-Sub that is being passed through, omit this field (and PID
     * field); there is no way to extract a specific language with pass-through captions.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #languageCode} will
     * return {@link LanguageCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #languageCodeAsString}.
     * </p>
     * 
     * @return The specific language to extract from source. If input is SCTE-27, complete this field and/or PID to
     *         select the caption language to extract. If input is DVB-Sub and output is Burn-in, complete this field
     *         and/or PID to select the caption language to extract. If input is DVB-Sub that is being passed through,
     *         omit this field (and PID field); there is no way to extract a specific language with pass-through
     *         captions.
     * @see LanguageCode
     */
    public final LanguageCode languageCode() {
        return LanguageCode.fromValue(languageCode);
    }

    /**
     * The specific language to extract from source. If input is SCTE-27, complete this field and/or PID to select the
     * caption language to extract. If input is DVB-Sub and output is Burn-in, complete this field and/or PID to select
     * the caption language to extract. If input is DVB-Sub that is being passed through, omit this field (and PID
     * field); there is no way to extract a specific language with pass-through captions.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #languageCode} will
     * return {@link LanguageCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #languageCodeAsString}.
     * </p>
     * 
     * @return The specific language to extract from source. If input is SCTE-27, complete this field and/or PID to
     *         select the caption language to extract. If input is DVB-Sub and output is Burn-in, complete this field
     *         and/or PID to select the caption language to extract. If input is DVB-Sub that is being passed through,
     *         omit this field (and PID field); there is no way to extract a specific language with pass-through
     *         captions.
     * @see LanguageCode
     */
    public final String languageCodeAsString() {
        return languageCode;
    }

    /**
     * If your input captions are SCC, TTML, STL, SMI, SRT, or IMSC in an xml file, specify the URI of the input
     * captions source file. If your input captions are IMSC in an IMF package, use TrackSourceSettings instead of
     * FileSoureSettings.
     * 
     * @return If your input captions are SCC, TTML, STL, SMI, SRT, or IMSC in an xml file, specify the URI of the input
     *         captions source file. If your input captions are IMSC in an IMF package, use TrackSourceSettings instead
     *         of FileSoureSettings.
     */
    public final CaptionSourceSettings sourceSettings() {
        return sourceSettings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(customLanguageCode());
        hashCode = 31 * hashCode + Objects.hashCode(languageCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sourceSettings());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CaptionSelector)) {
            return false;
        }
        CaptionSelector other = (CaptionSelector) obj;
        return Objects.equals(customLanguageCode(), other.customLanguageCode())
                && Objects.equals(languageCodeAsString(), other.languageCodeAsString())
                && Objects.equals(sourceSettings(), other.sourceSettings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CaptionSelector").add("CustomLanguageCode", customLanguageCode())
                .add("LanguageCode", languageCodeAsString()).add("SourceSettings", sourceSettings()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CustomLanguageCode":
            return Optional.ofNullable(clazz.cast(customLanguageCode()));
        case "LanguageCode":
            return Optional.ofNullable(clazz.cast(languageCodeAsString()));
        case "SourceSettings":
            return Optional.ofNullable(clazz.cast(sourceSettings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("customLanguageCode", CUSTOM_LANGUAGE_CODE_FIELD);
        map.put("languageCode", LANGUAGE_CODE_FIELD);
        map.put("sourceSettings", SOURCE_SETTINGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CaptionSelector, T> g) {
        return obj -> g.apply((CaptionSelector) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CaptionSelector> {
        /**
         * The specific language to extract from source, using the ISO 639-2 or ISO 639-3 three-letter language code. If
         * input is SCTE-27, complete this field and/or PID to select the caption language to extract. If input is
         * DVB-Sub and output is Burn-in, complete this field and/or PID to select the caption language to extract. If
         * input is DVB-Sub that is being passed through, omit this field (and PID field); there is no way to extract a
         * specific language with pass-through captions.
         * 
         * @param customLanguageCode
         *        The specific language to extract from source, using the ISO 639-2 or ISO 639-3 three-letter language
         *        code. If input is SCTE-27, complete this field and/or PID to select the caption language to extract.
         *        If input is DVB-Sub and output is Burn-in, complete this field and/or PID to select the caption
         *        language to extract. If input is DVB-Sub that is being passed through, omit this field (and PID
         *        field); there is no way to extract a specific language with pass-through captions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customLanguageCode(String customLanguageCode);

        /**
         * The specific language to extract from source. If input is SCTE-27, complete this field and/or PID to select
         * the caption language to extract. If input is DVB-Sub and output is Burn-in, complete this field and/or PID to
         * select the caption language to extract. If input is DVB-Sub that is being passed through, omit this field
         * (and PID field); there is no way to extract a specific language with pass-through captions.
         * 
         * @param languageCode
         *        The specific language to extract from source. If input is SCTE-27, complete this field and/or PID to
         *        select the caption language to extract. If input is DVB-Sub and output is Burn-in, complete this field
         *        and/or PID to select the caption language to extract. If input is DVB-Sub that is being passed
         *        through, omit this field (and PID field); there is no way to extract a specific language with
         *        pass-through captions.
         * @see LanguageCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LanguageCode
         */
        Builder languageCode(String languageCode);

        /**
         * The specific language to extract from source. If input is SCTE-27, complete this field and/or PID to select
         * the caption language to extract. If input is DVB-Sub and output is Burn-in, complete this field and/or PID to
         * select the caption language to extract. If input is DVB-Sub that is being passed through, omit this field
         * (and PID field); there is no way to extract a specific language with pass-through captions.
         * 
         * @param languageCode
         *        The specific language to extract from source. If input is SCTE-27, complete this field and/or PID to
         *        select the caption language to extract. If input is DVB-Sub and output is Burn-in, complete this field
         *        and/or PID to select the caption language to extract. If input is DVB-Sub that is being passed
         *        through, omit this field (and PID field); there is no way to extract a specific language with
         *        pass-through captions.
         * @see LanguageCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LanguageCode
         */
        Builder languageCode(LanguageCode languageCode);

        /**
         * If your input captions are SCC, TTML, STL, SMI, SRT, or IMSC in an xml file, specify the URI of the input
         * captions source file. If your input captions are IMSC in an IMF package, use TrackSourceSettings instead of
         * FileSoureSettings.
         * 
         * @param sourceSettings
         *        If your input captions are SCC, TTML, STL, SMI, SRT, or IMSC in an xml file, specify the URI of the
         *        input captions source file. If your input captions are IMSC in an IMF package, use TrackSourceSettings
         *        instead of FileSoureSettings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceSettings(CaptionSourceSettings sourceSettings);

        /**
         * If your input captions are SCC, TTML, STL, SMI, SRT, or IMSC in an xml file, specify the URI of the input
         * captions source file. If your input captions are IMSC in an IMF package, use TrackSourceSettings instead of
         * FileSoureSettings. This is a convenience method that creates an instance of the
         * {@link CaptionSourceSettings.Builder} avoiding the need to create one manually via
         * {@link CaptionSourceSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CaptionSourceSettings.Builder#build()} is called immediately and
         * its result is passed to {@link #sourceSettings(CaptionSourceSettings)}.
         * 
         * @param sourceSettings
         *        a consumer that will call methods on {@link CaptionSourceSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sourceSettings(CaptionSourceSettings)
         */
        default Builder sourceSettings(Consumer<CaptionSourceSettings.Builder> sourceSettings) {
            return sourceSettings(CaptionSourceSettings.builder().applyMutation(sourceSettings).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String customLanguageCode;

        private String languageCode;

        private CaptionSourceSettings sourceSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(CaptionSelector model) {
            customLanguageCode(model.customLanguageCode);
            languageCode(model.languageCode);
            sourceSettings(model.sourceSettings);
        }

        public final String getCustomLanguageCode() {
            return customLanguageCode;
        }

        public final void setCustomLanguageCode(String customLanguageCode) {
            this.customLanguageCode = customLanguageCode;
        }

        @Override
        public final Builder customLanguageCode(String customLanguageCode) {
            this.customLanguageCode = customLanguageCode;
            return this;
        }

        public final String getLanguageCode() {
            return languageCode;
        }

        public final void setLanguageCode(String languageCode) {
            this.languageCode = languageCode;
        }

        @Override
        public final Builder languageCode(String languageCode) {
            this.languageCode = languageCode;
            return this;
        }

        @Override
        public final Builder languageCode(LanguageCode languageCode) {
            this.languageCode(languageCode == null ? null : languageCode.toString());
            return this;
        }

        public final CaptionSourceSettings.Builder getSourceSettings() {
            return sourceSettings != null ? sourceSettings.toBuilder() : null;
        }

        public final void setSourceSettings(CaptionSourceSettings.BuilderImpl sourceSettings) {
            this.sourceSettings = sourceSettings != null ? sourceSettings.build() : null;
        }

        @Override
        public final Builder sourceSettings(CaptionSourceSettings sourceSettings) {
            this.sourceSettings = sourceSettings;
            return this;
        }

        @Override
        public CaptionSelector build() {
            return new CaptionSelector(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
