/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Settings related to your CMAF output package. For more information, see
 * https://docs.aws.amazon.com/mediaconvert/latest/ug/outputs-file-ABR.html.
 */
@Generated("software.amazon.awssdk:codegen")
public final class CmafGroupSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<CmafGroupSettings.Builder, CmafGroupSettings> {
    private static final SdkField<List<CmafAdditionalManifest>> ADDITIONAL_MANIFESTS_FIELD = SdkField
            .<List<CmafAdditionalManifest>> builder(MarshallingType.LIST)
            .memberName("AdditionalManifests")
            .getter(getter(CmafGroupSettings::additionalManifests))
            .setter(setter(Builder::additionalManifests))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("additionalManifests").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CmafAdditionalManifest> builder(MarshallingType.SDK_POJO)
                                            .constructor(CmafAdditionalManifest::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> BASE_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BaseUrl").getter(getter(CmafGroupSettings::baseUrl)).setter(setter(Builder::baseUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("baseUrl").build()).build();

    private static final SdkField<String> CLIENT_CACHE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClientCache").getter(getter(CmafGroupSettings::clientCacheAsString))
            .setter(setter(Builder::clientCache))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientCache").build()).build();

    private static final SdkField<String> CODEC_SPECIFICATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CodecSpecification").getter(getter(CmafGroupSettings::codecSpecificationAsString))
            .setter(setter(Builder::codecSpecification))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("codecSpecification").build())
            .build();

    private static final SdkField<String> DASH_I_FRAME_TRICK_PLAY_NAME_MODIFIER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("DashIFrameTrickPlayNameModifier")
            .getter(getter(CmafGroupSettings::dashIFrameTrickPlayNameModifier))
            .setter(setter(Builder::dashIFrameTrickPlayNameModifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dashIFrameTrickPlayNameModifier")
                    .build()).build();

    private static final SdkField<String> DASH_MANIFEST_STYLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DashManifestStyle").getter(getter(CmafGroupSettings::dashManifestStyleAsString))
            .setter(setter(Builder::dashManifestStyle))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dashManifestStyle").build()).build();

    private static final SdkField<String> DESTINATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Destination").getter(getter(CmafGroupSettings::destination)).setter(setter(Builder::destination))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destination").build()).build();

    private static final SdkField<DestinationSettings> DESTINATION_SETTINGS_FIELD = SdkField
            .<DestinationSettings> builder(MarshallingType.SDK_POJO).memberName("DestinationSettings")
            .getter(getter(CmafGroupSettings::destinationSettings)).setter(setter(Builder::destinationSettings))
            .constructor(DestinationSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationSettings").build())
            .build();

    private static final SdkField<CmafEncryptionSettings> ENCRYPTION_FIELD = SdkField
            .<CmafEncryptionSettings> builder(MarshallingType.SDK_POJO).memberName("Encryption")
            .getter(getter(CmafGroupSettings::encryption)).setter(setter(Builder::encryption))
            .constructor(CmafEncryptionSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encryption").build()).build();

    private static final SdkField<Integer> FRAGMENT_LENGTH_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("FragmentLength").getter(getter(CmafGroupSettings::fragmentLength))
            .setter(setter(Builder::fragmentLength))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fragmentLength").build()).build();

    private static final SdkField<String> IMAGE_BASED_TRICK_PLAY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ImageBasedTrickPlay").getter(getter(CmafGroupSettings::imageBasedTrickPlayAsString))
            .setter(setter(Builder::imageBasedTrickPlay))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageBasedTrickPlay").build())
            .build();

    private static final SdkField<CmafImageBasedTrickPlaySettings> IMAGE_BASED_TRICK_PLAY_SETTINGS_FIELD = SdkField
            .<CmafImageBasedTrickPlaySettings> builder(MarshallingType.SDK_POJO)
            .memberName("ImageBasedTrickPlaySettings")
            .getter(getter(CmafGroupSettings::imageBasedTrickPlaySettings))
            .setter(setter(Builder::imageBasedTrickPlaySettings))
            .constructor(CmafImageBasedTrickPlaySettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageBasedTrickPlaySettings")
                    .build()).build();

    private static final SdkField<String> MANIFEST_COMPRESSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ManifestCompression").getter(getter(CmafGroupSettings::manifestCompressionAsString))
            .setter(setter(Builder::manifestCompression))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("manifestCompression").build())
            .build();

    private static final SdkField<String> MANIFEST_DURATION_FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ManifestDurationFormat").getter(getter(CmafGroupSettings::manifestDurationFormatAsString))
            .setter(setter(Builder::manifestDurationFormat))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("manifestDurationFormat").build())
            .build();

    private static final SdkField<Integer> MIN_BUFFER_TIME_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MinBufferTime").getter(getter(CmafGroupSettings::minBufferTime)).setter(setter(Builder::minBufferTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("minBufferTime").build()).build();

    private static final SdkField<Double> MIN_FINAL_SEGMENT_LENGTH_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("MinFinalSegmentLength").getter(getter(CmafGroupSettings::minFinalSegmentLength))
            .setter(setter(Builder::minFinalSegmentLength))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("minFinalSegmentLength").build())
            .build();

    private static final SdkField<String> MPD_MANIFEST_BANDWIDTH_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MpdManifestBandwidthType").getter(getter(CmafGroupSettings::mpdManifestBandwidthTypeAsString))
            .setter(setter(Builder::mpdManifestBandwidthType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mpdManifestBandwidthType").build())
            .build();

    private static final SdkField<String> MPD_PROFILE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MpdProfile").getter(getter(CmafGroupSettings::mpdProfileAsString)).setter(setter(Builder::mpdProfile))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mpdProfile").build()).build();

    private static final SdkField<String> PTS_OFFSET_HANDLING_FOR_B_FRAMES_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PtsOffsetHandlingForBFrames")
            .getter(getter(CmafGroupSettings::ptsOffsetHandlingForBFramesAsString))
            .setter(setter(Builder::ptsOffsetHandlingForBFrames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ptsOffsetHandlingForBFrames")
                    .build()).build();

    private static final SdkField<String> SEGMENT_CONTROL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SegmentControl").getter(getter(CmafGroupSettings::segmentControlAsString))
            .setter(setter(Builder::segmentControl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("segmentControl").build()).build();

    private static final SdkField<Integer> SEGMENT_LENGTH_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("SegmentLength").getter(getter(CmafGroupSettings::segmentLength)).setter(setter(Builder::segmentLength))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("segmentLength").build()).build();

    private static final SdkField<String> SEGMENT_LENGTH_CONTROL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SegmentLengthControl").getter(getter(CmafGroupSettings::segmentLengthControlAsString))
            .setter(setter(Builder::segmentLengthControl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("segmentLengthControl").build())
            .build();

    private static final SdkField<String> STREAM_INF_RESOLUTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StreamInfResolution").getter(getter(CmafGroupSettings::streamInfResolutionAsString))
            .setter(setter(Builder::streamInfResolution))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("streamInfResolution").build())
            .build();

    private static final SdkField<String> TARGET_DURATION_COMPATIBILITY_MODE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("TargetDurationCompatibilityMode")
            .getter(getter(CmafGroupSettings::targetDurationCompatibilityModeAsString))
            .setter(setter(Builder::targetDurationCompatibilityMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetDurationCompatibilityMode")
                    .build()).build();

    private static final SdkField<String> VIDEO_COMPOSITION_OFFSETS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VideoCompositionOffsets").getter(getter(CmafGroupSettings::videoCompositionOffsetsAsString))
            .setter(setter(Builder::videoCompositionOffsets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("videoCompositionOffsets").build())
            .build();

    private static final SdkField<String> WRITE_DASH_MANIFEST_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WriteDashManifest").getter(getter(CmafGroupSettings::writeDashManifestAsString))
            .setter(setter(Builder::writeDashManifest))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("writeDashManifest").build()).build();

    private static final SdkField<String> WRITE_HLS_MANIFEST_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WriteHlsManifest").getter(getter(CmafGroupSettings::writeHlsManifestAsString))
            .setter(setter(Builder::writeHlsManifest))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("writeHlsManifest").build()).build();

    private static final SdkField<String> WRITE_SEGMENT_TIMELINE_IN_REPRESENTATION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("WriteSegmentTimelineInRepresentation")
            .getter(getter(CmafGroupSettings::writeSegmentTimelineInRepresentationAsString))
            .setter(setter(Builder::writeSegmentTimelineInRepresentation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("writeSegmentTimelineInRepresentation").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADDITIONAL_MANIFESTS_FIELD,
            BASE_URL_FIELD, CLIENT_CACHE_FIELD, CODEC_SPECIFICATION_FIELD, DASH_I_FRAME_TRICK_PLAY_NAME_MODIFIER_FIELD,
            DASH_MANIFEST_STYLE_FIELD, DESTINATION_FIELD, DESTINATION_SETTINGS_FIELD, ENCRYPTION_FIELD, FRAGMENT_LENGTH_FIELD,
            IMAGE_BASED_TRICK_PLAY_FIELD, IMAGE_BASED_TRICK_PLAY_SETTINGS_FIELD, MANIFEST_COMPRESSION_FIELD,
            MANIFEST_DURATION_FORMAT_FIELD, MIN_BUFFER_TIME_FIELD, MIN_FINAL_SEGMENT_LENGTH_FIELD,
            MPD_MANIFEST_BANDWIDTH_TYPE_FIELD, MPD_PROFILE_FIELD, PTS_OFFSET_HANDLING_FOR_B_FRAMES_FIELD, SEGMENT_CONTROL_FIELD,
            SEGMENT_LENGTH_FIELD, SEGMENT_LENGTH_CONTROL_FIELD, STREAM_INF_RESOLUTION_FIELD,
            TARGET_DURATION_COMPATIBILITY_MODE_FIELD, VIDEO_COMPOSITION_OFFSETS_FIELD, WRITE_DASH_MANIFEST_FIELD,
            WRITE_HLS_MANIFEST_FIELD, WRITE_SEGMENT_TIMELINE_IN_REPRESENTATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<CmafAdditionalManifest> additionalManifests;

    private final String baseUrl;

    private final String clientCache;

    private final String codecSpecification;

    private final String dashIFrameTrickPlayNameModifier;

    private final String dashManifestStyle;

    private final String destination;

    private final DestinationSettings destinationSettings;

    private final CmafEncryptionSettings encryption;

    private final Integer fragmentLength;

    private final String imageBasedTrickPlay;

    private final CmafImageBasedTrickPlaySettings imageBasedTrickPlaySettings;

    private final String manifestCompression;

    private final String manifestDurationFormat;

    private final Integer minBufferTime;

    private final Double minFinalSegmentLength;

    private final String mpdManifestBandwidthType;

    private final String mpdProfile;

    private final String ptsOffsetHandlingForBFrames;

    private final String segmentControl;

    private final Integer segmentLength;

    private final String segmentLengthControl;

    private final String streamInfResolution;

    private final String targetDurationCompatibilityMode;

    private final String videoCompositionOffsets;

    private final String writeDashManifest;

    private final String writeHlsManifest;

    private final String writeSegmentTimelineInRepresentation;

    private CmafGroupSettings(BuilderImpl builder) {
        this.additionalManifests = builder.additionalManifests;
        this.baseUrl = builder.baseUrl;
        this.clientCache = builder.clientCache;
        this.codecSpecification = builder.codecSpecification;
        this.dashIFrameTrickPlayNameModifier = builder.dashIFrameTrickPlayNameModifier;
        this.dashManifestStyle = builder.dashManifestStyle;
        this.destination = builder.destination;
        this.destinationSettings = builder.destinationSettings;
        this.encryption = builder.encryption;
        this.fragmentLength = builder.fragmentLength;
        this.imageBasedTrickPlay = builder.imageBasedTrickPlay;
        this.imageBasedTrickPlaySettings = builder.imageBasedTrickPlaySettings;
        this.manifestCompression = builder.manifestCompression;
        this.manifestDurationFormat = builder.manifestDurationFormat;
        this.minBufferTime = builder.minBufferTime;
        this.minFinalSegmentLength = builder.minFinalSegmentLength;
        this.mpdManifestBandwidthType = builder.mpdManifestBandwidthType;
        this.mpdProfile = builder.mpdProfile;
        this.ptsOffsetHandlingForBFrames = builder.ptsOffsetHandlingForBFrames;
        this.segmentControl = builder.segmentControl;
        this.segmentLength = builder.segmentLength;
        this.segmentLengthControl = builder.segmentLengthControl;
        this.streamInfResolution = builder.streamInfResolution;
        this.targetDurationCompatibilityMode = builder.targetDurationCompatibilityMode;
        this.videoCompositionOffsets = builder.videoCompositionOffsets;
        this.writeDashManifest = builder.writeDashManifest;
        this.writeHlsManifest = builder.writeHlsManifest;
        this.writeSegmentTimelineInRepresentation = builder.writeSegmentTimelineInRepresentation;
    }

    /**
     * For responses, this returns true if the service returned a value for the AdditionalManifests property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAdditionalManifests() {
        return additionalManifests != null && !(additionalManifests instanceof SdkAutoConstructList);
    }

    /**
     * By default, the service creates one top-level .m3u8 HLS manifest and one top -level .mpd DASH manifest for each
     * CMAF output group in your job. These default manifests reference every output in the output group. To create
     * additional top-level manifests that reference a subset of the outputs in the output group, specify a list of them
     * here. For each additional manifest that you specify, the service creates one HLS manifest and one DASH manifest.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAdditionalManifests} method.
     * </p>
     * 
     * @return By default, the service creates one top-level .m3u8 HLS manifest and one top -level .mpd DASH manifest
     *         for each CMAF output group in your job. These default manifests reference every output in the output
     *         group. To create additional top-level manifests that reference a subset of the outputs in the output
     *         group, specify a list of them here. For each additional manifest that you specify, the service creates
     *         one HLS manifest and one DASH manifest.
     */
    public final List<CmafAdditionalManifest> additionalManifests() {
        return additionalManifests;
    }

    /**
     * A partial URI prefix that will be put in the manifest file at the top level BaseURL element. Can be used if
     * streams are delivered from a different URL than the manifest file.
     * 
     * @return A partial URI prefix that will be put in the manifest file at the top level BaseURL element. Can be used
     *         if streams are delivered from a different URL than the manifest file.
     */
    public final String baseUrl() {
        return baseUrl;
    }

    /**
     * Disable this setting only when your workflow requires the #EXT-X-ALLOW-CACHE:no tag. Otherwise, keep the default
     * value Enabled and control caching in your video distribution set up. For example, use the Cache-Control http
     * header.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #clientCache} will
     * return {@link CmafClientCache#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #clientCacheAsString}.
     * </p>
     * 
     * @return Disable this setting only when your workflow requires the #EXT-X-ALLOW-CACHE:no tag. Otherwise, keep the
     *         default value Enabled and control caching in your video distribution set up. For example, use the
     *         Cache-Control http header.
     * @see CmafClientCache
     */
    public final CmafClientCache clientCache() {
        return CmafClientCache.fromValue(clientCache);
    }

    /**
     * Disable this setting only when your workflow requires the #EXT-X-ALLOW-CACHE:no tag. Otherwise, keep the default
     * value Enabled and control caching in your video distribution set up. For example, use the Cache-Control http
     * header.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #clientCache} will
     * return {@link CmafClientCache#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #clientCacheAsString}.
     * </p>
     * 
     * @return Disable this setting only when your workflow requires the #EXT-X-ALLOW-CACHE:no tag. Otherwise, keep the
     *         default value Enabled and control caching in your video distribution set up. For example, use the
     *         Cache-Control http header.
     * @see CmafClientCache
     */
    public final String clientCacheAsString() {
        return clientCache;
    }

    /**
     * Specification to use (RFC-6381 or the default RFC-4281) during m3u8 playlist generation.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #codecSpecification} will return {@link CmafCodecSpecification#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #codecSpecificationAsString}.
     * </p>
     * 
     * @return Specification to use (RFC-6381 or the default RFC-4281) during m3u8 playlist generation.
     * @see CmafCodecSpecification
     */
    public final CmafCodecSpecification codecSpecification() {
        return CmafCodecSpecification.fromValue(codecSpecification);
    }

    /**
     * Specification to use (RFC-6381 or the default RFC-4281) during m3u8 playlist generation.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #codecSpecification} will return {@link CmafCodecSpecification#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #codecSpecificationAsString}.
     * </p>
     * 
     * @return Specification to use (RFC-6381 or the default RFC-4281) during m3u8 playlist generation.
     * @see CmafCodecSpecification
     */
    public final String codecSpecificationAsString() {
        return codecSpecification;
    }

    /**
     * Specify whether MediaConvert generates I-frame only video segments for DASH trick play, also known as trick mode.
     * When specified, the I-frame only video segments are included within an additional AdaptationSet in your DASH
     * output manifest. To generate I-frame only video segments: Enter a name as a text string, up to 256 character
     * long. This name is appended to the end of this output group's base filename, that you specify as part of your
     * destination URI, and used for the I-frame only video segment files. You may also include format identifiers. For
     * more information, see:
     * https://docs.aws.amazon.com/mediaconvert/latest/ug/using-variables-in-your-job-settings.html
     * #using-settings-variables-with-streaming-outputs To not generate I-frame only video segments: Leave blank.
     * 
     * @return Specify whether MediaConvert generates I-frame only video segments for DASH trick play, also known as
     *         trick mode. When specified, the I-frame only video segments are included within an additional
     *         AdaptationSet in your DASH output manifest. To generate I-frame only video segments: Enter a name as a
     *         text string, up to 256 character long. This name is appended to the end of this output group's base
     *         filename, that you specify as part of your destination URI, and used for the I-frame only video segment
     *         files. You may also include format identifiers. For more information, see:
     *         https://docs.aws.amazon.com/mediaconvert
     *         /latest/ug/using-variables-in-your-job-settings.html#using-settings-variables-with-streaming-outputs To
     *         not generate I-frame only video segments: Leave blank.
     */
    public final String dashIFrameTrickPlayNameModifier() {
        return dashIFrameTrickPlayNameModifier;
    }

    /**
     * Specify how MediaConvert writes SegmentTimeline in your output DASH manifest. To write a SegmentTimeline in each
     * video Representation: Keep the default value, Basic. To write a common SegmentTimeline in the video
     * AdaptationSet: Choose Compact. Note that MediaConvert will still write a SegmentTimeline in any Representation
     * that does not share a common timeline. To write a video AdaptationSet for each different output framerate, and a
     * common SegmentTimeline in each AdaptationSet: Choose Distinct.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dashManifestStyle}
     * will return {@link DashManifestStyle#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #dashManifestStyleAsString}.
     * </p>
     * 
     * @return Specify how MediaConvert writes SegmentTimeline in your output DASH manifest. To write a SegmentTimeline
     *         in each video Representation: Keep the default value, Basic. To write a common SegmentTimeline in the
     *         video AdaptationSet: Choose Compact. Note that MediaConvert will still write a SegmentTimeline in any
     *         Representation that does not share a common timeline. To write a video AdaptationSet for each different
     *         output framerate, and a common SegmentTimeline in each AdaptationSet: Choose Distinct.
     * @see DashManifestStyle
     */
    public final DashManifestStyle dashManifestStyle() {
        return DashManifestStyle.fromValue(dashManifestStyle);
    }

    /**
     * Specify how MediaConvert writes SegmentTimeline in your output DASH manifest. To write a SegmentTimeline in each
     * video Representation: Keep the default value, Basic. To write a common SegmentTimeline in the video
     * AdaptationSet: Choose Compact. Note that MediaConvert will still write a SegmentTimeline in any Representation
     * that does not share a common timeline. To write a video AdaptationSet for each different output framerate, and a
     * common SegmentTimeline in each AdaptationSet: Choose Distinct.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dashManifestStyle}
     * will return {@link DashManifestStyle#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #dashManifestStyleAsString}.
     * </p>
     * 
     * @return Specify how MediaConvert writes SegmentTimeline in your output DASH manifest. To write a SegmentTimeline
     *         in each video Representation: Keep the default value, Basic. To write a common SegmentTimeline in the
     *         video AdaptationSet: Choose Compact. Note that MediaConvert will still write a SegmentTimeline in any
     *         Representation that does not share a common timeline. To write a video AdaptationSet for each different
     *         output framerate, and a common SegmentTimeline in each AdaptationSet: Choose Distinct.
     * @see DashManifestStyle
     */
    public final String dashManifestStyleAsString() {
        return dashManifestStyle;
    }

    /**
     * Use Destination to specify the S3 output location and the output filename base. Destination accepts format
     * identifiers. If you do not specify the base filename in the URI, the service will use the filename of the input
     * file. If your job has multiple inputs, the service uses the filename of the first input file.
     * 
     * @return Use Destination to specify the S3 output location and the output filename base. Destination accepts
     *         format identifiers. If you do not specify the base filename in the URI, the service will use the filename
     *         of the input file. If your job has multiple inputs, the service uses the filename of the first input
     *         file.
     */
    public final String destination() {
        return destination;
    }

    /**
     * Settings associated with the destination. Will vary based on the type of destination
     * 
     * @return Settings associated with the destination. Will vary based on the type of destination
     */
    public final DestinationSettings destinationSettings() {
        return destinationSettings;
    }

    /**
     * DRM settings.
     * 
     * @return DRM settings.
     */
    public final CmafEncryptionSettings encryption() {
        return encryption;
    }

    /**
     * Specify the length, in whole seconds, of the mp4 fragments. When you don't specify a value, MediaConvert defaults
     * to 2. Related setting: Use Fragment length control to specify whether the encoder enforces this value strictly.
     * 
     * @return Specify the length, in whole seconds, of the mp4 fragments. When you don't specify a value, MediaConvert
     *         defaults to 2. Related setting: Use Fragment length control to specify whether the encoder enforces this
     *         value strictly.
     */
    public final Integer fragmentLength() {
        return fragmentLength;
    }

    /**
     * Specify whether MediaConvert generates images for trick play. Keep the default value, None, to not generate any
     * images. Choose Thumbnail to generate tiled thumbnails. Choose Thumbnail and full frame to generate tiled
     * thumbnails and full-resolution images of single frames. When you enable Write HLS manifest, MediaConvert creates
     * a child manifest for each set of images that you generate and adds corresponding entries to the parent manifest.
     * When you enable Write DASH manifest, MediaConvert adds an entry in the .mpd manifest for each set of images that
     * you generate. A common application for these images is Roku trick mode. The thumbnails and full-frame images that
     * MediaConvert creates with this feature are compatible with this Roku specification:
     * https://developer.roku.com/docs/developer-program/media-playback/trick-mode/hls-and-dash.md
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #imageBasedTrickPlay} will return {@link CmafImageBasedTrickPlay#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #imageBasedTrickPlayAsString}.
     * </p>
     * 
     * @return Specify whether MediaConvert generates images for trick play. Keep the default value, None, to not
     *         generate any images. Choose Thumbnail to generate tiled thumbnails. Choose Thumbnail and full frame to
     *         generate tiled thumbnails and full-resolution images of single frames. When you enable Write HLS
     *         manifest, MediaConvert creates a child manifest for each set of images that you generate and adds
     *         corresponding entries to the parent manifest. When you enable Write DASH manifest, MediaConvert adds an
     *         entry in the .mpd manifest for each set of images that you generate. A common application for these
     *         images is Roku trick mode. The thumbnails and full-frame images that MediaConvert creates with this
     *         feature are compatible with this Roku specification:
     *         https://developer.roku.com/docs/developer-program/media-playback/trick-mode/hls-and-dash.md
     * @see CmafImageBasedTrickPlay
     */
    public final CmafImageBasedTrickPlay imageBasedTrickPlay() {
        return CmafImageBasedTrickPlay.fromValue(imageBasedTrickPlay);
    }

    /**
     * Specify whether MediaConvert generates images for trick play. Keep the default value, None, to not generate any
     * images. Choose Thumbnail to generate tiled thumbnails. Choose Thumbnail and full frame to generate tiled
     * thumbnails and full-resolution images of single frames. When you enable Write HLS manifest, MediaConvert creates
     * a child manifest for each set of images that you generate and adds corresponding entries to the parent manifest.
     * When you enable Write DASH manifest, MediaConvert adds an entry in the .mpd manifest for each set of images that
     * you generate. A common application for these images is Roku trick mode. The thumbnails and full-frame images that
     * MediaConvert creates with this feature are compatible with this Roku specification:
     * https://developer.roku.com/docs/developer-program/media-playback/trick-mode/hls-and-dash.md
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #imageBasedTrickPlay} will return {@link CmafImageBasedTrickPlay#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #imageBasedTrickPlayAsString}.
     * </p>
     * 
     * @return Specify whether MediaConvert generates images for trick play. Keep the default value, None, to not
     *         generate any images. Choose Thumbnail to generate tiled thumbnails. Choose Thumbnail and full frame to
     *         generate tiled thumbnails and full-resolution images of single frames. When you enable Write HLS
     *         manifest, MediaConvert creates a child manifest for each set of images that you generate and adds
     *         corresponding entries to the parent manifest. When you enable Write DASH manifest, MediaConvert adds an
     *         entry in the .mpd manifest for each set of images that you generate. A common application for these
     *         images is Roku trick mode. The thumbnails and full-frame images that MediaConvert creates with this
     *         feature are compatible with this Roku specification:
     *         https://developer.roku.com/docs/developer-program/media-playback/trick-mode/hls-and-dash.md
     * @see CmafImageBasedTrickPlay
     */
    public final String imageBasedTrickPlayAsString() {
        return imageBasedTrickPlay;
    }

    /**
     * Tile and thumbnail settings applicable when imageBasedTrickPlay is ADVANCED
     * 
     * @return Tile and thumbnail settings applicable when imageBasedTrickPlay is ADVANCED
     */
    public final CmafImageBasedTrickPlaySettings imageBasedTrickPlaySettings() {
        return imageBasedTrickPlaySettings;
    }

    /**
     * When set to GZIP, compresses HLS playlist.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #manifestCompression} will return {@link CmafManifestCompression#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #manifestCompressionAsString}.
     * </p>
     * 
     * @return When set to GZIP, compresses HLS playlist.
     * @see CmafManifestCompression
     */
    public final CmafManifestCompression manifestCompression() {
        return CmafManifestCompression.fromValue(manifestCompression);
    }

    /**
     * When set to GZIP, compresses HLS playlist.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #manifestCompression} will return {@link CmafManifestCompression#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #manifestCompressionAsString}.
     * </p>
     * 
     * @return When set to GZIP, compresses HLS playlist.
     * @see CmafManifestCompression
     */
    public final String manifestCompressionAsString() {
        return manifestCompression;
    }

    /**
     * Indicates whether the output manifest should use floating point values for segment duration.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #manifestDurationFormat} will return {@link CmafManifestDurationFormat#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #manifestDurationFormatAsString}.
     * </p>
     * 
     * @return Indicates whether the output manifest should use floating point values for segment duration.
     * @see CmafManifestDurationFormat
     */
    public final CmafManifestDurationFormat manifestDurationFormat() {
        return CmafManifestDurationFormat.fromValue(manifestDurationFormat);
    }

    /**
     * Indicates whether the output manifest should use floating point values for segment duration.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #manifestDurationFormat} will return {@link CmafManifestDurationFormat#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #manifestDurationFormatAsString}.
     * </p>
     * 
     * @return Indicates whether the output manifest should use floating point values for segment duration.
     * @see CmafManifestDurationFormat
     */
    public final String manifestDurationFormatAsString() {
        return manifestDurationFormat;
    }

    /**
     * Minimum time of initially buffered media that is needed to ensure smooth playout.
     * 
     * @return Minimum time of initially buffered media that is needed to ensure smooth playout.
     */
    public final Integer minBufferTime() {
        return minBufferTime;
    }

    /**
     * Keep this setting at the default value of 0, unless you are troubleshooting a problem with how devices play back
     * the end of your video asset. If you know that player devices are hanging on the final segment of your video
     * because the length of your final segment is too short, use this setting to specify a minimum final segment
     * length, in seconds. Choose a value that is greater than or equal to 1 and less than your segment length. When you
     * specify a value for this setting, the encoder will combine any final segment that is shorter than the length that
     * you specify with the previous segment. For example, your segment length is 3 seconds and your final segment is .5
     * seconds without a minimum final segment length; when you set the minimum final segment length to 1, your final
     * segment is 3.5 seconds.
     * 
     * @return Keep this setting at the default value of 0, unless you are troubleshooting a problem with how devices
     *         play back the end of your video asset. If you know that player devices are hanging on the final segment
     *         of your video because the length of your final segment is too short, use this setting to specify a
     *         minimum final segment length, in seconds. Choose a value that is greater than or equal to 1 and less than
     *         your segment length. When you specify a value for this setting, the encoder will combine any final
     *         segment that is shorter than the length that you specify with the previous segment. For example, your
     *         segment length is 3 seconds and your final segment is .5 seconds without a minimum final segment length;
     *         when you set the minimum final segment length to 1, your final segment is 3.5 seconds.
     */
    public final Double minFinalSegmentLength() {
        return minFinalSegmentLength;
    }

    /**
     * Specify how the value for bandwidth is determined for each video Representation in your output MPD manifest. We
     * recommend that you choose a MPD manifest bandwidth type that is compatible with your downstream player
     * configuration. Max: Use the same value that you specify for Max bitrate in the video output, in bits per second.
     * Average: Use the calculated average bitrate of the encoded video output, in bits per second.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #mpdManifestBandwidthType} will return {@link CmafMpdManifestBandwidthType#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #mpdManifestBandwidthTypeAsString}.
     * </p>
     * 
     * @return Specify how the value for bandwidth is determined for each video Representation in your output MPD
     *         manifest. We recommend that you choose a MPD manifest bandwidth type that is compatible with your
     *         downstream player configuration. Max: Use the same value that you specify for Max bitrate in the video
     *         output, in bits per second. Average: Use the calculated average bitrate of the encoded video output, in
     *         bits per second.
     * @see CmafMpdManifestBandwidthType
     */
    public final CmafMpdManifestBandwidthType mpdManifestBandwidthType() {
        return CmafMpdManifestBandwidthType.fromValue(mpdManifestBandwidthType);
    }

    /**
     * Specify how the value for bandwidth is determined for each video Representation in your output MPD manifest. We
     * recommend that you choose a MPD manifest bandwidth type that is compatible with your downstream player
     * configuration. Max: Use the same value that you specify for Max bitrate in the video output, in bits per second.
     * Average: Use the calculated average bitrate of the encoded video output, in bits per second.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #mpdManifestBandwidthType} will return {@link CmafMpdManifestBandwidthType#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #mpdManifestBandwidthTypeAsString}.
     * </p>
     * 
     * @return Specify how the value for bandwidth is determined for each video Representation in your output MPD
     *         manifest. We recommend that you choose a MPD manifest bandwidth type that is compatible with your
     *         downstream player configuration. Max: Use the same value that you specify for Max bitrate in the video
     *         output, in bits per second. Average: Use the calculated average bitrate of the encoded video output, in
     *         bits per second.
     * @see CmafMpdManifestBandwidthType
     */
    public final String mpdManifestBandwidthTypeAsString() {
        return mpdManifestBandwidthType;
    }

    /**
     * Specify whether your DASH profile is on-demand or main. When you choose Main profile, the service signals
     * urn:mpeg:dash:profile:isoff-main:2011 in your .mpd DASH manifest. When you choose On-demand, the service signals
     * urn:mpeg:dash:profile:isoff-on-demand:2011 in your .mpd. When you choose On-demand, you must also set the output
     * group setting Segment control to Single file.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mpdProfile} will
     * return {@link CmafMpdProfile#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #mpdProfileAsString}.
     * </p>
     * 
     * @return Specify whether your DASH profile is on-demand or main. When you choose Main profile, the service signals
     *         urn:mpeg:dash:profile:isoff-main:2011 in your .mpd DASH manifest. When you choose On-demand, the service
     *         signals urn:mpeg:dash:profile:isoff-on-demand:2011 in your .mpd. When you choose On-demand, you must also
     *         set the output group setting Segment control to Single file.
     * @see CmafMpdProfile
     */
    public final CmafMpdProfile mpdProfile() {
        return CmafMpdProfile.fromValue(mpdProfile);
    }

    /**
     * Specify whether your DASH profile is on-demand or main. When you choose Main profile, the service signals
     * urn:mpeg:dash:profile:isoff-main:2011 in your .mpd DASH manifest. When you choose On-demand, the service signals
     * urn:mpeg:dash:profile:isoff-on-demand:2011 in your .mpd. When you choose On-demand, you must also set the output
     * group setting Segment control to Single file.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mpdProfile} will
     * return {@link CmafMpdProfile#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #mpdProfileAsString}.
     * </p>
     * 
     * @return Specify whether your DASH profile is on-demand or main. When you choose Main profile, the service signals
     *         urn:mpeg:dash:profile:isoff-main:2011 in your .mpd DASH manifest. When you choose On-demand, the service
     *         signals urn:mpeg:dash:profile:isoff-on-demand:2011 in your .mpd. When you choose On-demand, you must also
     *         set the output group setting Segment control to Single file.
     * @see CmafMpdProfile
     */
    public final String mpdProfileAsString() {
        return mpdProfile;
    }

    /**
     * Use this setting only when your output video stream has B-frames, which causes the initial presentation time
     * stamp (PTS) to be offset from the initial decode time stamp (DTS). Specify how MediaConvert handles PTS when
     * writing time stamps in output DASH manifests. Choose Match initial PTS when you want MediaConvert to use the
     * initial PTS as the first time stamp in the manifest. Choose Zero-based to have MediaConvert ignore the initial
     * PTS in the video stream and instead write the initial time stamp as zero in the manifest. For outputs that don't
     * have B-frames, the time stamps in your DASH manifests start at zero regardless of your choice here.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #ptsOffsetHandlingForBFrames} will return {@link CmafPtsOffsetHandlingForBFrames#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #ptsOffsetHandlingForBFramesAsString}.
     * </p>
     * 
     * @return Use this setting only when your output video stream has B-frames, which causes the initial presentation
     *         time stamp (PTS) to be offset from the initial decode time stamp (DTS). Specify how MediaConvert handles
     *         PTS when writing time stamps in output DASH manifests. Choose Match initial PTS when you want
     *         MediaConvert to use the initial PTS as the first time stamp in the manifest. Choose Zero-based to have
     *         MediaConvert ignore the initial PTS in the video stream and instead write the initial time stamp as zero
     *         in the manifest. For outputs that don't have B-frames, the time stamps in your DASH manifests start at
     *         zero regardless of your choice here.
     * @see CmafPtsOffsetHandlingForBFrames
     */
    public final CmafPtsOffsetHandlingForBFrames ptsOffsetHandlingForBFrames() {
        return CmafPtsOffsetHandlingForBFrames.fromValue(ptsOffsetHandlingForBFrames);
    }

    /**
     * Use this setting only when your output video stream has B-frames, which causes the initial presentation time
     * stamp (PTS) to be offset from the initial decode time stamp (DTS). Specify how MediaConvert handles PTS when
     * writing time stamps in output DASH manifests. Choose Match initial PTS when you want MediaConvert to use the
     * initial PTS as the first time stamp in the manifest. Choose Zero-based to have MediaConvert ignore the initial
     * PTS in the video stream and instead write the initial time stamp as zero in the manifest. For outputs that don't
     * have B-frames, the time stamps in your DASH manifests start at zero regardless of your choice here.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #ptsOffsetHandlingForBFrames} will return {@link CmafPtsOffsetHandlingForBFrames#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #ptsOffsetHandlingForBFramesAsString}.
     * </p>
     * 
     * @return Use this setting only when your output video stream has B-frames, which causes the initial presentation
     *         time stamp (PTS) to be offset from the initial decode time stamp (DTS). Specify how MediaConvert handles
     *         PTS when writing time stamps in output DASH manifests. Choose Match initial PTS when you want
     *         MediaConvert to use the initial PTS as the first time stamp in the manifest. Choose Zero-based to have
     *         MediaConvert ignore the initial PTS in the video stream and instead write the initial time stamp as zero
     *         in the manifest. For outputs that don't have B-frames, the time stamps in your DASH manifests start at
     *         zero regardless of your choice here.
     * @see CmafPtsOffsetHandlingForBFrames
     */
    public final String ptsOffsetHandlingForBFramesAsString() {
        return ptsOffsetHandlingForBFrames;
    }

    /**
     * When set to SINGLE_FILE, a single output file is generated, which is internally segmented using the Fragment
     * Length and Segment Length. When set to SEGMENTED_FILES, separate segment files will be created.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #segmentControl}
     * will return {@link CmafSegmentControl#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #segmentControlAsString}.
     * </p>
     * 
     * @return When set to SINGLE_FILE, a single output file is generated, which is internally segmented using the
     *         Fragment Length and Segment Length. When set to SEGMENTED_FILES, separate segment files will be created.
     * @see CmafSegmentControl
     */
    public final CmafSegmentControl segmentControl() {
        return CmafSegmentControl.fromValue(segmentControl);
    }

    /**
     * When set to SINGLE_FILE, a single output file is generated, which is internally segmented using the Fragment
     * Length and Segment Length. When set to SEGMENTED_FILES, separate segment files will be created.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #segmentControl}
     * will return {@link CmafSegmentControl#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #segmentControlAsString}.
     * </p>
     * 
     * @return When set to SINGLE_FILE, a single output file is generated, which is internally segmented using the
     *         Fragment Length and Segment Length. When set to SEGMENTED_FILES, separate segment files will be created.
     * @see CmafSegmentControl
     */
    public final String segmentControlAsString() {
        return segmentControl;
    }

    /**
     * Specify the length, in whole seconds, of each segment. When you don't specify a value, MediaConvert defaults to
     * 10. Related settings: Use Segment length control to specify whether the encoder enforces this value strictly. Use
     * Segment control to specify whether MediaConvert creates separate segment files or one content file that has
     * metadata to mark the segment boundaries.
     * 
     * @return Specify the length, in whole seconds, of each segment. When you don't specify a value, MediaConvert
     *         defaults to 10. Related settings: Use Segment length control to specify whether the encoder enforces this
     *         value strictly. Use Segment control to specify whether MediaConvert creates separate segment files or one
     *         content file that has metadata to mark the segment boundaries.
     */
    public final Integer segmentLength() {
        return segmentLength;
    }

    /**
     * Specify how you want MediaConvert to determine the segment length. Choose Exact to have the encoder use the exact
     * length that you specify with the setting Segment length. This might result in extra I-frames. Choose Multiple of
     * GOP to have the encoder round up the segment lengths to match the next GOP boundary.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #segmentLengthControl} will return {@link CmafSegmentLengthControl#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #segmentLengthControlAsString}.
     * </p>
     * 
     * @return Specify how you want MediaConvert to determine the segment length. Choose Exact to have the encoder use
     *         the exact length that you specify with the setting Segment length. This might result in extra I-frames.
     *         Choose Multiple of GOP to have the encoder round up the segment lengths to match the next GOP boundary.
     * @see CmafSegmentLengthControl
     */
    public final CmafSegmentLengthControl segmentLengthControl() {
        return CmafSegmentLengthControl.fromValue(segmentLengthControl);
    }

    /**
     * Specify how you want MediaConvert to determine the segment length. Choose Exact to have the encoder use the exact
     * length that you specify with the setting Segment length. This might result in extra I-frames. Choose Multiple of
     * GOP to have the encoder round up the segment lengths to match the next GOP boundary.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #segmentLengthControl} will return {@link CmafSegmentLengthControl#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #segmentLengthControlAsString}.
     * </p>
     * 
     * @return Specify how you want MediaConvert to determine the segment length. Choose Exact to have the encoder use
     *         the exact length that you specify with the setting Segment length. This might result in extra I-frames.
     *         Choose Multiple of GOP to have the encoder round up the segment lengths to match the next GOP boundary.
     * @see CmafSegmentLengthControl
     */
    public final String segmentLengthControlAsString() {
        return segmentLengthControl;
    }

    /**
     * Include or exclude RESOLUTION attribute for video in EXT-X-STREAM-INF tag of variant manifest.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #streamInfResolution} will return {@link CmafStreamInfResolution#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #streamInfResolutionAsString}.
     * </p>
     * 
     * @return Include or exclude RESOLUTION attribute for video in EXT-X-STREAM-INF tag of variant manifest.
     * @see CmafStreamInfResolution
     */
    public final CmafStreamInfResolution streamInfResolution() {
        return CmafStreamInfResolution.fromValue(streamInfResolution);
    }

    /**
     * Include or exclude RESOLUTION attribute for video in EXT-X-STREAM-INF tag of variant manifest.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #streamInfResolution} will return {@link CmafStreamInfResolution#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #streamInfResolutionAsString}.
     * </p>
     * 
     * @return Include or exclude RESOLUTION attribute for video in EXT-X-STREAM-INF tag of variant manifest.
     * @see CmafStreamInfResolution
     */
    public final String streamInfResolutionAsString() {
        return streamInfResolution;
    }

    /**
     * When set to LEGACY, the segment target duration is always rounded up to the nearest integer value above its
     * current value in seconds. When set to SPEC\\_COMPLIANT, the segment target duration is rounded up to the nearest
     * integer value if fraction seconds are greater than or equal to 0.5 (>= 0.5) and rounded down if less than 0.5 (<
     * 0.5). You may need to use LEGACY if your client needs to ensure that the target duration is always longer than
     * the actual duration of the segment. Some older players may experience interrupted playback when the actual
     * duration of a track in a segment is longer than the target duration.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #targetDurationCompatibilityMode} will return
     * {@link CmafTargetDurationCompatibilityMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #targetDurationCompatibilityModeAsString}.
     * </p>
     * 
     * @return When set to LEGACY, the segment target duration is always rounded up to the nearest integer value above
     *         its current value in seconds. When set to SPEC\\_COMPLIANT, the segment target duration is rounded up to
     *         the nearest integer value if fraction seconds are greater than or equal to 0.5 (>= 0.5) and rounded down
     *         if less than 0.5 (< 0.5). You may need to use LEGACY if your client needs to ensure that the target
     *         duration is always longer than the actual duration of the segment. Some older players may experience
     *         interrupted playback when the actual duration of a track in a segment is longer than the target duration.
     * @see CmafTargetDurationCompatibilityMode
     */
    public final CmafTargetDurationCompatibilityMode targetDurationCompatibilityMode() {
        return CmafTargetDurationCompatibilityMode.fromValue(targetDurationCompatibilityMode);
    }

    /**
     * When set to LEGACY, the segment target duration is always rounded up to the nearest integer value above its
     * current value in seconds. When set to SPEC\\_COMPLIANT, the segment target duration is rounded up to the nearest
     * integer value if fraction seconds are greater than or equal to 0.5 (>= 0.5) and rounded down if less than 0.5 (<
     * 0.5). You may need to use LEGACY if your client needs to ensure that the target duration is always longer than
     * the actual duration of the segment. Some older players may experience interrupted playback when the actual
     * duration of a track in a segment is longer than the target duration.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #targetDurationCompatibilityMode} will return
     * {@link CmafTargetDurationCompatibilityMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #targetDurationCompatibilityModeAsString}.
     * </p>
     * 
     * @return When set to LEGACY, the segment target duration is always rounded up to the nearest integer value above
     *         its current value in seconds. When set to SPEC\\_COMPLIANT, the segment target duration is rounded up to
     *         the nearest integer value if fraction seconds are greater than or equal to 0.5 (>= 0.5) and rounded down
     *         if less than 0.5 (< 0.5). You may need to use LEGACY if your client needs to ensure that the target
     *         duration is always longer than the actual duration of the segment. Some older players may experience
     *         interrupted playback when the actual duration of a track in a segment is longer than the target duration.
     * @see CmafTargetDurationCompatibilityMode
     */
    public final String targetDurationCompatibilityModeAsString() {
        return targetDurationCompatibilityMode;
    }

    /**
     * Specify the video sample composition time offset mode in the output fMP4 TRUN box. For wider player
     * compatibility, set Video composition offsets to Unsigned or leave blank. The earliest presentation time may be
     * greater than zero, and sample composition time offsets will increment using unsigned integers. For strict fMP4
     * video and audio timing, set Video composition offsets to Signed. The earliest presentation time will be equal to
     * zero, and sample composition time offsets will increment using signed integers.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #videoCompositionOffsets} will return {@link CmafVideoCompositionOffsets#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #videoCompositionOffsetsAsString}.
     * </p>
     * 
     * @return Specify the video sample composition time offset mode in the output fMP4 TRUN box. For wider player
     *         compatibility, set Video composition offsets to Unsigned or leave blank. The earliest presentation time
     *         may be greater than zero, and sample composition time offsets will increment using unsigned integers. For
     *         strict fMP4 video and audio timing, set Video composition offsets to Signed. The earliest presentation
     *         time will be equal to zero, and sample composition time offsets will increment using signed integers.
     * @see CmafVideoCompositionOffsets
     */
    public final CmafVideoCompositionOffsets videoCompositionOffsets() {
        return CmafVideoCompositionOffsets.fromValue(videoCompositionOffsets);
    }

    /**
     * Specify the video sample composition time offset mode in the output fMP4 TRUN box. For wider player
     * compatibility, set Video composition offsets to Unsigned or leave blank. The earliest presentation time may be
     * greater than zero, and sample composition time offsets will increment using unsigned integers. For strict fMP4
     * video and audio timing, set Video composition offsets to Signed. The earliest presentation time will be equal to
     * zero, and sample composition time offsets will increment using signed integers.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #videoCompositionOffsets} will return {@link CmafVideoCompositionOffsets#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #videoCompositionOffsetsAsString}.
     * </p>
     * 
     * @return Specify the video sample composition time offset mode in the output fMP4 TRUN box. For wider player
     *         compatibility, set Video composition offsets to Unsigned or leave blank. The earliest presentation time
     *         may be greater than zero, and sample composition time offsets will increment using unsigned integers. For
     *         strict fMP4 video and audio timing, set Video composition offsets to Signed. The earliest presentation
     *         time will be equal to zero, and sample composition time offsets will increment using signed integers.
     * @see CmafVideoCompositionOffsets
     */
    public final String videoCompositionOffsetsAsString() {
        return videoCompositionOffsets;
    }

    /**
     * When set to ENABLED, a DASH MPD manifest will be generated for this output.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #writeDashManifest}
     * will return {@link CmafWriteDASHManifest#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #writeDashManifestAsString}.
     * </p>
     * 
     * @return When set to ENABLED, a DASH MPD manifest will be generated for this output.
     * @see CmafWriteDASHManifest
     */
    public final CmafWriteDASHManifest writeDashManifest() {
        return CmafWriteDASHManifest.fromValue(writeDashManifest);
    }

    /**
     * When set to ENABLED, a DASH MPD manifest will be generated for this output.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #writeDashManifest}
     * will return {@link CmafWriteDASHManifest#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #writeDashManifestAsString}.
     * </p>
     * 
     * @return When set to ENABLED, a DASH MPD manifest will be generated for this output.
     * @see CmafWriteDASHManifest
     */
    public final String writeDashManifestAsString() {
        return writeDashManifest;
    }

    /**
     * When set to ENABLED, an Apple HLS manifest will be generated for this output.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #writeHlsManifest}
     * will return {@link CmafWriteHLSManifest#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #writeHlsManifestAsString}.
     * </p>
     * 
     * @return When set to ENABLED, an Apple HLS manifest will be generated for this output.
     * @see CmafWriteHLSManifest
     */
    public final CmafWriteHLSManifest writeHlsManifest() {
        return CmafWriteHLSManifest.fromValue(writeHlsManifest);
    }

    /**
     * When set to ENABLED, an Apple HLS manifest will be generated for this output.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #writeHlsManifest}
     * will return {@link CmafWriteHLSManifest#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #writeHlsManifestAsString}.
     * </p>
     * 
     * @return When set to ENABLED, an Apple HLS manifest will be generated for this output.
     * @see CmafWriteHLSManifest
     */
    public final String writeHlsManifestAsString() {
        return writeHlsManifest;
    }

    /**
     * When you enable Precise segment duration in DASH manifests, your DASH manifest shows precise segment durations.
     * The segment duration information appears inside the SegmentTimeline element, inside SegmentTemplate at the
     * Representation level. When this feature isn't enabled, the segment durations in your DASH manifest are
     * approximate. The segment duration information appears in the duration attribute of the SegmentTemplate element.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #writeSegmentTimelineInRepresentation} will return
     * {@link CmafWriteSegmentTimelineInRepresentation#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #writeSegmentTimelineInRepresentationAsString}.
     * </p>
     * 
     * @return When you enable Precise segment duration in DASH manifests, your DASH manifest shows precise segment
     *         durations. The segment duration information appears inside the SegmentTimeline element, inside
     *         SegmentTemplate at the Representation level. When this feature isn't enabled, the segment durations in
     *         your DASH manifest are approximate. The segment duration information appears in the duration attribute of
     *         the SegmentTemplate element.
     * @see CmafWriteSegmentTimelineInRepresentation
     */
    public final CmafWriteSegmentTimelineInRepresentation writeSegmentTimelineInRepresentation() {
        return CmafWriteSegmentTimelineInRepresentation.fromValue(writeSegmentTimelineInRepresentation);
    }

    /**
     * When you enable Precise segment duration in DASH manifests, your DASH manifest shows precise segment durations.
     * The segment duration information appears inside the SegmentTimeline element, inside SegmentTemplate at the
     * Representation level. When this feature isn't enabled, the segment durations in your DASH manifest are
     * approximate. The segment duration information appears in the duration attribute of the SegmentTemplate element.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #writeSegmentTimelineInRepresentation} will return
     * {@link CmafWriteSegmentTimelineInRepresentation#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #writeSegmentTimelineInRepresentationAsString}.
     * </p>
     * 
     * @return When you enable Precise segment duration in DASH manifests, your DASH manifest shows precise segment
     *         durations. The segment duration information appears inside the SegmentTimeline element, inside
     *         SegmentTemplate at the Representation level. When this feature isn't enabled, the segment durations in
     *         your DASH manifest are approximate. The segment duration information appears in the duration attribute of
     *         the SegmentTemplate element.
     * @see CmafWriteSegmentTimelineInRepresentation
     */
    public final String writeSegmentTimelineInRepresentationAsString() {
        return writeSegmentTimelineInRepresentation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasAdditionalManifests() ? additionalManifests() : null);
        hashCode = 31 * hashCode + Objects.hashCode(baseUrl());
        hashCode = 31 * hashCode + Objects.hashCode(clientCacheAsString());
        hashCode = 31 * hashCode + Objects.hashCode(codecSpecificationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(dashIFrameTrickPlayNameModifier());
        hashCode = 31 * hashCode + Objects.hashCode(dashManifestStyleAsString());
        hashCode = 31 * hashCode + Objects.hashCode(destination());
        hashCode = 31 * hashCode + Objects.hashCode(destinationSettings());
        hashCode = 31 * hashCode + Objects.hashCode(encryption());
        hashCode = 31 * hashCode + Objects.hashCode(fragmentLength());
        hashCode = 31 * hashCode + Objects.hashCode(imageBasedTrickPlayAsString());
        hashCode = 31 * hashCode + Objects.hashCode(imageBasedTrickPlaySettings());
        hashCode = 31 * hashCode + Objects.hashCode(manifestCompressionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(manifestDurationFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(minBufferTime());
        hashCode = 31 * hashCode + Objects.hashCode(minFinalSegmentLength());
        hashCode = 31 * hashCode + Objects.hashCode(mpdManifestBandwidthTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(mpdProfileAsString());
        hashCode = 31 * hashCode + Objects.hashCode(ptsOffsetHandlingForBFramesAsString());
        hashCode = 31 * hashCode + Objects.hashCode(segmentControlAsString());
        hashCode = 31 * hashCode + Objects.hashCode(segmentLength());
        hashCode = 31 * hashCode + Objects.hashCode(segmentLengthControlAsString());
        hashCode = 31 * hashCode + Objects.hashCode(streamInfResolutionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(targetDurationCompatibilityModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(videoCompositionOffsetsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(writeDashManifestAsString());
        hashCode = 31 * hashCode + Objects.hashCode(writeHlsManifestAsString());
        hashCode = 31 * hashCode + Objects.hashCode(writeSegmentTimelineInRepresentationAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CmafGroupSettings)) {
            return false;
        }
        CmafGroupSettings other = (CmafGroupSettings) obj;
        return hasAdditionalManifests() == other.hasAdditionalManifests()
                && Objects.equals(additionalManifests(), other.additionalManifests())
                && Objects.equals(baseUrl(), other.baseUrl())
                && Objects.equals(clientCacheAsString(), other.clientCacheAsString())
                && Objects.equals(codecSpecificationAsString(), other.codecSpecificationAsString())
                && Objects.equals(dashIFrameTrickPlayNameModifier(), other.dashIFrameTrickPlayNameModifier())
                && Objects.equals(dashManifestStyleAsString(), other.dashManifestStyleAsString())
                && Objects.equals(destination(), other.destination())
                && Objects.equals(destinationSettings(), other.destinationSettings())
                && Objects.equals(encryption(), other.encryption())
                && Objects.equals(fragmentLength(), other.fragmentLength())
                && Objects.equals(imageBasedTrickPlayAsString(), other.imageBasedTrickPlayAsString())
                && Objects.equals(imageBasedTrickPlaySettings(), other.imageBasedTrickPlaySettings())
                && Objects.equals(manifestCompressionAsString(), other.manifestCompressionAsString())
                && Objects.equals(manifestDurationFormatAsString(), other.manifestDurationFormatAsString())
                && Objects.equals(minBufferTime(), other.minBufferTime())
                && Objects.equals(minFinalSegmentLength(), other.minFinalSegmentLength())
                && Objects.equals(mpdManifestBandwidthTypeAsString(), other.mpdManifestBandwidthTypeAsString())
                && Objects.equals(mpdProfileAsString(), other.mpdProfileAsString())
                && Objects.equals(ptsOffsetHandlingForBFramesAsString(), other.ptsOffsetHandlingForBFramesAsString())
                && Objects.equals(segmentControlAsString(), other.segmentControlAsString())
                && Objects.equals(segmentLength(), other.segmentLength())
                && Objects.equals(segmentLengthControlAsString(), other.segmentLengthControlAsString())
                && Objects.equals(streamInfResolutionAsString(), other.streamInfResolutionAsString())
                && Objects.equals(targetDurationCompatibilityModeAsString(), other.targetDurationCompatibilityModeAsString())
                && Objects.equals(videoCompositionOffsetsAsString(), other.videoCompositionOffsetsAsString())
                && Objects.equals(writeDashManifestAsString(), other.writeDashManifestAsString())
                && Objects.equals(writeHlsManifestAsString(), other.writeHlsManifestAsString())
                && Objects.equals(writeSegmentTimelineInRepresentationAsString(),
                        other.writeSegmentTimelineInRepresentationAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CmafGroupSettings")
                .add("AdditionalManifests", hasAdditionalManifests() ? additionalManifests() : null).add("BaseUrl", baseUrl())
                .add("ClientCache", clientCacheAsString()).add("CodecSpecification", codecSpecificationAsString())
                .add("DashIFrameTrickPlayNameModifier", dashIFrameTrickPlayNameModifier())
                .add("DashManifestStyle", dashManifestStyleAsString()).add("Destination", destination())
                .add("DestinationSettings", destinationSettings()).add("Encryption", encryption())
                .add("FragmentLength", fragmentLength()).add("ImageBasedTrickPlay", imageBasedTrickPlayAsString())
                .add("ImageBasedTrickPlaySettings", imageBasedTrickPlaySettings())
                .add("ManifestCompression", manifestCompressionAsString())
                .add("ManifestDurationFormat", manifestDurationFormatAsString()).add("MinBufferTime", minBufferTime())
                .add("MinFinalSegmentLength", minFinalSegmentLength())
                .add("MpdManifestBandwidthType", mpdManifestBandwidthTypeAsString()).add("MpdProfile", mpdProfileAsString())
                .add("PtsOffsetHandlingForBFrames", ptsOffsetHandlingForBFramesAsString())
                .add("SegmentControl", segmentControlAsString()).add("SegmentLength", segmentLength())
                .add("SegmentLengthControl", segmentLengthControlAsString())
                .add("StreamInfResolution", streamInfResolutionAsString())
                .add("TargetDurationCompatibilityMode", targetDurationCompatibilityModeAsString())
                .add("VideoCompositionOffsets", videoCompositionOffsetsAsString())
                .add("WriteDashManifest", writeDashManifestAsString()).add("WriteHlsManifest", writeHlsManifestAsString())
                .add("WriteSegmentTimelineInRepresentation", writeSegmentTimelineInRepresentationAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AdditionalManifests":
            return Optional.ofNullable(clazz.cast(additionalManifests()));
        case "BaseUrl":
            return Optional.ofNullable(clazz.cast(baseUrl()));
        case "ClientCache":
            return Optional.ofNullable(clazz.cast(clientCacheAsString()));
        case "CodecSpecification":
            return Optional.ofNullable(clazz.cast(codecSpecificationAsString()));
        case "DashIFrameTrickPlayNameModifier":
            return Optional.ofNullable(clazz.cast(dashIFrameTrickPlayNameModifier()));
        case "DashManifestStyle":
            return Optional.ofNullable(clazz.cast(dashManifestStyleAsString()));
        case "Destination":
            return Optional.ofNullable(clazz.cast(destination()));
        case "DestinationSettings":
            return Optional.ofNullable(clazz.cast(destinationSettings()));
        case "Encryption":
            return Optional.ofNullable(clazz.cast(encryption()));
        case "FragmentLength":
            return Optional.ofNullable(clazz.cast(fragmentLength()));
        case "ImageBasedTrickPlay":
            return Optional.ofNullable(clazz.cast(imageBasedTrickPlayAsString()));
        case "ImageBasedTrickPlaySettings":
            return Optional.ofNullable(clazz.cast(imageBasedTrickPlaySettings()));
        case "ManifestCompression":
            return Optional.ofNullable(clazz.cast(manifestCompressionAsString()));
        case "ManifestDurationFormat":
            return Optional.ofNullable(clazz.cast(manifestDurationFormatAsString()));
        case "MinBufferTime":
            return Optional.ofNullable(clazz.cast(minBufferTime()));
        case "MinFinalSegmentLength":
            return Optional.ofNullable(clazz.cast(minFinalSegmentLength()));
        case "MpdManifestBandwidthType":
            return Optional.ofNullable(clazz.cast(mpdManifestBandwidthTypeAsString()));
        case "MpdProfile":
            return Optional.ofNullable(clazz.cast(mpdProfileAsString()));
        case "PtsOffsetHandlingForBFrames":
            return Optional.ofNullable(clazz.cast(ptsOffsetHandlingForBFramesAsString()));
        case "SegmentControl":
            return Optional.ofNullable(clazz.cast(segmentControlAsString()));
        case "SegmentLength":
            return Optional.ofNullable(clazz.cast(segmentLength()));
        case "SegmentLengthControl":
            return Optional.ofNullable(clazz.cast(segmentLengthControlAsString()));
        case "StreamInfResolution":
            return Optional.ofNullable(clazz.cast(streamInfResolutionAsString()));
        case "TargetDurationCompatibilityMode":
            return Optional.ofNullable(clazz.cast(targetDurationCompatibilityModeAsString()));
        case "VideoCompositionOffsets":
            return Optional.ofNullable(clazz.cast(videoCompositionOffsetsAsString()));
        case "WriteDashManifest":
            return Optional.ofNullable(clazz.cast(writeDashManifestAsString()));
        case "WriteHlsManifest":
            return Optional.ofNullable(clazz.cast(writeHlsManifestAsString()));
        case "WriteSegmentTimelineInRepresentation":
            return Optional.ofNullable(clazz.cast(writeSegmentTimelineInRepresentationAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("additionalManifests", ADDITIONAL_MANIFESTS_FIELD);
        map.put("baseUrl", BASE_URL_FIELD);
        map.put("clientCache", CLIENT_CACHE_FIELD);
        map.put("codecSpecification", CODEC_SPECIFICATION_FIELD);
        map.put("dashIFrameTrickPlayNameModifier", DASH_I_FRAME_TRICK_PLAY_NAME_MODIFIER_FIELD);
        map.put("dashManifestStyle", DASH_MANIFEST_STYLE_FIELD);
        map.put("destination", DESTINATION_FIELD);
        map.put("destinationSettings", DESTINATION_SETTINGS_FIELD);
        map.put("encryption", ENCRYPTION_FIELD);
        map.put("fragmentLength", FRAGMENT_LENGTH_FIELD);
        map.put("imageBasedTrickPlay", IMAGE_BASED_TRICK_PLAY_FIELD);
        map.put("imageBasedTrickPlaySettings", IMAGE_BASED_TRICK_PLAY_SETTINGS_FIELD);
        map.put("manifestCompression", MANIFEST_COMPRESSION_FIELD);
        map.put("manifestDurationFormat", MANIFEST_DURATION_FORMAT_FIELD);
        map.put("minBufferTime", MIN_BUFFER_TIME_FIELD);
        map.put("minFinalSegmentLength", MIN_FINAL_SEGMENT_LENGTH_FIELD);
        map.put("mpdManifestBandwidthType", MPD_MANIFEST_BANDWIDTH_TYPE_FIELD);
        map.put("mpdProfile", MPD_PROFILE_FIELD);
        map.put("ptsOffsetHandlingForBFrames", PTS_OFFSET_HANDLING_FOR_B_FRAMES_FIELD);
        map.put("segmentControl", SEGMENT_CONTROL_FIELD);
        map.put("segmentLength", SEGMENT_LENGTH_FIELD);
        map.put("segmentLengthControl", SEGMENT_LENGTH_CONTROL_FIELD);
        map.put("streamInfResolution", STREAM_INF_RESOLUTION_FIELD);
        map.put("targetDurationCompatibilityMode", TARGET_DURATION_COMPATIBILITY_MODE_FIELD);
        map.put("videoCompositionOffsets", VIDEO_COMPOSITION_OFFSETS_FIELD);
        map.put("writeDashManifest", WRITE_DASH_MANIFEST_FIELD);
        map.put("writeHlsManifest", WRITE_HLS_MANIFEST_FIELD);
        map.put("writeSegmentTimelineInRepresentation", WRITE_SEGMENT_TIMELINE_IN_REPRESENTATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CmafGroupSettings, T> g) {
        return obj -> g.apply((CmafGroupSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CmafGroupSettings> {
        /**
         * By default, the service creates one top-level .m3u8 HLS manifest and one top -level .mpd DASH manifest for
         * each CMAF output group in your job. These default manifests reference every output in the output group. To
         * create additional top-level manifests that reference a subset of the outputs in the output group, specify a
         * list of them here. For each additional manifest that you specify, the service creates one HLS manifest and
         * one DASH manifest.
         * 
         * @param additionalManifests
         *        By default, the service creates one top-level .m3u8 HLS manifest and one top -level .mpd DASH manifest
         *        for each CMAF output group in your job. These default manifests reference every output in the output
         *        group. To create additional top-level manifests that reference a subset of the outputs in the output
         *        group, specify a list of them here. For each additional manifest that you specify, the service creates
         *        one HLS manifest and one DASH manifest.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalManifests(Collection<CmafAdditionalManifest> additionalManifests);

        /**
         * By default, the service creates one top-level .m3u8 HLS manifest and one top -level .mpd DASH manifest for
         * each CMAF output group in your job. These default manifests reference every output in the output group. To
         * create additional top-level manifests that reference a subset of the outputs in the output group, specify a
         * list of them here. For each additional manifest that you specify, the service creates one HLS manifest and
         * one DASH manifest.
         * 
         * @param additionalManifests
         *        By default, the service creates one top-level .m3u8 HLS manifest and one top -level .mpd DASH manifest
         *        for each CMAF output group in your job. These default manifests reference every output in the output
         *        group. To create additional top-level manifests that reference a subset of the outputs in the output
         *        group, specify a list of them here. For each additional manifest that you specify, the service creates
         *        one HLS manifest and one DASH manifest.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalManifests(CmafAdditionalManifest... additionalManifests);

        /**
         * By default, the service creates one top-level .m3u8 HLS manifest and one top -level .mpd DASH manifest for
         * each CMAF output group in your job. These default manifests reference every output in the output group. To
         * create additional top-level manifests that reference a subset of the outputs in the output group, specify a
         * list of them here. For each additional manifest that you specify, the service creates one HLS manifest and
         * one DASH manifest. This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.mediaconvert.model.CmafAdditionalManifest.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.mediaconvert.model.CmafAdditionalManifest#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.mediaconvert.model.CmafAdditionalManifest.Builder#build()} is called
         * immediately and its result is passed to {@link #additionalManifests(List<CmafAdditionalManifest>)}.
         * 
         * @param additionalManifests
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.mediaconvert.model.CmafAdditionalManifest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #additionalManifests(java.util.Collection<CmafAdditionalManifest>)
         */
        Builder additionalManifests(Consumer<CmafAdditionalManifest.Builder>... additionalManifests);

        /**
         * A partial URI prefix that will be put in the manifest file at the top level BaseURL element. Can be used if
         * streams are delivered from a different URL than the manifest file.
         * 
         * @param baseUrl
         *        A partial URI prefix that will be put in the manifest file at the top level BaseURL element. Can be
         *        used if streams are delivered from a different URL than the manifest file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder baseUrl(String baseUrl);

        /**
         * Disable this setting only when your workflow requires the #EXT-X-ALLOW-CACHE:no tag. Otherwise, keep the
         * default value Enabled and control caching in your video distribution set up. For example, use the
         * Cache-Control http header.
         * 
         * @param clientCache
         *        Disable this setting only when your workflow requires the #EXT-X-ALLOW-CACHE:no tag. Otherwise, keep
         *        the default value Enabled and control caching in your video distribution set up. For example, use the
         *        Cache-Control http header.
         * @see CmafClientCache
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CmafClientCache
         */
        Builder clientCache(String clientCache);

        /**
         * Disable this setting only when your workflow requires the #EXT-X-ALLOW-CACHE:no tag. Otherwise, keep the
         * default value Enabled and control caching in your video distribution set up. For example, use the
         * Cache-Control http header.
         * 
         * @param clientCache
         *        Disable this setting only when your workflow requires the #EXT-X-ALLOW-CACHE:no tag. Otherwise, keep
         *        the default value Enabled and control caching in your video distribution set up. For example, use the
         *        Cache-Control http header.
         * @see CmafClientCache
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CmafClientCache
         */
        Builder clientCache(CmafClientCache clientCache);

        /**
         * Specification to use (RFC-6381 or the default RFC-4281) during m3u8 playlist generation.
         * 
         * @param codecSpecification
         *        Specification to use (RFC-6381 or the default RFC-4281) during m3u8 playlist generation.
         * @see CmafCodecSpecification
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CmafCodecSpecification
         */
        Builder codecSpecification(String codecSpecification);

        /**
         * Specification to use (RFC-6381 or the default RFC-4281) during m3u8 playlist generation.
         * 
         * @param codecSpecification
         *        Specification to use (RFC-6381 or the default RFC-4281) during m3u8 playlist generation.
         * @see CmafCodecSpecification
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CmafCodecSpecification
         */
        Builder codecSpecification(CmafCodecSpecification codecSpecification);

        /**
         * Specify whether MediaConvert generates I-frame only video segments for DASH trick play, also known as trick
         * mode. When specified, the I-frame only video segments are included within an additional AdaptationSet in your
         * DASH output manifest. To generate I-frame only video segments: Enter a name as a text string, up to 256
         * character long. This name is appended to the end of this output group's base filename, that you specify as
         * part of your destination URI, and used for the I-frame only video segment files. You may also include format
         * identifiers. For more information, see:
         * https://docs.aws.amazon.com/mediaconvert/latest/ug/using-variables-in-
         * your-job-settings.html#using-settings-variables-with-streaming-outputs To not generate I-frame only video
         * segments: Leave blank.
         * 
         * @param dashIFrameTrickPlayNameModifier
         *        Specify whether MediaConvert generates I-frame only video segments for DASH trick play, also known as
         *        trick mode. When specified, the I-frame only video segments are included within an additional
         *        AdaptationSet in your DASH output manifest. To generate I-frame only video segments: Enter a name as a
         *        text string, up to 256 character long. This name is appended to the end of this output group's base
         *        filename, that you specify as part of your destination URI, and used for the I-frame only video
         *        segment files. You may also include format identifiers. For more information, see:
         *        https://docs.aws.amazon
         *        .com/mediaconvert/latest/ug/using-variables-in-your-job-settings.html#using-settings
         *        -variables-with-streaming-outputs To not generate I-frame only video segments: Leave blank.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dashIFrameTrickPlayNameModifier(String dashIFrameTrickPlayNameModifier);

        /**
         * Specify how MediaConvert writes SegmentTimeline in your output DASH manifest. To write a SegmentTimeline in
         * each video Representation: Keep the default value, Basic. To write a common SegmentTimeline in the video
         * AdaptationSet: Choose Compact. Note that MediaConvert will still write a SegmentTimeline in any
         * Representation that does not share a common timeline. To write a video AdaptationSet for each different
         * output framerate, and a common SegmentTimeline in each AdaptationSet: Choose Distinct.
         * 
         * @param dashManifestStyle
         *        Specify how MediaConvert writes SegmentTimeline in your output DASH manifest. To write a
         *        SegmentTimeline in each video Representation: Keep the default value, Basic. To write a common
         *        SegmentTimeline in the video AdaptationSet: Choose Compact. Note that MediaConvert will still write a
         *        SegmentTimeline in any Representation that does not share a common timeline. To write a video
         *        AdaptationSet for each different output framerate, and a common SegmentTimeline in each AdaptationSet:
         *        Choose Distinct.
         * @see DashManifestStyle
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DashManifestStyle
         */
        Builder dashManifestStyle(String dashManifestStyle);

        /**
         * Specify how MediaConvert writes SegmentTimeline in your output DASH manifest. To write a SegmentTimeline in
         * each video Representation: Keep the default value, Basic. To write a common SegmentTimeline in the video
         * AdaptationSet: Choose Compact. Note that MediaConvert will still write a SegmentTimeline in any
         * Representation that does not share a common timeline. To write a video AdaptationSet for each different
         * output framerate, and a common SegmentTimeline in each AdaptationSet: Choose Distinct.
         * 
         * @param dashManifestStyle
         *        Specify how MediaConvert writes SegmentTimeline in your output DASH manifest. To write a
         *        SegmentTimeline in each video Representation: Keep the default value, Basic. To write a common
         *        SegmentTimeline in the video AdaptationSet: Choose Compact. Note that MediaConvert will still write a
         *        SegmentTimeline in any Representation that does not share a common timeline. To write a video
         *        AdaptationSet for each different output framerate, and a common SegmentTimeline in each AdaptationSet:
         *        Choose Distinct.
         * @see DashManifestStyle
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DashManifestStyle
         */
        Builder dashManifestStyle(DashManifestStyle dashManifestStyle);

        /**
         * Use Destination to specify the S3 output location and the output filename base. Destination accepts format
         * identifiers. If you do not specify the base filename in the URI, the service will use the filename of the
         * input file. If your job has multiple inputs, the service uses the filename of the first input file.
         * 
         * @param destination
         *        Use Destination to specify the S3 output location and the output filename base. Destination accepts
         *        format identifiers. If you do not specify the base filename in the URI, the service will use the
         *        filename of the input file. If your job has multiple inputs, the service uses the filename of the
         *        first input file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destination(String destination);

        /**
         * Settings associated with the destination. Will vary based on the type of destination
         * 
         * @param destinationSettings
         *        Settings associated with the destination. Will vary based on the type of destination
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationSettings(DestinationSettings destinationSettings);

        /**
         * Settings associated with the destination. Will vary based on the type of destination This is a convenience
         * method that creates an instance of the {@link DestinationSettings.Builder} avoiding the need to create one
         * manually via {@link DestinationSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DestinationSettings.Builder#build()} is called immediately and
         * its result is passed to {@link #destinationSettings(DestinationSettings)}.
         * 
         * @param destinationSettings
         *        a consumer that will call methods on {@link DestinationSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #destinationSettings(DestinationSettings)
         */
        default Builder destinationSettings(Consumer<DestinationSettings.Builder> destinationSettings) {
            return destinationSettings(DestinationSettings.builder().applyMutation(destinationSettings).build());
        }

        /**
         * DRM settings.
         * 
         * @param encryption
         *        DRM settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encryption(CmafEncryptionSettings encryption);

        /**
         * DRM settings. This is a convenience method that creates an instance of the
         * {@link CmafEncryptionSettings.Builder} avoiding the need to create one manually via
         * {@link CmafEncryptionSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CmafEncryptionSettings.Builder#build()} is called immediately and
         * its result is passed to {@link #encryption(CmafEncryptionSettings)}.
         * 
         * @param encryption
         *        a consumer that will call methods on {@link CmafEncryptionSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #encryption(CmafEncryptionSettings)
         */
        default Builder encryption(Consumer<CmafEncryptionSettings.Builder> encryption) {
            return encryption(CmafEncryptionSettings.builder().applyMutation(encryption).build());
        }

        /**
         * Specify the length, in whole seconds, of the mp4 fragments. When you don't specify a value, MediaConvert
         * defaults to 2. Related setting: Use Fragment length control to specify whether the encoder enforces this
         * value strictly.
         * 
         * @param fragmentLength
         *        Specify the length, in whole seconds, of the mp4 fragments. When you don't specify a value,
         *        MediaConvert defaults to 2. Related setting: Use Fragment length control to specify whether the
         *        encoder enforces this value strictly.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fragmentLength(Integer fragmentLength);

        /**
         * Specify whether MediaConvert generates images for trick play. Keep the default value, None, to not generate
         * any images. Choose Thumbnail to generate tiled thumbnails. Choose Thumbnail and full frame to generate tiled
         * thumbnails and full-resolution images of single frames. When you enable Write HLS manifest, MediaConvert
         * creates a child manifest for each set of images that you generate and adds corresponding entries to the
         * parent manifest. When you enable Write DASH manifest, MediaConvert adds an entry in the .mpd manifest for
         * each set of images that you generate. A common application for these images is Roku trick mode. The
         * thumbnails and full-frame images that MediaConvert creates with this feature are compatible with this Roku
         * specification: https://developer.roku.com/docs/developer-program/media-playback/trick-mode/hls-and-dash.md
         * 
         * @param imageBasedTrickPlay
         *        Specify whether MediaConvert generates images for trick play. Keep the default value, None, to not
         *        generate any images. Choose Thumbnail to generate tiled thumbnails. Choose Thumbnail and full frame to
         *        generate tiled thumbnails and full-resolution images of single frames. When you enable Write HLS
         *        manifest, MediaConvert creates a child manifest for each set of images that you generate and adds
         *        corresponding entries to the parent manifest. When you enable Write DASH manifest, MediaConvert adds
         *        an entry in the .mpd manifest for each set of images that you generate. A common application for these
         *        images is Roku trick mode. The thumbnails and full-frame images that MediaConvert creates with this
         *        feature are compatible with this Roku specification:
         *        https://developer.roku.com/docs/developer-program/media-playback/trick-mode/hls-and-dash.md
         * @see CmafImageBasedTrickPlay
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CmafImageBasedTrickPlay
         */
        Builder imageBasedTrickPlay(String imageBasedTrickPlay);

        /**
         * Specify whether MediaConvert generates images for trick play. Keep the default value, None, to not generate
         * any images. Choose Thumbnail to generate tiled thumbnails. Choose Thumbnail and full frame to generate tiled
         * thumbnails and full-resolution images of single frames. When you enable Write HLS manifest, MediaConvert
         * creates a child manifest for each set of images that you generate and adds corresponding entries to the
         * parent manifest. When you enable Write DASH manifest, MediaConvert adds an entry in the .mpd manifest for
         * each set of images that you generate. A common application for these images is Roku trick mode. The
         * thumbnails and full-frame images that MediaConvert creates with this feature are compatible with this Roku
         * specification: https://developer.roku.com/docs/developer-program/media-playback/trick-mode/hls-and-dash.md
         * 
         * @param imageBasedTrickPlay
         *        Specify whether MediaConvert generates images for trick play. Keep the default value, None, to not
         *        generate any images. Choose Thumbnail to generate tiled thumbnails. Choose Thumbnail and full frame to
         *        generate tiled thumbnails and full-resolution images of single frames. When you enable Write HLS
         *        manifest, MediaConvert creates a child manifest for each set of images that you generate and adds
         *        corresponding entries to the parent manifest. When you enable Write DASH manifest, MediaConvert adds
         *        an entry in the .mpd manifest for each set of images that you generate. A common application for these
         *        images is Roku trick mode. The thumbnails and full-frame images that MediaConvert creates with this
         *        feature are compatible with this Roku specification:
         *        https://developer.roku.com/docs/developer-program/media-playback/trick-mode/hls-and-dash.md
         * @see CmafImageBasedTrickPlay
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CmafImageBasedTrickPlay
         */
        Builder imageBasedTrickPlay(CmafImageBasedTrickPlay imageBasedTrickPlay);

        /**
         * Tile and thumbnail settings applicable when imageBasedTrickPlay is ADVANCED
         * 
         * @param imageBasedTrickPlaySettings
         *        Tile and thumbnail settings applicable when imageBasedTrickPlay is ADVANCED
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageBasedTrickPlaySettings(CmafImageBasedTrickPlaySettings imageBasedTrickPlaySettings);

        /**
         * Tile and thumbnail settings applicable when imageBasedTrickPlay is ADVANCED This is a convenience method that
         * creates an instance of the {@link CmafImageBasedTrickPlaySettings.Builder} avoiding the need to create one
         * manually via {@link CmafImageBasedTrickPlaySettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CmafImageBasedTrickPlaySettings.Builder#build()} is called
         * immediately and its result is passed to {@link #imageBasedTrickPlaySettings(CmafImageBasedTrickPlaySettings)}.
         * 
         * @param imageBasedTrickPlaySettings
         *        a consumer that will call methods on {@link CmafImageBasedTrickPlaySettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #imageBasedTrickPlaySettings(CmafImageBasedTrickPlaySettings)
         */
        default Builder imageBasedTrickPlaySettings(Consumer<CmafImageBasedTrickPlaySettings.Builder> imageBasedTrickPlaySettings) {
            return imageBasedTrickPlaySettings(CmafImageBasedTrickPlaySettings.builder()
                    .applyMutation(imageBasedTrickPlaySettings).build());
        }

        /**
         * When set to GZIP, compresses HLS playlist.
         * 
         * @param manifestCompression
         *        When set to GZIP, compresses HLS playlist.
         * @see CmafManifestCompression
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CmafManifestCompression
         */
        Builder manifestCompression(String manifestCompression);

        /**
         * When set to GZIP, compresses HLS playlist.
         * 
         * @param manifestCompression
         *        When set to GZIP, compresses HLS playlist.
         * @see CmafManifestCompression
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CmafManifestCompression
         */
        Builder manifestCompression(CmafManifestCompression manifestCompression);

        /**
         * Indicates whether the output manifest should use floating point values for segment duration.
         * 
         * @param manifestDurationFormat
         *        Indicates whether the output manifest should use floating point values for segment duration.
         * @see CmafManifestDurationFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CmafManifestDurationFormat
         */
        Builder manifestDurationFormat(String manifestDurationFormat);

        /**
         * Indicates whether the output manifest should use floating point values for segment duration.
         * 
         * @param manifestDurationFormat
         *        Indicates whether the output manifest should use floating point values for segment duration.
         * @see CmafManifestDurationFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CmafManifestDurationFormat
         */
        Builder manifestDurationFormat(CmafManifestDurationFormat manifestDurationFormat);

        /**
         * Minimum time of initially buffered media that is needed to ensure smooth playout.
         * 
         * @param minBufferTime
         *        Minimum time of initially buffered media that is needed to ensure smooth playout.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minBufferTime(Integer minBufferTime);

        /**
         * Keep this setting at the default value of 0, unless you are troubleshooting a problem with how devices play
         * back the end of your video asset. If you know that player devices are hanging on the final segment of your
         * video because the length of your final segment is too short, use this setting to specify a minimum final
         * segment length, in seconds. Choose a value that is greater than or equal to 1 and less than your segment
         * length. When you specify a value for this setting, the encoder will combine any final segment that is shorter
         * than the length that you specify with the previous segment. For example, your segment length is 3 seconds and
         * your final segment is .5 seconds without a minimum final segment length; when you set the minimum final
         * segment length to 1, your final segment is 3.5 seconds.
         * 
         * @param minFinalSegmentLength
         *        Keep this setting at the default value of 0, unless you are troubleshooting a problem with how devices
         *        play back the end of your video asset. If you know that player devices are hanging on the final
         *        segment of your video because the length of your final segment is too short, use this setting to
         *        specify a minimum final segment length, in seconds. Choose a value that is greater than or equal to 1
         *        and less than your segment length. When you specify a value for this setting, the encoder will combine
         *        any final segment that is shorter than the length that you specify with the previous segment. For
         *        example, your segment length is 3 seconds and your final segment is .5 seconds without a minimum final
         *        segment length; when you set the minimum final segment length to 1, your final segment is 3.5 seconds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minFinalSegmentLength(Double minFinalSegmentLength);

        /**
         * Specify how the value for bandwidth is determined for each video Representation in your output MPD manifest.
         * We recommend that you choose a MPD manifest bandwidth type that is compatible with your downstream player
         * configuration. Max: Use the same value that you specify for Max bitrate in the video output, in bits per
         * second. Average: Use the calculated average bitrate of the encoded video output, in bits per second.
         * 
         * @param mpdManifestBandwidthType
         *        Specify how the value for bandwidth is determined for each video Representation in your output MPD
         *        manifest. We recommend that you choose a MPD manifest bandwidth type that is compatible with your
         *        downstream player configuration. Max: Use the same value that you specify for Max bitrate in the video
         *        output, in bits per second. Average: Use the calculated average bitrate of the encoded video output,
         *        in bits per second.
         * @see CmafMpdManifestBandwidthType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CmafMpdManifestBandwidthType
         */
        Builder mpdManifestBandwidthType(String mpdManifestBandwidthType);

        /**
         * Specify how the value for bandwidth is determined for each video Representation in your output MPD manifest.
         * We recommend that you choose a MPD manifest bandwidth type that is compatible with your downstream player
         * configuration. Max: Use the same value that you specify for Max bitrate in the video output, in bits per
         * second. Average: Use the calculated average bitrate of the encoded video output, in bits per second.
         * 
         * @param mpdManifestBandwidthType
         *        Specify how the value for bandwidth is determined for each video Representation in your output MPD
         *        manifest. We recommend that you choose a MPD manifest bandwidth type that is compatible with your
         *        downstream player configuration. Max: Use the same value that you specify for Max bitrate in the video
         *        output, in bits per second. Average: Use the calculated average bitrate of the encoded video output,
         *        in bits per second.
         * @see CmafMpdManifestBandwidthType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CmafMpdManifestBandwidthType
         */
        Builder mpdManifestBandwidthType(CmafMpdManifestBandwidthType mpdManifestBandwidthType);

        /**
         * Specify whether your DASH profile is on-demand or main. When you choose Main profile, the service signals
         * urn:mpeg:dash:profile:isoff-main:2011 in your .mpd DASH manifest. When you choose On-demand, the service
         * signals urn:mpeg:dash:profile:isoff-on-demand:2011 in your .mpd. When you choose On-demand, you must also set
         * the output group setting Segment control to Single file.
         * 
         * @param mpdProfile
         *        Specify whether your DASH profile is on-demand or main. When you choose Main profile, the service
         *        signals urn:mpeg:dash:profile:isoff-main:2011 in your .mpd DASH manifest. When you choose On-demand,
         *        the service signals urn:mpeg:dash:profile:isoff-on-demand:2011 in your .mpd. When you choose
         *        On-demand, you must also set the output group setting Segment control to Single file.
         * @see CmafMpdProfile
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CmafMpdProfile
         */
        Builder mpdProfile(String mpdProfile);

        /**
         * Specify whether your DASH profile is on-demand or main. When you choose Main profile, the service signals
         * urn:mpeg:dash:profile:isoff-main:2011 in your .mpd DASH manifest. When you choose On-demand, the service
         * signals urn:mpeg:dash:profile:isoff-on-demand:2011 in your .mpd. When you choose On-demand, you must also set
         * the output group setting Segment control to Single file.
         * 
         * @param mpdProfile
         *        Specify whether your DASH profile is on-demand or main. When you choose Main profile, the service
         *        signals urn:mpeg:dash:profile:isoff-main:2011 in your .mpd DASH manifest. When you choose On-demand,
         *        the service signals urn:mpeg:dash:profile:isoff-on-demand:2011 in your .mpd. When you choose
         *        On-demand, you must also set the output group setting Segment control to Single file.
         * @see CmafMpdProfile
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CmafMpdProfile
         */
        Builder mpdProfile(CmafMpdProfile mpdProfile);

        /**
         * Use this setting only when your output video stream has B-frames, which causes the initial presentation time
         * stamp (PTS) to be offset from the initial decode time stamp (DTS). Specify how MediaConvert handles PTS when
         * writing time stamps in output DASH manifests. Choose Match initial PTS when you want MediaConvert to use the
         * initial PTS as the first time stamp in the manifest. Choose Zero-based to have MediaConvert ignore the
         * initial PTS in the video stream and instead write the initial time stamp as zero in the manifest. For outputs
         * that don't have B-frames, the time stamps in your DASH manifests start at zero regardless of your choice
         * here.
         * 
         * @param ptsOffsetHandlingForBFrames
         *        Use this setting only when your output video stream has B-frames, which causes the initial
         *        presentation time stamp (PTS) to be offset from the initial decode time stamp (DTS). Specify how
         *        MediaConvert handles PTS when writing time stamps in output DASH manifests. Choose Match initial PTS
         *        when you want MediaConvert to use the initial PTS as the first time stamp in the manifest. Choose
         *        Zero-based to have MediaConvert ignore the initial PTS in the video stream and instead write the
         *        initial time stamp as zero in the manifest. For outputs that don't have B-frames, the time stamps in
         *        your DASH manifests start at zero regardless of your choice here.
         * @see CmafPtsOffsetHandlingForBFrames
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CmafPtsOffsetHandlingForBFrames
         */
        Builder ptsOffsetHandlingForBFrames(String ptsOffsetHandlingForBFrames);

        /**
         * Use this setting only when your output video stream has B-frames, which causes the initial presentation time
         * stamp (PTS) to be offset from the initial decode time stamp (DTS). Specify how MediaConvert handles PTS when
         * writing time stamps in output DASH manifests. Choose Match initial PTS when you want MediaConvert to use the
         * initial PTS as the first time stamp in the manifest. Choose Zero-based to have MediaConvert ignore the
         * initial PTS in the video stream and instead write the initial time stamp as zero in the manifest. For outputs
         * that don't have B-frames, the time stamps in your DASH manifests start at zero regardless of your choice
         * here.
         * 
         * @param ptsOffsetHandlingForBFrames
         *        Use this setting only when your output video stream has B-frames, which causes the initial
         *        presentation time stamp (PTS) to be offset from the initial decode time stamp (DTS). Specify how
         *        MediaConvert handles PTS when writing time stamps in output DASH manifests. Choose Match initial PTS
         *        when you want MediaConvert to use the initial PTS as the first time stamp in the manifest. Choose
         *        Zero-based to have MediaConvert ignore the initial PTS in the video stream and instead write the
         *        initial time stamp as zero in the manifest. For outputs that don't have B-frames, the time stamps in
         *        your DASH manifests start at zero regardless of your choice here.
         * @see CmafPtsOffsetHandlingForBFrames
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CmafPtsOffsetHandlingForBFrames
         */
        Builder ptsOffsetHandlingForBFrames(CmafPtsOffsetHandlingForBFrames ptsOffsetHandlingForBFrames);

        /**
         * When set to SINGLE_FILE, a single output file is generated, which is internally segmented using the Fragment
         * Length and Segment Length. When set to SEGMENTED_FILES, separate segment files will be created.
         * 
         * @param segmentControl
         *        When set to SINGLE_FILE, a single output file is generated, which is internally segmented using the
         *        Fragment Length and Segment Length. When set to SEGMENTED_FILES, separate segment files will be
         *        created.
         * @see CmafSegmentControl
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CmafSegmentControl
         */
        Builder segmentControl(String segmentControl);

        /**
         * When set to SINGLE_FILE, a single output file is generated, which is internally segmented using the Fragment
         * Length and Segment Length. When set to SEGMENTED_FILES, separate segment files will be created.
         * 
         * @param segmentControl
         *        When set to SINGLE_FILE, a single output file is generated, which is internally segmented using the
         *        Fragment Length and Segment Length. When set to SEGMENTED_FILES, separate segment files will be
         *        created.
         * @see CmafSegmentControl
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CmafSegmentControl
         */
        Builder segmentControl(CmafSegmentControl segmentControl);

        /**
         * Specify the length, in whole seconds, of each segment. When you don't specify a value, MediaConvert defaults
         * to 10. Related settings: Use Segment length control to specify whether the encoder enforces this value
         * strictly. Use Segment control to specify whether MediaConvert creates separate segment files or one content
         * file that has metadata to mark the segment boundaries.
         * 
         * @param segmentLength
         *        Specify the length, in whole seconds, of each segment. When you don't specify a value, MediaConvert
         *        defaults to 10. Related settings: Use Segment length control to specify whether the encoder enforces
         *        this value strictly. Use Segment control to specify whether MediaConvert creates separate segment
         *        files or one content file that has metadata to mark the segment boundaries.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder segmentLength(Integer segmentLength);

        /**
         * Specify how you want MediaConvert to determine the segment length. Choose Exact to have the encoder use the
         * exact length that you specify with the setting Segment length. This might result in extra I-frames. Choose
         * Multiple of GOP to have the encoder round up the segment lengths to match the next GOP boundary.
         * 
         * @param segmentLengthControl
         *        Specify how you want MediaConvert to determine the segment length. Choose Exact to have the encoder
         *        use the exact length that you specify with the setting Segment length. This might result in extra
         *        I-frames. Choose Multiple of GOP to have the encoder round up the segment lengths to match the next
         *        GOP boundary.
         * @see CmafSegmentLengthControl
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CmafSegmentLengthControl
         */
        Builder segmentLengthControl(String segmentLengthControl);

        /**
         * Specify how you want MediaConvert to determine the segment length. Choose Exact to have the encoder use the
         * exact length that you specify with the setting Segment length. This might result in extra I-frames. Choose
         * Multiple of GOP to have the encoder round up the segment lengths to match the next GOP boundary.
         * 
         * @param segmentLengthControl
         *        Specify how you want MediaConvert to determine the segment length. Choose Exact to have the encoder
         *        use the exact length that you specify with the setting Segment length. This might result in extra
         *        I-frames. Choose Multiple of GOP to have the encoder round up the segment lengths to match the next
         *        GOP boundary.
         * @see CmafSegmentLengthControl
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CmafSegmentLengthControl
         */
        Builder segmentLengthControl(CmafSegmentLengthControl segmentLengthControl);

        /**
         * Include or exclude RESOLUTION attribute for video in EXT-X-STREAM-INF tag of variant manifest.
         * 
         * @param streamInfResolution
         *        Include or exclude RESOLUTION attribute for video in EXT-X-STREAM-INF tag of variant manifest.
         * @see CmafStreamInfResolution
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CmafStreamInfResolution
         */
        Builder streamInfResolution(String streamInfResolution);

        /**
         * Include or exclude RESOLUTION attribute for video in EXT-X-STREAM-INF tag of variant manifest.
         * 
         * @param streamInfResolution
         *        Include or exclude RESOLUTION attribute for video in EXT-X-STREAM-INF tag of variant manifest.
         * @see CmafStreamInfResolution
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CmafStreamInfResolution
         */
        Builder streamInfResolution(CmafStreamInfResolution streamInfResolution);

        /**
         * When set to LEGACY, the segment target duration is always rounded up to the nearest integer value above its
         * current value in seconds. When set to SPEC\\_COMPLIANT, the segment target duration is rounded up to the
         * nearest integer value if fraction seconds are greater than or equal to 0.5 (>= 0.5) and rounded down if less
         * than 0.5 (< 0.5). You may need to use LEGACY if your client needs to ensure that the target duration is
         * always longer than the actual duration of the segment. Some older players may experience interrupted playback
         * when the actual duration of a track in a segment is longer than the target duration.
         * 
         * @param targetDurationCompatibilityMode
         *        When set to LEGACY, the segment target duration is always rounded up to the nearest integer value
         *        above its current value in seconds. When set to SPEC\\_COMPLIANT, the segment target duration is
         *        rounded up to the nearest integer value if fraction seconds are greater than or equal to 0.5 (>= 0.5)
         *        and rounded down if less than 0.5 (< 0.5). You may need to use LEGACY if your client needs to ensure
         *        that the target duration is always longer than the actual duration of the segment. Some older players
         *        may experience interrupted playback when the actual duration of a track in a segment is longer than
         *        the target duration.
         * @see CmafTargetDurationCompatibilityMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CmafTargetDurationCompatibilityMode
         */
        Builder targetDurationCompatibilityMode(String targetDurationCompatibilityMode);

        /**
         * When set to LEGACY, the segment target duration is always rounded up to the nearest integer value above its
         * current value in seconds. When set to SPEC\\_COMPLIANT, the segment target duration is rounded up to the
         * nearest integer value if fraction seconds are greater than or equal to 0.5 (>= 0.5) and rounded down if less
         * than 0.5 (< 0.5). You may need to use LEGACY if your client needs to ensure that the target duration is
         * always longer than the actual duration of the segment. Some older players may experience interrupted playback
         * when the actual duration of a track in a segment is longer than the target duration.
         * 
         * @param targetDurationCompatibilityMode
         *        When set to LEGACY, the segment target duration is always rounded up to the nearest integer value
         *        above its current value in seconds. When set to SPEC\\_COMPLIANT, the segment target duration is
         *        rounded up to the nearest integer value if fraction seconds are greater than or equal to 0.5 (>= 0.5)
         *        and rounded down if less than 0.5 (< 0.5). You may need to use LEGACY if your client needs to ensure
         *        that the target duration is always longer than the actual duration of the segment. Some older players
         *        may experience interrupted playback when the actual duration of a track in a segment is longer than
         *        the target duration.
         * @see CmafTargetDurationCompatibilityMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CmafTargetDurationCompatibilityMode
         */
        Builder targetDurationCompatibilityMode(CmafTargetDurationCompatibilityMode targetDurationCompatibilityMode);

        /**
         * Specify the video sample composition time offset mode in the output fMP4 TRUN box. For wider player
         * compatibility, set Video composition offsets to Unsigned or leave blank. The earliest presentation time may
         * be greater than zero, and sample composition time offsets will increment using unsigned integers. For strict
         * fMP4 video and audio timing, set Video composition offsets to Signed. The earliest presentation time will be
         * equal to zero, and sample composition time offsets will increment using signed integers.
         * 
         * @param videoCompositionOffsets
         *        Specify the video sample composition time offset mode in the output fMP4 TRUN box. For wider player
         *        compatibility, set Video composition offsets to Unsigned or leave blank. The earliest presentation
         *        time may be greater than zero, and sample composition time offsets will increment using unsigned
         *        integers. For strict fMP4 video and audio timing, set Video composition offsets to Signed. The
         *        earliest presentation time will be equal to zero, and sample composition time offsets will increment
         *        using signed integers.
         * @see CmafVideoCompositionOffsets
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CmafVideoCompositionOffsets
         */
        Builder videoCompositionOffsets(String videoCompositionOffsets);

        /**
         * Specify the video sample composition time offset mode in the output fMP4 TRUN box. For wider player
         * compatibility, set Video composition offsets to Unsigned or leave blank. The earliest presentation time may
         * be greater than zero, and sample composition time offsets will increment using unsigned integers. For strict
         * fMP4 video and audio timing, set Video composition offsets to Signed. The earliest presentation time will be
         * equal to zero, and sample composition time offsets will increment using signed integers.
         * 
         * @param videoCompositionOffsets
         *        Specify the video sample composition time offset mode in the output fMP4 TRUN box. For wider player
         *        compatibility, set Video composition offsets to Unsigned or leave blank. The earliest presentation
         *        time may be greater than zero, and sample composition time offsets will increment using unsigned
         *        integers. For strict fMP4 video and audio timing, set Video composition offsets to Signed. The
         *        earliest presentation time will be equal to zero, and sample composition time offsets will increment
         *        using signed integers.
         * @see CmafVideoCompositionOffsets
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CmafVideoCompositionOffsets
         */
        Builder videoCompositionOffsets(CmafVideoCompositionOffsets videoCompositionOffsets);

        /**
         * When set to ENABLED, a DASH MPD manifest will be generated for this output.
         * 
         * @param writeDashManifest
         *        When set to ENABLED, a DASH MPD manifest will be generated for this output.
         * @see CmafWriteDASHManifest
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CmafWriteDASHManifest
         */
        Builder writeDashManifest(String writeDashManifest);

        /**
         * When set to ENABLED, a DASH MPD manifest will be generated for this output.
         * 
         * @param writeDashManifest
         *        When set to ENABLED, a DASH MPD manifest will be generated for this output.
         * @see CmafWriteDASHManifest
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CmafWriteDASHManifest
         */
        Builder writeDashManifest(CmafWriteDASHManifest writeDashManifest);

        /**
         * When set to ENABLED, an Apple HLS manifest will be generated for this output.
         * 
         * @param writeHlsManifest
         *        When set to ENABLED, an Apple HLS manifest will be generated for this output.
         * @see CmafWriteHLSManifest
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CmafWriteHLSManifest
         */
        Builder writeHlsManifest(String writeHlsManifest);

        /**
         * When set to ENABLED, an Apple HLS manifest will be generated for this output.
         * 
         * @param writeHlsManifest
         *        When set to ENABLED, an Apple HLS manifest will be generated for this output.
         * @see CmafWriteHLSManifest
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CmafWriteHLSManifest
         */
        Builder writeHlsManifest(CmafWriteHLSManifest writeHlsManifest);

        /**
         * When you enable Precise segment duration in DASH manifests, your DASH manifest shows precise segment
         * durations. The segment duration information appears inside the SegmentTimeline element, inside
         * SegmentTemplate at the Representation level. When this feature isn't enabled, the segment durations in your
         * DASH manifest are approximate. The segment duration information appears in the duration attribute of the
         * SegmentTemplate element.
         * 
         * @param writeSegmentTimelineInRepresentation
         *        When you enable Precise segment duration in DASH manifests, your DASH manifest shows precise segment
         *        durations. The segment duration information appears inside the SegmentTimeline element, inside
         *        SegmentTemplate at the Representation level. When this feature isn't enabled, the segment durations in
         *        your DASH manifest are approximate. The segment duration information appears in the duration attribute
         *        of the SegmentTemplate element.
         * @see CmafWriteSegmentTimelineInRepresentation
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CmafWriteSegmentTimelineInRepresentation
         */
        Builder writeSegmentTimelineInRepresentation(String writeSegmentTimelineInRepresentation);

        /**
         * When you enable Precise segment duration in DASH manifests, your DASH manifest shows precise segment
         * durations. The segment duration information appears inside the SegmentTimeline element, inside
         * SegmentTemplate at the Representation level. When this feature isn't enabled, the segment durations in your
         * DASH manifest are approximate. The segment duration information appears in the duration attribute of the
         * SegmentTemplate element.
         * 
         * @param writeSegmentTimelineInRepresentation
         *        When you enable Precise segment duration in DASH manifests, your DASH manifest shows precise segment
         *        durations. The segment duration information appears inside the SegmentTimeline element, inside
         *        SegmentTemplate at the Representation level. When this feature isn't enabled, the segment durations in
         *        your DASH manifest are approximate. The segment duration information appears in the duration attribute
         *        of the SegmentTemplate element.
         * @see CmafWriteSegmentTimelineInRepresentation
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CmafWriteSegmentTimelineInRepresentation
         */
        Builder writeSegmentTimelineInRepresentation(CmafWriteSegmentTimelineInRepresentation writeSegmentTimelineInRepresentation);
    }

    static final class BuilderImpl implements Builder {
        private List<CmafAdditionalManifest> additionalManifests = DefaultSdkAutoConstructList.getInstance();

        private String baseUrl;

        private String clientCache;

        private String codecSpecification;

        private String dashIFrameTrickPlayNameModifier;

        private String dashManifestStyle;

        private String destination;

        private DestinationSettings destinationSettings;

        private CmafEncryptionSettings encryption;

        private Integer fragmentLength;

        private String imageBasedTrickPlay;

        private CmafImageBasedTrickPlaySettings imageBasedTrickPlaySettings;

        private String manifestCompression;

        private String manifestDurationFormat;

        private Integer minBufferTime;

        private Double minFinalSegmentLength;

        private String mpdManifestBandwidthType;

        private String mpdProfile;

        private String ptsOffsetHandlingForBFrames;

        private String segmentControl;

        private Integer segmentLength;

        private String segmentLengthControl;

        private String streamInfResolution;

        private String targetDurationCompatibilityMode;

        private String videoCompositionOffsets;

        private String writeDashManifest;

        private String writeHlsManifest;

        private String writeSegmentTimelineInRepresentation;

        private BuilderImpl() {
        }

        private BuilderImpl(CmafGroupSettings model) {
            additionalManifests(model.additionalManifests);
            baseUrl(model.baseUrl);
            clientCache(model.clientCache);
            codecSpecification(model.codecSpecification);
            dashIFrameTrickPlayNameModifier(model.dashIFrameTrickPlayNameModifier);
            dashManifestStyle(model.dashManifestStyle);
            destination(model.destination);
            destinationSettings(model.destinationSettings);
            encryption(model.encryption);
            fragmentLength(model.fragmentLength);
            imageBasedTrickPlay(model.imageBasedTrickPlay);
            imageBasedTrickPlaySettings(model.imageBasedTrickPlaySettings);
            manifestCompression(model.manifestCompression);
            manifestDurationFormat(model.manifestDurationFormat);
            minBufferTime(model.minBufferTime);
            minFinalSegmentLength(model.minFinalSegmentLength);
            mpdManifestBandwidthType(model.mpdManifestBandwidthType);
            mpdProfile(model.mpdProfile);
            ptsOffsetHandlingForBFrames(model.ptsOffsetHandlingForBFrames);
            segmentControl(model.segmentControl);
            segmentLength(model.segmentLength);
            segmentLengthControl(model.segmentLengthControl);
            streamInfResolution(model.streamInfResolution);
            targetDurationCompatibilityMode(model.targetDurationCompatibilityMode);
            videoCompositionOffsets(model.videoCompositionOffsets);
            writeDashManifest(model.writeDashManifest);
            writeHlsManifest(model.writeHlsManifest);
            writeSegmentTimelineInRepresentation(model.writeSegmentTimelineInRepresentation);
        }

        public final List<CmafAdditionalManifest.Builder> getAdditionalManifests() {
            List<CmafAdditionalManifest.Builder> result = ___listOfCmafAdditionalManifestCopier
                    .copyToBuilder(this.additionalManifests);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAdditionalManifests(Collection<CmafAdditionalManifest.BuilderImpl> additionalManifests) {
            this.additionalManifests = ___listOfCmafAdditionalManifestCopier.copyFromBuilder(additionalManifests);
        }

        @Override
        public final Builder additionalManifests(Collection<CmafAdditionalManifest> additionalManifests) {
            this.additionalManifests = ___listOfCmafAdditionalManifestCopier.copy(additionalManifests);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalManifests(CmafAdditionalManifest... additionalManifests) {
            additionalManifests(Arrays.asList(additionalManifests));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalManifests(Consumer<CmafAdditionalManifest.Builder>... additionalManifests) {
            additionalManifests(Stream.of(additionalManifests)
                    .map(c -> CmafAdditionalManifest.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getBaseUrl() {
            return baseUrl;
        }

        public final void setBaseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
        }

        @Override
        public final Builder baseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
            return this;
        }

        public final String getClientCache() {
            return clientCache;
        }

        public final void setClientCache(String clientCache) {
            this.clientCache = clientCache;
        }

        @Override
        public final Builder clientCache(String clientCache) {
            this.clientCache = clientCache;
            return this;
        }

        @Override
        public final Builder clientCache(CmafClientCache clientCache) {
            this.clientCache(clientCache == null ? null : clientCache.toString());
            return this;
        }

        public final String getCodecSpecification() {
            return codecSpecification;
        }

        public final void setCodecSpecification(String codecSpecification) {
            this.codecSpecification = codecSpecification;
        }

        @Override
        public final Builder codecSpecification(String codecSpecification) {
            this.codecSpecification = codecSpecification;
            return this;
        }

        @Override
        public final Builder codecSpecification(CmafCodecSpecification codecSpecification) {
            this.codecSpecification(codecSpecification == null ? null : codecSpecification.toString());
            return this;
        }

        public final String getDashIFrameTrickPlayNameModifier() {
            return dashIFrameTrickPlayNameModifier;
        }

        public final void setDashIFrameTrickPlayNameModifier(String dashIFrameTrickPlayNameModifier) {
            this.dashIFrameTrickPlayNameModifier = dashIFrameTrickPlayNameModifier;
        }

        @Override
        public final Builder dashIFrameTrickPlayNameModifier(String dashIFrameTrickPlayNameModifier) {
            this.dashIFrameTrickPlayNameModifier = dashIFrameTrickPlayNameModifier;
            return this;
        }

        public final String getDashManifestStyle() {
            return dashManifestStyle;
        }

        public final void setDashManifestStyle(String dashManifestStyle) {
            this.dashManifestStyle = dashManifestStyle;
        }

        @Override
        public final Builder dashManifestStyle(String dashManifestStyle) {
            this.dashManifestStyle = dashManifestStyle;
            return this;
        }

        @Override
        public final Builder dashManifestStyle(DashManifestStyle dashManifestStyle) {
            this.dashManifestStyle(dashManifestStyle == null ? null : dashManifestStyle.toString());
            return this;
        }

        public final String getDestination() {
            return destination;
        }

        public final void setDestination(String destination) {
            this.destination = destination;
        }

        @Override
        public final Builder destination(String destination) {
            this.destination = destination;
            return this;
        }

        public final DestinationSettings.Builder getDestinationSettings() {
            return destinationSettings != null ? destinationSettings.toBuilder() : null;
        }

        public final void setDestinationSettings(DestinationSettings.BuilderImpl destinationSettings) {
            this.destinationSettings = destinationSettings != null ? destinationSettings.build() : null;
        }

        @Override
        public final Builder destinationSettings(DestinationSettings destinationSettings) {
            this.destinationSettings = destinationSettings;
            return this;
        }

        public final CmafEncryptionSettings.Builder getEncryption() {
            return encryption != null ? encryption.toBuilder() : null;
        }

        public final void setEncryption(CmafEncryptionSettings.BuilderImpl encryption) {
            this.encryption = encryption != null ? encryption.build() : null;
        }

        @Override
        public final Builder encryption(CmafEncryptionSettings encryption) {
            this.encryption = encryption;
            return this;
        }

        public final Integer getFragmentLength() {
            return fragmentLength;
        }

        public final void setFragmentLength(Integer fragmentLength) {
            this.fragmentLength = fragmentLength;
        }

        @Override
        public final Builder fragmentLength(Integer fragmentLength) {
            this.fragmentLength = fragmentLength;
            return this;
        }

        public final String getImageBasedTrickPlay() {
            return imageBasedTrickPlay;
        }

        public final void setImageBasedTrickPlay(String imageBasedTrickPlay) {
            this.imageBasedTrickPlay = imageBasedTrickPlay;
        }

        @Override
        public final Builder imageBasedTrickPlay(String imageBasedTrickPlay) {
            this.imageBasedTrickPlay = imageBasedTrickPlay;
            return this;
        }

        @Override
        public final Builder imageBasedTrickPlay(CmafImageBasedTrickPlay imageBasedTrickPlay) {
            this.imageBasedTrickPlay(imageBasedTrickPlay == null ? null : imageBasedTrickPlay.toString());
            return this;
        }

        public final CmafImageBasedTrickPlaySettings.Builder getImageBasedTrickPlaySettings() {
            return imageBasedTrickPlaySettings != null ? imageBasedTrickPlaySettings.toBuilder() : null;
        }

        public final void setImageBasedTrickPlaySettings(CmafImageBasedTrickPlaySettings.BuilderImpl imageBasedTrickPlaySettings) {
            this.imageBasedTrickPlaySettings = imageBasedTrickPlaySettings != null ? imageBasedTrickPlaySettings.build() : null;
        }

        @Override
        public final Builder imageBasedTrickPlaySettings(CmafImageBasedTrickPlaySettings imageBasedTrickPlaySettings) {
            this.imageBasedTrickPlaySettings = imageBasedTrickPlaySettings;
            return this;
        }

        public final String getManifestCompression() {
            return manifestCompression;
        }

        public final void setManifestCompression(String manifestCompression) {
            this.manifestCompression = manifestCompression;
        }

        @Override
        public final Builder manifestCompression(String manifestCompression) {
            this.manifestCompression = manifestCompression;
            return this;
        }

        @Override
        public final Builder manifestCompression(CmafManifestCompression manifestCompression) {
            this.manifestCompression(manifestCompression == null ? null : manifestCompression.toString());
            return this;
        }

        public final String getManifestDurationFormat() {
            return manifestDurationFormat;
        }

        public final void setManifestDurationFormat(String manifestDurationFormat) {
            this.manifestDurationFormat = manifestDurationFormat;
        }

        @Override
        public final Builder manifestDurationFormat(String manifestDurationFormat) {
            this.manifestDurationFormat = manifestDurationFormat;
            return this;
        }

        @Override
        public final Builder manifestDurationFormat(CmafManifestDurationFormat manifestDurationFormat) {
            this.manifestDurationFormat(manifestDurationFormat == null ? null : manifestDurationFormat.toString());
            return this;
        }

        public final Integer getMinBufferTime() {
            return minBufferTime;
        }

        public final void setMinBufferTime(Integer minBufferTime) {
            this.minBufferTime = minBufferTime;
        }

        @Override
        public final Builder minBufferTime(Integer minBufferTime) {
            this.minBufferTime = minBufferTime;
            return this;
        }

        public final Double getMinFinalSegmentLength() {
            return minFinalSegmentLength;
        }

        public final void setMinFinalSegmentLength(Double minFinalSegmentLength) {
            this.minFinalSegmentLength = minFinalSegmentLength;
        }

        @Override
        public final Builder minFinalSegmentLength(Double minFinalSegmentLength) {
            this.minFinalSegmentLength = minFinalSegmentLength;
            return this;
        }

        public final String getMpdManifestBandwidthType() {
            return mpdManifestBandwidthType;
        }

        public final void setMpdManifestBandwidthType(String mpdManifestBandwidthType) {
            this.mpdManifestBandwidthType = mpdManifestBandwidthType;
        }

        @Override
        public final Builder mpdManifestBandwidthType(String mpdManifestBandwidthType) {
            this.mpdManifestBandwidthType = mpdManifestBandwidthType;
            return this;
        }

        @Override
        public final Builder mpdManifestBandwidthType(CmafMpdManifestBandwidthType mpdManifestBandwidthType) {
            this.mpdManifestBandwidthType(mpdManifestBandwidthType == null ? null : mpdManifestBandwidthType.toString());
            return this;
        }

        public final String getMpdProfile() {
            return mpdProfile;
        }

        public final void setMpdProfile(String mpdProfile) {
            this.mpdProfile = mpdProfile;
        }

        @Override
        public final Builder mpdProfile(String mpdProfile) {
            this.mpdProfile = mpdProfile;
            return this;
        }

        @Override
        public final Builder mpdProfile(CmafMpdProfile mpdProfile) {
            this.mpdProfile(mpdProfile == null ? null : mpdProfile.toString());
            return this;
        }

        public final String getPtsOffsetHandlingForBFrames() {
            return ptsOffsetHandlingForBFrames;
        }

        public final void setPtsOffsetHandlingForBFrames(String ptsOffsetHandlingForBFrames) {
            this.ptsOffsetHandlingForBFrames = ptsOffsetHandlingForBFrames;
        }

        @Override
        public final Builder ptsOffsetHandlingForBFrames(String ptsOffsetHandlingForBFrames) {
            this.ptsOffsetHandlingForBFrames = ptsOffsetHandlingForBFrames;
            return this;
        }

        @Override
        public final Builder ptsOffsetHandlingForBFrames(CmafPtsOffsetHandlingForBFrames ptsOffsetHandlingForBFrames) {
            this.ptsOffsetHandlingForBFrames(ptsOffsetHandlingForBFrames == null ? null : ptsOffsetHandlingForBFrames.toString());
            return this;
        }

        public final String getSegmentControl() {
            return segmentControl;
        }

        public final void setSegmentControl(String segmentControl) {
            this.segmentControl = segmentControl;
        }

        @Override
        public final Builder segmentControl(String segmentControl) {
            this.segmentControl = segmentControl;
            return this;
        }

        @Override
        public final Builder segmentControl(CmafSegmentControl segmentControl) {
            this.segmentControl(segmentControl == null ? null : segmentControl.toString());
            return this;
        }

        public final Integer getSegmentLength() {
            return segmentLength;
        }

        public final void setSegmentLength(Integer segmentLength) {
            this.segmentLength = segmentLength;
        }

        @Override
        public final Builder segmentLength(Integer segmentLength) {
            this.segmentLength = segmentLength;
            return this;
        }

        public final String getSegmentLengthControl() {
            return segmentLengthControl;
        }

        public final void setSegmentLengthControl(String segmentLengthControl) {
            this.segmentLengthControl = segmentLengthControl;
        }

        @Override
        public final Builder segmentLengthControl(String segmentLengthControl) {
            this.segmentLengthControl = segmentLengthControl;
            return this;
        }

        @Override
        public final Builder segmentLengthControl(CmafSegmentLengthControl segmentLengthControl) {
            this.segmentLengthControl(segmentLengthControl == null ? null : segmentLengthControl.toString());
            return this;
        }

        public final String getStreamInfResolution() {
            return streamInfResolution;
        }

        public final void setStreamInfResolution(String streamInfResolution) {
            this.streamInfResolution = streamInfResolution;
        }

        @Override
        public final Builder streamInfResolution(String streamInfResolution) {
            this.streamInfResolution = streamInfResolution;
            return this;
        }

        @Override
        public final Builder streamInfResolution(CmafStreamInfResolution streamInfResolution) {
            this.streamInfResolution(streamInfResolution == null ? null : streamInfResolution.toString());
            return this;
        }

        public final String getTargetDurationCompatibilityMode() {
            return targetDurationCompatibilityMode;
        }

        public final void setTargetDurationCompatibilityMode(String targetDurationCompatibilityMode) {
            this.targetDurationCompatibilityMode = targetDurationCompatibilityMode;
        }

        @Override
        public final Builder targetDurationCompatibilityMode(String targetDurationCompatibilityMode) {
            this.targetDurationCompatibilityMode = targetDurationCompatibilityMode;
            return this;
        }

        @Override
        public final Builder targetDurationCompatibilityMode(CmafTargetDurationCompatibilityMode targetDurationCompatibilityMode) {
            this.targetDurationCompatibilityMode(targetDurationCompatibilityMode == null ? null : targetDurationCompatibilityMode
                    .toString());
            return this;
        }

        public final String getVideoCompositionOffsets() {
            return videoCompositionOffsets;
        }

        public final void setVideoCompositionOffsets(String videoCompositionOffsets) {
            this.videoCompositionOffsets = videoCompositionOffsets;
        }

        @Override
        public final Builder videoCompositionOffsets(String videoCompositionOffsets) {
            this.videoCompositionOffsets = videoCompositionOffsets;
            return this;
        }

        @Override
        public final Builder videoCompositionOffsets(CmafVideoCompositionOffsets videoCompositionOffsets) {
            this.videoCompositionOffsets(videoCompositionOffsets == null ? null : videoCompositionOffsets.toString());
            return this;
        }

        public final String getWriteDashManifest() {
            return writeDashManifest;
        }

        public final void setWriteDashManifest(String writeDashManifest) {
            this.writeDashManifest = writeDashManifest;
        }

        @Override
        public final Builder writeDashManifest(String writeDashManifest) {
            this.writeDashManifest = writeDashManifest;
            return this;
        }

        @Override
        public final Builder writeDashManifest(CmafWriteDASHManifest writeDashManifest) {
            this.writeDashManifest(writeDashManifest == null ? null : writeDashManifest.toString());
            return this;
        }

        public final String getWriteHlsManifest() {
            return writeHlsManifest;
        }

        public final void setWriteHlsManifest(String writeHlsManifest) {
            this.writeHlsManifest = writeHlsManifest;
        }

        @Override
        public final Builder writeHlsManifest(String writeHlsManifest) {
            this.writeHlsManifest = writeHlsManifest;
            return this;
        }

        @Override
        public final Builder writeHlsManifest(CmafWriteHLSManifest writeHlsManifest) {
            this.writeHlsManifest(writeHlsManifest == null ? null : writeHlsManifest.toString());
            return this;
        }

        public final String getWriteSegmentTimelineInRepresentation() {
            return writeSegmentTimelineInRepresentation;
        }

        public final void setWriteSegmentTimelineInRepresentation(String writeSegmentTimelineInRepresentation) {
            this.writeSegmentTimelineInRepresentation = writeSegmentTimelineInRepresentation;
        }

        @Override
        public final Builder writeSegmentTimelineInRepresentation(String writeSegmentTimelineInRepresentation) {
            this.writeSegmentTimelineInRepresentation = writeSegmentTimelineInRepresentation;
            return this;
        }

        @Override
        public final Builder writeSegmentTimelineInRepresentation(
                CmafWriteSegmentTimelineInRepresentation writeSegmentTimelineInRepresentation) {
            this.writeSegmentTimelineInRepresentation(writeSegmentTimelineInRepresentation == null ? null
                    : writeSegmentTimelineInRepresentation.toString());
            return this;
        }

        @Override
        public CmafGroupSettings build() {
            return new CmafGroupSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
