/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Custom 3D lut settings
 */
@Generated("software.amazon.awssdk:codegen")
public final class ColorConversion3DLUTSetting implements SdkPojo, Serializable,
        ToCopyableBuilder<ColorConversion3DLUTSetting.Builder, ColorConversion3DLUTSetting> {
    private static final SdkField<String> FILE_INPUT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FileInput").getter(getter(ColorConversion3DLUTSetting::fileInput)).setter(setter(Builder::fileInput))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fileInput").build()).build();

    private static final SdkField<String> INPUT_COLOR_SPACE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InputColorSpace").getter(getter(ColorConversion3DLUTSetting::inputColorSpaceAsString))
            .setter(setter(Builder::inputColorSpace))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputColorSpace").build()).build();

    private static final SdkField<Integer> INPUT_MASTERING_LUMINANCE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("InputMasteringLuminance").getter(getter(ColorConversion3DLUTSetting::inputMasteringLuminance))
            .setter(setter(Builder::inputMasteringLuminance))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputMasteringLuminance").build())
            .build();

    private static final SdkField<String> OUTPUT_COLOR_SPACE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OutputColorSpace").getter(getter(ColorConversion3DLUTSetting::outputColorSpaceAsString))
            .setter(setter(Builder::outputColorSpace))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputColorSpace").build()).build();

    private static final SdkField<Integer> OUTPUT_MASTERING_LUMINANCE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("OutputMasteringLuminance").getter(getter(ColorConversion3DLUTSetting::outputMasteringLuminance))
            .setter(setter(Builder::outputMasteringLuminance))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputMasteringLuminance").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(FILE_INPUT_FIELD, INPUT_COLOR_SPACE_FIELD, INPUT_MASTERING_LUMINANCE_FIELD,
                    OUTPUT_COLOR_SPACE_FIELD, OUTPUT_MASTERING_LUMINANCE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String fileInput;

    private final String inputColorSpace;

    private final Integer inputMasteringLuminance;

    private final String outputColorSpace;

    private final Integer outputMasteringLuminance;

    private ColorConversion3DLUTSetting(BuilderImpl builder) {
        this.fileInput = builder.fileInput;
        this.inputColorSpace = builder.inputColorSpace;
        this.inputMasteringLuminance = builder.inputMasteringLuminance;
        this.outputColorSpace = builder.outputColorSpace;
        this.outputMasteringLuminance = builder.outputMasteringLuminance;
    }

    /**
     * Specify the input file S3, HTTP, or HTTPS URL for your 3D LUT .cube file. Note that MediaConvert accepts 3D LUT
     * files up to 8MB in size.
     * 
     * @return Specify the input file S3, HTTP, or HTTPS URL for your 3D LUT .cube file. Note that MediaConvert accepts
     *         3D LUT files up to 8MB in size.
     */
    public final String fileInput() {
        return fileInput;
    }

    /**
     * Specify which inputs use this 3D LUT, according to their color space.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #inputColorSpace}
     * will return {@link ColorSpace#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #inputColorSpaceAsString}.
     * </p>
     * 
     * @return Specify which inputs use this 3D LUT, according to their color space.
     * @see ColorSpace
     */
    public final ColorSpace inputColorSpace() {
        return ColorSpace.fromValue(inputColorSpace);
    }

    /**
     * Specify which inputs use this 3D LUT, according to their color space.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #inputColorSpace}
     * will return {@link ColorSpace#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #inputColorSpaceAsString}.
     * </p>
     * 
     * @return Specify which inputs use this 3D LUT, according to their color space.
     * @see ColorSpace
     */
    public final String inputColorSpaceAsString() {
        return inputColorSpace;
    }

    /**
     * Specify which inputs use this 3D LUT, according to their luminance. To apply this 3D LUT to HDR10 or P3D65 (HDR)
     * inputs with a specific mastering luminance: Enter an integer from 0 to 2147483647, corresponding to the input's
     * Maximum luminance value. To apply this 3D LUT to any input regardless of its luminance: Leave blank, or enter 0.
     * 
     * @return Specify which inputs use this 3D LUT, according to their luminance. To apply this 3D LUT to HDR10 or
     *         P3D65 (HDR) inputs with a specific mastering luminance: Enter an integer from 0 to 2147483647,
     *         corresponding to the input's Maximum luminance value. To apply this 3D LUT to any input regardless of its
     *         luminance: Leave blank, or enter 0.
     */
    public final Integer inputMasteringLuminance() {
        return inputMasteringLuminance;
    }

    /**
     * Specify which outputs use this 3D LUT, according to their color space.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #outputColorSpace}
     * will return {@link ColorSpace#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #outputColorSpaceAsString}.
     * </p>
     * 
     * @return Specify which outputs use this 3D LUT, according to their color space.
     * @see ColorSpace
     */
    public final ColorSpace outputColorSpace() {
        return ColorSpace.fromValue(outputColorSpace);
    }

    /**
     * Specify which outputs use this 3D LUT, according to their color space.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #outputColorSpace}
     * will return {@link ColorSpace#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #outputColorSpaceAsString}.
     * </p>
     * 
     * @return Specify which outputs use this 3D LUT, according to their color space.
     * @see ColorSpace
     */
    public final String outputColorSpaceAsString() {
        return outputColorSpace;
    }

    /**
     * Specify which outputs use this 3D LUT, according to their luminance. To apply this 3D LUT to HDR10 or P3D65 (HDR)
     * outputs with a specific luminance: Enter an integer from 0 to 2147483647, corresponding to the output's
     * luminance. To apply this 3D LUT to any output regardless of its luminance: Leave blank, or enter 0.
     * 
     * @return Specify which outputs use this 3D LUT, according to their luminance. To apply this 3D LUT to HDR10 or
     *         P3D65 (HDR) outputs with a specific luminance: Enter an integer from 0 to 2147483647, corresponding to
     *         the output's luminance. To apply this 3D LUT to any output regardless of its luminance: Leave blank, or
     *         enter 0.
     */
    public final Integer outputMasteringLuminance() {
        return outputMasteringLuminance;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(fileInput());
        hashCode = 31 * hashCode + Objects.hashCode(inputColorSpaceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(inputMasteringLuminance());
        hashCode = 31 * hashCode + Objects.hashCode(outputColorSpaceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(outputMasteringLuminance());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ColorConversion3DLUTSetting)) {
            return false;
        }
        ColorConversion3DLUTSetting other = (ColorConversion3DLUTSetting) obj;
        return Objects.equals(fileInput(), other.fileInput())
                && Objects.equals(inputColorSpaceAsString(), other.inputColorSpaceAsString())
                && Objects.equals(inputMasteringLuminance(), other.inputMasteringLuminance())
                && Objects.equals(outputColorSpaceAsString(), other.outputColorSpaceAsString())
                && Objects.equals(outputMasteringLuminance(), other.outputMasteringLuminance());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ColorConversion3DLUTSetting").add("FileInput", fileInput())
                .add("InputColorSpace", inputColorSpaceAsString()).add("InputMasteringLuminance", inputMasteringLuminance())
                .add("OutputColorSpace", outputColorSpaceAsString()).add("OutputMasteringLuminance", outputMasteringLuminance())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FileInput":
            return Optional.ofNullable(clazz.cast(fileInput()));
        case "InputColorSpace":
            return Optional.ofNullable(clazz.cast(inputColorSpaceAsString()));
        case "InputMasteringLuminance":
            return Optional.ofNullable(clazz.cast(inputMasteringLuminance()));
        case "OutputColorSpace":
            return Optional.ofNullable(clazz.cast(outputColorSpaceAsString()));
        case "OutputMasteringLuminance":
            return Optional.ofNullable(clazz.cast(outputMasteringLuminance()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("fileInput", FILE_INPUT_FIELD);
        map.put("inputColorSpace", INPUT_COLOR_SPACE_FIELD);
        map.put("inputMasteringLuminance", INPUT_MASTERING_LUMINANCE_FIELD);
        map.put("outputColorSpace", OUTPUT_COLOR_SPACE_FIELD);
        map.put("outputMasteringLuminance", OUTPUT_MASTERING_LUMINANCE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ColorConversion3DLUTSetting, T> g) {
        return obj -> g.apply((ColorConversion3DLUTSetting) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ColorConversion3DLUTSetting> {
        /**
         * Specify the input file S3, HTTP, or HTTPS URL for your 3D LUT .cube file. Note that MediaConvert accepts 3D
         * LUT files up to 8MB in size.
         * 
         * @param fileInput
         *        Specify the input file S3, HTTP, or HTTPS URL for your 3D LUT .cube file. Note that MediaConvert
         *        accepts 3D LUT files up to 8MB in size.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileInput(String fileInput);

        /**
         * Specify which inputs use this 3D LUT, according to their color space.
         * 
         * @param inputColorSpace
         *        Specify which inputs use this 3D LUT, according to their color space.
         * @see ColorSpace
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ColorSpace
         */
        Builder inputColorSpace(String inputColorSpace);

        /**
         * Specify which inputs use this 3D LUT, according to their color space.
         * 
         * @param inputColorSpace
         *        Specify which inputs use this 3D LUT, according to their color space.
         * @see ColorSpace
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ColorSpace
         */
        Builder inputColorSpace(ColorSpace inputColorSpace);

        /**
         * Specify which inputs use this 3D LUT, according to their luminance. To apply this 3D LUT to HDR10 or P3D65
         * (HDR) inputs with a specific mastering luminance: Enter an integer from 0 to 2147483647, corresponding to the
         * input's Maximum luminance value. To apply this 3D LUT to any input regardless of its luminance: Leave blank,
         * or enter 0.
         * 
         * @param inputMasteringLuminance
         *        Specify which inputs use this 3D LUT, according to their luminance. To apply this 3D LUT to HDR10 or
         *        P3D65 (HDR) inputs with a specific mastering luminance: Enter an integer from 0 to 2147483647,
         *        corresponding to the input's Maximum luminance value. To apply this 3D LUT to any input regardless of
         *        its luminance: Leave blank, or enter 0.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputMasteringLuminance(Integer inputMasteringLuminance);

        /**
         * Specify which outputs use this 3D LUT, according to their color space.
         * 
         * @param outputColorSpace
         *        Specify which outputs use this 3D LUT, according to their color space.
         * @see ColorSpace
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ColorSpace
         */
        Builder outputColorSpace(String outputColorSpace);

        /**
         * Specify which outputs use this 3D LUT, according to their color space.
         * 
         * @param outputColorSpace
         *        Specify which outputs use this 3D LUT, according to their color space.
         * @see ColorSpace
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ColorSpace
         */
        Builder outputColorSpace(ColorSpace outputColorSpace);

        /**
         * Specify which outputs use this 3D LUT, according to their luminance. To apply this 3D LUT to HDR10 or P3D65
         * (HDR) outputs with a specific luminance: Enter an integer from 0 to 2147483647, corresponding to the output's
         * luminance. To apply this 3D LUT to any output regardless of its luminance: Leave blank, or enter 0.
         * 
         * @param outputMasteringLuminance
         *        Specify which outputs use this 3D LUT, according to their luminance. To apply this 3D LUT to HDR10 or
         *        P3D65 (HDR) outputs with a specific luminance: Enter an integer from 0 to 2147483647, corresponding to
         *        the output's luminance. To apply this 3D LUT to any output regardless of its luminance: Leave blank,
         *        or enter 0.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputMasteringLuminance(Integer outputMasteringLuminance);
    }

    static final class BuilderImpl implements Builder {
        private String fileInput;

        private String inputColorSpace;

        private Integer inputMasteringLuminance;

        private String outputColorSpace;

        private Integer outputMasteringLuminance;

        private BuilderImpl() {
        }

        private BuilderImpl(ColorConversion3DLUTSetting model) {
            fileInput(model.fileInput);
            inputColorSpace(model.inputColorSpace);
            inputMasteringLuminance(model.inputMasteringLuminance);
            outputColorSpace(model.outputColorSpace);
            outputMasteringLuminance(model.outputMasteringLuminance);
        }

        public final String getFileInput() {
            return fileInput;
        }

        public final void setFileInput(String fileInput) {
            this.fileInput = fileInput;
        }

        @Override
        public final Builder fileInput(String fileInput) {
            this.fileInput = fileInput;
            return this;
        }

        public final String getInputColorSpace() {
            return inputColorSpace;
        }

        public final void setInputColorSpace(String inputColorSpace) {
            this.inputColorSpace = inputColorSpace;
        }

        @Override
        public final Builder inputColorSpace(String inputColorSpace) {
            this.inputColorSpace = inputColorSpace;
            return this;
        }

        @Override
        public final Builder inputColorSpace(ColorSpace inputColorSpace) {
            this.inputColorSpace(inputColorSpace == null ? null : inputColorSpace.toString());
            return this;
        }

        public final Integer getInputMasteringLuminance() {
            return inputMasteringLuminance;
        }

        public final void setInputMasteringLuminance(Integer inputMasteringLuminance) {
            this.inputMasteringLuminance = inputMasteringLuminance;
        }

        @Override
        public final Builder inputMasteringLuminance(Integer inputMasteringLuminance) {
            this.inputMasteringLuminance = inputMasteringLuminance;
            return this;
        }

        public final String getOutputColorSpace() {
            return outputColorSpace;
        }

        public final void setOutputColorSpace(String outputColorSpace) {
            this.outputColorSpace = outputColorSpace;
        }

        @Override
        public final Builder outputColorSpace(String outputColorSpace) {
            this.outputColorSpace = outputColorSpace;
            return this;
        }

        @Override
        public final Builder outputColorSpace(ColorSpace outputColorSpace) {
            this.outputColorSpace(outputColorSpace == null ? null : outputColorSpace.toString());
            return this;
        }

        public final Integer getOutputMasteringLuminance() {
            return outputMasteringLuminance;
        }

        public final void setOutputMasteringLuminance(Integer outputMasteringLuminance) {
            this.outputMasteringLuminance = outputMasteringLuminance;
        }

        @Override
        public final Builder outputMasteringLuminance(Integer outputMasteringLuminance) {
            this.outputMasteringLuminance = outputMasteringLuminance;
            return this;
        }

        @Override
        public ColorConversion3DLUTSetting build() {
            return new ColorConversion3DLUTSetting(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
