/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeEndpointsRequest extends MediaConvertRequest implements
        ToCopyableBuilder<DescribeEndpointsRequest.Builder, DescribeEndpointsRequest> {
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(DescribeEndpointsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()).build();

    private static final SdkField<String> MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Mode")
            .getter(getter(DescribeEndpointsRequest::modeAsString)).setter(setter(Builder::mode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mode").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(DescribeEndpointsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAX_RESULTS_FIELD, MODE_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Integer maxResults;

    private final String mode;

    private final String nextToken;

    private DescribeEndpointsRequest(BuilderImpl builder) {
        super(builder);
        this.maxResults = builder.maxResults;
        this.mode = builder.mode;
        this.nextToken = builder.nextToken;
    }

    /**
     * Optional. Max number of endpoints, up to twenty, that will be returned at one time.
     * 
     * @return Optional. Max number of endpoints, up to twenty, that will be returned at one time.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * Optional field, defaults to DEFAULT. Specify DEFAULT for this operation to return your endpoints if any exist, or
     * to create an endpoint for you and return it if one doesn't already exist. Specify GET_ONLY to return your
     * endpoints if any exist, or an empty list if none exist.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mode} will return
     * {@link DescribeEndpointsMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #modeAsString}.
     * </p>
     * 
     * @return Optional field, defaults to DEFAULT. Specify DEFAULT for this operation to return your endpoints if any
     *         exist, or to create an endpoint for you and return it if one doesn't already exist. Specify GET_ONLY to
     *         return your endpoints if any exist, or an empty list if none exist.
     * @see DescribeEndpointsMode
     */
    public final DescribeEndpointsMode mode() {
        return DescribeEndpointsMode.fromValue(mode);
    }

    /**
     * Optional field, defaults to DEFAULT. Specify DEFAULT for this operation to return your endpoints if any exist, or
     * to create an endpoint for you and return it if one doesn't already exist. Specify GET_ONLY to return your
     * endpoints if any exist, or an empty list if none exist.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mode} will return
     * {@link DescribeEndpointsMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #modeAsString}.
     * </p>
     * 
     * @return Optional field, defaults to DEFAULT. Specify DEFAULT for this operation to return your endpoints if any
     *         exist, or to create an endpoint for you and return it if one doesn't already exist. Specify GET_ONLY to
     *         return your endpoints if any exist, or an empty list if none exist.
     * @see DescribeEndpointsMode
     */
    public final String modeAsString() {
        return mode;
    }

    /**
     * Use this string, provided with the response to a previous request, to request the next batch of endpoints.
     * 
     * @return Use this string, provided with the response to a previous request, to request the next batch of
     *         endpoints.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(modeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeEndpointsRequest)) {
            return false;
        }
        DescribeEndpointsRequest other = (DescribeEndpointsRequest) obj;
        return Objects.equals(maxResults(), other.maxResults()) && Objects.equals(modeAsString(), other.modeAsString())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeEndpointsRequest").add("MaxResults", maxResults()).add("Mode", modeAsString())
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "Mode":
            return Optional.ofNullable(clazz.cast(modeAsString()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("maxResults", MAX_RESULTS_FIELD);
        map.put("mode", MODE_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeEndpointsRequest, T> g) {
        return obj -> g.apply((DescribeEndpointsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MediaConvertRequest.Builder, SdkPojo, CopyableBuilder<Builder, DescribeEndpointsRequest> {
        /**
         * Optional. Max number of endpoints, up to twenty, that will be returned at one time.
         * 
         * @param maxResults
         *        Optional. Max number of endpoints, up to twenty, that will be returned at one time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * Optional field, defaults to DEFAULT. Specify DEFAULT for this operation to return your endpoints if any
         * exist, or to create an endpoint for you and return it if one doesn't already exist. Specify GET_ONLY to
         * return your endpoints if any exist, or an empty list if none exist.
         * 
         * @param mode
         *        Optional field, defaults to DEFAULT. Specify DEFAULT for this operation to return your endpoints if
         *        any exist, or to create an endpoint for you and return it if one doesn't already exist. Specify
         *        GET_ONLY to return your endpoints if any exist, or an empty list if none exist.
         * @see DescribeEndpointsMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DescribeEndpointsMode
         */
        Builder mode(String mode);

        /**
         * Optional field, defaults to DEFAULT. Specify DEFAULT for this operation to return your endpoints if any
         * exist, or to create an endpoint for you and return it if one doesn't already exist. Specify GET_ONLY to
         * return your endpoints if any exist, or an empty list if none exist.
         * 
         * @param mode
         *        Optional field, defaults to DEFAULT. Specify DEFAULT for this operation to return your endpoints if
         *        any exist, or to create an endpoint for you and return it if one doesn't already exist. Specify
         *        GET_ONLY to return your endpoints if any exist, or an empty list if none exist.
         * @see DescribeEndpointsMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DescribeEndpointsMode
         */
        Builder mode(DescribeEndpointsMode mode);

        /**
         * Use this string, provided with the response to a previous request, to request the next batch of endpoints.
         * 
         * @param nextToken
         *        Use this string, provided with the response to a previous request, to request the next batch of
         *        endpoints.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MediaConvertRequest.BuilderImpl implements Builder {
        private Integer maxResults;

        private String mode;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeEndpointsRequest model) {
            super(model);
            maxResults(model.maxResults);
            mode(model.mode);
            nextToken(model.nextToken);
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getMode() {
            return mode;
        }

        public final void setMode(String mode) {
            this.mode = mode;
        }

        @Override
        public final Builder mode(String mode) {
            this.mode = mode;
            return this;
        }

        @Override
        public final Builder mode(DescribeEndpointsMode mode) {
            this.mode(mode == null ? null : mode.toString());
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeEndpointsRequest build() {
            return new DescribeEndpointsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
