/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Create Dolby Vision Profile 5 or Profile 8.1 compatible video output.
 */
@Generated("software.amazon.awssdk:codegen")
public final class DolbyVision implements SdkPojo, Serializable, ToCopyableBuilder<DolbyVision.Builder, DolbyVision> {
    private static final SdkField<DolbyVisionLevel6Metadata> L6_METADATA_FIELD = SdkField
            .<DolbyVisionLevel6Metadata> builder(MarshallingType.SDK_POJO).memberName("L6Metadata")
            .getter(getter(DolbyVision::l6Metadata)).setter(setter(Builder::l6Metadata))
            .constructor(DolbyVisionLevel6Metadata::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("l6Metadata").build()).build();

    private static final SdkField<String> L6_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("L6Mode")
            .getter(getter(DolbyVision::l6ModeAsString)).setter(setter(Builder::l6Mode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("l6Mode").build()).build();

    private static final SdkField<String> MAPPING_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Mapping")
            .getter(getter(DolbyVision::mappingAsString)).setter(setter(Builder::mapping))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mapping").build()).build();

    private static final SdkField<String> PROFILE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Profile")
            .getter(getter(DolbyVision::profileAsString)).setter(setter(Builder::profile))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("profile").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(L6_METADATA_FIELD,
            L6_MODE_FIELD, MAPPING_FIELD, PROFILE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final DolbyVisionLevel6Metadata l6Metadata;

    private final String l6Mode;

    private final String mapping;

    private final String profile;

    private DolbyVision(BuilderImpl builder) {
        this.l6Metadata = builder.l6Metadata;
        this.l6Mode = builder.l6Mode;
        this.mapping = builder.mapping;
        this.profile = builder.profile;
    }

    /**
     * Use these settings when you set DolbyVisionLevel6Mode to SPECIFY to override the MaxCLL and MaxFALL values in
     * your input with new values.
     * 
     * @return Use these settings when you set DolbyVisionLevel6Mode to SPECIFY to override the MaxCLL and MaxFALL
     *         values in your input with new values.
     */
    public final DolbyVisionLevel6Metadata l6Metadata() {
        return l6Metadata;
    }

    /**
     * Use Dolby Vision Mode to choose how the service will handle Dolby Vision MaxCLL and MaxFALL properies.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #l6Mode} will
     * return {@link DolbyVisionLevel6Mode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #l6ModeAsString}.
     * </p>
     * 
     * @return Use Dolby Vision Mode to choose how the service will handle Dolby Vision MaxCLL and MaxFALL properies.
     * @see DolbyVisionLevel6Mode
     */
    public final DolbyVisionLevel6Mode l6Mode() {
        return DolbyVisionLevel6Mode.fromValue(l6Mode);
    }

    /**
     * Use Dolby Vision Mode to choose how the service will handle Dolby Vision MaxCLL and MaxFALL properies.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #l6Mode} will
     * return {@link DolbyVisionLevel6Mode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #l6ModeAsString}.
     * </p>
     * 
     * @return Use Dolby Vision Mode to choose how the service will handle Dolby Vision MaxCLL and MaxFALL properies.
     * @see DolbyVisionLevel6Mode
     */
    public final String l6ModeAsString() {
        return l6Mode;
    }

    /**
     * Required when you set Dolby Vision Profile to Profile 8.1. When you set Content mapping to None, content mapping
     * is not applied to the HDR10-compatible signal. Depending on the source peak nit level, clipping might occur on
     * HDR devices without Dolby Vision. When you set Content mapping to HDR10 1000, the transcoder creates a 1,000 nits
     * peak HDR10-compatible signal by applying static content mapping to the source. This mode is speed-optimized for
     * PQ10 sources with metadata that is created from analysis. For graded Dolby Vision content, be aware that creative
     * intent might not be guaranteed with extreme 1,000 nits trims.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mapping} will
     * return {@link DolbyVisionMapping#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #mappingAsString}.
     * </p>
     * 
     * @return Required when you set Dolby Vision Profile to Profile 8.1. When you set Content mapping to None, content
     *         mapping is not applied to the HDR10-compatible signal. Depending on the source peak nit level, clipping
     *         might occur on HDR devices without Dolby Vision. When you set Content mapping to HDR10 1000, the
     *         transcoder creates a 1,000 nits peak HDR10-compatible signal by applying static content mapping to the
     *         source. This mode is speed-optimized for PQ10 sources with metadata that is created from analysis. For
     *         graded Dolby Vision content, be aware that creative intent might not be guaranteed with extreme 1,000
     *         nits trims.
     * @see DolbyVisionMapping
     */
    public final DolbyVisionMapping mapping() {
        return DolbyVisionMapping.fromValue(mapping);
    }

    /**
     * Required when you set Dolby Vision Profile to Profile 8.1. When you set Content mapping to None, content mapping
     * is not applied to the HDR10-compatible signal. Depending on the source peak nit level, clipping might occur on
     * HDR devices without Dolby Vision. When you set Content mapping to HDR10 1000, the transcoder creates a 1,000 nits
     * peak HDR10-compatible signal by applying static content mapping to the source. This mode is speed-optimized for
     * PQ10 sources with metadata that is created from analysis. For graded Dolby Vision content, be aware that creative
     * intent might not be guaranteed with extreme 1,000 nits trims.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mapping} will
     * return {@link DolbyVisionMapping#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #mappingAsString}.
     * </p>
     * 
     * @return Required when you set Dolby Vision Profile to Profile 8.1. When you set Content mapping to None, content
     *         mapping is not applied to the HDR10-compatible signal. Depending on the source peak nit level, clipping
     *         might occur on HDR devices without Dolby Vision. When you set Content mapping to HDR10 1000, the
     *         transcoder creates a 1,000 nits peak HDR10-compatible signal by applying static content mapping to the
     *         source. This mode is speed-optimized for PQ10 sources with metadata that is created from analysis. For
     *         graded Dolby Vision content, be aware that creative intent might not be guaranteed with extreme 1,000
     *         nits trims.
     * @see DolbyVisionMapping
     */
    public final String mappingAsString() {
        return mapping;
    }

    /**
     * Required when you enable Dolby Vision. Use Profile 5 to include frame-interleaved Dolby Vision metadata in your
     * output. Your input must include Dolby Vision metadata or an HDR10 YUV color space. Use Profile 8.1 to include
     * frame-interleaved Dolby Vision metadata and HDR10 metadata in your output. Your input must include Dolby Vision
     * metadata.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #profile} will
     * return {@link DolbyVisionProfile#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #profileAsString}.
     * </p>
     * 
     * @return Required when you enable Dolby Vision. Use Profile 5 to include frame-interleaved Dolby Vision metadata
     *         in your output. Your input must include Dolby Vision metadata or an HDR10 YUV color space. Use Profile
     *         8.1 to include frame-interleaved Dolby Vision metadata and HDR10 metadata in your output. Your input must
     *         include Dolby Vision metadata.
     * @see DolbyVisionProfile
     */
    public final DolbyVisionProfile profile() {
        return DolbyVisionProfile.fromValue(profile);
    }

    /**
     * Required when you enable Dolby Vision. Use Profile 5 to include frame-interleaved Dolby Vision metadata in your
     * output. Your input must include Dolby Vision metadata or an HDR10 YUV color space. Use Profile 8.1 to include
     * frame-interleaved Dolby Vision metadata and HDR10 metadata in your output. Your input must include Dolby Vision
     * metadata.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #profile} will
     * return {@link DolbyVisionProfile#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #profileAsString}.
     * </p>
     * 
     * @return Required when you enable Dolby Vision. Use Profile 5 to include frame-interleaved Dolby Vision metadata
     *         in your output. Your input must include Dolby Vision metadata or an HDR10 YUV color space. Use Profile
     *         8.1 to include frame-interleaved Dolby Vision metadata and HDR10 metadata in your output. Your input must
     *         include Dolby Vision metadata.
     * @see DolbyVisionProfile
     */
    public final String profileAsString() {
        return profile;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(l6Metadata());
        hashCode = 31 * hashCode + Objects.hashCode(l6ModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(mappingAsString());
        hashCode = 31 * hashCode + Objects.hashCode(profileAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DolbyVision)) {
            return false;
        }
        DolbyVision other = (DolbyVision) obj;
        return Objects.equals(l6Metadata(), other.l6Metadata()) && Objects.equals(l6ModeAsString(), other.l6ModeAsString())
                && Objects.equals(mappingAsString(), other.mappingAsString())
                && Objects.equals(profileAsString(), other.profileAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DolbyVision").add("L6Metadata", l6Metadata()).add("L6Mode", l6ModeAsString())
                .add("Mapping", mappingAsString()).add("Profile", profileAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "L6Metadata":
            return Optional.ofNullable(clazz.cast(l6Metadata()));
        case "L6Mode":
            return Optional.ofNullable(clazz.cast(l6ModeAsString()));
        case "Mapping":
            return Optional.ofNullable(clazz.cast(mappingAsString()));
        case "Profile":
            return Optional.ofNullable(clazz.cast(profileAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("l6Metadata", L6_METADATA_FIELD);
        map.put("l6Mode", L6_MODE_FIELD);
        map.put("mapping", MAPPING_FIELD);
        map.put("profile", PROFILE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DolbyVision, T> g) {
        return obj -> g.apply((DolbyVision) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DolbyVision> {
        /**
         * Use these settings when you set DolbyVisionLevel6Mode to SPECIFY to override the MaxCLL and MaxFALL values in
         * your input with new values.
         * 
         * @param l6Metadata
         *        Use these settings when you set DolbyVisionLevel6Mode to SPECIFY to override the MaxCLL and MaxFALL
         *        values in your input with new values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder l6Metadata(DolbyVisionLevel6Metadata l6Metadata);

        /**
         * Use these settings when you set DolbyVisionLevel6Mode to SPECIFY to override the MaxCLL and MaxFALL values in
         * your input with new values. This is a convenience method that creates an instance of the
         * {@link DolbyVisionLevel6Metadata.Builder} avoiding the need to create one manually via
         * {@link DolbyVisionLevel6Metadata#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DolbyVisionLevel6Metadata.Builder#build()} is called immediately
         * and its result is passed to {@link #l6Metadata(DolbyVisionLevel6Metadata)}.
         * 
         * @param l6Metadata
         *        a consumer that will call methods on {@link DolbyVisionLevel6Metadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #l6Metadata(DolbyVisionLevel6Metadata)
         */
        default Builder l6Metadata(Consumer<DolbyVisionLevel6Metadata.Builder> l6Metadata) {
            return l6Metadata(DolbyVisionLevel6Metadata.builder().applyMutation(l6Metadata).build());
        }

        /**
         * Use Dolby Vision Mode to choose how the service will handle Dolby Vision MaxCLL and MaxFALL properies.
         * 
         * @param l6Mode
         *        Use Dolby Vision Mode to choose how the service will handle Dolby Vision MaxCLL and MaxFALL properies.
         * @see DolbyVisionLevel6Mode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DolbyVisionLevel6Mode
         */
        Builder l6Mode(String l6Mode);

        /**
         * Use Dolby Vision Mode to choose how the service will handle Dolby Vision MaxCLL and MaxFALL properies.
         * 
         * @param l6Mode
         *        Use Dolby Vision Mode to choose how the service will handle Dolby Vision MaxCLL and MaxFALL properies.
         * @see DolbyVisionLevel6Mode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DolbyVisionLevel6Mode
         */
        Builder l6Mode(DolbyVisionLevel6Mode l6Mode);

        /**
         * Required when you set Dolby Vision Profile to Profile 8.1. When you set Content mapping to None, content
         * mapping is not applied to the HDR10-compatible signal. Depending on the source peak nit level, clipping might
         * occur on HDR devices without Dolby Vision. When you set Content mapping to HDR10 1000, the transcoder creates
         * a 1,000 nits peak HDR10-compatible signal by applying static content mapping to the source. This mode is
         * speed-optimized for PQ10 sources with metadata that is created from analysis. For graded Dolby Vision
         * content, be aware that creative intent might not be guaranteed with extreme 1,000 nits trims.
         * 
         * @param mapping
         *        Required when you set Dolby Vision Profile to Profile 8.1. When you set Content mapping to None,
         *        content mapping is not applied to the HDR10-compatible signal. Depending on the source peak nit level,
         *        clipping might occur on HDR devices without Dolby Vision. When you set Content mapping to HDR10 1000,
         *        the transcoder creates a 1,000 nits peak HDR10-compatible signal by applying static content mapping to
         *        the source. This mode is speed-optimized for PQ10 sources with metadata that is created from analysis.
         *        For graded Dolby Vision content, be aware that creative intent might not be guaranteed with extreme
         *        1,000 nits trims.
         * @see DolbyVisionMapping
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DolbyVisionMapping
         */
        Builder mapping(String mapping);

        /**
         * Required when you set Dolby Vision Profile to Profile 8.1. When you set Content mapping to None, content
         * mapping is not applied to the HDR10-compatible signal. Depending on the source peak nit level, clipping might
         * occur on HDR devices without Dolby Vision. When you set Content mapping to HDR10 1000, the transcoder creates
         * a 1,000 nits peak HDR10-compatible signal by applying static content mapping to the source. This mode is
         * speed-optimized for PQ10 sources with metadata that is created from analysis. For graded Dolby Vision
         * content, be aware that creative intent might not be guaranteed with extreme 1,000 nits trims.
         * 
         * @param mapping
         *        Required when you set Dolby Vision Profile to Profile 8.1. When you set Content mapping to None,
         *        content mapping is not applied to the HDR10-compatible signal. Depending on the source peak nit level,
         *        clipping might occur on HDR devices without Dolby Vision. When you set Content mapping to HDR10 1000,
         *        the transcoder creates a 1,000 nits peak HDR10-compatible signal by applying static content mapping to
         *        the source. This mode is speed-optimized for PQ10 sources with metadata that is created from analysis.
         *        For graded Dolby Vision content, be aware that creative intent might not be guaranteed with extreme
         *        1,000 nits trims.
         * @see DolbyVisionMapping
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DolbyVisionMapping
         */
        Builder mapping(DolbyVisionMapping mapping);

        /**
         * Required when you enable Dolby Vision. Use Profile 5 to include frame-interleaved Dolby Vision metadata in
         * your output. Your input must include Dolby Vision metadata or an HDR10 YUV color space. Use Profile 8.1 to
         * include frame-interleaved Dolby Vision metadata and HDR10 metadata in your output. Your input must include
         * Dolby Vision metadata.
         * 
         * @param profile
         *        Required when you enable Dolby Vision. Use Profile 5 to include frame-interleaved Dolby Vision
         *        metadata in your output. Your input must include Dolby Vision metadata or an HDR10 YUV color space.
         *        Use Profile 8.1 to include frame-interleaved Dolby Vision metadata and HDR10 metadata in your output.
         *        Your input must include Dolby Vision metadata.
         * @see DolbyVisionProfile
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DolbyVisionProfile
         */
        Builder profile(String profile);

        /**
         * Required when you enable Dolby Vision. Use Profile 5 to include frame-interleaved Dolby Vision metadata in
         * your output. Your input must include Dolby Vision metadata or an HDR10 YUV color space. Use Profile 8.1 to
         * include frame-interleaved Dolby Vision metadata and HDR10 metadata in your output. Your input must include
         * Dolby Vision metadata.
         * 
         * @param profile
         *        Required when you enable Dolby Vision. Use Profile 5 to include frame-interleaved Dolby Vision
         *        metadata in your output. Your input must include Dolby Vision metadata or an HDR10 YUV color space.
         *        Use Profile 8.1 to include frame-interleaved Dolby Vision metadata and HDR10 metadata in your output.
         *        Your input must include Dolby Vision metadata.
         * @see DolbyVisionProfile
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DolbyVisionProfile
         */
        Builder profile(DolbyVisionProfile profile);
    }

    static final class BuilderImpl implements Builder {
        private DolbyVisionLevel6Metadata l6Metadata;

        private String l6Mode;

        private String mapping;

        private String profile;

        private BuilderImpl() {
        }

        private BuilderImpl(DolbyVision model) {
            l6Metadata(model.l6Metadata);
            l6Mode(model.l6Mode);
            mapping(model.mapping);
            profile(model.profile);
        }

        public final DolbyVisionLevel6Metadata.Builder getL6Metadata() {
            return l6Metadata != null ? l6Metadata.toBuilder() : null;
        }

        public final void setL6Metadata(DolbyVisionLevel6Metadata.BuilderImpl l6Metadata) {
            this.l6Metadata = l6Metadata != null ? l6Metadata.build() : null;
        }

        @Override
        public final Builder l6Metadata(DolbyVisionLevel6Metadata l6Metadata) {
            this.l6Metadata = l6Metadata;
            return this;
        }

        public final String getL6Mode() {
            return l6Mode;
        }

        public final void setL6Mode(String l6Mode) {
            this.l6Mode = l6Mode;
        }

        @Override
        public final Builder l6Mode(String l6Mode) {
            this.l6Mode = l6Mode;
            return this;
        }

        @Override
        public final Builder l6Mode(DolbyVisionLevel6Mode l6Mode) {
            this.l6Mode(l6Mode == null ? null : l6Mode.toString());
            return this;
        }

        public final String getMapping() {
            return mapping;
        }

        public final void setMapping(String mapping) {
            this.mapping = mapping;
        }

        @Override
        public final Builder mapping(String mapping) {
            this.mapping = mapping;
            return this;
        }

        @Override
        public final Builder mapping(DolbyVisionMapping mapping) {
            this.mapping(mapping == null ? null : mapping.toString());
            return this;
        }

        public final String getProfile() {
            return profile;
        }

        public final void setProfile(String profile) {
            this.profile = profile;
        }

        @Override
        public final Builder profile(String profile) {
            this.profile = profile;
            return this;
        }

        @Override
        public final Builder profile(DolbyVisionProfile profile) {
            this.profile(profile == null ? null : profile.toString());
            return this;
        }

        @Override
        public DolbyVision build() {
            return new DolbyVision(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
