/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Specify the SPEKE version, either v1.0 or v2.0, that MediaConvert uses when encrypting your output. For more
 * information, see: https://docs.aws.amazon.com/speke/latest/documentation/speke-api-specification.html To use SPEKE
 * v1.0: Leave blank. To use SPEKE v2.0: Specify a SPEKE v2.0 video preset and a SPEKE v2.0 audio preset.
 */
@Generated("software.amazon.awssdk:codegen")
public final class EncryptionContractConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<EncryptionContractConfiguration.Builder, EncryptionContractConfiguration> {
    private static final SdkField<String> SPEKE_AUDIO_PRESET_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SpekeAudioPreset").getter(getter(EncryptionContractConfiguration::spekeAudioPresetAsString))
            .setter(setter(Builder::spekeAudioPreset))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("spekeAudioPreset").build()).build();

    private static final SdkField<String> SPEKE_VIDEO_PRESET_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SpekeVideoPreset").getter(getter(EncryptionContractConfiguration::spekeVideoPresetAsString))
            .setter(setter(Builder::spekeVideoPreset))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("spekeVideoPreset").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SPEKE_AUDIO_PRESET_FIELD,
            SPEKE_VIDEO_PRESET_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String spekeAudioPreset;

    private final String spekeVideoPreset;

    private EncryptionContractConfiguration(BuilderImpl builder) {
        this.spekeAudioPreset = builder.spekeAudioPreset;
        this.spekeVideoPreset = builder.spekeVideoPreset;
    }

    /**
     * Specify which SPEKE version 2.0 audio preset MediaConvert uses to request content keys from your SPEKE server.
     * For more information, see: https://docs.aws.amazon.com/mediaconvert/latest/ug/drm-content-speke-v2-presets.html
     * To encrypt to your audio outputs, choose from the following: Audio preset 1, Audio preset 2, or Audio preset 3.
     * To encrypt your audio outputs, using the same content key for both your audio and video outputs: Choose Shared.
     * When you do, you must also set SPEKE v2.0 video preset to Shared. To not encrypt your audio outputs: Choose
     * Unencrypted. When you do, to encrypt your video outputs, you must also specify a SPEKE v2.0 video preset (other
     * than Shared or Unencrypted).
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #spekeAudioPreset}
     * will return {@link PresetSpeke20Audio#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #spekeAudioPresetAsString}.
     * </p>
     * 
     * @return Specify which SPEKE version 2.0 audio preset MediaConvert uses to request content keys from your SPEKE
     *         server. For more information, see:
     *         https://docs.aws.amazon.com/mediaconvert/latest/ug/drm-content-speke-v2-presets.html To encrypt to your
     *         audio outputs, choose from the following: Audio preset 1, Audio preset 2, or Audio preset 3. To encrypt
     *         your audio outputs, using the same content key for both your audio and video outputs: Choose Shared. When
     *         you do, you must also set SPEKE v2.0 video preset to Shared. To not encrypt your audio outputs: Choose
     *         Unencrypted. When you do, to encrypt your video outputs, you must also specify a SPEKE v2.0 video preset
     *         (other than Shared or Unencrypted).
     * @see PresetSpeke20Audio
     */
    public final PresetSpeke20Audio spekeAudioPreset() {
        return PresetSpeke20Audio.fromValue(spekeAudioPreset);
    }

    /**
     * Specify which SPEKE version 2.0 audio preset MediaConvert uses to request content keys from your SPEKE server.
     * For more information, see: https://docs.aws.amazon.com/mediaconvert/latest/ug/drm-content-speke-v2-presets.html
     * To encrypt to your audio outputs, choose from the following: Audio preset 1, Audio preset 2, or Audio preset 3.
     * To encrypt your audio outputs, using the same content key for both your audio and video outputs: Choose Shared.
     * When you do, you must also set SPEKE v2.0 video preset to Shared. To not encrypt your audio outputs: Choose
     * Unencrypted. When you do, to encrypt your video outputs, you must also specify a SPEKE v2.0 video preset (other
     * than Shared or Unencrypted).
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #spekeAudioPreset}
     * will return {@link PresetSpeke20Audio#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #spekeAudioPresetAsString}.
     * </p>
     * 
     * @return Specify which SPEKE version 2.0 audio preset MediaConvert uses to request content keys from your SPEKE
     *         server. For more information, see:
     *         https://docs.aws.amazon.com/mediaconvert/latest/ug/drm-content-speke-v2-presets.html To encrypt to your
     *         audio outputs, choose from the following: Audio preset 1, Audio preset 2, or Audio preset 3. To encrypt
     *         your audio outputs, using the same content key for both your audio and video outputs: Choose Shared. When
     *         you do, you must also set SPEKE v2.0 video preset to Shared. To not encrypt your audio outputs: Choose
     *         Unencrypted. When you do, to encrypt your video outputs, you must also specify a SPEKE v2.0 video preset
     *         (other than Shared or Unencrypted).
     * @see PresetSpeke20Audio
     */
    public final String spekeAudioPresetAsString() {
        return spekeAudioPreset;
    }

    /**
     * Specify which SPEKE version 2.0 video preset MediaConvert uses to request content keys from your SPEKE server.
     * For more information, see: https://docs.aws.amazon.com/mediaconvert/latest/ug/drm-content-speke-v2-presets.html
     * To encrypt to your video outputs, choose from the following: Video preset 1, Video preset 2, Video preset 3,
     * Video preset 4, Video preset 5, Video preset 6, Video preset 7, or Video preset 8. To encrypt your video outputs,
     * using the same content key for both your video and audio outputs: Choose Shared. When you do, you must also set
     * SPEKE v2.0 audio preset to Shared. To not encrypt your video outputs: Choose Unencrypted. When you do, to encrypt
     * your audio outputs, you must also specify a SPEKE v2.0 audio preset (other than Shared or Unencrypted).
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #spekeVideoPreset}
     * will return {@link PresetSpeke20Video#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #spekeVideoPresetAsString}.
     * </p>
     * 
     * @return Specify which SPEKE version 2.0 video preset MediaConvert uses to request content keys from your SPEKE
     *         server. For more information, see:
     *         https://docs.aws.amazon.com/mediaconvert/latest/ug/drm-content-speke-v2-presets.html To encrypt to your
     *         video outputs, choose from the following: Video preset 1, Video preset 2, Video preset 3, Video preset 4,
     *         Video preset 5, Video preset 6, Video preset 7, or Video preset 8. To encrypt your video outputs, using
     *         the same content key for both your video and audio outputs: Choose Shared. When you do, you must also set
     *         SPEKE v2.0 audio preset to Shared. To not encrypt your video outputs: Choose Unencrypted. When you do, to
     *         encrypt your audio outputs, you must also specify a SPEKE v2.0 audio preset (other than Shared or
     *         Unencrypted).
     * @see PresetSpeke20Video
     */
    public final PresetSpeke20Video spekeVideoPreset() {
        return PresetSpeke20Video.fromValue(spekeVideoPreset);
    }

    /**
     * Specify which SPEKE version 2.0 video preset MediaConvert uses to request content keys from your SPEKE server.
     * For more information, see: https://docs.aws.amazon.com/mediaconvert/latest/ug/drm-content-speke-v2-presets.html
     * To encrypt to your video outputs, choose from the following: Video preset 1, Video preset 2, Video preset 3,
     * Video preset 4, Video preset 5, Video preset 6, Video preset 7, or Video preset 8. To encrypt your video outputs,
     * using the same content key for both your video and audio outputs: Choose Shared. When you do, you must also set
     * SPEKE v2.0 audio preset to Shared. To not encrypt your video outputs: Choose Unencrypted. When you do, to encrypt
     * your audio outputs, you must also specify a SPEKE v2.0 audio preset (other than Shared or Unencrypted).
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #spekeVideoPreset}
     * will return {@link PresetSpeke20Video#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #spekeVideoPresetAsString}.
     * </p>
     * 
     * @return Specify which SPEKE version 2.0 video preset MediaConvert uses to request content keys from your SPEKE
     *         server. For more information, see:
     *         https://docs.aws.amazon.com/mediaconvert/latest/ug/drm-content-speke-v2-presets.html To encrypt to your
     *         video outputs, choose from the following: Video preset 1, Video preset 2, Video preset 3, Video preset 4,
     *         Video preset 5, Video preset 6, Video preset 7, or Video preset 8. To encrypt your video outputs, using
     *         the same content key for both your video and audio outputs: Choose Shared. When you do, you must also set
     *         SPEKE v2.0 audio preset to Shared. To not encrypt your video outputs: Choose Unencrypted. When you do, to
     *         encrypt your audio outputs, you must also specify a SPEKE v2.0 audio preset (other than Shared or
     *         Unencrypted).
     * @see PresetSpeke20Video
     */
    public final String spekeVideoPresetAsString() {
        return spekeVideoPreset;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(spekeAudioPresetAsString());
        hashCode = 31 * hashCode + Objects.hashCode(spekeVideoPresetAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EncryptionContractConfiguration)) {
            return false;
        }
        EncryptionContractConfiguration other = (EncryptionContractConfiguration) obj;
        return Objects.equals(spekeAudioPresetAsString(), other.spekeAudioPresetAsString())
                && Objects.equals(spekeVideoPresetAsString(), other.spekeVideoPresetAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EncryptionContractConfiguration").add("SpekeAudioPreset", spekeAudioPresetAsString())
                .add("SpekeVideoPreset", spekeVideoPresetAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SpekeAudioPreset":
            return Optional.ofNullable(clazz.cast(spekeAudioPresetAsString()));
        case "SpekeVideoPreset":
            return Optional.ofNullable(clazz.cast(spekeVideoPresetAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("spekeAudioPreset", SPEKE_AUDIO_PRESET_FIELD);
        map.put("spekeVideoPreset", SPEKE_VIDEO_PRESET_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EncryptionContractConfiguration, T> g) {
        return obj -> g.apply((EncryptionContractConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EncryptionContractConfiguration> {
        /**
         * Specify which SPEKE version 2.0 audio preset MediaConvert uses to request content keys from your SPEKE
         * server. For more information, see:
         * https://docs.aws.amazon.com/mediaconvert/latest/ug/drm-content-speke-v2-presets.html To encrypt to your audio
         * outputs, choose from the following: Audio preset 1, Audio preset 2, or Audio preset 3. To encrypt your audio
         * outputs, using the same content key for both your audio and video outputs: Choose Shared. When you do, you
         * must also set SPEKE v2.0 video preset to Shared. To not encrypt your audio outputs: Choose Unencrypted. When
         * you do, to encrypt your video outputs, you must also specify a SPEKE v2.0 video preset (other than Shared or
         * Unencrypted).
         * 
         * @param spekeAudioPreset
         *        Specify which SPEKE version 2.0 audio preset MediaConvert uses to request content keys from your SPEKE
         *        server. For more information, see:
         *        https://docs.aws.amazon.com/mediaconvert/latest/ug/drm-content-speke-v2-presets.html To encrypt to
         *        your audio outputs, choose from the following: Audio preset 1, Audio preset 2, or Audio preset 3. To
         *        encrypt your audio outputs, using the same content key for both your audio and video outputs: Choose
         *        Shared. When you do, you must also set SPEKE v2.0 video preset to Shared. To not encrypt your audio
         *        outputs: Choose Unencrypted. When you do, to encrypt your video outputs, you must also specify a SPEKE
         *        v2.0 video preset (other than Shared or Unencrypted).
         * @see PresetSpeke20Audio
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PresetSpeke20Audio
         */
        Builder spekeAudioPreset(String spekeAudioPreset);

        /**
         * Specify which SPEKE version 2.0 audio preset MediaConvert uses to request content keys from your SPEKE
         * server. For more information, see:
         * https://docs.aws.amazon.com/mediaconvert/latest/ug/drm-content-speke-v2-presets.html To encrypt to your audio
         * outputs, choose from the following: Audio preset 1, Audio preset 2, or Audio preset 3. To encrypt your audio
         * outputs, using the same content key for both your audio and video outputs: Choose Shared. When you do, you
         * must also set SPEKE v2.0 video preset to Shared. To not encrypt your audio outputs: Choose Unencrypted. When
         * you do, to encrypt your video outputs, you must also specify a SPEKE v2.0 video preset (other than Shared or
         * Unencrypted).
         * 
         * @param spekeAudioPreset
         *        Specify which SPEKE version 2.0 audio preset MediaConvert uses to request content keys from your SPEKE
         *        server. For more information, see:
         *        https://docs.aws.amazon.com/mediaconvert/latest/ug/drm-content-speke-v2-presets.html To encrypt to
         *        your audio outputs, choose from the following: Audio preset 1, Audio preset 2, or Audio preset 3. To
         *        encrypt your audio outputs, using the same content key for both your audio and video outputs: Choose
         *        Shared. When you do, you must also set SPEKE v2.0 video preset to Shared. To not encrypt your audio
         *        outputs: Choose Unencrypted. When you do, to encrypt your video outputs, you must also specify a SPEKE
         *        v2.0 video preset (other than Shared or Unencrypted).
         * @see PresetSpeke20Audio
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PresetSpeke20Audio
         */
        Builder spekeAudioPreset(PresetSpeke20Audio spekeAudioPreset);

        /**
         * Specify which SPEKE version 2.0 video preset MediaConvert uses to request content keys from your SPEKE
         * server. For more information, see:
         * https://docs.aws.amazon.com/mediaconvert/latest/ug/drm-content-speke-v2-presets.html To encrypt to your video
         * outputs, choose from the following: Video preset 1, Video preset 2, Video preset 3, Video preset 4, Video
         * preset 5, Video preset 6, Video preset 7, or Video preset 8. To encrypt your video outputs, using the same
         * content key for both your video and audio outputs: Choose Shared. When you do, you must also set SPEKE v2.0
         * audio preset to Shared. To not encrypt your video outputs: Choose Unencrypted. When you do, to encrypt your
         * audio outputs, you must also specify a SPEKE v2.0 audio preset (other than Shared or Unencrypted).
         * 
         * @param spekeVideoPreset
         *        Specify which SPEKE version 2.0 video preset MediaConvert uses to request content keys from your SPEKE
         *        server. For more information, see:
         *        https://docs.aws.amazon.com/mediaconvert/latest/ug/drm-content-speke-v2-presets.html To encrypt to
         *        your video outputs, choose from the following: Video preset 1, Video preset 2, Video preset 3, Video
         *        preset 4, Video preset 5, Video preset 6, Video preset 7, or Video preset 8. To encrypt your video
         *        outputs, using the same content key for both your video and audio outputs: Choose Shared. When you do,
         *        you must also set SPEKE v2.0 audio preset to Shared. To not encrypt your video outputs: Choose
         *        Unencrypted. When you do, to encrypt your audio outputs, you must also specify a SPEKE v2.0 audio
         *        preset (other than Shared or Unencrypted).
         * @see PresetSpeke20Video
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PresetSpeke20Video
         */
        Builder spekeVideoPreset(String spekeVideoPreset);

        /**
         * Specify which SPEKE version 2.0 video preset MediaConvert uses to request content keys from your SPEKE
         * server. For more information, see:
         * https://docs.aws.amazon.com/mediaconvert/latest/ug/drm-content-speke-v2-presets.html To encrypt to your video
         * outputs, choose from the following: Video preset 1, Video preset 2, Video preset 3, Video preset 4, Video
         * preset 5, Video preset 6, Video preset 7, or Video preset 8. To encrypt your video outputs, using the same
         * content key for both your video and audio outputs: Choose Shared. When you do, you must also set SPEKE v2.0
         * audio preset to Shared. To not encrypt your video outputs: Choose Unencrypted. When you do, to encrypt your
         * audio outputs, you must also specify a SPEKE v2.0 audio preset (other than Shared or Unencrypted).
         * 
         * @param spekeVideoPreset
         *        Specify which SPEKE version 2.0 video preset MediaConvert uses to request content keys from your SPEKE
         *        server. For more information, see:
         *        https://docs.aws.amazon.com/mediaconvert/latest/ug/drm-content-speke-v2-presets.html To encrypt to
         *        your video outputs, choose from the following: Video preset 1, Video preset 2, Video preset 3, Video
         *        preset 4, Video preset 5, Video preset 6, Video preset 7, or Video preset 8. To encrypt your video
         *        outputs, using the same content key for both your video and audio outputs: Choose Shared. When you do,
         *        you must also set SPEKE v2.0 audio preset to Shared. To not encrypt your video outputs: Choose
         *        Unencrypted. When you do, to encrypt your audio outputs, you must also specify a SPEKE v2.0 audio
         *        preset (other than Shared or Unencrypted).
         * @see PresetSpeke20Video
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PresetSpeke20Video
         */
        Builder spekeVideoPreset(PresetSpeke20Video spekeVideoPreset);
    }

    static final class BuilderImpl implements Builder {
        private String spekeAudioPreset;

        private String spekeVideoPreset;

        private BuilderImpl() {
        }

        private BuilderImpl(EncryptionContractConfiguration model) {
            spekeAudioPreset(model.spekeAudioPreset);
            spekeVideoPreset(model.spekeVideoPreset);
        }

        public final String getSpekeAudioPreset() {
            return spekeAudioPreset;
        }

        public final void setSpekeAudioPreset(String spekeAudioPreset) {
            this.spekeAudioPreset = spekeAudioPreset;
        }

        @Override
        public final Builder spekeAudioPreset(String spekeAudioPreset) {
            this.spekeAudioPreset = spekeAudioPreset;
            return this;
        }

        @Override
        public final Builder spekeAudioPreset(PresetSpeke20Audio spekeAudioPreset) {
            this.spekeAudioPreset(spekeAudioPreset == null ? null : spekeAudioPreset.toString());
            return this;
        }

        public final String getSpekeVideoPreset() {
            return spekeVideoPreset;
        }

        public final void setSpekeVideoPreset(String spekeVideoPreset) {
            this.spekeVideoPreset = spekeVideoPreset;
        }

        @Override
        public final Builder spekeVideoPreset(String spekeVideoPreset) {
            this.spekeVideoPreset = spekeVideoPreset;
            return this;
        }

        @Override
        public final Builder spekeVideoPreset(PresetSpeke20Video spekeVideoPreset) {
            this.spekeVideoPreset(spekeVideoPreset == null ? null : spekeVideoPreset.toString());
            return this;
        }

        @Override
        public EncryptionContractConfiguration build() {
            return new EncryptionContractConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
