/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * If your input captions are SCC, SMI, SRT, STL, TTML, WebVTT, or IMSC 1.1 in an xml file, specify the URI of the input
 * caption source file. If your caption source is IMSC in an IMF package, use TrackSourceSettings instead of
 * FileSoureSettings.
 */
@Generated("software.amazon.awssdk:codegen")
public final class FileSourceSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<FileSourceSettings.Builder, FileSourceSettings> {
    private static final SdkField<String> BYTE_RATE_LIMIT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ByteRateLimit").getter(getter(FileSourceSettings::byteRateLimitAsString))
            .setter(setter(Builder::byteRateLimit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("byteRateLimit").build()).build();

    private static final SdkField<String> CONVERT608_TO708_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Convert608To708").getter(getter(FileSourceSettings::convert608To708AsString))
            .setter(setter(Builder::convert608To708))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("convert608To708").build()).build();

    private static final SdkField<String> CONVERT_PAINT_TO_POP_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConvertPaintToPop").getter(getter(FileSourceSettings::convertPaintToPopAsString))
            .setter(setter(Builder::convertPaintToPop))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("convertPaintToPop").build()).build();

    private static final SdkField<CaptionSourceFramerate> FRAMERATE_FIELD = SdkField
            .<CaptionSourceFramerate> builder(MarshallingType.SDK_POJO).memberName("Framerate")
            .getter(getter(FileSourceSettings::framerate)).setter(setter(Builder::framerate))
            .constructor(CaptionSourceFramerate::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("framerate").build()).build();

    private static final SdkField<String> SOURCE_FILE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceFile").getter(getter(FileSourceSettings::sourceFile)).setter(setter(Builder::sourceFile))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceFile").build()).build();

    private static final SdkField<Integer> TIME_DELTA_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("TimeDelta").getter(getter(FileSourceSettings::timeDelta)).setter(setter(Builder::timeDelta))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timeDelta").build()).build();

    private static final SdkField<String> TIME_DELTA_UNITS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TimeDeltaUnits").getter(getter(FileSourceSettings::timeDeltaUnitsAsString))
            .setter(setter(Builder::timeDeltaUnits))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timeDeltaUnits").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BYTE_RATE_LIMIT_FIELD,
            CONVERT608_TO708_FIELD, CONVERT_PAINT_TO_POP_FIELD, FRAMERATE_FIELD, SOURCE_FILE_FIELD, TIME_DELTA_FIELD,
            TIME_DELTA_UNITS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String byteRateLimit;

    private final String convert608To708;

    private final String convertPaintToPop;

    private final CaptionSourceFramerate framerate;

    private final String sourceFile;

    private final Integer timeDelta;

    private final String timeDeltaUnits;

    private FileSourceSettings(BuilderImpl builder) {
        this.byteRateLimit = builder.byteRateLimit;
        this.convert608To708 = builder.convert608To708;
        this.convertPaintToPop = builder.convertPaintToPop;
        this.framerate = builder.framerate;
        this.sourceFile = builder.sourceFile;
        this.timeDelta = builder.timeDelta;
        this.timeDeltaUnits = builder.timeDeltaUnits;
    }

    /**
     * Choose whether to limit the byte rate at which your SCC input captions are inserted into your output. To not
     * limit the caption rate: We recommend that you keep the default value, Disabled. MediaConvert inserts captions in
     * your output according to the byte rates listed in the EIA-608 specification, typically 2 or 3 caption bytes per
     * frame depending on your output frame rate. To limit your output caption rate: Choose Enabled. Choose this option
     * if your downstream systems require a maximum of 2 caption bytes per frame. Note that this setting has no effect
     * when your output frame rate is 30 or 60.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #byteRateLimit}
     * will return {@link CaptionSourceByteRateLimit#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #byteRateLimitAsString}.
     * </p>
     * 
     * @return Choose whether to limit the byte rate at which your SCC input captions are inserted into your output. To
     *         not limit the caption rate: We recommend that you keep the default value, Disabled. MediaConvert inserts
     *         captions in your output according to the byte rates listed in the EIA-608 specification, typically 2 or 3
     *         caption bytes per frame depending on your output frame rate. To limit your output caption rate: Choose
     *         Enabled. Choose this option if your downstream systems require a maximum of 2 caption bytes per frame.
     *         Note that this setting has no effect when your output frame rate is 30 or 60.
     * @see CaptionSourceByteRateLimit
     */
    public final CaptionSourceByteRateLimit byteRateLimit() {
        return CaptionSourceByteRateLimit.fromValue(byteRateLimit);
    }

    /**
     * Choose whether to limit the byte rate at which your SCC input captions are inserted into your output. To not
     * limit the caption rate: We recommend that you keep the default value, Disabled. MediaConvert inserts captions in
     * your output according to the byte rates listed in the EIA-608 specification, typically 2 or 3 caption bytes per
     * frame depending on your output frame rate. To limit your output caption rate: Choose Enabled. Choose this option
     * if your downstream systems require a maximum of 2 caption bytes per frame. Note that this setting has no effect
     * when your output frame rate is 30 or 60.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #byteRateLimit}
     * will return {@link CaptionSourceByteRateLimit#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #byteRateLimitAsString}.
     * </p>
     * 
     * @return Choose whether to limit the byte rate at which your SCC input captions are inserted into your output. To
     *         not limit the caption rate: We recommend that you keep the default value, Disabled. MediaConvert inserts
     *         captions in your output according to the byte rates listed in the EIA-608 specification, typically 2 or 3
     *         caption bytes per frame depending on your output frame rate. To limit your output caption rate: Choose
     *         Enabled. Choose this option if your downstream systems require a maximum of 2 caption bytes per frame.
     *         Note that this setting has no effect when your output frame rate is 30 or 60.
     * @see CaptionSourceByteRateLimit
     */
    public final String byteRateLimitAsString() {
        return byteRateLimit;
    }

    /**
     * Specify whether this set of input captions appears in your outputs in both 608 and 708 format. If you choose
     * Upconvert, MediaConvert includes the captions data in two ways: it passes the 608 data through using the 608
     * compatibility bytes fields of the 708 wrapper, and it also translates the 608 data into 708.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #convert608To708}
     * will return {@link FileSourceConvert608To708#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #convert608To708AsString}.
     * </p>
     * 
     * @return Specify whether this set of input captions appears in your outputs in both 608 and 708 format. If you
     *         choose Upconvert, MediaConvert includes the captions data in two ways: it passes the 608 data through
     *         using the 608 compatibility bytes fields of the 708 wrapper, and it also translates the 608 data into
     *         708.
     * @see FileSourceConvert608To708
     */
    public final FileSourceConvert608To708 convert608To708() {
        return FileSourceConvert608To708.fromValue(convert608To708);
    }

    /**
     * Specify whether this set of input captions appears in your outputs in both 608 and 708 format. If you choose
     * Upconvert, MediaConvert includes the captions data in two ways: it passes the 608 data through using the 608
     * compatibility bytes fields of the 708 wrapper, and it also translates the 608 data into 708.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #convert608To708}
     * will return {@link FileSourceConvert608To708#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #convert608To708AsString}.
     * </p>
     * 
     * @return Specify whether this set of input captions appears in your outputs in both 608 and 708 format. If you
     *         choose Upconvert, MediaConvert includes the captions data in two ways: it passes the 608 data through
     *         using the 608 compatibility bytes fields of the 708 wrapper, and it also translates the 608 data into
     *         708.
     * @see FileSourceConvert608To708
     */
    public final String convert608To708AsString() {
        return convert608To708;
    }

    /**
     * Choose the presentation style of your input SCC captions. To use the same presentation style as your input: Keep
     * the default value, Disabled. To convert paint-on captions to pop-on: Choose Enabled. We also recommend that you
     * choose Enabled if you notice additional repeated lines in your output captions.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #convertPaintToPop}
     * will return {@link CaptionSourceConvertPaintOnToPopOn#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #convertPaintToPopAsString}.
     * </p>
     * 
     * @return Choose the presentation style of your input SCC captions. To use the same presentation style as your
     *         input: Keep the default value, Disabled. To convert paint-on captions to pop-on: Choose Enabled. We also
     *         recommend that you choose Enabled if you notice additional repeated lines in your output captions.
     * @see CaptionSourceConvertPaintOnToPopOn
     */
    public final CaptionSourceConvertPaintOnToPopOn convertPaintToPop() {
        return CaptionSourceConvertPaintOnToPopOn.fromValue(convertPaintToPop);
    }

    /**
     * Choose the presentation style of your input SCC captions. To use the same presentation style as your input: Keep
     * the default value, Disabled. To convert paint-on captions to pop-on: Choose Enabled. We also recommend that you
     * choose Enabled if you notice additional repeated lines in your output captions.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #convertPaintToPop}
     * will return {@link CaptionSourceConvertPaintOnToPopOn#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #convertPaintToPopAsString}.
     * </p>
     * 
     * @return Choose the presentation style of your input SCC captions. To use the same presentation style as your
     *         input: Keep the default value, Disabled. To convert paint-on captions to pop-on: Choose Enabled. We also
     *         recommend that you choose Enabled if you notice additional repeated lines in your output captions.
     * @see CaptionSourceConvertPaintOnToPopOn
     */
    public final String convertPaintToPopAsString() {
        return convertPaintToPop;
    }

    /**
     * Ignore this setting unless your input captions format is SCC. To have the service compensate for differing frame
     * rates between your input captions and input video, specify the frame rate of the captions file. Specify this
     * value as a fraction. For example, you might specify 24 / 1 for 24 fps, 25 / 1 for 25 fps, 24000 / 1001 for 23.976
     * fps, or 30000 / 1001 for 29.97 fps.
     * 
     * @return Ignore this setting unless your input captions format is SCC. To have the service compensate for
     *         differing frame rates between your input captions and input video, specify the frame rate of the captions
     *         file. Specify this value as a fraction. For example, you might specify 24 / 1 for 24 fps, 25 / 1 for 25
     *         fps, 24000 / 1001 for 23.976 fps, or 30000 / 1001 for 29.97 fps.
     */
    public final CaptionSourceFramerate framerate() {
        return framerate;
    }

    /**
     * External caption file used for loading captions. Accepted file extensions are 'scc', 'ttml', 'dfxp', 'stl',
     * 'srt', 'xml', 'smi', 'webvtt', and 'vtt'.
     * 
     * @return External caption file used for loading captions. Accepted file extensions are 'scc', 'ttml', 'dfxp',
     *         'stl', 'srt', 'xml', 'smi', 'webvtt', and 'vtt'.
     */
    public final String sourceFile() {
        return sourceFile;
    }

    /**
     * Optional. Use this setting when you need to adjust the sync between your sidecar captions and your video. For
     * more information, see https://docs.aws.amazon.com/mediaconvert/latest/ug/time-delta-use-cases.html. Enter a
     * positive or negative number to modify the times in the captions file. For example, type 15 to add 15 seconds to
     * all the times in the captions file. Type -5 to subtract 5 seconds from the times in the captions file. You can
     * optionally specify your time delta in milliseconds instead of seconds. When you do so, set the related setting,
     * Time delta units to Milliseconds. Note that, when you specify a time delta for timecode-based caption sources,
     * such as SCC and STL, and your time delta isn't a multiple of the input frame rate, MediaConvert snaps the
     * captions to the nearest frame. For example, when your input video frame rate is 25 fps and you specify 1010ms for
     * time delta, MediaConvert delays your captions by 1000 ms.
     * 
     * @return Optional. Use this setting when you need to adjust the sync between your sidecar captions and your video.
     *         For more information, see https://docs.aws.amazon.com/mediaconvert/latest/ug/time-delta-use-cases.html.
     *         Enter a positive or negative number to modify the times in the captions file. For example, type 15 to add
     *         15 seconds to all the times in the captions file. Type -5 to subtract 5 seconds from the times in the
     *         captions file. You can optionally specify your time delta in milliseconds instead of seconds. When you do
     *         so, set the related setting, Time delta units to Milliseconds. Note that, when you specify a time delta
     *         for timecode-based caption sources, such as SCC and STL, and your time delta isn't a multiple of the
     *         input frame rate, MediaConvert snaps the captions to the nearest frame. For example, when your input
     *         video frame rate is 25 fps and you specify 1010ms for time delta, MediaConvert delays your captions by
     *         1000 ms.
     */
    public final Integer timeDelta() {
        return timeDelta;
    }

    /**
     * When you use the setting Time delta to adjust the sync between your sidecar captions and your video, use this
     * setting to specify the units for the delta that you specify. When you don't specify a value for Time delta units,
     * MediaConvert uses seconds by default.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #timeDeltaUnits}
     * will return {@link FileSourceTimeDeltaUnits#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #timeDeltaUnitsAsString}.
     * </p>
     * 
     * @return When you use the setting Time delta to adjust the sync between your sidecar captions and your video, use
     *         this setting to specify the units for the delta that you specify. When you don't specify a value for Time
     *         delta units, MediaConvert uses seconds by default.
     * @see FileSourceTimeDeltaUnits
     */
    public final FileSourceTimeDeltaUnits timeDeltaUnits() {
        return FileSourceTimeDeltaUnits.fromValue(timeDeltaUnits);
    }

    /**
     * When you use the setting Time delta to adjust the sync between your sidecar captions and your video, use this
     * setting to specify the units for the delta that you specify. When you don't specify a value for Time delta units,
     * MediaConvert uses seconds by default.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #timeDeltaUnits}
     * will return {@link FileSourceTimeDeltaUnits#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #timeDeltaUnitsAsString}.
     * </p>
     * 
     * @return When you use the setting Time delta to adjust the sync between your sidecar captions and your video, use
     *         this setting to specify the units for the delta that you specify. When you don't specify a value for Time
     *         delta units, MediaConvert uses seconds by default.
     * @see FileSourceTimeDeltaUnits
     */
    public final String timeDeltaUnitsAsString() {
        return timeDeltaUnits;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(byteRateLimitAsString());
        hashCode = 31 * hashCode + Objects.hashCode(convert608To708AsString());
        hashCode = 31 * hashCode + Objects.hashCode(convertPaintToPopAsString());
        hashCode = 31 * hashCode + Objects.hashCode(framerate());
        hashCode = 31 * hashCode + Objects.hashCode(sourceFile());
        hashCode = 31 * hashCode + Objects.hashCode(timeDelta());
        hashCode = 31 * hashCode + Objects.hashCode(timeDeltaUnitsAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FileSourceSettings)) {
            return false;
        }
        FileSourceSettings other = (FileSourceSettings) obj;
        return Objects.equals(byteRateLimitAsString(), other.byteRateLimitAsString())
                && Objects.equals(convert608To708AsString(), other.convert608To708AsString())
                && Objects.equals(convertPaintToPopAsString(), other.convertPaintToPopAsString())
                && Objects.equals(framerate(), other.framerate()) && Objects.equals(sourceFile(), other.sourceFile())
                && Objects.equals(timeDelta(), other.timeDelta())
                && Objects.equals(timeDeltaUnitsAsString(), other.timeDeltaUnitsAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FileSourceSettings").add("ByteRateLimit", byteRateLimitAsString())
                .add("Convert608To708", convert608To708AsString()).add("ConvertPaintToPop", convertPaintToPopAsString())
                .add("Framerate", framerate()).add("SourceFile", sourceFile()).add("TimeDelta", timeDelta())
                .add("TimeDeltaUnits", timeDeltaUnitsAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ByteRateLimit":
            return Optional.ofNullable(clazz.cast(byteRateLimitAsString()));
        case "Convert608To708":
            return Optional.ofNullable(clazz.cast(convert608To708AsString()));
        case "ConvertPaintToPop":
            return Optional.ofNullable(clazz.cast(convertPaintToPopAsString()));
        case "Framerate":
            return Optional.ofNullable(clazz.cast(framerate()));
        case "SourceFile":
            return Optional.ofNullable(clazz.cast(sourceFile()));
        case "TimeDelta":
            return Optional.ofNullable(clazz.cast(timeDelta()));
        case "TimeDeltaUnits":
            return Optional.ofNullable(clazz.cast(timeDeltaUnitsAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("byteRateLimit", BYTE_RATE_LIMIT_FIELD);
        map.put("convert608To708", CONVERT608_TO708_FIELD);
        map.put("convertPaintToPop", CONVERT_PAINT_TO_POP_FIELD);
        map.put("framerate", FRAMERATE_FIELD);
        map.put("sourceFile", SOURCE_FILE_FIELD);
        map.put("timeDelta", TIME_DELTA_FIELD);
        map.put("timeDeltaUnits", TIME_DELTA_UNITS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FileSourceSettings, T> g) {
        return obj -> g.apply((FileSourceSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FileSourceSettings> {
        /**
         * Choose whether to limit the byte rate at which your SCC input captions are inserted into your output. To not
         * limit the caption rate: We recommend that you keep the default value, Disabled. MediaConvert inserts captions
         * in your output according to the byte rates listed in the EIA-608 specification, typically 2 or 3 caption
         * bytes per frame depending on your output frame rate. To limit your output caption rate: Choose Enabled.
         * Choose this option if your downstream systems require a maximum of 2 caption bytes per frame. Note that this
         * setting has no effect when your output frame rate is 30 or 60.
         * 
         * @param byteRateLimit
         *        Choose whether to limit the byte rate at which your SCC input captions are inserted into your output.
         *        To not limit the caption rate: We recommend that you keep the default value, Disabled. MediaConvert
         *        inserts captions in your output according to the byte rates listed in the EIA-608 specification,
         *        typically 2 or 3 caption bytes per frame depending on your output frame rate. To limit your output
         *        caption rate: Choose Enabled. Choose this option if your downstream systems require a maximum of 2
         *        caption bytes per frame. Note that this setting has no effect when your output frame rate is 30 or 60.
         * @see CaptionSourceByteRateLimit
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CaptionSourceByteRateLimit
         */
        Builder byteRateLimit(String byteRateLimit);

        /**
         * Choose whether to limit the byte rate at which your SCC input captions are inserted into your output. To not
         * limit the caption rate: We recommend that you keep the default value, Disabled. MediaConvert inserts captions
         * in your output according to the byte rates listed in the EIA-608 specification, typically 2 or 3 caption
         * bytes per frame depending on your output frame rate. To limit your output caption rate: Choose Enabled.
         * Choose this option if your downstream systems require a maximum of 2 caption bytes per frame. Note that this
         * setting has no effect when your output frame rate is 30 or 60.
         * 
         * @param byteRateLimit
         *        Choose whether to limit the byte rate at which your SCC input captions are inserted into your output.
         *        To not limit the caption rate: We recommend that you keep the default value, Disabled. MediaConvert
         *        inserts captions in your output according to the byte rates listed in the EIA-608 specification,
         *        typically 2 or 3 caption bytes per frame depending on your output frame rate. To limit your output
         *        caption rate: Choose Enabled. Choose this option if your downstream systems require a maximum of 2
         *        caption bytes per frame. Note that this setting has no effect when your output frame rate is 30 or 60.
         * @see CaptionSourceByteRateLimit
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CaptionSourceByteRateLimit
         */
        Builder byteRateLimit(CaptionSourceByteRateLimit byteRateLimit);

        /**
         * Specify whether this set of input captions appears in your outputs in both 608 and 708 format. If you choose
         * Upconvert, MediaConvert includes the captions data in two ways: it passes the 608 data through using the 608
         * compatibility bytes fields of the 708 wrapper, and it also translates the 608 data into 708.
         * 
         * @param convert608To708
         *        Specify whether this set of input captions appears in your outputs in both 608 and 708 format. If you
         *        choose Upconvert, MediaConvert includes the captions data in two ways: it passes the 608 data through
         *        using the 608 compatibility bytes fields of the 708 wrapper, and it also translates the 608 data into
         *        708.
         * @see FileSourceConvert608To708
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FileSourceConvert608To708
         */
        Builder convert608To708(String convert608To708);

        /**
         * Specify whether this set of input captions appears in your outputs in both 608 and 708 format. If you choose
         * Upconvert, MediaConvert includes the captions data in two ways: it passes the 608 data through using the 608
         * compatibility bytes fields of the 708 wrapper, and it also translates the 608 data into 708.
         * 
         * @param convert608To708
         *        Specify whether this set of input captions appears in your outputs in both 608 and 708 format. If you
         *        choose Upconvert, MediaConvert includes the captions data in two ways: it passes the 608 data through
         *        using the 608 compatibility bytes fields of the 708 wrapper, and it also translates the 608 data into
         *        708.
         * @see FileSourceConvert608To708
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FileSourceConvert608To708
         */
        Builder convert608To708(FileSourceConvert608To708 convert608To708);

        /**
         * Choose the presentation style of your input SCC captions. To use the same presentation style as your input:
         * Keep the default value, Disabled. To convert paint-on captions to pop-on: Choose Enabled. We also recommend
         * that you choose Enabled if you notice additional repeated lines in your output captions.
         * 
         * @param convertPaintToPop
         *        Choose the presentation style of your input SCC captions. To use the same presentation style as your
         *        input: Keep the default value, Disabled. To convert paint-on captions to pop-on: Choose Enabled. We
         *        also recommend that you choose Enabled if you notice additional repeated lines in your output
         *        captions.
         * @see CaptionSourceConvertPaintOnToPopOn
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CaptionSourceConvertPaintOnToPopOn
         */
        Builder convertPaintToPop(String convertPaintToPop);

        /**
         * Choose the presentation style of your input SCC captions. To use the same presentation style as your input:
         * Keep the default value, Disabled. To convert paint-on captions to pop-on: Choose Enabled. We also recommend
         * that you choose Enabled if you notice additional repeated lines in your output captions.
         * 
         * @param convertPaintToPop
         *        Choose the presentation style of your input SCC captions. To use the same presentation style as your
         *        input: Keep the default value, Disabled. To convert paint-on captions to pop-on: Choose Enabled. We
         *        also recommend that you choose Enabled if you notice additional repeated lines in your output
         *        captions.
         * @see CaptionSourceConvertPaintOnToPopOn
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CaptionSourceConvertPaintOnToPopOn
         */
        Builder convertPaintToPop(CaptionSourceConvertPaintOnToPopOn convertPaintToPop);

        /**
         * Ignore this setting unless your input captions format is SCC. To have the service compensate for differing
         * frame rates between your input captions and input video, specify the frame rate of the captions file. Specify
         * this value as a fraction. For example, you might specify 24 / 1 for 24 fps, 25 / 1 for 25 fps, 24000 / 1001
         * for 23.976 fps, or 30000 / 1001 for 29.97 fps.
         * 
         * @param framerate
         *        Ignore this setting unless your input captions format is SCC. To have the service compensate for
         *        differing frame rates between your input captions and input video, specify the frame rate of the
         *        captions file. Specify this value as a fraction. For example, you might specify 24 / 1 for 24 fps, 25
         *        / 1 for 25 fps, 24000 / 1001 for 23.976 fps, or 30000 / 1001 for 29.97 fps.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder framerate(CaptionSourceFramerate framerate);

        /**
         * Ignore this setting unless your input captions format is SCC. To have the service compensate for differing
         * frame rates between your input captions and input video, specify the frame rate of the captions file. Specify
         * this value as a fraction. For example, you might specify 24 / 1 for 24 fps, 25 / 1 for 25 fps, 24000 / 1001
         * for 23.976 fps, or 30000 / 1001 for 29.97 fps. This is a convenience method that creates an instance of the
         * {@link CaptionSourceFramerate.Builder} avoiding the need to create one manually via
         * {@link CaptionSourceFramerate#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CaptionSourceFramerate.Builder#build()} is called immediately and
         * its result is passed to {@link #framerate(CaptionSourceFramerate)}.
         * 
         * @param framerate
         *        a consumer that will call methods on {@link CaptionSourceFramerate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #framerate(CaptionSourceFramerate)
         */
        default Builder framerate(Consumer<CaptionSourceFramerate.Builder> framerate) {
            return framerate(CaptionSourceFramerate.builder().applyMutation(framerate).build());
        }

        /**
         * External caption file used for loading captions. Accepted file extensions are 'scc', 'ttml', 'dfxp', 'stl',
         * 'srt', 'xml', 'smi', 'webvtt', and 'vtt'.
         * 
         * @param sourceFile
         *        External caption file used for loading captions. Accepted file extensions are 'scc', 'ttml', 'dfxp',
         *        'stl', 'srt', 'xml', 'smi', 'webvtt', and 'vtt'.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceFile(String sourceFile);

        /**
         * Optional. Use this setting when you need to adjust the sync between your sidecar captions and your video. For
         * more information, see https://docs.aws.amazon.com/mediaconvert/latest/ug/time-delta-use-cases.html. Enter a
         * positive or negative number to modify the times in the captions file. For example, type 15 to add 15 seconds
         * to all the times in the captions file. Type -5 to subtract 5 seconds from the times in the captions file. You
         * can optionally specify your time delta in milliseconds instead of seconds. When you do so, set the related
         * setting, Time delta units to Milliseconds. Note that, when you specify a time delta for timecode-based
         * caption sources, such as SCC and STL, and your time delta isn't a multiple of the input frame rate,
         * MediaConvert snaps the captions to the nearest frame. For example, when your input video frame rate is 25 fps
         * and you specify 1010ms for time delta, MediaConvert delays your captions by 1000 ms.
         * 
         * @param timeDelta
         *        Optional. Use this setting when you need to adjust the sync between your sidecar captions and your
         *        video. For more information, see
         *        https://docs.aws.amazon.com/mediaconvert/latest/ug/time-delta-use-cases.html. Enter a positive or
         *        negative number to modify the times in the captions file. For example, type 15 to add 15 seconds to
         *        all the times in the captions file. Type -5 to subtract 5 seconds from the times in the captions file.
         *        You can optionally specify your time delta in milliseconds instead of seconds. When you do so, set the
         *        related setting, Time delta units to Milliseconds. Note that, when you specify a time delta for
         *        timecode-based caption sources, such as SCC and STL, and your time delta isn't a multiple of the input
         *        frame rate, MediaConvert snaps the captions to the nearest frame. For example, when your input video
         *        frame rate is 25 fps and you specify 1010ms for time delta, MediaConvert delays your captions by 1000
         *        ms.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeDelta(Integer timeDelta);

        /**
         * When you use the setting Time delta to adjust the sync between your sidecar captions and your video, use this
         * setting to specify the units for the delta that you specify. When you don't specify a value for Time delta
         * units, MediaConvert uses seconds by default.
         * 
         * @param timeDeltaUnits
         *        When you use the setting Time delta to adjust the sync between your sidecar captions and your video,
         *        use this setting to specify the units for the delta that you specify. When you don't specify a value
         *        for Time delta units, MediaConvert uses seconds by default.
         * @see FileSourceTimeDeltaUnits
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FileSourceTimeDeltaUnits
         */
        Builder timeDeltaUnits(String timeDeltaUnits);

        /**
         * When you use the setting Time delta to adjust the sync between your sidecar captions and your video, use this
         * setting to specify the units for the delta that you specify. When you don't specify a value for Time delta
         * units, MediaConvert uses seconds by default.
         * 
         * @param timeDeltaUnits
         *        When you use the setting Time delta to adjust the sync between your sidecar captions and your video,
         *        use this setting to specify the units for the delta that you specify. When you don't specify a value
         *        for Time delta units, MediaConvert uses seconds by default.
         * @see FileSourceTimeDeltaUnits
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FileSourceTimeDeltaUnits
         */
        Builder timeDeltaUnits(FileSourceTimeDeltaUnits timeDeltaUnits);
    }

    static final class BuilderImpl implements Builder {
        private String byteRateLimit;

        private String convert608To708;

        private String convertPaintToPop;

        private CaptionSourceFramerate framerate;

        private String sourceFile;

        private Integer timeDelta;

        private String timeDeltaUnits;

        private BuilderImpl() {
        }

        private BuilderImpl(FileSourceSettings model) {
            byteRateLimit(model.byteRateLimit);
            convert608To708(model.convert608To708);
            convertPaintToPop(model.convertPaintToPop);
            framerate(model.framerate);
            sourceFile(model.sourceFile);
            timeDelta(model.timeDelta);
            timeDeltaUnits(model.timeDeltaUnits);
        }

        public final String getByteRateLimit() {
            return byteRateLimit;
        }

        public final void setByteRateLimit(String byteRateLimit) {
            this.byteRateLimit = byteRateLimit;
        }

        @Override
        public final Builder byteRateLimit(String byteRateLimit) {
            this.byteRateLimit = byteRateLimit;
            return this;
        }

        @Override
        public final Builder byteRateLimit(CaptionSourceByteRateLimit byteRateLimit) {
            this.byteRateLimit(byteRateLimit == null ? null : byteRateLimit.toString());
            return this;
        }

        public final String getConvert608To708() {
            return convert608To708;
        }

        public final void setConvert608To708(String convert608To708) {
            this.convert608To708 = convert608To708;
        }

        @Override
        public final Builder convert608To708(String convert608To708) {
            this.convert608To708 = convert608To708;
            return this;
        }

        @Override
        public final Builder convert608To708(FileSourceConvert608To708 convert608To708) {
            this.convert608To708(convert608To708 == null ? null : convert608To708.toString());
            return this;
        }

        public final String getConvertPaintToPop() {
            return convertPaintToPop;
        }

        public final void setConvertPaintToPop(String convertPaintToPop) {
            this.convertPaintToPop = convertPaintToPop;
        }

        @Override
        public final Builder convertPaintToPop(String convertPaintToPop) {
            this.convertPaintToPop = convertPaintToPop;
            return this;
        }

        @Override
        public final Builder convertPaintToPop(CaptionSourceConvertPaintOnToPopOn convertPaintToPop) {
            this.convertPaintToPop(convertPaintToPop == null ? null : convertPaintToPop.toString());
            return this;
        }

        public final CaptionSourceFramerate.Builder getFramerate() {
            return framerate != null ? framerate.toBuilder() : null;
        }

        public final void setFramerate(CaptionSourceFramerate.BuilderImpl framerate) {
            this.framerate = framerate != null ? framerate.build() : null;
        }

        @Override
        public final Builder framerate(CaptionSourceFramerate framerate) {
            this.framerate = framerate;
            return this;
        }

        public final String getSourceFile() {
            return sourceFile;
        }

        public final void setSourceFile(String sourceFile) {
            this.sourceFile = sourceFile;
        }

        @Override
        public final Builder sourceFile(String sourceFile) {
            this.sourceFile = sourceFile;
            return this;
        }

        public final Integer getTimeDelta() {
            return timeDelta;
        }

        public final void setTimeDelta(Integer timeDelta) {
            this.timeDelta = timeDelta;
        }

        @Override
        public final Builder timeDelta(Integer timeDelta) {
            this.timeDelta = timeDelta;
            return this;
        }

        public final String getTimeDeltaUnits() {
            return timeDeltaUnits;
        }

        public final void setTimeDeltaUnits(String timeDeltaUnits) {
            this.timeDeltaUnits = timeDeltaUnits;
        }

        @Override
        public final Builder timeDeltaUnits(String timeDeltaUnits) {
            this.timeDeltaUnits = timeDeltaUnits;
            return this;
        }

        @Override
        public final Builder timeDeltaUnits(FileSourceTimeDeltaUnits timeDeltaUnits) {
            this.timeDeltaUnits(timeDeltaUnits == null ? null : timeDeltaUnits.toString());
            return this;
        }

        @Override
        public FileSourceSettings build() {
            return new FileSourceSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
