/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetPresetResponse extends MediaConvertResponse implements
        ToCopyableBuilder<GetPresetResponse.Builder, GetPresetResponse> {
    private static final SdkField<Preset> PRESET_FIELD = SdkField.<Preset> builder(MarshallingType.SDK_POJO).memberName("Preset")
            .getter(getter(GetPresetResponse::preset)).setter(setter(Builder::preset)).constructor(Preset::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("preset").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PRESET_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Preset preset;

    private GetPresetResponse(BuilderImpl builder) {
        super(builder);
        this.preset = builder.preset;
    }

    /**
     * A preset is a collection of preconfigured media conversion settings that you want MediaConvert to apply to the
     * output during the conversion process.
     * 
     * @return A preset is a collection of preconfigured media conversion settings that you want MediaConvert to apply
     *         to the output during the conversion process.
     */
    public final Preset preset() {
        return preset;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(preset());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetPresetResponse)) {
            return false;
        }
        GetPresetResponse other = (GetPresetResponse) obj;
        return Objects.equals(preset(), other.preset());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetPresetResponse").add("Preset", preset()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Preset":
            return Optional.ofNullable(clazz.cast(preset()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("preset", PRESET_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetPresetResponse, T> g) {
        return obj -> g.apply((GetPresetResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MediaConvertResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetPresetResponse> {
        /**
         * A preset is a collection of preconfigured media conversion settings that you want MediaConvert to apply to
         * the output during the conversion process.
         * 
         * @param preset
         *        A preset is a collection of preconfigured media conversion settings that you want MediaConvert to
         *        apply to the output during the conversion process.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder preset(Preset preset);

        /**
         * A preset is a collection of preconfigured media conversion settings that you want MediaConvert to apply to
         * the output during the conversion process. This is a convenience method that creates an instance of the
         * {@link Preset.Builder} avoiding the need to create one manually via {@link Preset#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Preset.Builder#build()} is called immediately and its result is
         * passed to {@link #preset(Preset)}.
         * 
         * @param preset
         *        a consumer that will call methods on {@link Preset.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #preset(Preset)
         */
        default Builder preset(Consumer<Preset.Builder> preset) {
            return preset(Preset.builder().applyMutation(preset).build());
        }
    }

    static final class BuilderImpl extends MediaConvertResponse.BuilderImpl implements Builder {
        private Preset preset;

        private BuilderImpl() {
        }

        private BuilderImpl(GetPresetResponse model) {
            super(model);
            preset(model.preset);
        }

        public final Preset.Builder getPreset() {
            return preset != null ? preset.toBuilder() : null;
        }

        public final void setPreset(Preset.BuilderImpl preset) {
            this.preset = preset != null ? preset.build() : null;
        }

        @Override
        public final Builder preset(Preset preset) {
            this.preset = preset;
            return this;
        }

        @Override
        public GetPresetResponse build() {
            return new GetPresetResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
