/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

/**
 * Specify how SPS and PPS NAL units are written in your output MP4 container, according to ISO/IEC 14496-15. If the
 * location of these parameters doesn't matter in your workflow: Keep the default value, AVC1. MediaConvert writes SPS
 * and PPS NAL units in the sample description ('stsd') box (but not into samples directly). To write SPS and PPS NAL
 * units directly into samples (but not in the 'stsd' box): Choose AVC3. When you do, note that your output might not
 * play properly with some downstream systems or players.
 */
@Generated("software.amazon.awssdk:codegen")
public enum H264WriteMp4PackagingType {
    AVC1("AVC1"),

    AVC3("AVC3"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, H264WriteMp4PackagingType> VALUE_MAP = EnumUtils.uniqueIndex(
            H264WriteMp4PackagingType.class, H264WriteMp4PackagingType::toString);

    private final String value;

    private H264WriteMp4PackagingType(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return H264WriteMp4PackagingType corresponding to the value
     */
    public static H264WriteMp4PackagingType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link H264WriteMp4PackagingType}s
     */
    public static Set<H264WriteMp4PackagingType> knownValues() {
        Set<H264WriteMp4PackagingType> knownValues = EnumSet.allOf(H264WriteMp4PackagingType.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
