/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Settings specific to audio sources in an HLS alternate rendition group. Specify the properties (renditionGroupId,
 * renditionName or renditionLanguageCode) to identify the unique audio track among the alternative rendition groups
 * present in the HLS manifest. If no unique track is found, or multiple tracks match the properties provided, the job
 * fails. If no properties in hlsRenditionGroupSettings are specified, the default audio track within the video segment
 * is chosen. If there is no audio within video segment, the alternative audio with DEFAULT=YES is chosen instead.
 */
@Generated("software.amazon.awssdk:codegen")
public final class HlsRenditionGroupSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<HlsRenditionGroupSettings.Builder, HlsRenditionGroupSettings> {
    private static final SdkField<String> RENDITION_GROUP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RenditionGroupId").getter(getter(HlsRenditionGroupSettings::renditionGroupId))
            .setter(setter(Builder::renditionGroupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("renditionGroupId").build()).build();

    private static final SdkField<String> RENDITION_LANGUAGE_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RenditionLanguageCode").getter(getter(HlsRenditionGroupSettings::renditionLanguageCodeAsString))
            .setter(setter(Builder::renditionLanguageCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("renditionLanguageCode").build())
            .build();

    private static final SdkField<String> RENDITION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RenditionName").getter(getter(HlsRenditionGroupSettings::renditionName))
            .setter(setter(Builder::renditionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("renditionName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RENDITION_GROUP_ID_FIELD,
            RENDITION_LANGUAGE_CODE_FIELD, RENDITION_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String renditionGroupId;

    private final String renditionLanguageCode;

    private final String renditionName;

    private HlsRenditionGroupSettings(BuilderImpl builder) {
        this.renditionGroupId = builder.renditionGroupId;
        this.renditionLanguageCode = builder.renditionLanguageCode;
        this.renditionName = builder.renditionName;
    }

    /**
     * Optional. Specify alternative group ID
     * 
     * @return Optional. Specify alternative group ID
     */
    public final String renditionGroupId() {
        return renditionGroupId;
    }

    /**
     * Optional. Specify ISO 639-2 or ISO 639-3 code in the language property
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #renditionLanguageCode} will return {@link LanguageCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by
     * the service is available from {@link #renditionLanguageCodeAsString}.
     * </p>
     * 
     * @return Optional. Specify ISO 639-2 or ISO 639-3 code in the language property
     * @see LanguageCode
     */
    public final LanguageCode renditionLanguageCode() {
        return LanguageCode.fromValue(renditionLanguageCode);
    }

    /**
     * Optional. Specify ISO 639-2 or ISO 639-3 code in the language property
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #renditionLanguageCode} will return {@link LanguageCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by
     * the service is available from {@link #renditionLanguageCodeAsString}.
     * </p>
     * 
     * @return Optional. Specify ISO 639-2 or ISO 639-3 code in the language property
     * @see LanguageCode
     */
    public final String renditionLanguageCodeAsString() {
        return renditionLanguageCode;
    }

    /**
     * Optional. Specify media name
     * 
     * @return Optional. Specify media name
     */
    public final String renditionName() {
        return renditionName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(renditionGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(renditionLanguageCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(renditionName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HlsRenditionGroupSettings)) {
            return false;
        }
        HlsRenditionGroupSettings other = (HlsRenditionGroupSettings) obj;
        return Objects.equals(renditionGroupId(), other.renditionGroupId())
                && Objects.equals(renditionLanguageCodeAsString(), other.renditionLanguageCodeAsString())
                && Objects.equals(renditionName(), other.renditionName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("HlsRenditionGroupSettings").add("RenditionGroupId", renditionGroupId())
                .add("RenditionLanguageCode", renditionLanguageCodeAsString()).add("RenditionName", renditionName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RenditionGroupId":
            return Optional.ofNullable(clazz.cast(renditionGroupId()));
        case "RenditionLanguageCode":
            return Optional.ofNullable(clazz.cast(renditionLanguageCodeAsString()));
        case "RenditionName":
            return Optional.ofNullable(clazz.cast(renditionName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("renditionGroupId", RENDITION_GROUP_ID_FIELD);
        map.put("renditionLanguageCode", RENDITION_LANGUAGE_CODE_FIELD);
        map.put("renditionName", RENDITION_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<HlsRenditionGroupSettings, T> g) {
        return obj -> g.apply((HlsRenditionGroupSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, HlsRenditionGroupSettings> {
        /**
         * Optional. Specify alternative group ID
         * 
         * @param renditionGroupId
         *        Optional. Specify alternative group ID
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder renditionGroupId(String renditionGroupId);

        /**
         * Optional. Specify ISO 639-2 or ISO 639-3 code in the language property
         * 
         * @param renditionLanguageCode
         *        Optional. Specify ISO 639-2 or ISO 639-3 code in the language property
         * @see LanguageCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LanguageCode
         */
        Builder renditionLanguageCode(String renditionLanguageCode);

        /**
         * Optional. Specify ISO 639-2 or ISO 639-3 code in the language property
         * 
         * @param renditionLanguageCode
         *        Optional. Specify ISO 639-2 or ISO 639-3 code in the language property
         * @see LanguageCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LanguageCode
         */
        Builder renditionLanguageCode(LanguageCode renditionLanguageCode);

        /**
         * Optional. Specify media name
         * 
         * @param renditionName
         *        Optional. Specify media name
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder renditionName(String renditionName);
    }

    static final class BuilderImpl implements Builder {
        private String renditionGroupId;

        private String renditionLanguageCode;

        private String renditionName;

        private BuilderImpl() {
        }

        private BuilderImpl(HlsRenditionGroupSettings model) {
            renditionGroupId(model.renditionGroupId);
            renditionLanguageCode(model.renditionLanguageCode);
            renditionName(model.renditionName);
        }

        public final String getRenditionGroupId() {
            return renditionGroupId;
        }

        public final void setRenditionGroupId(String renditionGroupId) {
            this.renditionGroupId = renditionGroupId;
        }

        @Override
        public final Builder renditionGroupId(String renditionGroupId) {
            this.renditionGroupId = renditionGroupId;
            return this;
        }

        public final String getRenditionLanguageCode() {
            return renditionLanguageCode;
        }

        public final void setRenditionLanguageCode(String renditionLanguageCode) {
            this.renditionLanguageCode = renditionLanguageCode;
        }

        @Override
        public final Builder renditionLanguageCode(String renditionLanguageCode) {
            this.renditionLanguageCode = renditionLanguageCode;
            return this;
        }

        @Override
        public final Builder renditionLanguageCode(LanguageCode renditionLanguageCode) {
            this.renditionLanguageCode(renditionLanguageCode == null ? null : renditionLanguageCode.toString());
            return this;
        }

        public final String getRenditionName() {
            return renditionName;
        }

        public final void setRenditionName(String renditionName) {
            this.renditionName = renditionName;
        }

        @Override
        public final Builder renditionName(String renditionName) {
            this.renditionName = renditionName;
            return this;
        }

        @Override
        public HlsRenditionGroupSettings build() {
            return new HlsRenditionGroupSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
