/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Settings for decrypting any input files that you encrypt before you upload them to Amazon S3. MediaConvert can
 * decrypt files only when you use AWS Key Management Service (KMS) to encrypt the data key that you use to encrypt your
 * content.
 */
@Generated("software.amazon.awssdk:codegen")
public final class InputDecryptionSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<InputDecryptionSettings.Builder, InputDecryptionSettings> {
    private static final SdkField<String> DECRYPTION_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DecryptionMode").getter(getter(InputDecryptionSettings::decryptionModeAsString))
            .setter(setter(Builder::decryptionMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("decryptionMode").build()).build();

    private static final SdkField<String> ENCRYPTED_DECRYPTION_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EncryptedDecryptionKey").getter(getter(InputDecryptionSettings::encryptedDecryptionKey))
            .setter(setter(Builder::encryptedDecryptionKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encryptedDecryptionKey").build())
            .build();

    private static final SdkField<String> INITIALIZATION_VECTOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InitializationVector").getter(getter(InputDecryptionSettings::initializationVector))
            .setter(setter(Builder::initializationVector))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("initializationVector").build())
            .build();

    private static final SdkField<String> KMS_KEY_REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KmsKeyRegion").getter(getter(InputDecryptionSettings::kmsKeyRegion))
            .setter(setter(Builder::kmsKeyRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsKeyRegion").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DECRYPTION_MODE_FIELD,
            ENCRYPTED_DECRYPTION_KEY_FIELD, INITIALIZATION_VECTOR_FIELD, KMS_KEY_REGION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String decryptionMode;

    private final String encryptedDecryptionKey;

    private final String initializationVector;

    private final String kmsKeyRegion;

    private InputDecryptionSettings(BuilderImpl builder) {
        this.decryptionMode = builder.decryptionMode;
        this.encryptedDecryptionKey = builder.encryptedDecryptionKey;
        this.initializationVector = builder.initializationVector;
        this.kmsKeyRegion = builder.kmsKeyRegion;
    }

    /**
     * Specify the encryption mode that you used to encrypt your input files.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #decryptionMode}
     * will return {@link DecryptionMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #decryptionModeAsString}.
     * </p>
     * 
     * @return Specify the encryption mode that you used to encrypt your input files.
     * @see DecryptionMode
     */
    public final DecryptionMode decryptionMode() {
        return DecryptionMode.fromValue(decryptionMode);
    }

    /**
     * Specify the encryption mode that you used to encrypt your input files.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #decryptionMode}
     * will return {@link DecryptionMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #decryptionModeAsString}.
     * </p>
     * 
     * @return Specify the encryption mode that you used to encrypt your input files.
     * @see DecryptionMode
     */
    public final String decryptionModeAsString() {
        return decryptionMode;
    }

    /**
     * Warning! Don't provide your encryption key in plaintext. Your job settings could be intercepted, making your
     * encrypted content vulnerable. Specify the encrypted version of the data key that you used to encrypt your
     * content. The data key must be encrypted by AWS Key Management Service (KMS). The key can be 128, 192, or 256
     * bits.
     * 
     * @return Warning! Don't provide your encryption key in plaintext. Your job settings could be intercepted, making
     *         your encrypted content vulnerable. Specify the encrypted version of the data key that you used to encrypt
     *         your content. The data key must be encrypted by AWS Key Management Service (KMS). The key can be 128,
     *         192, or 256 bits.
     */
    public final String encryptedDecryptionKey() {
        return encryptedDecryptionKey;
    }

    /**
     * Specify the initialization vector that you used when you encrypted your content before uploading it to Amazon S3.
     * You can use a 16-byte initialization vector with any encryption mode. Or, you can use a 12-byte initialization
     * vector with GCM or CTR. MediaConvert accepts only initialization vectors that are base64-encoded.
     * 
     * @return Specify the initialization vector that you used when you encrypted your content before uploading it to
     *         Amazon S3. You can use a 16-byte initialization vector with any encryption mode. Or, you can use a
     *         12-byte initialization vector with GCM or CTR. MediaConvert accepts only initialization vectors that are
     *         base64-encoded.
     */
    public final String initializationVector() {
        return initializationVector;
    }

    /**
     * Specify the AWS Region for AWS Key Management Service (KMS) that you used to encrypt your data key, if that
     * Region is different from the one you are using for AWS Elemental MediaConvert.
     * 
     * @return Specify the AWS Region for AWS Key Management Service (KMS) that you used to encrypt your data key, if
     *         that Region is different from the one you are using for AWS Elemental MediaConvert.
     */
    public final String kmsKeyRegion() {
        return kmsKeyRegion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(decryptionModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(encryptedDecryptionKey());
        hashCode = 31 * hashCode + Objects.hashCode(initializationVector());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyRegion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InputDecryptionSettings)) {
            return false;
        }
        InputDecryptionSettings other = (InputDecryptionSettings) obj;
        return Objects.equals(decryptionModeAsString(), other.decryptionModeAsString())
                && Objects.equals(encryptedDecryptionKey(), other.encryptedDecryptionKey())
                && Objects.equals(initializationVector(), other.initializationVector())
                && Objects.equals(kmsKeyRegion(), other.kmsKeyRegion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InputDecryptionSettings").add("DecryptionMode", decryptionModeAsString())
                .add("EncryptedDecryptionKey", encryptedDecryptionKey()).add("InitializationVector", initializationVector())
                .add("KmsKeyRegion", kmsKeyRegion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DecryptionMode":
            return Optional.ofNullable(clazz.cast(decryptionModeAsString()));
        case "EncryptedDecryptionKey":
            return Optional.ofNullable(clazz.cast(encryptedDecryptionKey()));
        case "InitializationVector":
            return Optional.ofNullable(clazz.cast(initializationVector()));
        case "KmsKeyRegion":
            return Optional.ofNullable(clazz.cast(kmsKeyRegion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("decryptionMode", DECRYPTION_MODE_FIELD);
        map.put("encryptedDecryptionKey", ENCRYPTED_DECRYPTION_KEY_FIELD);
        map.put("initializationVector", INITIALIZATION_VECTOR_FIELD);
        map.put("kmsKeyRegion", KMS_KEY_REGION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InputDecryptionSettings, T> g) {
        return obj -> g.apply((InputDecryptionSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InputDecryptionSettings> {
        /**
         * Specify the encryption mode that you used to encrypt your input files.
         * 
         * @param decryptionMode
         *        Specify the encryption mode that you used to encrypt your input files.
         * @see DecryptionMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DecryptionMode
         */
        Builder decryptionMode(String decryptionMode);

        /**
         * Specify the encryption mode that you used to encrypt your input files.
         * 
         * @param decryptionMode
         *        Specify the encryption mode that you used to encrypt your input files.
         * @see DecryptionMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DecryptionMode
         */
        Builder decryptionMode(DecryptionMode decryptionMode);

        /**
         * Warning! Don't provide your encryption key in plaintext. Your job settings could be intercepted, making your
         * encrypted content vulnerable. Specify the encrypted version of the data key that you used to encrypt your
         * content. The data key must be encrypted by AWS Key Management Service (KMS). The key can be 128, 192, or 256
         * bits.
         * 
         * @param encryptedDecryptionKey
         *        Warning! Don't provide your encryption key in plaintext. Your job settings could be intercepted,
         *        making your encrypted content vulnerable. Specify the encrypted version of the data key that you used
         *        to encrypt your content. The data key must be encrypted by AWS Key Management Service (KMS). The key
         *        can be 128, 192, or 256 bits.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encryptedDecryptionKey(String encryptedDecryptionKey);

        /**
         * Specify the initialization vector that you used when you encrypted your content before uploading it to Amazon
         * S3. You can use a 16-byte initialization vector with any encryption mode. Or, you can use a 12-byte
         * initialization vector with GCM or CTR. MediaConvert accepts only initialization vectors that are
         * base64-encoded.
         * 
         * @param initializationVector
         *        Specify the initialization vector that you used when you encrypted your content before uploading it to
         *        Amazon S3. You can use a 16-byte initialization vector with any encryption mode. Or, you can use a
         *        12-byte initialization vector with GCM or CTR. MediaConvert accepts only initialization vectors that
         *        are base64-encoded.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder initializationVector(String initializationVector);

        /**
         * Specify the AWS Region for AWS Key Management Service (KMS) that you used to encrypt your data key, if that
         * Region is different from the one you are using for AWS Elemental MediaConvert.
         * 
         * @param kmsKeyRegion
         *        Specify the AWS Region for AWS Key Management Service (KMS) that you used to encrypt your data key, if
         *        that Region is different from the one you are using for AWS Elemental MediaConvert.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyRegion(String kmsKeyRegion);
    }

    static final class BuilderImpl implements Builder {
        private String decryptionMode;

        private String encryptedDecryptionKey;

        private String initializationVector;

        private String kmsKeyRegion;

        private BuilderImpl() {
        }

        private BuilderImpl(InputDecryptionSettings model) {
            decryptionMode(model.decryptionMode);
            encryptedDecryptionKey(model.encryptedDecryptionKey);
            initializationVector(model.initializationVector);
            kmsKeyRegion(model.kmsKeyRegion);
        }

        public final String getDecryptionMode() {
            return decryptionMode;
        }

        public final void setDecryptionMode(String decryptionMode) {
            this.decryptionMode = decryptionMode;
        }

        @Override
        public final Builder decryptionMode(String decryptionMode) {
            this.decryptionMode = decryptionMode;
            return this;
        }

        @Override
        public final Builder decryptionMode(DecryptionMode decryptionMode) {
            this.decryptionMode(decryptionMode == null ? null : decryptionMode.toString());
            return this;
        }

        public final String getEncryptedDecryptionKey() {
            return encryptedDecryptionKey;
        }

        public final void setEncryptedDecryptionKey(String encryptedDecryptionKey) {
            this.encryptedDecryptionKey = encryptedDecryptionKey;
        }

        @Override
        public final Builder encryptedDecryptionKey(String encryptedDecryptionKey) {
            this.encryptedDecryptionKey = encryptedDecryptionKey;
            return this;
        }

        public final String getInitializationVector() {
            return initializationVector;
        }

        public final void setInitializationVector(String initializationVector) {
            this.initializationVector = initializationVector;
        }

        @Override
        public final Builder initializationVector(String initializationVector) {
            this.initializationVector = initializationVector;
            return this;
        }

        public final String getKmsKeyRegion() {
            return kmsKeyRegion;
        }

        public final void setKmsKeyRegion(String kmsKeyRegion) {
            this.kmsKeyRegion = kmsKeyRegion;
        }

        @Override
        public final Builder kmsKeyRegion(String kmsKeyRegion) {
            this.kmsKeyRegion = kmsKeyRegion;
            return this;
        }

        @Override
        public InputDecryptionSettings build() {
            return new InputDecryptionSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
