/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Provides messages from the service about jobs that you have already successfully submitted.
 */
@Generated("software.amazon.awssdk:codegen")
public final class JobMessages implements SdkPojo, Serializable, ToCopyableBuilder<JobMessages.Builder, JobMessages> {
    private static final SdkField<List<String>> INFO_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Info")
            .getter(getter(JobMessages::info))
            .setter(setter(Builder::info))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("info").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> WARNING_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Warning")
            .getter(getter(JobMessages::warning))
            .setter(setter(Builder::warning))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("warning").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INFO_FIELD, WARNING_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<String> info;

    private final List<String> warning;

    private JobMessages(BuilderImpl builder) {
        this.info = builder.info;
        this.warning = builder.warning;
    }

    /**
     * For responses, this returns true if the service returned a value for the Info property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasInfo() {
        return info != null && !(info instanceof SdkAutoConstructList);
    }

    /**
     * List of messages that are informational only and don't indicate a problem with your job.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInfo} method.
     * </p>
     * 
     * @return List of messages that are informational only and don't indicate a problem with your job.
     */
    public final List<String> info() {
        return info;
    }

    /**
     * For responses, this returns true if the service returned a value for the Warning property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasWarning() {
        return warning != null && !(warning instanceof SdkAutoConstructList);
    }

    /**
     * List of messages that warn about conditions that might cause your job not to run or to fail.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasWarning} method.
     * </p>
     * 
     * @return List of messages that warn about conditions that might cause your job not to run or to fail.
     */
    public final List<String> warning() {
        return warning;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasInfo() ? info() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasWarning() ? warning() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobMessages)) {
            return false;
        }
        JobMessages other = (JobMessages) obj;
        return hasInfo() == other.hasInfo() && Objects.equals(info(), other.info()) && hasWarning() == other.hasWarning()
                && Objects.equals(warning(), other.warning());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("JobMessages").add("Info", hasInfo() ? info() : null)
                .add("Warning", hasWarning() ? warning() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Info":
            return Optional.ofNullable(clazz.cast(info()));
        case "Warning":
            return Optional.ofNullable(clazz.cast(warning()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("info", INFO_FIELD);
        map.put("warning", WARNING_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<JobMessages, T> g) {
        return obj -> g.apply((JobMessages) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, JobMessages> {
        /**
         * List of messages that are informational only and don't indicate a problem with your job.
         * 
         * @param info
         *        List of messages that are informational only and don't indicate a problem with your job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder info(Collection<String> info);

        /**
         * List of messages that are informational only and don't indicate a problem with your job.
         * 
         * @param info
         *        List of messages that are informational only and don't indicate a problem with your job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder info(String... info);

        /**
         * List of messages that warn about conditions that might cause your job not to run or to fail.
         * 
         * @param warning
         *        List of messages that warn about conditions that might cause your job not to run or to fail.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder warning(Collection<String> warning);

        /**
         * List of messages that warn about conditions that might cause your job not to run or to fail.
         * 
         * @param warning
         *        List of messages that warn about conditions that might cause your job not to run or to fail.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder warning(String... warning);
    }

    static final class BuilderImpl implements Builder {
        private List<String> info = DefaultSdkAutoConstructList.getInstance();

        private List<String> warning = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(JobMessages model) {
            info(model.info);
            warning(model.warning);
        }

        public final Collection<String> getInfo() {
            if (info instanceof SdkAutoConstructList) {
                return null;
            }
            return info;
        }

        public final void setInfo(Collection<String> info) {
            this.info = ___listOf__stringCopier.copy(info);
        }

        @Override
        public final Builder info(Collection<String> info) {
            this.info = ___listOf__stringCopier.copy(info);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder info(String... info) {
            info(Arrays.asList(info));
            return this;
        }

        public final Collection<String> getWarning() {
            if (warning instanceof SdkAutoConstructList) {
                return null;
            }
            return warning;
        }

        public final void setWarning(Collection<String> warning) {
            this.warning = ___listOf__stringCopier.copy(warning);
        }

        @Override
        public final Builder warning(Collection<String> warning) {
            this.warning = ___listOf__stringCopier.copy(warning);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder warning(String... warning) {
            warning(Arrays.asList(warning));
            return this;
        }

        @Override
        public JobMessages build() {
            return new JobMessages(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
