/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Use these settings only when you use Kantar watermarking. Specify the values that MediaConvert uses to generate and
 * place Kantar watermarks in your output audio. These settings apply to every output in your job. In addition to
 * specifying these values, you also need to store your Kantar credentials in AWS Secrets Manager. For more information,
 * see https://docs.aws.amazon.com/mediaconvert/latest/ug/kantar-watermarking.html.
 */
@Generated("software.amazon.awssdk:codegen")
public final class KantarWatermarkSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<KantarWatermarkSettings.Builder, KantarWatermarkSettings> {
    private static final SdkField<String> CHANNEL_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ChannelName").getter(getter(KantarWatermarkSettings::channelName)).setter(setter(Builder::channelName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("channelName").build()).build();

    private static final SdkField<String> CONTENT_REFERENCE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ContentReference").getter(getter(KantarWatermarkSettings::contentReference))
            .setter(setter(Builder::contentReference))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contentReference").build()).build();

    private static final SdkField<String> CREDENTIALS_SECRET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CredentialsSecretName").getter(getter(KantarWatermarkSettings::credentialsSecretName))
            .setter(setter(Builder::credentialsSecretName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("credentialsSecretName").build())
            .build();

    private static final SdkField<Double> FILE_OFFSET_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("FileOffset").getter(getter(KantarWatermarkSettings::fileOffset)).setter(setter(Builder::fileOffset))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fileOffset").build()).build();

    private static final SdkField<Integer> KANTAR_LICENSE_ID_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("KantarLicenseId").getter(getter(KantarWatermarkSettings::kantarLicenseId))
            .setter(setter(Builder::kantarLicenseId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kantarLicenseId").build()).build();

    private static final SdkField<String> KANTAR_SERVER_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KantarServerUrl").getter(getter(KantarWatermarkSettings::kantarServerUrl))
            .setter(setter(Builder::kantarServerUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kantarServerUrl").build()).build();

    private static final SdkField<String> LOG_DESTINATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LogDestination").getter(getter(KantarWatermarkSettings::logDestination))
            .setter(setter(Builder::logDestination))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logDestination").build()).build();

    private static final SdkField<String> METADATA3_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Metadata3").getter(getter(KantarWatermarkSettings::metadata3)).setter(setter(Builder::metadata3))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metadata3").build()).build();

    private static final SdkField<String> METADATA4_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Metadata4").getter(getter(KantarWatermarkSettings::metadata4)).setter(setter(Builder::metadata4))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metadata4").build()).build();

    private static final SdkField<String> METADATA5_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Metadata5").getter(getter(KantarWatermarkSettings::metadata5)).setter(setter(Builder::metadata5))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metadata5").build()).build();

    private static final SdkField<String> METADATA6_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Metadata6").getter(getter(KantarWatermarkSettings::metadata6)).setter(setter(Builder::metadata6))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metadata6").build()).build();

    private static final SdkField<String> METADATA7_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Metadata7").getter(getter(KantarWatermarkSettings::metadata7)).setter(setter(Builder::metadata7))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metadata7").build()).build();

    private static final SdkField<String> METADATA8_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Metadata8").getter(getter(KantarWatermarkSettings::metadata8)).setter(setter(Builder::metadata8))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metadata8").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANNEL_NAME_FIELD,
            CONTENT_REFERENCE_FIELD, CREDENTIALS_SECRET_NAME_FIELD, FILE_OFFSET_FIELD, KANTAR_LICENSE_ID_FIELD,
            KANTAR_SERVER_URL_FIELD, LOG_DESTINATION_FIELD, METADATA3_FIELD, METADATA4_FIELD, METADATA5_FIELD, METADATA6_FIELD,
            METADATA7_FIELD, METADATA8_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String channelName;

    private final String contentReference;

    private final String credentialsSecretName;

    private final Double fileOffset;

    private final Integer kantarLicenseId;

    private final String kantarServerUrl;

    private final String logDestination;

    private final String metadata3;

    private final String metadata4;

    private final String metadata5;

    private final String metadata6;

    private final String metadata7;

    private final String metadata8;

    private KantarWatermarkSettings(BuilderImpl builder) {
        this.channelName = builder.channelName;
        this.contentReference = builder.contentReference;
        this.credentialsSecretName = builder.credentialsSecretName;
        this.fileOffset = builder.fileOffset;
        this.kantarLicenseId = builder.kantarLicenseId;
        this.kantarServerUrl = builder.kantarServerUrl;
        this.logDestination = builder.logDestination;
        this.metadata3 = builder.metadata3;
        this.metadata4 = builder.metadata4;
        this.metadata5 = builder.metadata5;
        this.metadata6 = builder.metadata6;
        this.metadata7 = builder.metadata7;
        this.metadata8 = builder.metadata8;
    }

    /**
     * Provide an audio channel name from your Kantar audio license.
     * 
     * @return Provide an audio channel name from your Kantar audio license.
     */
    public final String channelName() {
        return channelName;
    }

    /**
     * Specify a unique identifier for Kantar to use for this piece of content.
     * 
     * @return Specify a unique identifier for Kantar to use for this piece of content.
     */
    public final String contentReference() {
        return contentReference;
    }

    /**
     * Provide the name of the AWS Secrets Manager secret where your Kantar credentials are stored. Note that your
     * MediaConvert service role must provide access to this secret. For more information, see
     * https://docs.aws.amazon.com
     * /mediaconvert/latest/ug/granting-permissions-for-mediaconvert-to-access-secrets-manager-secret.html. For
     * instructions on creating a secret, see
     * https://docs.aws.amazon.com/secretsmanager/latest/userguide/tutorials_basic.html, in the AWS Secrets Manager User
     * Guide.
     * 
     * @return Provide the name of the AWS Secrets Manager secret where your Kantar credentials are stored. Note that
     *         your MediaConvert service role must provide access to this secret. For more information, see
     *         https://docs.
     *         aws.amazon.com/mediaconvert/latest/ug/granting-permissions-for-mediaconvert-to-access-secrets
     *         -manager-secret.html. For instructions on creating a secret, see
     *         https://docs.aws.amazon.com/secretsmanager/latest/userguide/tutorials_basic.html, in the AWS Secrets
     *         Manager User Guide.
     */
    public final String credentialsSecretName() {
        return credentialsSecretName;
    }

    /**
     * Optional. Specify an offset, in whole seconds, from the start of your output and the beginning of the
     * watermarking. When you don't specify an offset, Kantar defaults to zero.
     * 
     * @return Optional. Specify an offset, in whole seconds, from the start of your output and the beginning of the
     *         watermarking. When you don't specify an offset, Kantar defaults to zero.
     */
    public final Double fileOffset() {
        return fileOffset;
    }

    /**
     * Provide your Kantar license ID number. You should get this number from Kantar.
     * 
     * @return Provide your Kantar license ID number. You should get this number from Kantar.
     */
    public final Integer kantarLicenseId() {
        return kantarLicenseId;
    }

    /**
     * Provide the HTTPS endpoint to the Kantar server. You should get this endpoint from Kantar.
     * 
     * @return Provide the HTTPS endpoint to the Kantar server. You should get this endpoint from Kantar.
     */
    public final String kantarServerUrl() {
        return kantarServerUrl;
    }

    /**
     * Optional. Specify the Amazon S3 bucket where you want MediaConvert to store your Kantar watermark XML logs. When
     * you don't specify a bucket, MediaConvert doesn't save these logs. Note that your MediaConvert service role must
     * provide access to this location. For more information, see
     * https://docs.aws.amazon.com/mediaconvert/latest/ug/iam-role.html
     * 
     * @return Optional. Specify the Amazon S3 bucket where you want MediaConvert to store your Kantar watermark XML
     *         logs. When you don't specify a bucket, MediaConvert doesn't save these logs. Note that your MediaConvert
     *         service role must provide access to this location. For more information, see
     *         https://docs.aws.amazon.com/mediaconvert/latest/ug/iam-role.html
     */
    public final String logDestination() {
        return logDestination;
    }

    /**
     * You can optionally use this field to specify the first timestamp that Kantar embeds during watermarking. Kantar
     * suggests that you be very cautious when using this Kantar feature, and that you use it only on channels that are
     * managed specifically for use with this feature by your Audience Measurement Operator. For more information about
     * this feature, contact Kantar technical support.
     * 
     * @return You can optionally use this field to specify the first timestamp that Kantar embeds during watermarking.
     *         Kantar suggests that you be very cautious when using this Kantar feature, and that you use it only on
     *         channels that are managed specifically for use with this feature by your Audience Measurement Operator.
     *         For more information about this feature, contact Kantar technical support.
     */
    public final String metadata3() {
        return metadata3;
    }

    /**
     * Additional metadata that MediaConvert sends to Kantar. Maximum length is 50 characters.
     * 
     * @return Additional metadata that MediaConvert sends to Kantar. Maximum length is 50 characters.
     */
    public final String metadata4() {
        return metadata4;
    }

    /**
     * Additional metadata that MediaConvert sends to Kantar. Maximum length is 50 characters.
     * 
     * @return Additional metadata that MediaConvert sends to Kantar. Maximum length is 50 characters.
     */
    public final String metadata5() {
        return metadata5;
    }

    /**
     * Additional metadata that MediaConvert sends to Kantar. Maximum length is 50 characters.
     * 
     * @return Additional metadata that MediaConvert sends to Kantar. Maximum length is 50 characters.
     */
    public final String metadata6() {
        return metadata6;
    }

    /**
     * Additional metadata that MediaConvert sends to Kantar. Maximum length is 50 characters.
     * 
     * @return Additional metadata that MediaConvert sends to Kantar. Maximum length is 50 characters.
     */
    public final String metadata7() {
        return metadata7;
    }

    /**
     * Additional metadata that MediaConvert sends to Kantar. Maximum length is 50 characters.
     * 
     * @return Additional metadata that MediaConvert sends to Kantar. Maximum length is 50 characters.
     */
    public final String metadata8() {
        return metadata8;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(channelName());
        hashCode = 31 * hashCode + Objects.hashCode(contentReference());
        hashCode = 31 * hashCode + Objects.hashCode(credentialsSecretName());
        hashCode = 31 * hashCode + Objects.hashCode(fileOffset());
        hashCode = 31 * hashCode + Objects.hashCode(kantarLicenseId());
        hashCode = 31 * hashCode + Objects.hashCode(kantarServerUrl());
        hashCode = 31 * hashCode + Objects.hashCode(logDestination());
        hashCode = 31 * hashCode + Objects.hashCode(metadata3());
        hashCode = 31 * hashCode + Objects.hashCode(metadata4());
        hashCode = 31 * hashCode + Objects.hashCode(metadata5());
        hashCode = 31 * hashCode + Objects.hashCode(metadata6());
        hashCode = 31 * hashCode + Objects.hashCode(metadata7());
        hashCode = 31 * hashCode + Objects.hashCode(metadata8());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KantarWatermarkSettings)) {
            return false;
        }
        KantarWatermarkSettings other = (KantarWatermarkSettings) obj;
        return Objects.equals(channelName(), other.channelName()) && Objects.equals(contentReference(), other.contentReference())
                && Objects.equals(credentialsSecretName(), other.credentialsSecretName())
                && Objects.equals(fileOffset(), other.fileOffset()) && Objects.equals(kantarLicenseId(), other.kantarLicenseId())
                && Objects.equals(kantarServerUrl(), other.kantarServerUrl())
                && Objects.equals(logDestination(), other.logDestination()) && Objects.equals(metadata3(), other.metadata3())
                && Objects.equals(metadata4(), other.metadata4()) && Objects.equals(metadata5(), other.metadata5())
                && Objects.equals(metadata6(), other.metadata6()) && Objects.equals(metadata7(), other.metadata7())
                && Objects.equals(metadata8(), other.metadata8());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("KantarWatermarkSettings").add("ChannelName", channelName())
                .add("ContentReference", contentReference()).add("CredentialsSecretName", credentialsSecretName())
                .add("FileOffset", fileOffset()).add("KantarLicenseId", kantarLicenseId())
                .add("KantarServerUrl", kantarServerUrl()).add("LogDestination", logDestination()).add("Metadata3", metadata3())
                .add("Metadata4", metadata4()).add("Metadata5", metadata5()).add("Metadata6", metadata6())
                .add("Metadata7", metadata7()).add("Metadata8", metadata8()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ChannelName":
            return Optional.ofNullable(clazz.cast(channelName()));
        case "ContentReference":
            return Optional.ofNullable(clazz.cast(contentReference()));
        case "CredentialsSecretName":
            return Optional.ofNullable(clazz.cast(credentialsSecretName()));
        case "FileOffset":
            return Optional.ofNullable(clazz.cast(fileOffset()));
        case "KantarLicenseId":
            return Optional.ofNullable(clazz.cast(kantarLicenseId()));
        case "KantarServerUrl":
            return Optional.ofNullable(clazz.cast(kantarServerUrl()));
        case "LogDestination":
            return Optional.ofNullable(clazz.cast(logDestination()));
        case "Metadata3":
            return Optional.ofNullable(clazz.cast(metadata3()));
        case "Metadata4":
            return Optional.ofNullable(clazz.cast(metadata4()));
        case "Metadata5":
            return Optional.ofNullable(clazz.cast(metadata5()));
        case "Metadata6":
            return Optional.ofNullable(clazz.cast(metadata6()));
        case "Metadata7":
            return Optional.ofNullable(clazz.cast(metadata7()));
        case "Metadata8":
            return Optional.ofNullable(clazz.cast(metadata8()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("channelName", CHANNEL_NAME_FIELD);
        map.put("contentReference", CONTENT_REFERENCE_FIELD);
        map.put("credentialsSecretName", CREDENTIALS_SECRET_NAME_FIELD);
        map.put("fileOffset", FILE_OFFSET_FIELD);
        map.put("kantarLicenseId", KANTAR_LICENSE_ID_FIELD);
        map.put("kantarServerUrl", KANTAR_SERVER_URL_FIELD);
        map.put("logDestination", LOG_DESTINATION_FIELD);
        map.put("metadata3", METADATA3_FIELD);
        map.put("metadata4", METADATA4_FIELD);
        map.put("metadata5", METADATA5_FIELD);
        map.put("metadata6", METADATA6_FIELD);
        map.put("metadata7", METADATA7_FIELD);
        map.put("metadata8", METADATA8_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<KantarWatermarkSettings, T> g) {
        return obj -> g.apply((KantarWatermarkSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, KantarWatermarkSettings> {
        /**
         * Provide an audio channel name from your Kantar audio license.
         * 
         * @param channelName
         *        Provide an audio channel name from your Kantar audio license.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelName(String channelName);

        /**
         * Specify a unique identifier for Kantar to use for this piece of content.
         * 
         * @param contentReference
         *        Specify a unique identifier for Kantar to use for this piece of content.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contentReference(String contentReference);

        /**
         * Provide the name of the AWS Secrets Manager secret where your Kantar credentials are stored. Note that your
         * MediaConvert service role must provide access to this secret. For more information, see
         * https://docs.aws.amazon
         * .com/mediaconvert/latest/ug/granting-permissions-for-mediaconvert-to-access-secrets-manager-secret.html. For
         * instructions on creating a secret, see
         * https://docs.aws.amazon.com/secretsmanager/latest/userguide/tutorials_basic.html, in the AWS Secrets Manager
         * User Guide.
         * 
         * @param credentialsSecretName
         *        Provide the name of the AWS Secrets Manager secret where your Kantar credentials are stored. Note that
         *        your MediaConvert service role must provide access to this secret. For more information, see
         *        https://docs
         *        .aws.amazon.com/mediaconvert/latest/ug/granting-permissions-for-mediaconvert-to-access-secrets
         *        -manager-secret.html. For instructions on creating a secret, see
         *        https://docs.aws.amazon.com/secretsmanager/latest/userguide/tutorials_basic.html, in the AWS Secrets
         *        Manager User Guide.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder credentialsSecretName(String credentialsSecretName);

        /**
         * Optional. Specify an offset, in whole seconds, from the start of your output and the beginning of the
         * watermarking. When you don't specify an offset, Kantar defaults to zero.
         * 
         * @param fileOffset
         *        Optional. Specify an offset, in whole seconds, from the start of your output and the beginning of the
         *        watermarking. When you don't specify an offset, Kantar defaults to zero.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileOffset(Double fileOffset);

        /**
         * Provide your Kantar license ID number. You should get this number from Kantar.
         * 
         * @param kantarLicenseId
         *        Provide your Kantar license ID number. You should get this number from Kantar.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kantarLicenseId(Integer kantarLicenseId);

        /**
         * Provide the HTTPS endpoint to the Kantar server. You should get this endpoint from Kantar.
         * 
         * @param kantarServerUrl
         *        Provide the HTTPS endpoint to the Kantar server. You should get this endpoint from Kantar.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kantarServerUrl(String kantarServerUrl);

        /**
         * Optional. Specify the Amazon S3 bucket where you want MediaConvert to store your Kantar watermark XML logs.
         * When you don't specify a bucket, MediaConvert doesn't save these logs. Note that your MediaConvert service
         * role must provide access to this location. For more information, see
         * https://docs.aws.amazon.com/mediaconvert/latest/ug/iam-role.html
         * 
         * @param logDestination
         *        Optional. Specify the Amazon S3 bucket where you want MediaConvert to store your Kantar watermark XML
         *        logs. When you don't specify a bucket, MediaConvert doesn't save these logs. Note that your
         *        MediaConvert service role must provide access to this location. For more information, see
         *        https://docs.aws.amazon.com/mediaconvert/latest/ug/iam-role.html
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logDestination(String logDestination);

        /**
         * You can optionally use this field to specify the first timestamp that Kantar embeds during watermarking.
         * Kantar suggests that you be very cautious when using this Kantar feature, and that you use it only on
         * channels that are managed specifically for use with this feature by your Audience Measurement Operator. For
         * more information about this feature, contact Kantar technical support.
         * 
         * @param metadata3
         *        You can optionally use this field to specify the first timestamp that Kantar embeds during
         *        watermarking. Kantar suggests that you be very cautious when using this Kantar feature, and that you
         *        use it only on channels that are managed specifically for use with this feature by your Audience
         *        Measurement Operator. For more information about this feature, contact Kantar technical support.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metadata3(String metadata3);

        /**
         * Additional metadata that MediaConvert sends to Kantar. Maximum length is 50 characters.
         * 
         * @param metadata4
         *        Additional metadata that MediaConvert sends to Kantar. Maximum length is 50 characters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metadata4(String metadata4);

        /**
         * Additional metadata that MediaConvert sends to Kantar. Maximum length is 50 characters.
         * 
         * @param metadata5
         *        Additional metadata that MediaConvert sends to Kantar. Maximum length is 50 characters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metadata5(String metadata5);

        /**
         * Additional metadata that MediaConvert sends to Kantar. Maximum length is 50 characters.
         * 
         * @param metadata6
         *        Additional metadata that MediaConvert sends to Kantar. Maximum length is 50 characters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metadata6(String metadata6);

        /**
         * Additional metadata that MediaConvert sends to Kantar. Maximum length is 50 characters.
         * 
         * @param metadata7
         *        Additional metadata that MediaConvert sends to Kantar. Maximum length is 50 characters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metadata7(String metadata7);

        /**
         * Additional metadata that MediaConvert sends to Kantar. Maximum length is 50 characters.
         * 
         * @param metadata8
         *        Additional metadata that MediaConvert sends to Kantar. Maximum length is 50 characters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metadata8(String metadata8);
    }

    static final class BuilderImpl implements Builder {
        private String channelName;

        private String contentReference;

        private String credentialsSecretName;

        private Double fileOffset;

        private Integer kantarLicenseId;

        private String kantarServerUrl;

        private String logDestination;

        private String metadata3;

        private String metadata4;

        private String metadata5;

        private String metadata6;

        private String metadata7;

        private String metadata8;

        private BuilderImpl() {
        }

        private BuilderImpl(KantarWatermarkSettings model) {
            channelName(model.channelName);
            contentReference(model.contentReference);
            credentialsSecretName(model.credentialsSecretName);
            fileOffset(model.fileOffset);
            kantarLicenseId(model.kantarLicenseId);
            kantarServerUrl(model.kantarServerUrl);
            logDestination(model.logDestination);
            metadata3(model.metadata3);
            metadata4(model.metadata4);
            metadata5(model.metadata5);
            metadata6(model.metadata6);
            metadata7(model.metadata7);
            metadata8(model.metadata8);
        }

        public final String getChannelName() {
            return channelName;
        }

        public final void setChannelName(String channelName) {
            this.channelName = channelName;
        }

        @Override
        public final Builder channelName(String channelName) {
            this.channelName = channelName;
            return this;
        }

        public final String getContentReference() {
            return contentReference;
        }

        public final void setContentReference(String contentReference) {
            this.contentReference = contentReference;
        }

        @Override
        public final Builder contentReference(String contentReference) {
            this.contentReference = contentReference;
            return this;
        }

        public final String getCredentialsSecretName() {
            return credentialsSecretName;
        }

        public final void setCredentialsSecretName(String credentialsSecretName) {
            this.credentialsSecretName = credentialsSecretName;
        }

        @Override
        public final Builder credentialsSecretName(String credentialsSecretName) {
            this.credentialsSecretName = credentialsSecretName;
            return this;
        }

        public final Double getFileOffset() {
            return fileOffset;
        }

        public final void setFileOffset(Double fileOffset) {
            this.fileOffset = fileOffset;
        }

        @Override
        public final Builder fileOffset(Double fileOffset) {
            this.fileOffset = fileOffset;
            return this;
        }

        public final Integer getKantarLicenseId() {
            return kantarLicenseId;
        }

        public final void setKantarLicenseId(Integer kantarLicenseId) {
            this.kantarLicenseId = kantarLicenseId;
        }

        @Override
        public final Builder kantarLicenseId(Integer kantarLicenseId) {
            this.kantarLicenseId = kantarLicenseId;
            return this;
        }

        public final String getKantarServerUrl() {
            return kantarServerUrl;
        }

        public final void setKantarServerUrl(String kantarServerUrl) {
            this.kantarServerUrl = kantarServerUrl;
        }

        @Override
        public final Builder kantarServerUrl(String kantarServerUrl) {
            this.kantarServerUrl = kantarServerUrl;
            return this;
        }

        public final String getLogDestination() {
            return logDestination;
        }

        public final void setLogDestination(String logDestination) {
            this.logDestination = logDestination;
        }

        @Override
        public final Builder logDestination(String logDestination) {
            this.logDestination = logDestination;
            return this;
        }

        public final String getMetadata3() {
            return metadata3;
        }

        public final void setMetadata3(String metadata3) {
            this.metadata3 = metadata3;
        }

        @Override
        public final Builder metadata3(String metadata3) {
            this.metadata3 = metadata3;
            return this;
        }

        public final String getMetadata4() {
            return metadata4;
        }

        public final void setMetadata4(String metadata4) {
            this.metadata4 = metadata4;
        }

        @Override
        public final Builder metadata4(String metadata4) {
            this.metadata4 = metadata4;
            return this;
        }

        public final String getMetadata5() {
            return metadata5;
        }

        public final void setMetadata5(String metadata5) {
            this.metadata5 = metadata5;
        }

        @Override
        public final Builder metadata5(String metadata5) {
            this.metadata5 = metadata5;
            return this;
        }

        public final String getMetadata6() {
            return metadata6;
        }

        public final void setMetadata6(String metadata6) {
            this.metadata6 = metadata6;
        }

        @Override
        public final Builder metadata6(String metadata6) {
            this.metadata6 = metadata6;
            return this;
        }

        public final String getMetadata7() {
            return metadata7;
        }

        public final void setMetadata7(String metadata7) {
            this.metadata7 = metadata7;
        }

        @Override
        public final Builder metadata7(String metadata7) {
            this.metadata7 = metadata7;
            return this;
        }

        public final String getMetadata8() {
            return metadata8;
        }

        public final void setMetadata8(String metadata8) {
            this.metadata8 = metadata8;
        }

        @Override
        public final Builder metadata8(String metadata8) {
            this.metadata8 = metadata8;
            return this;
        }

        @Override
        public KantarWatermarkSettings build() {
            return new KantarWatermarkSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
