/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListQueuesResponse extends MediaConvertResponse implements
        ToCopyableBuilder<ListQueuesResponse.Builder, ListQueuesResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListQueuesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<List<Queue>> QUEUES_FIELD = SdkField
            .<List<Queue>> builder(MarshallingType.LIST)
            .memberName("Queues")
            .getter(getter(ListQueuesResponse::queues))
            .setter(setter(Builder::queues))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queues").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Queue> builder(MarshallingType.SDK_POJO)
                                            .constructor(Queue::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> TOTAL_CONCURRENT_JOBS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("TotalConcurrentJobs").getter(getter(ListQueuesResponse::totalConcurrentJobs))
            .setter(setter(Builder::totalConcurrentJobs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("totalConcurrentJobs").build())
            .build();

    private static final SdkField<Integer> UNALLOCATED_CONCURRENT_JOBS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER).memberName("UnallocatedConcurrentJobs")
            .getter(getter(ListQueuesResponse::unallocatedConcurrentJobs)).setter(setter(Builder::unallocatedConcurrentJobs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("unallocatedConcurrentJobs").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            QUEUES_FIELD, TOTAL_CONCURRENT_JOBS_FIELD, UNALLOCATED_CONCURRENT_JOBS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String nextToken;

    private final List<Queue> queues;

    private final Integer totalConcurrentJobs;

    private final Integer unallocatedConcurrentJobs;

    private ListQueuesResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.queues = builder.queues;
        this.totalConcurrentJobs = builder.totalConcurrentJobs;
        this.unallocatedConcurrentJobs = builder.unallocatedConcurrentJobs;
    }

    /**
     * Use this string to request the next batch of queues.
     * 
     * @return Use this string to request the next batch of queues.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Queues property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasQueues() {
        return queues != null && !(queues instanceof SdkAutoConstructList);
    }

    /**
     * List of queues.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasQueues} method.
     * </p>
     * 
     * @return List of queues.
     */
    public final List<Queue> queues() {
        return queues;
    }

    /**
     * The maximum number of jobs that MediaConvert can process at one time, across all of your on-demand queues in the
     * current AWS Region.
     * 
     * @return The maximum number of jobs that MediaConvert can process at one time, across all of your on-demand queues
     *         in the current AWS Region.
     */
    public final Integer totalConcurrentJobs() {
        return totalConcurrentJobs;
    }

    /**
     * The remaining number of concurrent jobs that are not associated with a queue and are available to allocate to a
     * queue. You can allocate these jobs when you create or update a queue.
     * 
     * @return The remaining number of concurrent jobs that are not associated with a queue and are available to
     *         allocate to a queue. You can allocate these jobs when you create or update a queue.
     */
    public final Integer unallocatedConcurrentJobs() {
        return unallocatedConcurrentJobs;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasQueues() ? queues() : null);
        hashCode = 31 * hashCode + Objects.hashCode(totalConcurrentJobs());
        hashCode = 31 * hashCode + Objects.hashCode(unallocatedConcurrentJobs());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListQueuesResponse)) {
            return false;
        }
        ListQueuesResponse other = (ListQueuesResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && hasQueues() == other.hasQueues()
                && Objects.equals(queues(), other.queues()) && Objects.equals(totalConcurrentJobs(), other.totalConcurrentJobs())
                && Objects.equals(unallocatedConcurrentJobs(), other.unallocatedConcurrentJobs());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListQueuesResponse").add("NextToken", nextToken()).add("Queues", hasQueues() ? queues() : null)
                .add("TotalConcurrentJobs", totalConcurrentJobs()).add("UnallocatedConcurrentJobs", unallocatedConcurrentJobs())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "Queues":
            return Optional.ofNullable(clazz.cast(queues()));
        case "TotalConcurrentJobs":
            return Optional.ofNullable(clazz.cast(totalConcurrentJobs()));
        case "UnallocatedConcurrentJobs":
            return Optional.ofNullable(clazz.cast(unallocatedConcurrentJobs()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("queues", QUEUES_FIELD);
        map.put("totalConcurrentJobs", TOTAL_CONCURRENT_JOBS_FIELD);
        map.put("unallocatedConcurrentJobs", UNALLOCATED_CONCURRENT_JOBS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListQueuesResponse, T> g) {
        return obj -> g.apply((ListQueuesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MediaConvertResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListQueuesResponse> {
        /**
         * Use this string to request the next batch of queues.
         * 
         * @param nextToken
         *        Use this string to request the next batch of queues.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * List of queues.
         * 
         * @param queues
         *        List of queues.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queues(Collection<Queue> queues);

        /**
         * List of queues.
         * 
         * @param queues
         *        List of queues.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queues(Queue... queues);

        /**
         * List of queues. This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.mediaconvert.model.Queue.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.mediaconvert.model.Queue#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.mediaconvert.model.Queue.Builder#build()} is called immediately and
         * its result is passed to {@link #queues(List<Queue>)}.
         * 
         * @param queues
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.mediaconvert.model.Queue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #queues(java.util.Collection<Queue>)
         */
        Builder queues(Consumer<Queue.Builder>... queues);

        /**
         * The maximum number of jobs that MediaConvert can process at one time, across all of your on-demand queues in
         * the current AWS Region.
         * 
         * @param totalConcurrentJobs
         *        The maximum number of jobs that MediaConvert can process at one time, across all of your on-demand
         *        queues in the current AWS Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalConcurrentJobs(Integer totalConcurrentJobs);

        /**
         * The remaining number of concurrent jobs that are not associated with a queue and are available to allocate to
         * a queue. You can allocate these jobs when you create or update a queue.
         * 
         * @param unallocatedConcurrentJobs
         *        The remaining number of concurrent jobs that are not associated with a queue and are available to
         *        allocate to a queue. You can allocate these jobs when you create or update a queue.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unallocatedConcurrentJobs(Integer unallocatedConcurrentJobs);
    }

    static final class BuilderImpl extends MediaConvertResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<Queue> queues = DefaultSdkAutoConstructList.getInstance();

        private Integer totalConcurrentJobs;

        private Integer unallocatedConcurrentJobs;

        private BuilderImpl() {
        }

        private BuilderImpl(ListQueuesResponse model) {
            super(model);
            nextToken(model.nextToken);
            queues(model.queues);
            totalConcurrentJobs(model.totalConcurrentJobs);
            unallocatedConcurrentJobs(model.unallocatedConcurrentJobs);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<Queue.Builder> getQueues() {
            List<Queue.Builder> result = ___listOfQueueCopier.copyToBuilder(this.queues);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setQueues(Collection<Queue.BuilderImpl> queues) {
            this.queues = ___listOfQueueCopier.copyFromBuilder(queues);
        }

        @Override
        public final Builder queues(Collection<Queue> queues) {
            this.queues = ___listOfQueueCopier.copy(queues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder queues(Queue... queues) {
            queues(Arrays.asList(queues));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder queues(Consumer<Queue.Builder>... queues) {
            queues(Stream.of(queues).map(c -> Queue.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Integer getTotalConcurrentJobs() {
            return totalConcurrentJobs;
        }

        public final void setTotalConcurrentJobs(Integer totalConcurrentJobs) {
            this.totalConcurrentJobs = totalConcurrentJobs;
        }

        @Override
        public final Builder totalConcurrentJobs(Integer totalConcurrentJobs) {
            this.totalConcurrentJobs = totalConcurrentJobs;
            return this;
        }

        public final Integer getUnallocatedConcurrentJobs() {
            return unallocatedConcurrentJobs;
        }

        public final void setUnallocatedConcurrentJobs(Integer unallocatedConcurrentJobs) {
            this.unallocatedConcurrentJobs = unallocatedConcurrentJobs;
        }

        @Override
        public final Builder unallocatedConcurrentJobs(Integer unallocatedConcurrentJobs) {
            this.unallocatedConcurrentJobs = unallocatedConcurrentJobs;
            return this;
        }

        @Override
        public ListQueuesResponse build() {
            return new ListQueuesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
