/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Use Min top rendition size to specify a minimum size for the highest resolution in your ABR stack. * The highest
 * resolution in your ABR stack will be equal to or greater than the value that you enter. For example: If you specify
 * 1280x720 the highest resolution in your ABR stack will be equal to or greater than 1280x720. * If you specify a value
 * for Max resolution, the value that you specify for Min top rendition size must be less than, or equal to, Max
 * resolution.
 */
@Generated("software.amazon.awssdk:codegen")
public final class MinTopRenditionSize implements SdkPojo, Serializable,
        ToCopyableBuilder<MinTopRenditionSize.Builder, MinTopRenditionSize> {
    private static final SdkField<Integer> HEIGHT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Height").getter(getter(MinTopRenditionSize::height)).setter(setter(Builder::height))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("height").build()).build();

    private static final SdkField<Integer> WIDTH_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Width")
            .getter(getter(MinTopRenditionSize::width)).setter(setter(Builder::width))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("width").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HEIGHT_FIELD, WIDTH_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer height;

    private final Integer width;

    private MinTopRenditionSize(BuilderImpl builder) {
        this.height = builder.height;
        this.width = builder.width;
    }

    /**
     * Use Height to define the video resolution height, in pixels, for this rule.
     * 
     * @return Use Height to define the video resolution height, in pixels, for this rule.
     */
    public final Integer height() {
        return height;
    }

    /**
     * Use Width to define the video resolution width, in pixels, for this rule.
     * 
     * @return Use Width to define the video resolution width, in pixels, for this rule.
     */
    public final Integer width() {
        return width;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(height());
        hashCode = 31 * hashCode + Objects.hashCode(width());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MinTopRenditionSize)) {
            return false;
        }
        MinTopRenditionSize other = (MinTopRenditionSize) obj;
        return Objects.equals(height(), other.height()) && Objects.equals(width(), other.width());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MinTopRenditionSize").add("Height", height()).add("Width", width()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Height":
            return Optional.ofNullable(clazz.cast(height()));
        case "Width":
            return Optional.ofNullable(clazz.cast(width()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("height", HEIGHT_FIELD);
        map.put("width", WIDTH_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MinTopRenditionSize, T> g) {
        return obj -> g.apply((MinTopRenditionSize) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MinTopRenditionSize> {
        /**
         * Use Height to define the video resolution height, in pixels, for this rule.
         * 
         * @param height
         *        Use Height to define the video resolution height, in pixels, for this rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder height(Integer height);

        /**
         * Use Width to define the video resolution width, in pixels, for this rule.
         * 
         * @param width
         *        Use Width to define the video resolution width, in pixels, for this rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder width(Integer width);
    }

    static final class BuilderImpl implements Builder {
        private Integer height;

        private Integer width;

        private BuilderImpl() {
        }

        private BuilderImpl(MinTopRenditionSize model) {
            height(model.height);
            width(model.width);
        }

        public final Integer getHeight() {
            return height;
        }

        public final void setHeight(Integer height) {
            this.height = height;
        }

        @Override
        public final Builder height(Integer height) {
            this.height = height;
            return this;
        }

        public final Integer getWidth() {
            return width;
        }

        public final void setWidth(Integer width) {
            this.width = width;
        }

        @Override
        public final Builder width(Integer width) {
            this.width = width;
            return this;
        }

        @Override
        public MinTopRenditionSize build() {
            return new MinTopRenditionSize(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
