/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Specify the offset between the upper-left corner of the video frame and the top left corner of the overlay.
 */
@Generated("software.amazon.awssdk:codegen")
public final class MotionImageInsertionOffset implements SdkPojo, Serializable,
        ToCopyableBuilder<MotionImageInsertionOffset.Builder, MotionImageInsertionOffset> {
    private static final SdkField<Integer> IMAGEX_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ImageX").getter(getter(MotionImageInsertionOffset::imageX)).setter(setter(Builder::imageX))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageX").build()).build();

    private static final SdkField<Integer> IMAGEY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ImageY").getter(getter(MotionImageInsertionOffset::imageY)).setter(setter(Builder::imageY))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageY").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IMAGEX_FIELD, IMAGEY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer imageX;

    private final Integer imageY;

    private MotionImageInsertionOffset(BuilderImpl builder) {
        this.imageX = builder.imageX;
        this.imageY = builder.imageY;
    }

    /**
     * Set the distance, in pixels, between the overlay and the left edge of the video frame.
     * 
     * @return Set the distance, in pixels, between the overlay and the left edge of the video frame.
     */
    public final Integer imageX() {
        return imageX;
    }

    /**
     * Set the distance, in pixels, between the overlay and the top edge of the video frame.
     * 
     * @return Set the distance, in pixels, between the overlay and the top edge of the video frame.
     */
    public final Integer imageY() {
        return imageY;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(imageX());
        hashCode = 31 * hashCode + Objects.hashCode(imageY());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MotionImageInsertionOffset)) {
            return false;
        }
        MotionImageInsertionOffset other = (MotionImageInsertionOffset) obj;
        return Objects.equals(imageX(), other.imageX()) && Objects.equals(imageY(), other.imageY());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MotionImageInsertionOffset").add("ImageX", imageX()).add("ImageY", imageY()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ImageX":
            return Optional.ofNullable(clazz.cast(imageX()));
        case "ImageY":
            return Optional.ofNullable(clazz.cast(imageY()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("imageX", IMAGEX_FIELD);
        map.put("imageY", IMAGEY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MotionImageInsertionOffset, T> g) {
        return obj -> g.apply((MotionImageInsertionOffset) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MotionImageInsertionOffset> {
        /**
         * Set the distance, in pixels, between the overlay and the left edge of the video frame.
         * 
         * @param imageX
         *        Set the distance, in pixels, between the overlay and the left edge of the video frame.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageX(Integer imageX);

        /**
         * Set the distance, in pixels, between the overlay and the top edge of the video frame.
         * 
         * @param imageY
         *        Set the distance, in pixels, between the overlay and the top edge of the video frame.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageY(Integer imageY);
    }

    static final class BuilderImpl implements Builder {
        private Integer imageX;

        private Integer imageY;

        private BuilderImpl() {
        }

        private BuilderImpl(MotionImageInsertionOffset model) {
            imageX(model.imageX);
            imageY(model.imageY);
        }

        public final Integer getImageX() {
            return imageX;
        }

        public final void setImageX(Integer imageX) {
            this.imageX = imageX;
        }

        @Override
        public final Builder imageX(Integer imageX) {
            this.imageX = imageX;
            return this;
        }

        public final Integer getImageY() {
            return imageY;
        }

        public final void setImageY(Integer imageY) {
            this.imageY = imageY;
        }

        @Override
        public final Builder imageY(Integer imageY) {
            this.imageY = imageY;
            return this;
        }

        @Override
        public MotionImageInsertionOffset build() {
            return new MotionImageInsertionOffset(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
