/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * These settings relate to your MP4 output container. You can create audio only outputs with this container. For more
 * information, see
 * https://docs.aws.amazon.com/mediaconvert/latest/ug/supported-codecs-containers-audio-only.html#output
 * -codecs-and-containers-supported-for-audio-only.
 */
@Generated("software.amazon.awssdk:codegen")
public final class Mp4Settings implements SdkPojo, Serializable, ToCopyableBuilder<Mp4Settings.Builder, Mp4Settings> {
    private static final SdkField<String> AUDIO_DURATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AudioDuration").getter(getter(Mp4Settings::audioDurationAsString))
            .setter(setter(Builder::audioDuration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("audioDuration").build()).build();

    private static final SdkField<String> CSLG_ATOM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CslgAtom").getter(getter(Mp4Settings::cslgAtomAsString)).setter(setter(Builder::cslgAtom))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cslgAtom").build()).build();

    private static final SdkField<Integer> CTTS_VERSION_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("CttsVersion").getter(getter(Mp4Settings::cttsVersion)).setter(setter(Builder::cttsVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cttsVersion").build()).build();

    private static final SdkField<String> FREE_SPACE_BOX_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FreeSpaceBox").getter(getter(Mp4Settings::freeSpaceBoxAsString)).setter(setter(Builder::freeSpaceBox))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("freeSpaceBox").build()).build();

    private static final SdkField<String> MOOV_PLACEMENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MoovPlacement").getter(getter(Mp4Settings::moovPlacementAsString))
            .setter(setter(Builder::moovPlacement))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("moovPlacement").build()).build();

    private static final SdkField<String> MP4_MAJOR_BRAND_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Mp4MajorBrand").getter(getter(Mp4Settings::mp4MajorBrand)).setter(setter(Builder::mp4MajorBrand))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mp4MajorBrand").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUDIO_DURATION_FIELD,
            CSLG_ATOM_FIELD, CTTS_VERSION_FIELD, FREE_SPACE_BOX_FIELD, MOOV_PLACEMENT_FIELD, MP4_MAJOR_BRAND_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String audioDuration;

    private final String cslgAtom;

    private final Integer cttsVersion;

    private final String freeSpaceBox;

    private final String moovPlacement;

    private final String mp4MajorBrand;

    private Mp4Settings(BuilderImpl builder) {
        this.audioDuration = builder.audioDuration;
        this.cslgAtom = builder.cslgAtom;
        this.cttsVersion = builder.cttsVersion;
        this.freeSpaceBox = builder.freeSpaceBox;
        this.moovPlacement = builder.moovPlacement;
        this.mp4MajorBrand = builder.mp4MajorBrand;
    }

    /**
     * Specify this setting only when your output will be consumed by a downstream repackaging workflow that is
     * sensitive to very small duration differences between video and audio. For this situation, choose Match video
     * duration. In all other cases, keep the default value, Default codec duration. When you choose Match video
     * duration, MediaConvert pads the output audio streams with silence or trims them to ensure that the total duration
     * of each audio stream is at least as long as the total duration of the video stream. After padding or trimming,
     * the audio stream duration is no more than one frame longer than the video stream. MediaConvert applies audio
     * padding or trimming only to the end of the last segment of the output. For unsegmented outputs, MediaConvert adds
     * padding only to the end of the file. When you keep the default value, any minor discrepancies between audio and
     * video duration will depend on your output audio codec.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #audioDuration}
     * will return {@link CmfcAudioDuration#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #audioDurationAsString}.
     * </p>
     * 
     * @return Specify this setting only when your output will be consumed by a downstream repackaging workflow that is
     *         sensitive to very small duration differences between video and audio. For this situation, choose Match
     *         video duration. In all other cases, keep the default value, Default codec duration. When you choose Match
     *         video duration, MediaConvert pads the output audio streams with silence or trims them to ensure that the
     *         total duration of each audio stream is at least as long as the total duration of the video stream. After
     *         padding or trimming, the audio stream duration is no more than one frame longer than the video stream.
     *         MediaConvert applies audio padding or trimming only to the end of the last segment of the output. For
     *         unsegmented outputs, MediaConvert adds padding only to the end of the file. When you keep the default
     *         value, any minor discrepancies between audio and video duration will depend on your output audio codec.
     * @see CmfcAudioDuration
     */
    public final CmfcAudioDuration audioDuration() {
        return CmfcAudioDuration.fromValue(audioDuration);
    }

    /**
     * Specify this setting only when your output will be consumed by a downstream repackaging workflow that is
     * sensitive to very small duration differences between video and audio. For this situation, choose Match video
     * duration. In all other cases, keep the default value, Default codec duration. When you choose Match video
     * duration, MediaConvert pads the output audio streams with silence or trims them to ensure that the total duration
     * of each audio stream is at least as long as the total duration of the video stream. After padding or trimming,
     * the audio stream duration is no more than one frame longer than the video stream. MediaConvert applies audio
     * padding or trimming only to the end of the last segment of the output. For unsegmented outputs, MediaConvert adds
     * padding only to the end of the file. When you keep the default value, any minor discrepancies between audio and
     * video duration will depend on your output audio codec.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #audioDuration}
     * will return {@link CmfcAudioDuration#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #audioDurationAsString}.
     * </p>
     * 
     * @return Specify this setting only when your output will be consumed by a downstream repackaging workflow that is
     *         sensitive to very small duration differences between video and audio. For this situation, choose Match
     *         video duration. In all other cases, keep the default value, Default codec duration. When you choose Match
     *         video duration, MediaConvert pads the output audio streams with silence or trims them to ensure that the
     *         total duration of each audio stream is at least as long as the total duration of the video stream. After
     *         padding or trimming, the audio stream duration is no more than one frame longer than the video stream.
     *         MediaConvert applies audio padding or trimming only to the end of the last segment of the output. For
     *         unsegmented outputs, MediaConvert adds padding only to the end of the file. When you keep the default
     *         value, any minor discrepancies between audio and video duration will depend on your output audio codec.
     * @see CmfcAudioDuration
     */
    public final String audioDurationAsString() {
        return audioDuration;
    }

    /**
     * When enabled, file composition times will start at zero, composition times in the 'ctts' (composition time to
     * sample) box for B-frames will be negative, and a 'cslg' (composition shift least greatest) box will be included
     * per 14496-1 amendment 1. This improves compatibility with Apple players and tools.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #cslgAtom} will
     * return {@link Mp4CslgAtom#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #cslgAtomAsString}.
     * </p>
     * 
     * @return When enabled, file composition times will start at zero, composition times in the 'ctts' (composition
     *         time to sample) box for B-frames will be negative, and a 'cslg' (composition shift least greatest) box
     *         will be included per 14496-1 amendment 1. This improves compatibility with Apple players and tools.
     * @see Mp4CslgAtom
     */
    public final Mp4CslgAtom cslgAtom() {
        return Mp4CslgAtom.fromValue(cslgAtom);
    }

    /**
     * When enabled, file composition times will start at zero, composition times in the 'ctts' (composition time to
     * sample) box for B-frames will be negative, and a 'cslg' (composition shift least greatest) box will be included
     * per 14496-1 amendment 1. This improves compatibility with Apple players and tools.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #cslgAtom} will
     * return {@link Mp4CslgAtom#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #cslgAtomAsString}.
     * </p>
     * 
     * @return When enabled, file composition times will start at zero, composition times in the 'ctts' (composition
     *         time to sample) box for B-frames will be negative, and a 'cslg' (composition shift least greatest) box
     *         will be included per 14496-1 amendment 1. This improves compatibility with Apple players and tools.
     * @see Mp4CslgAtom
     */
    public final String cslgAtomAsString() {
        return cslgAtom;
    }

    /**
     * Ignore this setting unless compliance to the CTTS box version specification matters in your workflow. Specify a
     * value of 1 to set your CTTS box version to 1 and make your output compliant with the specification. When you
     * specify a value of 1, you must also set CSLG atom to the value INCLUDE. Keep the default value 0 to set your CTTS
     * box version to 0. This can provide backward compatibility for some players and packagers.
     * 
     * @return Ignore this setting unless compliance to the CTTS box version specification matters in your workflow.
     *         Specify a value of 1 to set your CTTS box version to 1 and make your output compliant with the
     *         specification. When you specify a value of 1, you must also set CSLG atom to the value INCLUDE. Keep the
     *         default value 0 to set your CTTS box version to 0. This can provide backward compatibility for some
     *         players and packagers.
     */
    public final Integer cttsVersion() {
        return cttsVersion;
    }

    /**
     * Inserts a free-space box immediately after the moov box.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #freeSpaceBox} will
     * return {@link Mp4FreeSpaceBox#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #freeSpaceBoxAsString}.
     * </p>
     * 
     * @return Inserts a free-space box immediately after the moov box.
     * @see Mp4FreeSpaceBox
     */
    public final Mp4FreeSpaceBox freeSpaceBox() {
        return Mp4FreeSpaceBox.fromValue(freeSpaceBox);
    }

    /**
     * Inserts a free-space box immediately after the moov box.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #freeSpaceBox} will
     * return {@link Mp4FreeSpaceBox#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #freeSpaceBoxAsString}.
     * </p>
     * 
     * @return Inserts a free-space box immediately after the moov box.
     * @see Mp4FreeSpaceBox
     */
    public final String freeSpaceBoxAsString() {
        return freeSpaceBox;
    }

    /**
     * To place the MOOV atom at the beginning of your output, which is useful for progressive downloading: Leave blank
     * or choose Progressive download. To place the MOOV at the end of your output: Choose Normal.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #moovPlacement}
     * will return {@link Mp4MoovPlacement#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #moovPlacementAsString}.
     * </p>
     * 
     * @return To place the MOOV atom at the beginning of your output, which is useful for progressive downloading:
     *         Leave blank or choose Progressive download. To place the MOOV at the end of your output: Choose Normal.
     * @see Mp4MoovPlacement
     */
    public final Mp4MoovPlacement moovPlacement() {
        return Mp4MoovPlacement.fromValue(moovPlacement);
    }

    /**
     * To place the MOOV atom at the beginning of your output, which is useful for progressive downloading: Leave blank
     * or choose Progressive download. To place the MOOV at the end of your output: Choose Normal.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #moovPlacement}
     * will return {@link Mp4MoovPlacement#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #moovPlacementAsString}.
     * </p>
     * 
     * @return To place the MOOV atom at the beginning of your output, which is useful for progressive downloading:
     *         Leave blank or choose Progressive download. To place the MOOV at the end of your output: Choose Normal.
     * @see Mp4MoovPlacement
     */
    public final String moovPlacementAsString() {
        return moovPlacement;
    }

    /**
     * Overrides the "Major Brand" field in the output file. Usually not necessary to specify.
     * 
     * @return Overrides the "Major Brand" field in the output file. Usually not necessary to specify.
     */
    public final String mp4MajorBrand() {
        return mp4MajorBrand;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(audioDurationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(cslgAtomAsString());
        hashCode = 31 * hashCode + Objects.hashCode(cttsVersion());
        hashCode = 31 * hashCode + Objects.hashCode(freeSpaceBoxAsString());
        hashCode = 31 * hashCode + Objects.hashCode(moovPlacementAsString());
        hashCode = 31 * hashCode + Objects.hashCode(mp4MajorBrand());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Mp4Settings)) {
            return false;
        }
        Mp4Settings other = (Mp4Settings) obj;
        return Objects.equals(audioDurationAsString(), other.audioDurationAsString())
                && Objects.equals(cslgAtomAsString(), other.cslgAtomAsString())
                && Objects.equals(cttsVersion(), other.cttsVersion())
                && Objects.equals(freeSpaceBoxAsString(), other.freeSpaceBoxAsString())
                && Objects.equals(moovPlacementAsString(), other.moovPlacementAsString())
                && Objects.equals(mp4MajorBrand(), other.mp4MajorBrand());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Mp4Settings").add("AudioDuration", audioDurationAsString()).add("CslgAtom", cslgAtomAsString())
                .add("CttsVersion", cttsVersion()).add("FreeSpaceBox", freeSpaceBoxAsString())
                .add("MoovPlacement", moovPlacementAsString()).add("Mp4MajorBrand", mp4MajorBrand()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AudioDuration":
            return Optional.ofNullable(clazz.cast(audioDurationAsString()));
        case "CslgAtom":
            return Optional.ofNullable(clazz.cast(cslgAtomAsString()));
        case "CttsVersion":
            return Optional.ofNullable(clazz.cast(cttsVersion()));
        case "FreeSpaceBox":
            return Optional.ofNullable(clazz.cast(freeSpaceBoxAsString()));
        case "MoovPlacement":
            return Optional.ofNullable(clazz.cast(moovPlacementAsString()));
        case "Mp4MajorBrand":
            return Optional.ofNullable(clazz.cast(mp4MajorBrand()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("audioDuration", AUDIO_DURATION_FIELD);
        map.put("cslgAtom", CSLG_ATOM_FIELD);
        map.put("cttsVersion", CTTS_VERSION_FIELD);
        map.put("freeSpaceBox", FREE_SPACE_BOX_FIELD);
        map.put("moovPlacement", MOOV_PLACEMENT_FIELD);
        map.put("mp4MajorBrand", MP4_MAJOR_BRAND_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Mp4Settings, T> g) {
        return obj -> g.apply((Mp4Settings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Mp4Settings> {
        /**
         * Specify this setting only when your output will be consumed by a downstream repackaging workflow that is
         * sensitive to very small duration differences between video and audio. For this situation, choose Match video
         * duration. In all other cases, keep the default value, Default codec duration. When you choose Match video
         * duration, MediaConvert pads the output audio streams with silence or trims them to ensure that the total
         * duration of each audio stream is at least as long as the total duration of the video stream. After padding or
         * trimming, the audio stream duration is no more than one frame longer than the video stream. MediaConvert
         * applies audio padding or trimming only to the end of the last segment of the output. For unsegmented outputs,
         * MediaConvert adds padding only to the end of the file. When you keep the default value, any minor
         * discrepancies between audio and video duration will depend on your output audio codec.
         * 
         * @param audioDuration
         *        Specify this setting only when your output will be consumed by a downstream repackaging workflow that
         *        is sensitive to very small duration differences between video and audio. For this situation, choose
         *        Match video duration. In all other cases, keep the default value, Default codec duration. When you
         *        choose Match video duration, MediaConvert pads the output audio streams with silence or trims them to
         *        ensure that the total duration of each audio stream is at least as long as the total duration of the
         *        video stream. After padding or trimming, the audio stream duration is no more than one frame longer
         *        than the video stream. MediaConvert applies audio padding or trimming only to the end of the last
         *        segment of the output. For unsegmented outputs, MediaConvert adds padding only to the end of the file.
         *        When you keep the default value, any minor discrepancies between audio and video duration will depend
         *        on your output audio codec.
         * @see CmfcAudioDuration
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CmfcAudioDuration
         */
        Builder audioDuration(String audioDuration);

        /**
         * Specify this setting only when your output will be consumed by a downstream repackaging workflow that is
         * sensitive to very small duration differences between video and audio. For this situation, choose Match video
         * duration. In all other cases, keep the default value, Default codec duration. When you choose Match video
         * duration, MediaConvert pads the output audio streams with silence or trims them to ensure that the total
         * duration of each audio stream is at least as long as the total duration of the video stream. After padding or
         * trimming, the audio stream duration is no more than one frame longer than the video stream. MediaConvert
         * applies audio padding or trimming only to the end of the last segment of the output. For unsegmented outputs,
         * MediaConvert adds padding only to the end of the file. When you keep the default value, any minor
         * discrepancies between audio and video duration will depend on your output audio codec.
         * 
         * @param audioDuration
         *        Specify this setting only when your output will be consumed by a downstream repackaging workflow that
         *        is sensitive to very small duration differences between video and audio. For this situation, choose
         *        Match video duration. In all other cases, keep the default value, Default codec duration. When you
         *        choose Match video duration, MediaConvert pads the output audio streams with silence or trims them to
         *        ensure that the total duration of each audio stream is at least as long as the total duration of the
         *        video stream. After padding or trimming, the audio stream duration is no more than one frame longer
         *        than the video stream. MediaConvert applies audio padding or trimming only to the end of the last
         *        segment of the output. For unsegmented outputs, MediaConvert adds padding only to the end of the file.
         *        When you keep the default value, any minor discrepancies between audio and video duration will depend
         *        on your output audio codec.
         * @see CmfcAudioDuration
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CmfcAudioDuration
         */
        Builder audioDuration(CmfcAudioDuration audioDuration);

        /**
         * When enabled, file composition times will start at zero, composition times in the 'ctts' (composition time to
         * sample) box for B-frames will be negative, and a 'cslg' (composition shift least greatest) box will be
         * included per 14496-1 amendment 1. This improves compatibility with Apple players and tools.
         * 
         * @param cslgAtom
         *        When enabled, file composition times will start at zero, composition times in the 'ctts' (composition
         *        time to sample) box for B-frames will be negative, and a 'cslg' (composition shift least greatest) box
         *        will be included per 14496-1 amendment 1. This improves compatibility with Apple players and tools.
         * @see Mp4CslgAtom
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Mp4CslgAtom
         */
        Builder cslgAtom(String cslgAtom);

        /**
         * When enabled, file composition times will start at zero, composition times in the 'ctts' (composition time to
         * sample) box for B-frames will be negative, and a 'cslg' (composition shift least greatest) box will be
         * included per 14496-1 amendment 1. This improves compatibility with Apple players and tools.
         * 
         * @param cslgAtom
         *        When enabled, file composition times will start at zero, composition times in the 'ctts' (composition
         *        time to sample) box for B-frames will be negative, and a 'cslg' (composition shift least greatest) box
         *        will be included per 14496-1 amendment 1. This improves compatibility with Apple players and tools.
         * @see Mp4CslgAtom
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Mp4CslgAtom
         */
        Builder cslgAtom(Mp4CslgAtom cslgAtom);

        /**
         * Ignore this setting unless compliance to the CTTS box version specification matters in your workflow. Specify
         * a value of 1 to set your CTTS box version to 1 and make your output compliant with the specification. When
         * you specify a value of 1, you must also set CSLG atom to the value INCLUDE. Keep the default value 0 to set
         * your CTTS box version to 0. This can provide backward compatibility for some players and packagers.
         * 
         * @param cttsVersion
         *        Ignore this setting unless compliance to the CTTS box version specification matters in your workflow.
         *        Specify a value of 1 to set your CTTS box version to 1 and make your output compliant with the
         *        specification. When you specify a value of 1, you must also set CSLG atom to the value INCLUDE. Keep
         *        the default value 0 to set your CTTS box version to 0. This can provide backward compatibility for
         *        some players and packagers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cttsVersion(Integer cttsVersion);

        /**
         * Inserts a free-space box immediately after the moov box.
         * 
         * @param freeSpaceBox
         *        Inserts a free-space box immediately after the moov box.
         * @see Mp4FreeSpaceBox
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Mp4FreeSpaceBox
         */
        Builder freeSpaceBox(String freeSpaceBox);

        /**
         * Inserts a free-space box immediately after the moov box.
         * 
         * @param freeSpaceBox
         *        Inserts a free-space box immediately after the moov box.
         * @see Mp4FreeSpaceBox
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Mp4FreeSpaceBox
         */
        Builder freeSpaceBox(Mp4FreeSpaceBox freeSpaceBox);

        /**
         * To place the MOOV atom at the beginning of your output, which is useful for progressive downloading: Leave
         * blank or choose Progressive download. To place the MOOV at the end of your output: Choose Normal.
         * 
         * @param moovPlacement
         *        To place the MOOV atom at the beginning of your output, which is useful for progressive downloading:
         *        Leave blank or choose Progressive download. To place the MOOV at the end of your output: Choose
         *        Normal.
         * @see Mp4MoovPlacement
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Mp4MoovPlacement
         */
        Builder moovPlacement(String moovPlacement);

        /**
         * To place the MOOV atom at the beginning of your output, which is useful for progressive downloading: Leave
         * blank or choose Progressive download. To place the MOOV at the end of your output: Choose Normal.
         * 
         * @param moovPlacement
         *        To place the MOOV atom at the beginning of your output, which is useful for progressive downloading:
         *        Leave blank or choose Progressive download. To place the MOOV at the end of your output: Choose
         *        Normal.
         * @see Mp4MoovPlacement
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Mp4MoovPlacement
         */
        Builder moovPlacement(Mp4MoovPlacement moovPlacement);

        /**
         * Overrides the "Major Brand" field in the output file. Usually not necessary to specify.
         * 
         * @param mp4MajorBrand
         *        Overrides the "Major Brand" field in the output file. Usually not necessary to specify.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mp4MajorBrand(String mp4MajorBrand);
    }

    static final class BuilderImpl implements Builder {
        private String audioDuration;

        private String cslgAtom;

        private Integer cttsVersion;

        private String freeSpaceBox;

        private String moovPlacement;

        private String mp4MajorBrand;

        private BuilderImpl() {
        }

        private BuilderImpl(Mp4Settings model) {
            audioDuration(model.audioDuration);
            cslgAtom(model.cslgAtom);
            cttsVersion(model.cttsVersion);
            freeSpaceBox(model.freeSpaceBox);
            moovPlacement(model.moovPlacement);
            mp4MajorBrand(model.mp4MajorBrand);
        }

        public final String getAudioDuration() {
            return audioDuration;
        }

        public final void setAudioDuration(String audioDuration) {
            this.audioDuration = audioDuration;
        }

        @Override
        public final Builder audioDuration(String audioDuration) {
            this.audioDuration = audioDuration;
            return this;
        }

        @Override
        public final Builder audioDuration(CmfcAudioDuration audioDuration) {
            this.audioDuration(audioDuration == null ? null : audioDuration.toString());
            return this;
        }

        public final String getCslgAtom() {
            return cslgAtom;
        }

        public final void setCslgAtom(String cslgAtom) {
            this.cslgAtom = cslgAtom;
        }

        @Override
        public final Builder cslgAtom(String cslgAtom) {
            this.cslgAtom = cslgAtom;
            return this;
        }

        @Override
        public final Builder cslgAtom(Mp4CslgAtom cslgAtom) {
            this.cslgAtom(cslgAtom == null ? null : cslgAtom.toString());
            return this;
        }

        public final Integer getCttsVersion() {
            return cttsVersion;
        }

        public final void setCttsVersion(Integer cttsVersion) {
            this.cttsVersion = cttsVersion;
        }

        @Override
        public final Builder cttsVersion(Integer cttsVersion) {
            this.cttsVersion = cttsVersion;
            return this;
        }

        public final String getFreeSpaceBox() {
            return freeSpaceBox;
        }

        public final void setFreeSpaceBox(String freeSpaceBox) {
            this.freeSpaceBox = freeSpaceBox;
        }

        @Override
        public final Builder freeSpaceBox(String freeSpaceBox) {
            this.freeSpaceBox = freeSpaceBox;
            return this;
        }

        @Override
        public final Builder freeSpaceBox(Mp4FreeSpaceBox freeSpaceBox) {
            this.freeSpaceBox(freeSpaceBox == null ? null : freeSpaceBox.toString());
            return this;
        }

        public final String getMoovPlacement() {
            return moovPlacement;
        }

        public final void setMoovPlacement(String moovPlacement) {
            this.moovPlacement = moovPlacement;
        }

        @Override
        public final Builder moovPlacement(String moovPlacement) {
            this.moovPlacement = moovPlacement;
            return this;
        }

        @Override
        public final Builder moovPlacement(Mp4MoovPlacement moovPlacement) {
            this.moovPlacement(moovPlacement == null ? null : moovPlacement.toString());
            return this;
        }

        public final String getMp4MajorBrand() {
            return mp4MajorBrand;
        }

        public final void setMp4MajorBrand(String mp4MajorBrand) {
            this.mp4MajorBrand = mp4MajorBrand;
        }

        @Override
        public final Builder mp4MajorBrand(String mp4MajorBrand) {
            this.mp4MajorBrand = mp4MajorBrand;
            return this;
        }

        @Override
        public Mp4Settings build() {
            return new Mp4Settings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
