/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Settings for a noise reducer filter
 */
@Generated("software.amazon.awssdk:codegen")
public final class NoiseReducerFilterSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<NoiseReducerFilterSettings.Builder, NoiseReducerFilterSettings> {
    private static final SdkField<Integer> STRENGTH_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Strength").getter(getter(NoiseReducerFilterSettings::strength)).setter(setter(Builder::strength))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("strength").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STRENGTH_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer strength;

    private NoiseReducerFilterSettings(BuilderImpl builder) {
        this.strength = builder.strength;
    }

    /**
     * Relative strength of noise reducing filter. Higher values produce stronger filtering.
     * 
     * @return Relative strength of noise reducing filter. Higher values produce stronger filtering.
     */
    public final Integer strength() {
        return strength;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(strength());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NoiseReducerFilterSettings)) {
            return false;
        }
        NoiseReducerFilterSettings other = (NoiseReducerFilterSettings) obj;
        return Objects.equals(strength(), other.strength());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("NoiseReducerFilterSettings").add("Strength", strength()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Strength":
            return Optional.ofNullable(clazz.cast(strength()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("strength", STRENGTH_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<NoiseReducerFilterSettings, T> g) {
        return obj -> g.apply((NoiseReducerFilterSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NoiseReducerFilterSettings> {
        /**
         * Relative strength of noise reducing filter. Higher values produce stronger filtering.
         * 
         * @param strength
         *        Relative strength of noise reducing filter. Higher values produce stronger filtering.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder strength(Integer strength);
    }

    static final class BuilderImpl implements Builder {
        private Integer strength;

        private BuilderImpl() {
        }

        private BuilderImpl(NoiseReducerFilterSettings model) {
            strength(model.strength);
        }

        public final Integer getStrength() {
            return strength;
        }

        public final void setStrength(Integer strength) {
            this.strength = strength;
        }

        @Override
        public final Builder strength(Integer strength) {
            this.strength = strength;
            return this;
        }

        @Override
        public NoiseReducerFilterSettings build() {
            return new NoiseReducerFilterSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
