/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

/**
 * Specify which SPEKE version 2.0 audio preset MediaConvert uses to request content keys from your SPEKE server. For
 * more information, see: https://docs.aws.amazon.com/mediaconvert/latest/ug/drm-content-speke-v2-presets.html To
 * encrypt to your audio outputs, choose from the following: Audio preset 1, Audio preset 2, or Audio preset 3. To
 * encrypt your audio outputs, using the same content key for both your audio and video outputs: Choose Shared. When you
 * do, you must also set SPEKE v2.0 video preset to Shared. To not encrypt your audio outputs: Choose Unencrypted. When
 * you do, to encrypt your video outputs, you must also specify a SPEKE v2.0 video preset (other than Shared or
 * Unencrypted).
 */
@Generated("software.amazon.awssdk:codegen")
public enum PresetSpeke20Audio {
    PRESET_AUDIO_1("PRESET_AUDIO_1"),

    PRESET_AUDIO_2("PRESET_AUDIO_2"),

    PRESET_AUDIO_3("PRESET_AUDIO_3"),

    SHARED("SHARED"),

    UNENCRYPTED("UNENCRYPTED"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, PresetSpeke20Audio> VALUE_MAP = EnumUtils.uniqueIndex(PresetSpeke20Audio.class,
            PresetSpeke20Audio::toString);

    private final String value;

    private PresetSpeke20Audio(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return PresetSpeke20Audio corresponding to the value
     */
    public static PresetSpeke20Audio fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link PresetSpeke20Audio}s
     */
    public static Set<PresetSpeke20Audio> knownValues() {
        Set<PresetSpeke20Audio> knownValues = EnumSet.allOf(PresetSpeke20Audio.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
