/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * You can use queues to manage the resources that are available to your AWS account for running multiple transcoding
 * jobs at the same time. If you don't specify a queue, the service sends all jobs through the default queue. For more
 * information, see https://docs.aws.amazon.com/mediaconvert/latest/ug/working-with-queues.html.
 */
@Generated("software.amazon.awssdk:codegen")
public final class Queue implements SdkPojo, Serializable, ToCopyableBuilder<Queue.Builder, Queue> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(Queue::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<Integer> CONCURRENT_JOBS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ConcurrentJobs").getter(getter(Queue::concurrentJobs)).setter(setter(Builder::concurrentJobs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("concurrentJobs").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedAt")
            .getter(getter(Queue::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.UNIX_TIMESTAMP)).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(Queue::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastUpdated")
            .getter(getter(Queue::lastUpdated))
            .setter(setter(Builder::lastUpdated))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdated").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.UNIX_TIMESTAMP)).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(Queue::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> PRICING_PLAN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PricingPlan").getter(getter(Queue::pricingPlanAsString)).setter(setter(Builder::pricingPlan))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pricingPlan").build()).build();

    private static final SdkField<Integer> PROGRESSING_JOBS_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ProgressingJobsCount").getter(getter(Queue::progressingJobsCount))
            .setter(setter(Builder::progressingJobsCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("progressingJobsCount").build())
            .build();

    private static final SdkField<ReservationPlan> RESERVATION_PLAN_FIELD = SdkField
            .<ReservationPlan> builder(MarshallingType.SDK_POJO).memberName("ReservationPlan")
            .getter(getter(Queue::reservationPlan)).setter(setter(Builder::reservationPlan))
            .constructor(ReservationPlan::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reservationPlan").build()).build();

    private static final SdkField<List<ServiceOverride>> SERVICE_OVERRIDES_FIELD = SdkField
            .<List<ServiceOverride>> builder(MarshallingType.LIST)
            .memberName("ServiceOverrides")
            .getter(getter(Queue::serviceOverrides))
            .setter(setter(Builder::serviceOverrides))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceOverrides").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ServiceOverride> builder(MarshallingType.SDK_POJO)
                                            .constructor(ServiceOverride::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(Queue::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<Integer> SUBMITTED_JOBS_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("SubmittedJobsCount").getter(getter(Queue::submittedJobsCount))
            .setter(setter(Builder::submittedJobsCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("submittedJobsCount").build())
            .build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(Queue::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD,
            CONCURRENT_JOBS_FIELD, CREATED_AT_FIELD, DESCRIPTION_FIELD, LAST_UPDATED_FIELD, NAME_FIELD, PRICING_PLAN_FIELD,
            PROGRESSING_JOBS_COUNT_FIELD, RESERVATION_PLAN_FIELD, SERVICE_OVERRIDES_FIELD, STATUS_FIELD,
            SUBMITTED_JOBS_COUNT_FIELD, TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final Integer concurrentJobs;

    private final Instant createdAt;

    private final String description;

    private final Instant lastUpdated;

    private final String name;

    private final String pricingPlan;

    private final Integer progressingJobsCount;

    private final ReservationPlan reservationPlan;

    private final List<ServiceOverride> serviceOverrides;

    private final String status;

    private final Integer submittedJobsCount;

    private final String type;

    private Queue(BuilderImpl builder) {
        this.arn = builder.arn;
        this.concurrentJobs = builder.concurrentJobs;
        this.createdAt = builder.createdAt;
        this.description = builder.description;
        this.lastUpdated = builder.lastUpdated;
        this.name = builder.name;
        this.pricingPlan = builder.pricingPlan;
        this.progressingJobsCount = builder.progressingJobsCount;
        this.reservationPlan = builder.reservationPlan;
        this.serviceOverrides = builder.serviceOverrides;
        this.status = builder.status;
        this.submittedJobsCount = builder.submittedJobsCount;
        this.type = builder.type;
    }

    /**
     * An identifier for this resource that is unique within all of AWS.
     * 
     * @return An identifier for this resource that is unique within all of AWS.
     */
    public final String arn() {
        return arn;
    }

    /**
     * The maximum number of jobs your queue can process concurrently.
     * 
     * @return The maximum number of jobs your queue can process concurrently.
     */
    public final Integer concurrentJobs() {
        return concurrentJobs;
    }

    /**
     * The timestamp in epoch seconds for when you created the queue.
     * 
     * @return The timestamp in epoch seconds for when you created the queue.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * An optional description that you create for each queue.
     * 
     * @return An optional description that you create for each queue.
     */
    public final String description() {
        return description;
    }

    /**
     * The timestamp in epoch seconds for when you most recently updated the queue.
     * 
     * @return The timestamp in epoch seconds for when you most recently updated the queue.
     */
    public final Instant lastUpdated() {
        return lastUpdated;
    }

    /**
     * A name that you create for each queue. Each name must be unique within your account.
     * 
     * @return A name that you create for each queue. Each name must be unique within your account.
     */
    public final String name() {
        return name;
    }

    /**
     * Specifies whether the pricing plan for the queue is on-demand or reserved. For on-demand, you pay per minute,
     * billed in increments of .01 minute. For reserved, you pay for the transcoding capacity of the entire queue,
     * regardless of how much or how little you use it. Reserved pricing requires a 12-month commitment.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #pricingPlan} will
     * return {@link PricingPlan#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #pricingPlanAsString}.
     * </p>
     * 
     * @return Specifies whether the pricing plan for the queue is on-demand or reserved. For on-demand, you pay per
     *         minute, billed in increments of .01 minute. For reserved, you pay for the transcoding capacity of the
     *         entire queue, regardless of how much or how little you use it. Reserved pricing requires a 12-month
     *         commitment.
     * @see PricingPlan
     */
    public final PricingPlan pricingPlan() {
        return PricingPlan.fromValue(pricingPlan);
    }

    /**
     * Specifies whether the pricing plan for the queue is on-demand or reserved. For on-demand, you pay per minute,
     * billed in increments of .01 minute. For reserved, you pay for the transcoding capacity of the entire queue,
     * regardless of how much or how little you use it. Reserved pricing requires a 12-month commitment.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #pricingPlan} will
     * return {@link PricingPlan#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #pricingPlanAsString}.
     * </p>
     * 
     * @return Specifies whether the pricing plan for the queue is on-demand or reserved. For on-demand, you pay per
     *         minute, billed in increments of .01 minute. For reserved, you pay for the transcoding capacity of the
     *         entire queue, regardless of how much or how little you use it. Reserved pricing requires a 12-month
     *         commitment.
     * @see PricingPlan
     */
    public final String pricingPlanAsString() {
        return pricingPlan;
    }

    /**
     * The estimated number of jobs with a PROGRESSING status.
     * 
     * @return The estimated number of jobs with a PROGRESSING status.
     */
    public final Integer progressingJobsCount() {
        return progressingJobsCount;
    }

    /**
     * Details about the pricing plan for your reserved queue. Required for reserved queues and not applicable to
     * on-demand queues.
     * 
     * @return Details about the pricing plan for your reserved queue. Required for reserved queues and not applicable
     *         to on-demand queues.
     */
    public final ReservationPlan reservationPlan() {
        return reservationPlan;
    }

    /**
     * For responses, this returns true if the service returned a value for the ServiceOverrides property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasServiceOverrides() {
        return serviceOverrides != null && !(serviceOverrides instanceof SdkAutoConstructList);
    }

    /**
     * A list of any service overrides applied by MediaConvert to the settings that you have configured. If you see any
     * overrides, we recommend that you contact AWS Support.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasServiceOverrides} method.
     * </p>
     * 
     * @return A list of any service overrides applied by MediaConvert to the settings that you have configured. If you
     *         see any overrides, we recommend that you contact AWS Support.
     */
    public final List<ServiceOverride> serviceOverrides() {
        return serviceOverrides;
    }

    /**
     * Queues can be ACTIVE or PAUSED. If you pause a queue, the service won't begin processing jobs in that queue. Jobs
     * that are running when you pause the queue continue to run until they finish or result in an error.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link QueueStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return Queues can be ACTIVE or PAUSED. If you pause a queue, the service won't begin processing jobs in that
     *         queue. Jobs that are running when you pause the queue continue to run until they finish or result in an
     *         error.
     * @see QueueStatus
     */
    public final QueueStatus status() {
        return QueueStatus.fromValue(status);
    }

    /**
     * Queues can be ACTIVE or PAUSED. If you pause a queue, the service won't begin processing jobs in that queue. Jobs
     * that are running when you pause the queue continue to run until they finish or result in an error.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link QueueStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return Queues can be ACTIVE or PAUSED. If you pause a queue, the service won't begin processing jobs in that
     *         queue. Jobs that are running when you pause the queue continue to run until they finish or result in an
     *         error.
     * @see QueueStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * The estimated number of jobs with a SUBMITTED status.
     * 
     * @return The estimated number of jobs with a SUBMITTED status.
     */
    public final Integer submittedJobsCount() {
        return submittedJobsCount;
    }

    /**
     * Specifies whether this on-demand queue is system or custom. System queues are built in. You can't modify or
     * delete system queues. You can create and modify custom queues.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link Type#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return Specifies whether this on-demand queue is system or custom. System queues are built in. You can't modify
     *         or delete system queues. You can create and modify custom queues.
     * @see Type
     */
    public final Type type() {
        return Type.fromValue(type);
    }

    /**
     * Specifies whether this on-demand queue is system or custom. System queues are built in. You can't modify or
     * delete system queues. You can create and modify custom queues.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link Type#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return Specifies whether this on-demand queue is system or custom. System queues are built in. You can't modify
     *         or delete system queues. You can create and modify custom queues.
     * @see Type
     */
    public final String typeAsString() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(concurrentJobs());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdated());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(pricingPlanAsString());
        hashCode = 31 * hashCode + Objects.hashCode(progressingJobsCount());
        hashCode = 31 * hashCode + Objects.hashCode(reservationPlan());
        hashCode = 31 * hashCode + Objects.hashCode(hasServiceOverrides() ? serviceOverrides() : null);
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(submittedJobsCount());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Queue)) {
            return false;
        }
        Queue other = (Queue) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(concurrentJobs(), other.concurrentJobs())
                && Objects.equals(createdAt(), other.createdAt()) && Objects.equals(description(), other.description())
                && Objects.equals(lastUpdated(), other.lastUpdated()) && Objects.equals(name(), other.name())
                && Objects.equals(pricingPlanAsString(), other.pricingPlanAsString())
                && Objects.equals(progressingJobsCount(), other.progressingJobsCount())
                && Objects.equals(reservationPlan(), other.reservationPlan())
                && hasServiceOverrides() == other.hasServiceOverrides()
                && Objects.equals(serviceOverrides(), other.serviceOverrides())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(submittedJobsCount(), other.submittedJobsCount())
                && Objects.equals(typeAsString(), other.typeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Queue").add("Arn", arn()).add("ConcurrentJobs", concurrentJobs()).add("CreatedAt", createdAt())
                .add("Description", description()).add("LastUpdated", lastUpdated()).add("Name", name())
                .add("PricingPlan", pricingPlanAsString()).add("ProgressingJobsCount", progressingJobsCount())
                .add("ReservationPlan", reservationPlan())
                .add("ServiceOverrides", hasServiceOverrides() ? serviceOverrides() : null).add("Status", statusAsString())
                .add("SubmittedJobsCount", submittedJobsCount()).add("Type", typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "ConcurrentJobs":
            return Optional.ofNullable(clazz.cast(concurrentJobs()));
        case "CreatedAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "LastUpdated":
            return Optional.ofNullable(clazz.cast(lastUpdated()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "PricingPlan":
            return Optional.ofNullable(clazz.cast(pricingPlanAsString()));
        case "ProgressingJobsCount":
            return Optional.ofNullable(clazz.cast(progressingJobsCount()));
        case "ReservationPlan":
            return Optional.ofNullable(clazz.cast(reservationPlan()));
        case "ServiceOverrides":
            return Optional.ofNullable(clazz.cast(serviceOverrides()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "SubmittedJobsCount":
            return Optional.ofNullable(clazz.cast(submittedJobsCount()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("arn", ARN_FIELD);
        map.put("concurrentJobs", CONCURRENT_JOBS_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("lastUpdated", LAST_UPDATED_FIELD);
        map.put("name", NAME_FIELD);
        map.put("pricingPlan", PRICING_PLAN_FIELD);
        map.put("progressingJobsCount", PROGRESSING_JOBS_COUNT_FIELD);
        map.put("reservationPlan", RESERVATION_PLAN_FIELD);
        map.put("serviceOverrides", SERVICE_OVERRIDES_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("submittedJobsCount", SUBMITTED_JOBS_COUNT_FIELD);
        map.put("type", TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Queue, T> g) {
        return obj -> g.apply((Queue) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Queue> {
        /**
         * An identifier for this resource that is unique within all of AWS.
         * 
         * @param arn
         *        An identifier for this resource that is unique within all of AWS.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * The maximum number of jobs your queue can process concurrently.
         * 
         * @param concurrentJobs
         *        The maximum number of jobs your queue can process concurrently.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder concurrentJobs(Integer concurrentJobs);

        /**
         * The timestamp in epoch seconds for when you created the queue.
         * 
         * @param createdAt
         *        The timestamp in epoch seconds for when you created the queue.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * An optional description that you create for each queue.
         * 
         * @param description
         *        An optional description that you create for each queue.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * The timestamp in epoch seconds for when you most recently updated the queue.
         * 
         * @param lastUpdated
         *        The timestamp in epoch seconds for when you most recently updated the queue.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdated(Instant lastUpdated);

        /**
         * A name that you create for each queue. Each name must be unique within your account.
         * 
         * @param name
         *        A name that you create for each queue. Each name must be unique within your account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * Specifies whether the pricing plan for the queue is on-demand or reserved. For on-demand, you pay per minute,
         * billed in increments of .01 minute. For reserved, you pay for the transcoding capacity of the entire queue,
         * regardless of how much or how little you use it. Reserved pricing requires a 12-month commitment.
         * 
         * @param pricingPlan
         *        Specifies whether the pricing plan for the queue is on-demand or reserved. For on-demand, you pay per
         *        minute, billed in increments of .01 minute. For reserved, you pay for the transcoding capacity of the
         *        entire queue, regardless of how much or how little you use it. Reserved pricing requires a 12-month
         *        commitment.
         * @see PricingPlan
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PricingPlan
         */
        Builder pricingPlan(String pricingPlan);

        /**
         * Specifies whether the pricing plan for the queue is on-demand or reserved. For on-demand, you pay per minute,
         * billed in increments of .01 minute. For reserved, you pay for the transcoding capacity of the entire queue,
         * regardless of how much or how little you use it. Reserved pricing requires a 12-month commitment.
         * 
         * @param pricingPlan
         *        Specifies whether the pricing plan for the queue is on-demand or reserved. For on-demand, you pay per
         *        minute, billed in increments of .01 minute. For reserved, you pay for the transcoding capacity of the
         *        entire queue, regardless of how much or how little you use it. Reserved pricing requires a 12-month
         *        commitment.
         * @see PricingPlan
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PricingPlan
         */
        Builder pricingPlan(PricingPlan pricingPlan);

        /**
         * The estimated number of jobs with a PROGRESSING status.
         * 
         * @param progressingJobsCount
         *        The estimated number of jobs with a PROGRESSING status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder progressingJobsCount(Integer progressingJobsCount);

        /**
         * Details about the pricing plan for your reserved queue. Required for reserved queues and not applicable to
         * on-demand queues.
         * 
         * @param reservationPlan
         *        Details about the pricing plan for your reserved queue. Required for reserved queues and not
         *        applicable to on-demand queues.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reservationPlan(ReservationPlan reservationPlan);

        /**
         * Details about the pricing plan for your reserved queue. Required for reserved queues and not applicable to
         * on-demand queues. This is a convenience method that creates an instance of the
         * {@link ReservationPlan.Builder} avoiding the need to create one manually via
         * {@link ReservationPlan#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ReservationPlan.Builder#build()} is called immediately and its
         * result is passed to {@link #reservationPlan(ReservationPlan)}.
         * 
         * @param reservationPlan
         *        a consumer that will call methods on {@link ReservationPlan.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #reservationPlan(ReservationPlan)
         */
        default Builder reservationPlan(Consumer<ReservationPlan.Builder> reservationPlan) {
            return reservationPlan(ReservationPlan.builder().applyMutation(reservationPlan).build());
        }

        /**
         * A list of any service overrides applied by MediaConvert to the settings that you have configured. If you see
         * any overrides, we recommend that you contact AWS Support.
         * 
         * @param serviceOverrides
         *        A list of any service overrides applied by MediaConvert to the settings that you have configured. If
         *        you see any overrides, we recommend that you contact AWS Support.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceOverrides(Collection<ServiceOverride> serviceOverrides);

        /**
         * A list of any service overrides applied by MediaConvert to the settings that you have configured. If you see
         * any overrides, we recommend that you contact AWS Support.
         * 
         * @param serviceOverrides
         *        A list of any service overrides applied by MediaConvert to the settings that you have configured. If
         *        you see any overrides, we recommend that you contact AWS Support.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceOverrides(ServiceOverride... serviceOverrides);

        /**
         * A list of any service overrides applied by MediaConvert to the settings that you have configured. If you see
         * any overrides, we recommend that you contact AWS Support. This is a convenience method that creates an
         * instance of the {@link software.amazon.awssdk.services.mediaconvert.model.ServiceOverride.Builder} avoiding
         * the need to create one manually via
         * {@link software.amazon.awssdk.services.mediaconvert.model.ServiceOverride#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.mediaconvert.model.ServiceOverride.Builder#build()} is called
         * immediately and its result is passed to {@link #serviceOverrides(List<ServiceOverride>)}.
         * 
         * @param serviceOverrides
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.mediaconvert.model.ServiceOverride.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #serviceOverrides(java.util.Collection<ServiceOverride>)
         */
        Builder serviceOverrides(Consumer<ServiceOverride.Builder>... serviceOverrides);

        /**
         * Queues can be ACTIVE or PAUSED. If you pause a queue, the service won't begin processing jobs in that queue.
         * Jobs that are running when you pause the queue continue to run until they finish or result in an error.
         * 
         * @param status
         *        Queues can be ACTIVE or PAUSED. If you pause a queue, the service won't begin processing jobs in that
         *        queue. Jobs that are running when you pause the queue continue to run until they finish or result in
         *        an error.
         * @see QueueStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see QueueStatus
         */
        Builder status(String status);

        /**
         * Queues can be ACTIVE or PAUSED. If you pause a queue, the service won't begin processing jobs in that queue.
         * Jobs that are running when you pause the queue continue to run until they finish or result in an error.
         * 
         * @param status
         *        Queues can be ACTIVE or PAUSED. If you pause a queue, the service won't begin processing jobs in that
         *        queue. Jobs that are running when you pause the queue continue to run until they finish or result in
         *        an error.
         * @see QueueStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see QueueStatus
         */
        Builder status(QueueStatus status);

        /**
         * The estimated number of jobs with a SUBMITTED status.
         * 
         * @param submittedJobsCount
         *        The estimated number of jobs with a SUBMITTED status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder submittedJobsCount(Integer submittedJobsCount);

        /**
         * Specifies whether this on-demand queue is system or custom. System queues are built in. You can't modify or
         * delete system queues. You can create and modify custom queues.
         * 
         * @param type
         *        Specifies whether this on-demand queue is system or custom. System queues are built in. You can't
         *        modify or delete system queues. You can create and modify custom queues.
         * @see Type
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Type
         */
        Builder type(String type);

        /**
         * Specifies whether this on-demand queue is system or custom. System queues are built in. You can't modify or
         * delete system queues. You can create and modify custom queues.
         * 
         * @param type
         *        Specifies whether this on-demand queue is system or custom. System queues are built in. You can't
         *        modify or delete system queues. You can create and modify custom queues.
         * @see Type
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Type
         */
        Builder type(Type type);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private Integer concurrentJobs;

        private Instant createdAt;

        private String description;

        private Instant lastUpdated;

        private String name;

        private String pricingPlan;

        private Integer progressingJobsCount;

        private ReservationPlan reservationPlan;

        private List<ServiceOverride> serviceOverrides = DefaultSdkAutoConstructList.getInstance();

        private String status;

        private Integer submittedJobsCount;

        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(Queue model) {
            arn(model.arn);
            concurrentJobs(model.concurrentJobs);
            createdAt(model.createdAt);
            description(model.description);
            lastUpdated(model.lastUpdated);
            name(model.name);
            pricingPlan(model.pricingPlan);
            progressingJobsCount(model.progressingJobsCount);
            reservationPlan(model.reservationPlan);
            serviceOverrides(model.serviceOverrides);
            status(model.status);
            submittedJobsCount(model.submittedJobsCount);
            type(model.type);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Integer getConcurrentJobs() {
            return concurrentJobs;
        }

        public final void setConcurrentJobs(Integer concurrentJobs) {
            this.concurrentJobs = concurrentJobs;
        }

        @Override
        public final Builder concurrentJobs(Integer concurrentJobs) {
            this.concurrentJobs = concurrentJobs;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Instant getLastUpdated() {
            return lastUpdated;
        }

        public final void setLastUpdated(Instant lastUpdated) {
            this.lastUpdated = lastUpdated;
        }

        @Override
        public final Builder lastUpdated(Instant lastUpdated) {
            this.lastUpdated = lastUpdated;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getPricingPlan() {
            return pricingPlan;
        }

        public final void setPricingPlan(String pricingPlan) {
            this.pricingPlan = pricingPlan;
        }

        @Override
        public final Builder pricingPlan(String pricingPlan) {
            this.pricingPlan = pricingPlan;
            return this;
        }

        @Override
        public final Builder pricingPlan(PricingPlan pricingPlan) {
            this.pricingPlan(pricingPlan == null ? null : pricingPlan.toString());
            return this;
        }

        public final Integer getProgressingJobsCount() {
            return progressingJobsCount;
        }

        public final void setProgressingJobsCount(Integer progressingJobsCount) {
            this.progressingJobsCount = progressingJobsCount;
        }

        @Override
        public final Builder progressingJobsCount(Integer progressingJobsCount) {
            this.progressingJobsCount = progressingJobsCount;
            return this;
        }

        public final ReservationPlan.Builder getReservationPlan() {
            return reservationPlan != null ? reservationPlan.toBuilder() : null;
        }

        public final void setReservationPlan(ReservationPlan.BuilderImpl reservationPlan) {
            this.reservationPlan = reservationPlan != null ? reservationPlan.build() : null;
        }

        @Override
        public final Builder reservationPlan(ReservationPlan reservationPlan) {
            this.reservationPlan = reservationPlan;
            return this;
        }

        public final List<ServiceOverride.Builder> getServiceOverrides() {
            List<ServiceOverride.Builder> result = ___listOfServiceOverrideCopier.copyToBuilder(this.serviceOverrides);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setServiceOverrides(Collection<ServiceOverride.BuilderImpl> serviceOverrides) {
            this.serviceOverrides = ___listOfServiceOverrideCopier.copyFromBuilder(serviceOverrides);
        }

        @Override
        public final Builder serviceOverrides(Collection<ServiceOverride> serviceOverrides) {
            this.serviceOverrides = ___listOfServiceOverrideCopier.copy(serviceOverrides);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceOverrides(ServiceOverride... serviceOverrides) {
            serviceOverrides(Arrays.asList(serviceOverrides));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceOverrides(Consumer<ServiceOverride.Builder>... serviceOverrides) {
            serviceOverrides(Stream.of(serviceOverrides).map(c -> ServiceOverride.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(QueueStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Integer getSubmittedJobsCount() {
            return submittedJobsCount;
        }

        public final void setSubmittedJobsCount(Integer submittedJobsCount) {
            this.submittedJobsCount = submittedJobsCount;
        }

        @Override
        public final Builder submittedJobsCount(Integer submittedJobsCount) {
            this.submittedJobsCount = submittedJobsCount;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(Type type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        @Override
        public Queue build() {
            return new Queue(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
