/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Use Rectangle to identify a specific area of the video frame.
 */
@Generated("software.amazon.awssdk:codegen")
public final class Rectangle implements SdkPojo, Serializable, ToCopyableBuilder<Rectangle.Builder, Rectangle> {
    private static final SdkField<Integer> HEIGHT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Height").getter(getter(Rectangle::height)).setter(setter(Builder::height))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("height").build()).build();

    private static final SdkField<Integer> WIDTH_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Width")
            .getter(getter(Rectangle::width)).setter(setter(Builder::width))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("width").build()).build();

    private static final SdkField<Integer> X_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("X")
            .getter(getter(Rectangle::x)).setter(setter(Builder::x))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("x").build()).build();

    private static final SdkField<Integer> Y_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Y")
            .getter(getter(Rectangle::y)).setter(setter(Builder::y))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("y").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HEIGHT_FIELD, WIDTH_FIELD,
            X_FIELD, Y_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer height;

    private final Integer width;

    private final Integer x;

    private final Integer y;

    private Rectangle(BuilderImpl builder) {
        this.height = builder.height;
        this.width = builder.width;
        this.x = builder.x;
        this.y = builder.y;
    }

    /**
     * Height of rectangle in pixels. Specify only even numbers.
     * 
     * @return Height of rectangle in pixels. Specify only even numbers.
     */
    public final Integer height() {
        return height;
    }

    /**
     * Width of rectangle in pixels. Specify only even numbers.
     * 
     * @return Width of rectangle in pixels. Specify only even numbers.
     */
    public final Integer width() {
        return width;
    }

    /**
     * The distance, in pixels, between the rectangle and the left edge of the video frame. Specify only even numbers.
     * 
     * @return The distance, in pixels, between the rectangle and the left edge of the video frame. Specify only even
     *         numbers.
     */
    public final Integer x() {
        return x;
    }

    /**
     * The distance, in pixels, between the rectangle and the top edge of the video frame. Specify only even numbers.
     * 
     * @return The distance, in pixels, between the rectangle and the top edge of the video frame. Specify only even
     *         numbers.
     */
    public final Integer y() {
        return y;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(height());
        hashCode = 31 * hashCode + Objects.hashCode(width());
        hashCode = 31 * hashCode + Objects.hashCode(x());
        hashCode = 31 * hashCode + Objects.hashCode(y());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Rectangle)) {
            return false;
        }
        Rectangle other = (Rectangle) obj;
        return Objects.equals(height(), other.height()) && Objects.equals(width(), other.width())
                && Objects.equals(x(), other.x()) && Objects.equals(y(), other.y());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Rectangle").add("Height", height()).add("Width", width()).add("X", x()).add("Y", y()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Height":
            return Optional.ofNullable(clazz.cast(height()));
        case "Width":
            return Optional.ofNullable(clazz.cast(width()));
        case "X":
            return Optional.ofNullable(clazz.cast(x()));
        case "Y":
            return Optional.ofNullable(clazz.cast(y()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("height", HEIGHT_FIELD);
        map.put("width", WIDTH_FIELD);
        map.put("x", X_FIELD);
        map.put("y", Y_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Rectangle, T> g) {
        return obj -> g.apply((Rectangle) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Rectangle> {
        /**
         * Height of rectangle in pixels. Specify only even numbers.
         * 
         * @param height
         *        Height of rectangle in pixels. Specify only even numbers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder height(Integer height);

        /**
         * Width of rectangle in pixels. Specify only even numbers.
         * 
         * @param width
         *        Width of rectangle in pixels. Specify only even numbers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder width(Integer width);

        /**
         * The distance, in pixels, between the rectangle and the left edge of the video frame. Specify only even
         * numbers.
         * 
         * @param x
         *        The distance, in pixels, between the rectangle and the left edge of the video frame. Specify only even
         *        numbers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder x(Integer x);

        /**
         * The distance, in pixels, between the rectangle and the top edge of the video frame. Specify only even
         * numbers.
         * 
         * @param y
         *        The distance, in pixels, between the rectangle and the top edge of the video frame. Specify only even
         *        numbers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder y(Integer y);
    }

    static final class BuilderImpl implements Builder {
        private Integer height;

        private Integer width;

        private Integer x;

        private Integer y;

        private BuilderImpl() {
        }

        private BuilderImpl(Rectangle model) {
            height(model.height);
            width(model.width);
            x(model.x);
            y(model.y);
        }

        public final Integer getHeight() {
            return height;
        }

        public final void setHeight(Integer height) {
            this.height = height;
        }

        @Override
        public final Builder height(Integer height) {
            this.height = height;
            return this;
        }

        public final Integer getWidth() {
            return width;
        }

        public final void setWidth(Integer width) {
            this.width = width;
        }

        @Override
        public final Builder width(Integer width) {
            this.width = width;
            return this;
        }

        public final Integer getX() {
            return x;
        }

        public final void setX(Integer x) {
            this.x = x;
        }

        @Override
        public final Builder x(Integer x) {
            this.x = x;
            return this;
        }

        public final Integer getY() {
            return y;
        }

        public final void setY(Integer y) {
            this.y = y;
        }

        @Override
        public final Builder y(Integer y) {
            this.y = y;
            return this;
        }

        @Override
        public Rectangle build() {
            return new Rectangle(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
