/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Use Manual audio remixing to adjust audio levels for each audio channel in each output of your job. With audio
 * remixing, you can output more or fewer audio channels than your input audio source provides.
 */
@Generated("software.amazon.awssdk:codegen")
public final class RemixSettings implements SdkPojo, Serializable, ToCopyableBuilder<RemixSettings.Builder, RemixSettings> {
    private static final SdkField<Integer> AUDIO_DESCRIPTION_AUDIO_CHANNEL_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("AudioDescriptionAudioChannel")
            .getter(getter(RemixSettings::audioDescriptionAudioChannel))
            .setter(setter(Builder::audioDescriptionAudioChannel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("audioDescriptionAudioChannel")
                    .build()).build();

    private static final SdkField<Integer> AUDIO_DESCRIPTION_DATA_CHANNEL_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("AudioDescriptionDataChannel")
            .getter(getter(RemixSettings::audioDescriptionDataChannel))
            .setter(setter(Builder::audioDescriptionDataChannel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("audioDescriptionDataChannel")
                    .build()).build();

    private static final SdkField<ChannelMapping> CHANNEL_MAPPING_FIELD = SdkField
            .<ChannelMapping> builder(MarshallingType.SDK_POJO).memberName("ChannelMapping")
            .getter(getter(RemixSettings::channelMapping)).setter(setter(Builder::channelMapping))
            .constructor(ChannelMapping::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("channelMapping").build()).build();

    private static final SdkField<Integer> CHANNELS_IN_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ChannelsIn").getter(getter(RemixSettings::channelsIn)).setter(setter(Builder::channelsIn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("channelsIn").build()).build();

    private static final SdkField<Integer> CHANNELS_OUT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ChannelsOut").getter(getter(RemixSettings::channelsOut)).setter(setter(Builder::channelsOut))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("channelsOut").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            AUDIO_DESCRIPTION_AUDIO_CHANNEL_FIELD, AUDIO_DESCRIPTION_DATA_CHANNEL_FIELD, CHANNEL_MAPPING_FIELD,
            CHANNELS_IN_FIELD, CHANNELS_OUT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer audioDescriptionAudioChannel;

    private final Integer audioDescriptionDataChannel;

    private final ChannelMapping channelMapping;

    private final Integer channelsIn;

    private final Integer channelsOut;

    private RemixSettings(BuilderImpl builder) {
        this.audioDescriptionAudioChannel = builder.audioDescriptionAudioChannel;
        this.audioDescriptionDataChannel = builder.audioDescriptionDataChannel;
        this.channelMapping = builder.channelMapping;
        this.channelsIn = builder.channelsIn;
        this.channelsOut = builder.channelsOut;
    }

    /**
     * Optionally specify the channel in your input that contains your audio description audio signal. MediaConvert
     * mixes your audio signal across all output channels, while reducing their volume according to your data stream.
     * When you specify an audio description audio channel, you must also specify an audio description data channel. For
     * more information about audio description signals, see the BBC WHP 198 and 051 white papers.
     * 
     * @return Optionally specify the channel in your input that contains your audio description audio signal.
     *         MediaConvert mixes your audio signal across all output channels, while reducing their volume according to
     *         your data stream. When you specify an audio description audio channel, you must also specify an audio
     *         description data channel. For more information about audio description signals, see the BBC WHP 198 and
     *         051 white papers.
     */
    public final Integer audioDescriptionAudioChannel() {
        return audioDescriptionAudioChannel;
    }

    /**
     * Optionally specify the channel in your input that contains your audio description data stream. MediaConvert mixes
     * your audio signal across all output channels, while reducing their volume according to your data stream. When you
     * specify an audio description data channel, you must also specify an audio description audio channel. For more
     * information about audio description signals, see the BBC WHP 198 and 051 white papers.
     * 
     * @return Optionally specify the channel in your input that contains your audio description data stream.
     *         MediaConvert mixes your audio signal across all output channels, while reducing their volume according to
     *         your data stream. When you specify an audio description data channel, you must also specify an audio
     *         description audio channel. For more information about audio description signals, see the BBC WHP 198 and
     *         051 white papers.
     */
    public final Integer audioDescriptionDataChannel() {
        return audioDescriptionDataChannel;
    }

    /**
     * Channel mapping contains the group of fields that hold the remixing value for each channel, in dB. Specify remix
     * values to indicate how much of the content from your input audio channel you want in your output audio channels.
     * Each instance of the InputChannels or InputChannelsFineTune array specifies these values for one output channel.
     * Use one instance of this array for each output channel. In the console, each array corresponds to a column in the
     * graphical depiction of the mapping matrix. The rows of the graphical matrix correspond to input channels. Valid
     * values are within the range from -60 (mute) through 6. A setting of 0 passes the input channel unchanged to the
     * output channel (no attenuation or amplification). Use InputChannels or InputChannelsFineTune to specify your
     * remix values. Don't use both.
     * 
     * @return Channel mapping contains the group of fields that hold the remixing value for each channel, in dB.
     *         Specify remix values to indicate how much of the content from your input audio channel you want in your
     *         output audio channels. Each instance of the InputChannels or InputChannelsFineTune array specifies these
     *         values for one output channel. Use one instance of this array for each output channel. In the console,
     *         each array corresponds to a column in the graphical depiction of the mapping matrix. The rows of the
     *         graphical matrix correspond to input channels. Valid values are within the range from -60 (mute) through
     *         6. A setting of 0 passes the input channel unchanged to the output channel (no attenuation or
     *         amplification). Use InputChannels or InputChannelsFineTune to specify your remix values. Don't use both.
     */
    public final ChannelMapping channelMapping() {
        return channelMapping;
    }

    /**
     * Specify the number of audio channels from your input that you want to use in your output. With remixing, you
     * might combine or split the data in these channels, so the number of channels in your final output might be
     * different. If you are doing both input channel mapping and output channel mapping, the number of output channels
     * in your input mapping must be the same as the number of input channels in your output mapping.
     * 
     * @return Specify the number of audio channels from your input that you want to use in your output. With remixing,
     *         you might combine or split the data in these channels, so the number of channels in your final output
     *         might be different. If you are doing both input channel mapping and output channel mapping, the number of
     *         output channels in your input mapping must be the same as the number of input channels in your output
     *         mapping.
     */
    public final Integer channelsIn() {
        return channelsIn;
    }

    /**
     * Specify the number of channels in this output after remixing. Valid values: 1, 2, 4, 6, 8... 64. (1 and even
     * numbers to 64.) If you are doing both input channel mapping and output channel mapping, the number of output
     * channels in your input mapping must be the same as the number of input channels in your output mapping.
     * 
     * @return Specify the number of channels in this output after remixing. Valid values: 1, 2, 4, 6, 8... 64. (1 and
     *         even numbers to 64.) If you are doing both input channel mapping and output channel mapping, the number
     *         of output channels in your input mapping must be the same as the number of input channels in your output
     *         mapping.
     */
    public final Integer channelsOut() {
        return channelsOut;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(audioDescriptionAudioChannel());
        hashCode = 31 * hashCode + Objects.hashCode(audioDescriptionDataChannel());
        hashCode = 31 * hashCode + Objects.hashCode(channelMapping());
        hashCode = 31 * hashCode + Objects.hashCode(channelsIn());
        hashCode = 31 * hashCode + Objects.hashCode(channelsOut());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RemixSettings)) {
            return false;
        }
        RemixSettings other = (RemixSettings) obj;
        return Objects.equals(audioDescriptionAudioChannel(), other.audioDescriptionAudioChannel())
                && Objects.equals(audioDescriptionDataChannel(), other.audioDescriptionDataChannel())
                && Objects.equals(channelMapping(), other.channelMapping()) && Objects.equals(channelsIn(), other.channelsIn())
                && Objects.equals(channelsOut(), other.channelsOut());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RemixSettings").add("AudioDescriptionAudioChannel", audioDescriptionAudioChannel())
                .add("AudioDescriptionDataChannel", audioDescriptionDataChannel()).add("ChannelMapping", channelMapping())
                .add("ChannelsIn", channelsIn()).add("ChannelsOut", channelsOut()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AudioDescriptionAudioChannel":
            return Optional.ofNullable(clazz.cast(audioDescriptionAudioChannel()));
        case "AudioDescriptionDataChannel":
            return Optional.ofNullable(clazz.cast(audioDescriptionDataChannel()));
        case "ChannelMapping":
            return Optional.ofNullable(clazz.cast(channelMapping()));
        case "ChannelsIn":
            return Optional.ofNullable(clazz.cast(channelsIn()));
        case "ChannelsOut":
            return Optional.ofNullable(clazz.cast(channelsOut()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("audioDescriptionAudioChannel", AUDIO_DESCRIPTION_AUDIO_CHANNEL_FIELD);
        map.put("audioDescriptionDataChannel", AUDIO_DESCRIPTION_DATA_CHANNEL_FIELD);
        map.put("channelMapping", CHANNEL_MAPPING_FIELD);
        map.put("channelsIn", CHANNELS_IN_FIELD);
        map.put("channelsOut", CHANNELS_OUT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RemixSettings, T> g) {
        return obj -> g.apply((RemixSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RemixSettings> {
        /**
         * Optionally specify the channel in your input that contains your audio description audio signal. MediaConvert
         * mixes your audio signal across all output channels, while reducing their volume according to your data
         * stream. When you specify an audio description audio channel, you must also specify an audio description data
         * channel. For more information about audio description signals, see the BBC WHP 198 and 051 white papers.
         * 
         * @param audioDescriptionAudioChannel
         *        Optionally specify the channel in your input that contains your audio description audio signal.
         *        MediaConvert mixes your audio signal across all output channels, while reducing their volume according
         *        to your data stream. When you specify an audio description audio channel, you must also specify an
         *        audio description data channel. For more information about audio description signals, see the BBC WHP
         *        198 and 051 white papers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder audioDescriptionAudioChannel(Integer audioDescriptionAudioChannel);

        /**
         * Optionally specify the channel in your input that contains your audio description data stream. MediaConvert
         * mixes your audio signal across all output channels, while reducing their volume according to your data
         * stream. When you specify an audio description data channel, you must also specify an audio description audio
         * channel. For more information about audio description signals, see the BBC WHP 198 and 051 white papers.
         * 
         * @param audioDescriptionDataChannel
         *        Optionally specify the channel in your input that contains your audio description data stream.
         *        MediaConvert mixes your audio signal across all output channels, while reducing their volume according
         *        to your data stream. When you specify an audio description data channel, you must also specify an
         *        audio description audio channel. For more information about audio description signals, see the BBC WHP
         *        198 and 051 white papers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder audioDescriptionDataChannel(Integer audioDescriptionDataChannel);

        /**
         * Channel mapping contains the group of fields that hold the remixing value for each channel, in dB. Specify
         * remix values to indicate how much of the content from your input audio channel you want in your output audio
         * channels. Each instance of the InputChannels or InputChannelsFineTune array specifies these values for one
         * output channel. Use one instance of this array for each output channel. In the console, each array
         * corresponds to a column in the graphical depiction of the mapping matrix. The rows of the graphical matrix
         * correspond to input channels. Valid values are within the range from -60 (mute) through 6. A setting of 0
         * passes the input channel unchanged to the output channel (no attenuation or amplification). Use InputChannels
         * or InputChannelsFineTune to specify your remix values. Don't use both.
         * 
         * @param channelMapping
         *        Channel mapping contains the group of fields that hold the remixing value for each channel, in dB.
         *        Specify remix values to indicate how much of the content from your input audio channel you want in
         *        your output audio channels. Each instance of the InputChannels or InputChannelsFineTune array
         *        specifies these values for one output channel. Use one instance of this array for each output channel.
         *        In the console, each array corresponds to a column in the graphical depiction of the mapping matrix.
         *        The rows of the graphical matrix correspond to input channels. Valid values are within the range from
         *        -60 (mute) through 6. A setting of 0 passes the input channel unchanged to the output channel (no
         *        attenuation or amplification). Use InputChannels or InputChannelsFineTune to specify your remix
         *        values. Don't use both.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelMapping(ChannelMapping channelMapping);

        /**
         * Channel mapping contains the group of fields that hold the remixing value for each channel, in dB. Specify
         * remix values to indicate how much of the content from your input audio channel you want in your output audio
         * channels. Each instance of the InputChannels or InputChannelsFineTune array specifies these values for one
         * output channel. Use one instance of this array for each output channel. In the console, each array
         * corresponds to a column in the graphical depiction of the mapping matrix. The rows of the graphical matrix
         * correspond to input channels. Valid values are within the range from -60 (mute) through 6. A setting of 0
         * passes the input channel unchanged to the output channel (no attenuation or amplification). Use InputChannels
         * or InputChannelsFineTune to specify your remix values. Don't use both. This is a convenience method that
         * creates an instance of the {@link ChannelMapping.Builder} avoiding the need to create one manually via
         * {@link ChannelMapping#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ChannelMapping.Builder#build()} is called immediately and its
         * result is passed to {@link #channelMapping(ChannelMapping)}.
         * 
         * @param channelMapping
         *        a consumer that will call methods on {@link ChannelMapping.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #channelMapping(ChannelMapping)
         */
        default Builder channelMapping(Consumer<ChannelMapping.Builder> channelMapping) {
            return channelMapping(ChannelMapping.builder().applyMutation(channelMapping).build());
        }

        /**
         * Specify the number of audio channels from your input that you want to use in your output. With remixing, you
         * might combine or split the data in these channels, so the number of channels in your final output might be
         * different. If you are doing both input channel mapping and output channel mapping, the number of output
         * channels in your input mapping must be the same as the number of input channels in your output mapping.
         * 
         * @param channelsIn
         *        Specify the number of audio channels from your input that you want to use in your output. With
         *        remixing, you might combine or split the data in these channels, so the number of channels in your
         *        final output might be different. If you are doing both input channel mapping and output channel
         *        mapping, the number of output channels in your input mapping must be the same as the number of input
         *        channels in your output mapping.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelsIn(Integer channelsIn);

        /**
         * Specify the number of channels in this output after remixing. Valid values: 1, 2, 4, 6, 8... 64. (1 and even
         * numbers to 64.) If you are doing both input channel mapping and output channel mapping, the number of output
         * channels in your input mapping must be the same as the number of input channels in your output mapping.
         * 
         * @param channelsOut
         *        Specify the number of channels in this output after remixing. Valid values: 1, 2, 4, 6, 8... 64. (1
         *        and even numbers to 64.) If you are doing both input channel mapping and output channel mapping, the
         *        number of output channels in your input mapping must be the same as the number of input channels in
         *        your output mapping.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelsOut(Integer channelsOut);
    }

    static final class BuilderImpl implements Builder {
        private Integer audioDescriptionAudioChannel;

        private Integer audioDescriptionDataChannel;

        private ChannelMapping channelMapping;

        private Integer channelsIn;

        private Integer channelsOut;

        private BuilderImpl() {
        }

        private BuilderImpl(RemixSettings model) {
            audioDescriptionAudioChannel(model.audioDescriptionAudioChannel);
            audioDescriptionDataChannel(model.audioDescriptionDataChannel);
            channelMapping(model.channelMapping);
            channelsIn(model.channelsIn);
            channelsOut(model.channelsOut);
        }

        public final Integer getAudioDescriptionAudioChannel() {
            return audioDescriptionAudioChannel;
        }

        public final void setAudioDescriptionAudioChannel(Integer audioDescriptionAudioChannel) {
            this.audioDescriptionAudioChannel = audioDescriptionAudioChannel;
        }

        @Override
        public final Builder audioDescriptionAudioChannel(Integer audioDescriptionAudioChannel) {
            this.audioDescriptionAudioChannel = audioDescriptionAudioChannel;
            return this;
        }

        public final Integer getAudioDescriptionDataChannel() {
            return audioDescriptionDataChannel;
        }

        public final void setAudioDescriptionDataChannel(Integer audioDescriptionDataChannel) {
            this.audioDescriptionDataChannel = audioDescriptionDataChannel;
        }

        @Override
        public final Builder audioDescriptionDataChannel(Integer audioDescriptionDataChannel) {
            this.audioDescriptionDataChannel = audioDescriptionDataChannel;
            return this;
        }

        public final ChannelMapping.Builder getChannelMapping() {
            return channelMapping != null ? channelMapping.toBuilder() : null;
        }

        public final void setChannelMapping(ChannelMapping.BuilderImpl channelMapping) {
            this.channelMapping = channelMapping != null ? channelMapping.build() : null;
        }

        @Override
        public final Builder channelMapping(ChannelMapping channelMapping) {
            this.channelMapping = channelMapping;
            return this;
        }

        public final Integer getChannelsIn() {
            return channelsIn;
        }

        public final void setChannelsIn(Integer channelsIn) {
            this.channelsIn = channelsIn;
        }

        @Override
        public final Builder channelsIn(Integer channelsIn) {
            this.channelsIn = channelsIn;
            return this;
        }

        public final Integer getChannelsOut() {
            return channelsOut;
        }

        public final void setChannelsOut(Integer channelsOut) {
            this.channelsOut = channelsOut;
        }

        @Override
        public final Builder channelsOut(Integer channelsOut) {
            this.channelsOut = channelsOut;
            return this;
        }

        @Override
        public RemixSettings build() {
            return new RemixSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
