/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * A service override applied by MediaConvert to the settings that you have configured. If you see any overrides, we
 * recommend that you contact AWS Support.
 */
@Generated("software.amazon.awssdk:codegen")
public final class ServiceOverride implements SdkPojo, Serializable, ToCopyableBuilder<ServiceOverride.Builder, ServiceOverride> {
    private static final SdkField<String> MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Message")
            .getter(getter(ServiceOverride::message)).setter(setter(Builder::message))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("message").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(ServiceOverride::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> OVERRIDE_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OverrideValue").getter(getter(ServiceOverride::overrideValue)).setter(setter(Builder::overrideValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("overrideValue").build()).build();

    private static final SdkField<String> VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Value")
            .getter(getter(ServiceOverride::value)).setter(setter(Builder::value))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MESSAGE_FIELD, NAME_FIELD,
            OVERRIDE_VALUE_FIELD, VALUE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String message;

    private final String name;

    private final String overrideValue;

    private final String value;

    private ServiceOverride(BuilderImpl builder) {
        this.message = builder.message;
        this.name = builder.name;
        this.overrideValue = builder.overrideValue;
        this.value = builder.value;
    }

    /**
     * Details about the service override that MediaConvert has applied.
     * 
     * @return Details about the service override that MediaConvert has applied.
     */
    public final String message() {
        return message;
    }

    /**
     * The name of the setting that MediaConvert has applied an override to.
     * 
     * @return The name of the setting that MediaConvert has applied an override to.
     */
    public final String name() {
        return name;
    }

    /**
     * The current value of the service override that MediaConvert has applied.
     * 
     * @return The current value of the service override that MediaConvert has applied.
     */
    public final String overrideValue() {
        return overrideValue;
    }

    /**
     * The value of the setting that you configured, prior to any overrides that MediaConvert has applied.
     * 
     * @return The value of the setting that you configured, prior to any overrides that MediaConvert has applied.
     */
    public final String value() {
        return value;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(message());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(overrideValue());
        hashCode = 31 * hashCode + Objects.hashCode(value());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServiceOverride)) {
            return false;
        }
        ServiceOverride other = (ServiceOverride) obj;
        return Objects.equals(message(), other.message()) && Objects.equals(name(), other.name())
                && Objects.equals(overrideValue(), other.overrideValue()) && Objects.equals(value(), other.value());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ServiceOverride").add("Message", message()).add("Name", name())
                .add("OverrideValue", overrideValue()).add("Value", value()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Message":
            return Optional.ofNullable(clazz.cast(message()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "OverrideValue":
            return Optional.ofNullable(clazz.cast(overrideValue()));
        case "Value":
            return Optional.ofNullable(clazz.cast(value()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("message", MESSAGE_FIELD);
        map.put("name", NAME_FIELD);
        map.put("overrideValue", OVERRIDE_VALUE_FIELD);
        map.put("value", VALUE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ServiceOverride, T> g) {
        return obj -> g.apply((ServiceOverride) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ServiceOverride> {
        /**
         * Details about the service override that MediaConvert has applied.
         * 
         * @param message
         *        Details about the service override that MediaConvert has applied.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(String message);

        /**
         * The name of the setting that MediaConvert has applied an override to.
         * 
         * @param name
         *        The name of the setting that MediaConvert has applied an override to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * The current value of the service override that MediaConvert has applied.
         * 
         * @param overrideValue
         *        The current value of the service override that MediaConvert has applied.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder overrideValue(String overrideValue);

        /**
         * The value of the setting that you configured, prior to any overrides that MediaConvert has applied.
         * 
         * @param value
         *        The value of the setting that you configured, prior to any overrides that MediaConvert has applied.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(String value);
    }

    static final class BuilderImpl implements Builder {
        private String message;

        private String name;

        private String overrideValue;

        private String value;

        private BuilderImpl() {
        }

        private BuilderImpl(ServiceOverride model) {
            message(model.message);
            name(model.name);
            overrideValue(model.overrideValue);
            value(model.value);
        }

        public final String getMessage() {
            return message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getOverrideValue() {
            return overrideValue;
        }

        public final void setOverrideValue(String overrideValue) {
            this.overrideValue = overrideValue;
        }

        @Override
        public final Builder overrideValue(String overrideValue) {
            this.overrideValue = overrideValue;
            return this;
        }

        public final String getValue() {
            return value;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        @Override
        public ServiceOverride build() {
            return new ServiceOverride(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
