/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

/**
 * To include a timecode track in your MP4 output: Choose Enabled. MediaConvert writes the timecode track in the Null
 * Media Header box (NMHD), without any timecode text formatting information. You can also specify dropframe or
 * non-dropframe timecode under the Drop Frame Timecode setting. To not include a timecode track: Keep the default
 * value, Disabled.
 */
@Generated("software.amazon.awssdk:codegen")
public enum TimecodeTrack {
    DISABLED("DISABLED"),

    ENABLED("ENABLED"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, TimecodeTrack> VALUE_MAP = EnumUtils.uniqueIndex(TimecodeTrack.class,
            TimecodeTrack::toString);

    private final String value;

    private TimecodeTrack(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return TimecodeTrack corresponding to the value
     */
    public static TimecodeTrack fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link TimecodeTrack}s
     */
    public static Set<TimecodeTrack> knownValues() {
        Set<TimecodeTrack> knownValues = EnumSet.allOf(TimecodeTrack.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
