/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Settings related to TTML captions. TTML is a sidecar format that holds captions in a file that is separate from the
 * video container. Set up sidecar captions in the same output group, but different output from your video. For more
 * information, see https://docs.aws.amazon.com/mediaconvert/latest/ug/ttml-and-webvtt-output-captions.html.
 */
@Generated("software.amazon.awssdk:codegen")
public final class TtmlDestinationSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<TtmlDestinationSettings.Builder, TtmlDestinationSettings> {
    private static final SdkField<String> STYLE_PASSTHROUGH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StylePassthrough").getter(getter(TtmlDestinationSettings::stylePassthroughAsString))
            .setter(setter(Builder::stylePassthrough))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stylePassthrough").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STYLE_PASSTHROUGH_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String stylePassthrough;

    private TtmlDestinationSettings(BuilderImpl builder) {
        this.stylePassthrough = builder.stylePassthrough;
    }

    /**
     * Pass through style and position information from a TTML-like input source (TTML, IMSC, SMPTE-TT) to the TTML
     * output.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #stylePassthrough}
     * will return {@link TtmlStylePassthrough#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #stylePassthroughAsString}.
     * </p>
     * 
     * @return Pass through style and position information from a TTML-like input source (TTML, IMSC, SMPTE-TT) to the
     *         TTML output.
     * @see TtmlStylePassthrough
     */
    public final TtmlStylePassthrough stylePassthrough() {
        return TtmlStylePassthrough.fromValue(stylePassthrough);
    }

    /**
     * Pass through style and position information from a TTML-like input source (TTML, IMSC, SMPTE-TT) to the TTML
     * output.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #stylePassthrough}
     * will return {@link TtmlStylePassthrough#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #stylePassthroughAsString}.
     * </p>
     * 
     * @return Pass through style and position information from a TTML-like input source (TTML, IMSC, SMPTE-TT) to the
     *         TTML output.
     * @see TtmlStylePassthrough
     */
    public final String stylePassthroughAsString() {
        return stylePassthrough;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(stylePassthroughAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TtmlDestinationSettings)) {
            return false;
        }
        TtmlDestinationSettings other = (TtmlDestinationSettings) obj;
        return Objects.equals(stylePassthroughAsString(), other.stylePassthroughAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TtmlDestinationSettings").add("StylePassthrough", stylePassthroughAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StylePassthrough":
            return Optional.ofNullable(clazz.cast(stylePassthroughAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("stylePassthrough", STYLE_PASSTHROUGH_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TtmlDestinationSettings, T> g) {
        return obj -> g.apply((TtmlDestinationSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TtmlDestinationSettings> {
        /**
         * Pass through style and position information from a TTML-like input source (TTML, IMSC, SMPTE-TT) to the TTML
         * output.
         * 
         * @param stylePassthrough
         *        Pass through style and position information from a TTML-like input source (TTML, IMSC, SMPTE-TT) to
         *        the TTML output.
         * @see TtmlStylePassthrough
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TtmlStylePassthrough
         */
        Builder stylePassthrough(String stylePassthrough);

        /**
         * Pass through style and position information from a TTML-like input source (TTML, IMSC, SMPTE-TT) to the TTML
         * output.
         * 
         * @param stylePassthrough
         *        Pass through style and position information from a TTML-like input source (TTML, IMSC, SMPTE-TT) to
         *        the TTML output.
         * @see TtmlStylePassthrough
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TtmlStylePassthrough
         */
        Builder stylePassthrough(TtmlStylePassthrough stylePassthrough);
    }

    static final class BuilderImpl implements Builder {
        private String stylePassthrough;

        private BuilderImpl() {
        }

        private BuilderImpl(TtmlDestinationSettings model) {
            stylePassthrough(model.stylePassthrough);
        }

        public final String getStylePassthrough() {
            return stylePassthrough;
        }

        public final void setStylePassthrough(String stylePassthrough) {
            this.stylePassthrough = stylePassthrough;
        }

        @Override
        public final Builder stylePassthrough(String stylePassthrough) {
            this.stylePassthrough = stylePassthrough;
            return this;
        }

        @Override
        public final Builder stylePassthrough(TtmlStylePassthrough stylePassthrough) {
            this.stylePassthrough(stylePassthrough == null ? null : stylePassthrough.toString());
            return this;
        }

        @Override
        public TtmlDestinationSettings build() {
            return new TtmlDestinationSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
