/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateQueueRequest extends MediaConvertRequest implements
        ToCopyableBuilder<UpdateQueueRequest.Builder, UpdateQueueRequest> {
    private static final SdkField<Integer> CONCURRENT_JOBS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ConcurrentJobs").getter(getter(UpdateQueueRequest::concurrentJobs))
            .setter(setter(Builder::concurrentJobs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("concurrentJobs").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(UpdateQueueRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(UpdateQueueRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("name").build()).build();

    private static final SdkField<ReservationPlanSettings> RESERVATION_PLAN_SETTINGS_FIELD = SdkField
            .<ReservationPlanSettings> builder(MarshallingType.SDK_POJO).memberName("ReservationPlanSettings")
            .getter(getter(UpdateQueueRequest::reservationPlanSettings)).setter(setter(Builder::reservationPlanSettings))
            .constructor(ReservationPlanSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reservationPlanSettings").build())
            .build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(UpdateQueueRequest::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONCURRENT_JOBS_FIELD,
            DESCRIPTION_FIELD, NAME_FIELD, RESERVATION_PLAN_SETTINGS_FIELD, STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Integer concurrentJobs;

    private final String description;

    private final String name;

    private final ReservationPlanSettings reservationPlanSettings;

    private final String status;

    private UpdateQueueRequest(BuilderImpl builder) {
        super(builder);
        this.concurrentJobs = builder.concurrentJobs;
        this.description = builder.description;
        this.name = builder.name;
        this.reservationPlanSettings = builder.reservationPlanSettings;
        this.status = builder.status;
    }

    /**
     * Specify the maximum number of jobs your queue can process concurrently. For on-demand queues, the value you enter
     * is constrained by your service quotas for Maximum concurrent jobs, per on-demand queue and Maximum concurrent
     * jobs, per account. For reserved queues, update your reservation plan instead in order to increase your yearly
     * commitment.
     * 
     * @return Specify the maximum number of jobs your queue can process concurrently. For on-demand queues, the value
     *         you enter is constrained by your service quotas for Maximum concurrent jobs, per on-demand queue and
     *         Maximum concurrent jobs, per account. For reserved queues, update your reservation plan instead in order
     *         to increase your yearly commitment.
     */
    public final Integer concurrentJobs() {
        return concurrentJobs;
    }

    /**
     * The new description for the queue, if you are changing it.
     * 
     * @return The new description for the queue, if you are changing it.
     */
    public final String description() {
        return description;
    }

    /**
     * The name of the queue that you are modifying.
     * 
     * @return The name of the queue that you are modifying.
     */
    public final String name() {
        return name;
    }

    /**
     * The new details of your pricing plan for your reserved queue. When you set up a new pricing plan to replace an
     * expired one, you enter into another 12-month commitment. When you add capacity to your queue by increasing the
     * number of RTS, you extend the term of your commitment to 12 months from when you add capacity. After you make
     * these commitments, you can't cancel them.
     * 
     * @return The new details of your pricing plan for your reserved queue. When you set up a new pricing plan to
     *         replace an expired one, you enter into another 12-month commitment. When you add capacity to your queue
     *         by increasing the number of RTS, you extend the term of your commitment to 12 months from when you add
     *         capacity. After you make these commitments, you can't cancel them.
     */
    public final ReservationPlanSettings reservationPlanSettings() {
        return reservationPlanSettings;
    }

    /**
     * Pause or activate a queue by changing its status between ACTIVE and PAUSED. If you pause a queue, jobs in that
     * queue won't begin. Jobs that are running when you pause the queue continue to run until they finish or result in
     * an error.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link QueueStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return Pause or activate a queue by changing its status between ACTIVE and PAUSED. If you pause a queue, jobs in
     *         that queue won't begin. Jobs that are running when you pause the queue continue to run until they finish
     *         or result in an error.
     * @see QueueStatus
     */
    public final QueueStatus status() {
        return QueueStatus.fromValue(status);
    }

    /**
     * Pause or activate a queue by changing its status between ACTIVE and PAUSED. If you pause a queue, jobs in that
     * queue won't begin. Jobs that are running when you pause the queue continue to run until they finish or result in
     * an error.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link QueueStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return Pause or activate a queue by changing its status between ACTIVE and PAUSED. If you pause a queue, jobs in
     *         that queue won't begin. Jobs that are running when you pause the queue continue to run until they finish
     *         or result in an error.
     * @see QueueStatus
     */
    public final String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(concurrentJobs());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(reservationPlanSettings());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateQueueRequest)) {
            return false;
        }
        UpdateQueueRequest other = (UpdateQueueRequest) obj;
        return Objects.equals(concurrentJobs(), other.concurrentJobs()) && Objects.equals(description(), other.description())
                && Objects.equals(name(), other.name())
                && Objects.equals(reservationPlanSettings(), other.reservationPlanSettings())
                && Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateQueueRequest").add("ConcurrentJobs", concurrentJobs()).add("Description", description())
                .add("Name", name()).add("ReservationPlanSettings", reservationPlanSettings()).add("Status", statusAsString())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConcurrentJobs":
            return Optional.ofNullable(clazz.cast(concurrentJobs()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "ReservationPlanSettings":
            return Optional.ofNullable(clazz.cast(reservationPlanSettings()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("concurrentJobs", CONCURRENT_JOBS_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("name", NAME_FIELD);
        map.put("reservationPlanSettings", RESERVATION_PLAN_SETTINGS_FIELD);
        map.put("status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateQueueRequest, T> g) {
        return obj -> g.apply((UpdateQueueRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MediaConvertRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateQueueRequest> {
        /**
         * Specify the maximum number of jobs your queue can process concurrently. For on-demand queues, the value you
         * enter is constrained by your service quotas for Maximum concurrent jobs, per on-demand queue and Maximum
         * concurrent jobs, per account. For reserved queues, update your reservation plan instead in order to increase
         * your yearly commitment.
         * 
         * @param concurrentJobs
         *        Specify the maximum number of jobs your queue can process concurrently. For on-demand queues, the
         *        value you enter is constrained by your service quotas for Maximum concurrent jobs, per on-demand queue
         *        and Maximum concurrent jobs, per account. For reserved queues, update your reservation plan instead in
         *        order to increase your yearly commitment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder concurrentJobs(Integer concurrentJobs);

        /**
         * The new description for the queue, if you are changing it.
         * 
         * @param description
         *        The new description for the queue, if you are changing it.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * The name of the queue that you are modifying.
         * 
         * @param name
         *        The name of the queue that you are modifying.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * The new details of your pricing plan for your reserved queue. When you set up a new pricing plan to replace
         * an expired one, you enter into another 12-month commitment. When you add capacity to your queue by increasing
         * the number of RTS, you extend the term of your commitment to 12 months from when you add capacity. After you
         * make these commitments, you can't cancel them.
         * 
         * @param reservationPlanSettings
         *        The new details of your pricing plan for your reserved queue. When you set up a new pricing plan to
         *        replace an expired one, you enter into another 12-month commitment. When you add capacity to your
         *        queue by increasing the number of RTS, you extend the term of your commitment to 12 months from when
         *        you add capacity. After you make these commitments, you can't cancel them.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reservationPlanSettings(ReservationPlanSettings reservationPlanSettings);

        /**
         * The new details of your pricing plan for your reserved queue. When you set up a new pricing plan to replace
         * an expired one, you enter into another 12-month commitment. When you add capacity to your queue by increasing
         * the number of RTS, you extend the term of your commitment to 12 months from when you add capacity. After you
         * make these commitments, you can't cancel them. This is a convenience method that creates an instance of the
         * {@link ReservationPlanSettings.Builder} avoiding the need to create one manually via
         * {@link ReservationPlanSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ReservationPlanSettings.Builder#build()} is called immediately
         * and its result is passed to {@link #reservationPlanSettings(ReservationPlanSettings)}.
         * 
         * @param reservationPlanSettings
         *        a consumer that will call methods on {@link ReservationPlanSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #reservationPlanSettings(ReservationPlanSettings)
         */
        default Builder reservationPlanSettings(Consumer<ReservationPlanSettings.Builder> reservationPlanSettings) {
            return reservationPlanSettings(ReservationPlanSettings.builder().applyMutation(reservationPlanSettings).build());
        }

        /**
         * Pause or activate a queue by changing its status between ACTIVE and PAUSED. If you pause a queue, jobs in
         * that queue won't begin. Jobs that are running when you pause the queue continue to run until they finish or
         * result in an error.
         * 
         * @param status
         *        Pause or activate a queue by changing its status between ACTIVE and PAUSED. If you pause a queue, jobs
         *        in that queue won't begin. Jobs that are running when you pause the queue continue to run until they
         *        finish or result in an error.
         * @see QueueStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see QueueStatus
         */
        Builder status(String status);

        /**
         * Pause or activate a queue by changing its status between ACTIVE and PAUSED. If you pause a queue, jobs in
         * that queue won't begin. Jobs that are running when you pause the queue continue to run until they finish or
         * result in an error.
         * 
         * @param status
         *        Pause or activate a queue by changing its status between ACTIVE and PAUSED. If you pause a queue, jobs
         *        in that queue won't begin. Jobs that are running when you pause the queue continue to run until they
         *        finish or result in an error.
         * @see QueueStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see QueueStatus
         */
        Builder status(QueueStatus status);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MediaConvertRequest.BuilderImpl implements Builder {
        private Integer concurrentJobs;

        private String description;

        private String name;

        private ReservationPlanSettings reservationPlanSettings;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateQueueRequest model) {
            super(model);
            concurrentJobs(model.concurrentJobs);
            description(model.description);
            name(model.name);
            reservationPlanSettings(model.reservationPlanSettings);
            status(model.status);
        }

        public final Integer getConcurrentJobs() {
            return concurrentJobs;
        }

        public final void setConcurrentJobs(Integer concurrentJobs) {
            this.concurrentJobs = concurrentJobs;
        }

        @Override
        public final Builder concurrentJobs(Integer concurrentJobs) {
            this.concurrentJobs = concurrentJobs;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final ReservationPlanSettings.Builder getReservationPlanSettings() {
            return reservationPlanSettings != null ? reservationPlanSettings.toBuilder() : null;
        }

        public final void setReservationPlanSettings(ReservationPlanSettings.BuilderImpl reservationPlanSettings) {
            this.reservationPlanSettings = reservationPlanSettings != null ? reservationPlanSettings.build() : null;
        }

        @Override
        public final Builder reservationPlanSettings(ReservationPlanSettings reservationPlanSettings) {
            this.reservationPlanSettings = reservationPlanSettings;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(QueueStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateQueueRequest build() {
            return new UpdateQueueRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
