/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Specify one or more Transitions for your video overlay. Use Transitions to reposition or resize your overlay over
 * time. To use the same position and size for the duration of your video overlay: Leave blank. To specify a Transition:
 * Enter a value for Start timecode, End Timecode, X Position, Y Position, Width, or Height.
 */
@Generated("software.amazon.awssdk:codegen")
public final class VideoOverlayTransition implements SdkPojo, Serializable,
        ToCopyableBuilder<VideoOverlayTransition.Builder, VideoOverlayTransition> {
    private static final SdkField<VideoOverlayPosition> END_POSITION_FIELD = SdkField
            .<VideoOverlayPosition> builder(MarshallingType.SDK_POJO).memberName("EndPosition")
            .getter(getter(VideoOverlayTransition::endPosition)).setter(setter(Builder::endPosition))
            .constructor(VideoOverlayPosition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endPosition").build()).build();

    private static final SdkField<String> END_TIMECODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EndTimecode").getter(getter(VideoOverlayTransition::endTimecode)).setter(setter(Builder::endTimecode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTimecode").build()).build();

    private static final SdkField<String> START_TIMECODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StartTimecode").getter(getter(VideoOverlayTransition::startTimecode))
            .setter(setter(Builder::startTimecode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTimecode").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(END_POSITION_FIELD,
            END_TIMECODE_FIELD, START_TIMECODE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final VideoOverlayPosition endPosition;

    private final String endTimecode;

    private final String startTimecode;

    private VideoOverlayTransition(BuilderImpl builder) {
        this.endPosition = builder.endPosition;
        this.endTimecode = builder.endTimecode;
        this.startTimecode = builder.startTimecode;
    }

    /**
     * Specify the ending position for this transition, relative to the base input video's frame. Your video overlay
     * will move smoothly to this position, beginning at this transition's Start timecode and ending at this
     * transition's End timecode.
     * 
     * @return Specify the ending position for this transition, relative to the base input video's frame. Your video
     *         overlay will move smoothly to this position, beginning at this transition's Start timecode and ending at
     *         this transition's End timecode.
     */
    public final VideoOverlayPosition endPosition() {
        return endPosition;
    }

    /**
     * Specify the timecode for when this transition ends. Use the format HH:MM:SS:FF or HH:MM:SS;FF, where HH is the
     * hour, MM is the minute, SS is the second, and FF is the frame number. When entering this value, take into account
     * your choice for Timecode source.
     * 
     * @return Specify the timecode for when this transition ends. Use the format HH:MM:SS:FF or HH:MM:SS;FF, where HH
     *         is the hour, MM is the minute, SS is the second, and FF is the frame number. When entering this value,
     *         take into account your choice for Timecode source.
     */
    public final String endTimecode() {
        return endTimecode;
    }

    /**
     * Specify the timecode for when this transition begins. Use the format HH:MM:SS:FF or HH:MM:SS;FF, where HH is the
     * hour, MM is the minute, SS is the second, and FF is the frame number. When entering this value, take into account
     * your choice for Timecode source.
     * 
     * @return Specify the timecode for when this transition begins. Use the format HH:MM:SS:FF or HH:MM:SS;FF, where HH
     *         is the hour, MM is the minute, SS is the second, and FF is the frame number. When entering this value,
     *         take into account your choice for Timecode source.
     */
    public final String startTimecode() {
        return startTimecode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(endPosition());
        hashCode = 31 * hashCode + Objects.hashCode(endTimecode());
        hashCode = 31 * hashCode + Objects.hashCode(startTimecode());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VideoOverlayTransition)) {
            return false;
        }
        VideoOverlayTransition other = (VideoOverlayTransition) obj;
        return Objects.equals(endPosition(), other.endPosition()) && Objects.equals(endTimecode(), other.endTimecode())
                && Objects.equals(startTimecode(), other.startTimecode());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("VideoOverlayTransition").add("EndPosition", endPosition()).add("EndTimecode", endTimecode())
                .add("StartTimecode", startTimecode()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EndPosition":
            return Optional.ofNullable(clazz.cast(endPosition()));
        case "EndTimecode":
            return Optional.ofNullable(clazz.cast(endTimecode()));
        case "StartTimecode":
            return Optional.ofNullable(clazz.cast(startTimecode()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("endPosition", END_POSITION_FIELD);
        map.put("endTimecode", END_TIMECODE_FIELD);
        map.put("startTimecode", START_TIMECODE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<VideoOverlayTransition, T> g) {
        return obj -> g.apply((VideoOverlayTransition) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VideoOverlayTransition> {
        /**
         * Specify the ending position for this transition, relative to the base input video's frame. Your video overlay
         * will move smoothly to this position, beginning at this transition's Start timecode and ending at this
         * transition's End timecode.
         * 
         * @param endPosition
         *        Specify the ending position for this transition, relative to the base input video's frame. Your video
         *        overlay will move smoothly to this position, beginning at this transition's Start timecode and ending
         *        at this transition's End timecode.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endPosition(VideoOverlayPosition endPosition);

        /**
         * Specify the ending position for this transition, relative to the base input video's frame. Your video overlay
         * will move smoothly to this position, beginning at this transition's Start timecode and ending at this
         * transition's End timecode. This is a convenience method that creates an instance of the
         * {@link VideoOverlayPosition.Builder} avoiding the need to create one manually via
         * {@link VideoOverlayPosition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VideoOverlayPosition.Builder#build()} is called immediately and
         * its result is passed to {@link #endPosition(VideoOverlayPosition)}.
         * 
         * @param endPosition
         *        a consumer that will call methods on {@link VideoOverlayPosition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #endPosition(VideoOverlayPosition)
         */
        default Builder endPosition(Consumer<VideoOverlayPosition.Builder> endPosition) {
            return endPosition(VideoOverlayPosition.builder().applyMutation(endPosition).build());
        }

        /**
         * Specify the timecode for when this transition ends. Use the format HH:MM:SS:FF or HH:MM:SS;FF, where HH is
         * the hour, MM is the minute, SS is the second, and FF is the frame number. When entering this value, take into
         * account your choice for Timecode source.
         * 
         * @param endTimecode
         *        Specify the timecode for when this transition ends. Use the format HH:MM:SS:FF or HH:MM:SS;FF, where
         *        HH is the hour, MM is the minute, SS is the second, and FF is the frame number. When entering this
         *        value, take into account your choice for Timecode source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTimecode(String endTimecode);

        /**
         * Specify the timecode for when this transition begins. Use the format HH:MM:SS:FF or HH:MM:SS;FF, where HH is
         * the hour, MM is the minute, SS is the second, and FF is the frame number. When entering this value, take into
         * account your choice for Timecode source.
         * 
         * @param startTimecode
         *        Specify the timecode for when this transition begins. Use the format HH:MM:SS:FF or HH:MM:SS;FF, where
         *        HH is the hour, MM is the minute, SS is the second, and FF is the frame number. When entering this
         *        value, take into account your choice for Timecode source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTimecode(String startTimecode);
    }

    static final class BuilderImpl implements Builder {
        private VideoOverlayPosition endPosition;

        private String endTimecode;

        private String startTimecode;

        private BuilderImpl() {
        }

        private BuilderImpl(VideoOverlayTransition model) {
            endPosition(model.endPosition);
            endTimecode(model.endTimecode);
            startTimecode(model.startTimecode);
        }

        public final VideoOverlayPosition.Builder getEndPosition() {
            return endPosition != null ? endPosition.toBuilder() : null;
        }

        public final void setEndPosition(VideoOverlayPosition.BuilderImpl endPosition) {
            this.endPosition = endPosition != null ? endPosition.build() : null;
        }

        @Override
        public final Builder endPosition(VideoOverlayPosition endPosition) {
            this.endPosition = endPosition;
            return this;
        }

        public final String getEndTimecode() {
            return endTimecode;
        }

        public final void setEndTimecode(String endTimecode) {
            this.endTimecode = endTimecode;
        }

        @Override
        public final Builder endTimecode(String endTimecode) {
            this.endTimecode = endTimecode;
            return this;
        }

        public final String getStartTimecode() {
            return startTimecode;
        }

        public final void setStartTimecode(String startTimecode) {
            this.startTimecode = startTimecode;
        }

        @Override
        public final Builder startTimecode(String startTimecode) {
            this.startTimecode = startTimecode;
            return this;
        }

        @Override
        public VideoOverlayTransition build() {
            return new VideoOverlayTransition(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
