/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Contains any warning codes and their count for the job.
 */
@Generated("software.amazon.awssdk:codegen")
public final class WarningGroup implements SdkPojo, Serializable, ToCopyableBuilder<WarningGroup.Builder, WarningGroup> {
    private static final SdkField<Integer> CODE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Code")
            .getter(getter(WarningGroup::code)).setter(setter(Builder::code))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("code").build()).build();

    private static final SdkField<Integer> COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Count")
            .getter(getter(WarningGroup::count)).setter(setter(Builder::count))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("count").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CODE_FIELD, COUNT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer code;

    private final Integer count;

    private WarningGroup(BuilderImpl builder) {
        this.code = builder.code;
        this.count = builder.count;
    }

    /**
     * Warning code that identifies a specific warning in the job. For more information, see
     * https://docs.aws.amazon.com/mediaconvert/latest/ug/warning_codes.html
     * 
     * @return Warning code that identifies a specific warning in the job. For more information, see
     *         https://docs.aws.amazon.com/mediaconvert/latest/ug/warning_codes.html
     */
    public final Integer code() {
        return code;
    }

    /**
     * The number of times this warning occurred in the job.
     * 
     * @return The number of times this warning occurred in the job.
     */
    public final Integer count() {
        return count;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(code());
        hashCode = 31 * hashCode + Objects.hashCode(count());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WarningGroup)) {
            return false;
        }
        WarningGroup other = (WarningGroup) obj;
        return Objects.equals(code(), other.code()) && Objects.equals(count(), other.count());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("WarningGroup").add("Code", code()).add("Count", count()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Code":
            return Optional.ofNullable(clazz.cast(code()));
        case "Count":
            return Optional.ofNullable(clazz.cast(count()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("code", CODE_FIELD);
        map.put("count", COUNT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<WarningGroup, T> g) {
        return obj -> g.apply((WarningGroup) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, WarningGroup> {
        /**
         * Warning code that identifies a specific warning in the job. For more information, see
         * https://docs.aws.amazon.com/mediaconvert/latest/ug/warning_codes.html
         * 
         * @param code
         *        Warning code that identifies a specific warning in the job. For more information, see
         *        https://docs.aws.amazon.com/mediaconvert/latest/ug/warning_codes.html
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder code(Integer code);

        /**
         * The number of times this warning occurred in the job.
         * 
         * @param count
         *        The number of times this warning occurred in the job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder count(Integer count);
    }

    static final class BuilderImpl implements Builder {
        private Integer code;

        private Integer count;

        private BuilderImpl() {
        }

        private BuilderImpl(WarningGroup model) {
            code(model.code);
            count(model.count);
        }

        public final Integer getCode() {
            return code;
        }

        public final void setCode(Integer code) {
            this.code = code;
        }

        @Override
        public final Builder code(Integer code) {
            this.code = code;
            return this;
        }

        public final Integer getCount() {
            return count;
        }

        public final void setCount(Integer count) {
            this.count = count;
        }

        @Override
        public final Builder count(Integer count) {
            this.count = count;
            return this;
        }

        @Override
        public WarningGroup build() {
            return new WarningGroup(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
