/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Required when you set Codec to the value WAV.
 */
@Generated("software.amazon.awssdk:codegen")
public final class WavSettings implements SdkPojo, Serializable, ToCopyableBuilder<WavSettings.Builder, WavSettings> {
    private static final SdkField<Integer> BIT_DEPTH_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("BitDepth").getter(getter(WavSettings::bitDepth)).setter(setter(Builder::bitDepth))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bitDepth").build()).build();

    private static final SdkField<Integer> CHANNELS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Channels").getter(getter(WavSettings::channels)).setter(setter(Builder::channels))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("channels").build()).build();

    private static final SdkField<String> FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Format")
            .getter(getter(WavSettings::formatAsString)).setter(setter(Builder::format))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("format").build()).build();

    private static final SdkField<Integer> SAMPLE_RATE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("SampleRate").getter(getter(WavSettings::sampleRate)).setter(setter(Builder::sampleRate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sampleRate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BIT_DEPTH_FIELD,
            CHANNELS_FIELD, FORMAT_FIELD, SAMPLE_RATE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer bitDepth;

    private final Integer channels;

    private final String format;

    private final Integer sampleRate;

    private WavSettings(BuilderImpl builder) {
        this.bitDepth = builder.bitDepth;
        this.channels = builder.channels;
        this.format = builder.format;
        this.sampleRate = builder.sampleRate;
    }

    /**
     * Specify Bit depth, in bits per sample, to choose the encoding quality for this audio track.
     * 
     * @return Specify Bit depth, in bits per sample, to choose the encoding quality for this audio track.
     */
    public final Integer bitDepth() {
        return bitDepth;
    }

    /**
     * Specify the number of channels in this output audio track. Valid values are 1 and even numbers up to 64. For
     * example, 1, 2, 4, 6, and so on, up to 64.
     * 
     * @return Specify the number of channels in this output audio track. Valid values are 1 and even numbers up to 64.
     *         For example, 1, 2, 4, 6, and so on, up to 64.
     */
    public final Integer channels() {
        return channels;
    }

    /**
     * The service defaults to using RIFF for WAV outputs. If your output audio is likely to exceed 4 GB in file size,
     * or if you otherwise need the extended support of the RF64 format, set your output WAV file format to RF64.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #format} will
     * return {@link WavFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #formatAsString}.
     * </p>
     * 
     * @return The service defaults to using RIFF for WAV outputs. If your output audio is likely to exceed 4 GB in file
     *         size, or if you otherwise need the extended support of the RF64 format, set your output WAV file format
     *         to RF64.
     * @see WavFormat
     */
    public final WavFormat format() {
        return WavFormat.fromValue(format);
    }

    /**
     * The service defaults to using RIFF for WAV outputs. If your output audio is likely to exceed 4 GB in file size,
     * or if you otherwise need the extended support of the RF64 format, set your output WAV file format to RF64.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #format} will
     * return {@link WavFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #formatAsString}.
     * </p>
     * 
     * @return The service defaults to using RIFF for WAV outputs. If your output audio is likely to exceed 4 GB in file
     *         size, or if you otherwise need the extended support of the RF64 format, set your output WAV file format
     *         to RF64.
     * @see WavFormat
     */
    public final String formatAsString() {
        return format;
    }

    /**
     * Sample rate in Hz.
     * 
     * @return Sample rate in Hz.
     */
    public final Integer sampleRate() {
        return sampleRate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(bitDepth());
        hashCode = 31 * hashCode + Objects.hashCode(channels());
        hashCode = 31 * hashCode + Objects.hashCode(formatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sampleRate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WavSettings)) {
            return false;
        }
        WavSettings other = (WavSettings) obj;
        return Objects.equals(bitDepth(), other.bitDepth()) && Objects.equals(channels(), other.channels())
                && Objects.equals(formatAsString(), other.formatAsString()) && Objects.equals(sampleRate(), other.sampleRate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("WavSettings").add("BitDepth", bitDepth()).add("Channels", channels())
                .add("Format", formatAsString()).add("SampleRate", sampleRate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BitDepth":
            return Optional.ofNullable(clazz.cast(bitDepth()));
        case "Channels":
            return Optional.ofNullable(clazz.cast(channels()));
        case "Format":
            return Optional.ofNullable(clazz.cast(formatAsString()));
        case "SampleRate":
            return Optional.ofNullable(clazz.cast(sampleRate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("bitDepth", BIT_DEPTH_FIELD);
        map.put("channels", CHANNELS_FIELD);
        map.put("format", FORMAT_FIELD);
        map.put("sampleRate", SAMPLE_RATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<WavSettings, T> g) {
        return obj -> g.apply((WavSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, WavSettings> {
        /**
         * Specify Bit depth, in bits per sample, to choose the encoding quality for this audio track.
         * 
         * @param bitDepth
         *        Specify Bit depth, in bits per sample, to choose the encoding quality for this audio track.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bitDepth(Integer bitDepth);

        /**
         * Specify the number of channels in this output audio track. Valid values are 1 and even numbers up to 64. For
         * example, 1, 2, 4, 6, and so on, up to 64.
         * 
         * @param channels
         *        Specify the number of channels in this output audio track. Valid values are 1 and even numbers up to
         *        64. For example, 1, 2, 4, 6, and so on, up to 64.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channels(Integer channels);

        /**
         * The service defaults to using RIFF for WAV outputs. If your output audio is likely to exceed 4 GB in file
         * size, or if you otherwise need the extended support of the RF64 format, set your output WAV file format to
         * RF64.
         * 
         * @param format
         *        The service defaults to using RIFF for WAV outputs. If your output audio is likely to exceed 4 GB in
         *        file size, or if you otherwise need the extended support of the RF64 format, set your output WAV file
         *        format to RF64.
         * @see WavFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WavFormat
         */
        Builder format(String format);

        /**
         * The service defaults to using RIFF for WAV outputs. If your output audio is likely to exceed 4 GB in file
         * size, or if you otherwise need the extended support of the RF64 format, set your output WAV file format to
         * RF64.
         * 
         * @param format
         *        The service defaults to using RIFF for WAV outputs. If your output audio is likely to exceed 4 GB in
         *        file size, or if you otherwise need the extended support of the RF64 format, set your output WAV file
         *        format to RF64.
         * @see WavFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WavFormat
         */
        Builder format(WavFormat format);

        /**
         * Sample rate in Hz.
         * 
         * @param sampleRate
         *        Sample rate in Hz.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sampleRate(Integer sampleRate);
    }

    static final class BuilderImpl implements Builder {
        private Integer bitDepth;

        private Integer channels;

        private String format;

        private Integer sampleRate;

        private BuilderImpl() {
        }

        private BuilderImpl(WavSettings model) {
            bitDepth(model.bitDepth);
            channels(model.channels);
            format(model.format);
            sampleRate(model.sampleRate);
        }

        public final Integer getBitDepth() {
            return bitDepth;
        }

        public final void setBitDepth(Integer bitDepth) {
            this.bitDepth = bitDepth;
        }

        @Override
        public final Builder bitDepth(Integer bitDepth) {
            this.bitDepth = bitDepth;
            return this;
        }

        public final Integer getChannels() {
            return channels;
        }

        public final void setChannels(Integer channels) {
            this.channels = channels;
        }

        @Override
        public final Builder channels(Integer channels) {
            this.channels = channels;
            return this;
        }

        public final String getFormat() {
            return format;
        }

        public final void setFormat(String format) {
            this.format = format;
        }

        @Override
        public final Builder format(String format) {
            this.format = format;
            return this;
        }

        @Override
        public final Builder format(WavFormat format) {
            this.format(format == null ? null : format.toString());
            return this;
        }

        public final Integer getSampleRate() {
            return sampleRate;
        }

        public final void setSampleRate(Integer sampleRate) {
            this.sampleRate = sampleRate;
        }

        @Override
        public final Builder sampleRate(Integer sampleRate) {
            this.sampleRate = sampleRate;
            return this;
        }

        @Override
        public WavSettings build() {
            return new WavSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
