/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Required when you set Profile to the value XAVC_4K_INTRA_VBR.
 */
@Generated("software.amazon.awssdk:codegen")
public final class Xavc4kIntraVbrProfileSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<Xavc4kIntraVbrProfileSettings.Builder, Xavc4kIntraVbrProfileSettings> {
    private static final SdkField<String> XAVC_CLASS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("XavcClass").getter(getter(Xavc4kIntraVbrProfileSettings::xavcClassAsString))
            .setter(setter(Builder::xavcClass))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("xavcClass").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(XAVC_CLASS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String xavcClass;

    private Xavc4kIntraVbrProfileSettings(BuilderImpl builder) {
        this.xavcClass = builder.xavcClass;
    }

    /**
     * Specify the XAVC Intra 4k (VBR) Class to set the bitrate of your output. Outputs of the same class have similar
     * image quality over the operating points that are valid for that class.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #xavcClass} will
     * return {@link Xavc4kIntraVbrProfileClass#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #xavcClassAsString}.
     * </p>
     * 
     * @return Specify the XAVC Intra 4k (VBR) Class to set the bitrate of your output. Outputs of the same class have
     *         similar image quality over the operating points that are valid for that class.
     * @see Xavc4kIntraVbrProfileClass
     */
    public final Xavc4kIntraVbrProfileClass xavcClass() {
        return Xavc4kIntraVbrProfileClass.fromValue(xavcClass);
    }

    /**
     * Specify the XAVC Intra 4k (VBR) Class to set the bitrate of your output. Outputs of the same class have similar
     * image quality over the operating points that are valid for that class.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #xavcClass} will
     * return {@link Xavc4kIntraVbrProfileClass#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #xavcClassAsString}.
     * </p>
     * 
     * @return Specify the XAVC Intra 4k (VBR) Class to set the bitrate of your output. Outputs of the same class have
     *         similar image quality over the operating points that are valid for that class.
     * @see Xavc4kIntraVbrProfileClass
     */
    public final String xavcClassAsString() {
        return xavcClass;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(xavcClassAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Xavc4kIntraVbrProfileSettings)) {
            return false;
        }
        Xavc4kIntraVbrProfileSettings other = (Xavc4kIntraVbrProfileSettings) obj;
        return Objects.equals(xavcClassAsString(), other.xavcClassAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Xavc4kIntraVbrProfileSettings").add("XavcClass", xavcClassAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "XavcClass":
            return Optional.ofNullable(clazz.cast(xavcClassAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("xavcClass", XAVC_CLASS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Xavc4kIntraVbrProfileSettings, T> g) {
        return obj -> g.apply((Xavc4kIntraVbrProfileSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Xavc4kIntraVbrProfileSettings> {
        /**
         * Specify the XAVC Intra 4k (VBR) Class to set the bitrate of your output. Outputs of the same class have
         * similar image quality over the operating points that are valid for that class.
         * 
         * @param xavcClass
         *        Specify the XAVC Intra 4k (VBR) Class to set the bitrate of your output. Outputs of the same class
         *        have similar image quality over the operating points that are valid for that class.
         * @see Xavc4kIntraVbrProfileClass
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Xavc4kIntraVbrProfileClass
         */
        Builder xavcClass(String xavcClass);

        /**
         * Specify the XAVC Intra 4k (VBR) Class to set the bitrate of your output. Outputs of the same class have
         * similar image quality over the operating points that are valid for that class.
         * 
         * @param xavcClass
         *        Specify the XAVC Intra 4k (VBR) Class to set the bitrate of your output. Outputs of the same class
         *        have similar image quality over the operating points that are valid for that class.
         * @see Xavc4kIntraVbrProfileClass
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Xavc4kIntraVbrProfileClass
         */
        Builder xavcClass(Xavc4kIntraVbrProfileClass xavcClass);
    }

    static final class BuilderImpl implements Builder {
        private String xavcClass;

        private BuilderImpl() {
        }

        private BuilderImpl(Xavc4kIntraVbrProfileSettings model) {
            xavcClass(model.xavcClass);
        }

        public final String getXavcClass() {
            return xavcClass;
        }

        public final void setXavcClass(String xavcClass) {
            this.xavcClass = xavcClass;
        }

        @Override
        public final Builder xavcClass(String xavcClass) {
            this.xavcClass = xavcClass;
            return this;
        }

        @Override
        public final Builder xavcClass(Xavc4kIntraVbrProfileClass xavcClass) {
            this.xavcClass(xavcClass == null ? null : xavcClass.toString());
            return this;
        }

        @Override
        public Xavc4kIntraVbrProfileSettings build() {
            return new Xavc4kIntraVbrProfileSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
