/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Required when you set Profile to the value XAVC_4K.
 */
@Generated("software.amazon.awssdk:codegen")
public final class Xavc4kProfileSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<Xavc4kProfileSettings.Builder, Xavc4kProfileSettings> {
    private static final SdkField<String> BITRATE_CLASS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BitrateClass").getter(getter(Xavc4kProfileSettings::bitrateClassAsString))
            .setter(setter(Builder::bitrateClass))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bitrateClass").build()).build();

    private static final SdkField<String> CODEC_PROFILE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CodecProfile").getter(getter(Xavc4kProfileSettings::codecProfileAsString))
            .setter(setter(Builder::codecProfile))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("codecProfile").build()).build();

    private static final SdkField<String> FLICKER_ADAPTIVE_QUANTIZATION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("FlickerAdaptiveQuantization")
            .getter(getter(Xavc4kProfileSettings::flickerAdaptiveQuantizationAsString))
            .setter(setter(Builder::flickerAdaptiveQuantization))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("flickerAdaptiveQuantization")
                    .build()).build();

    private static final SdkField<String> GOP_B_REFERENCE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GopBReference").getter(getter(Xavc4kProfileSettings::gopBReferenceAsString))
            .setter(setter(Builder::gopBReference))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("gopBReference").build()).build();

    private static final SdkField<Integer> GOP_CLOSED_CADENCE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("GopClosedCadence").getter(getter(Xavc4kProfileSettings::gopClosedCadence))
            .setter(setter(Builder::gopClosedCadence))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("gopClosedCadence").build()).build();

    private static final SdkField<Integer> HRD_BUFFER_SIZE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("HrdBufferSize").getter(getter(Xavc4kProfileSettings::hrdBufferSize))
            .setter(setter(Builder::hrdBufferSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hrdBufferSize").build()).build();

    private static final SdkField<String> QUALITY_TUNING_LEVEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("QualityTuningLevel").getter(getter(Xavc4kProfileSettings::qualityTuningLevelAsString))
            .setter(setter(Builder::qualityTuningLevel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("qualityTuningLevel").build())
            .build();

    private static final SdkField<Integer> SLICES_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Slices").getter(getter(Xavc4kProfileSettings::slices)).setter(setter(Builder::slices))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("slices").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BITRATE_CLASS_FIELD,
            CODEC_PROFILE_FIELD, FLICKER_ADAPTIVE_QUANTIZATION_FIELD, GOP_B_REFERENCE_FIELD, GOP_CLOSED_CADENCE_FIELD,
            HRD_BUFFER_SIZE_FIELD, QUALITY_TUNING_LEVEL_FIELD, SLICES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String bitrateClass;

    private final String codecProfile;

    private final String flickerAdaptiveQuantization;

    private final String gopBReference;

    private final Integer gopClosedCadence;

    private final Integer hrdBufferSize;

    private final String qualityTuningLevel;

    private final Integer slices;

    private Xavc4kProfileSettings(BuilderImpl builder) {
        this.bitrateClass = builder.bitrateClass;
        this.codecProfile = builder.codecProfile;
        this.flickerAdaptiveQuantization = builder.flickerAdaptiveQuantization;
        this.gopBReference = builder.gopBReference;
        this.gopClosedCadence = builder.gopClosedCadence;
        this.hrdBufferSize = builder.hrdBufferSize;
        this.qualityTuningLevel = builder.qualityTuningLevel;
        this.slices = builder.slices;
    }

    /**
     * Specify the XAVC 4k (Long GOP) Bitrate Class to set the bitrate of your output. Outputs of the same class have
     * similar image quality over the operating points that are valid for that class.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #bitrateClass} will
     * return {@link Xavc4kProfileBitrateClass#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #bitrateClassAsString}.
     * </p>
     * 
     * @return Specify the XAVC 4k (Long GOP) Bitrate Class to set the bitrate of your output. Outputs of the same class
     *         have similar image quality over the operating points that are valid for that class.
     * @see Xavc4kProfileBitrateClass
     */
    public final Xavc4kProfileBitrateClass bitrateClass() {
        return Xavc4kProfileBitrateClass.fromValue(bitrateClass);
    }

    /**
     * Specify the XAVC 4k (Long GOP) Bitrate Class to set the bitrate of your output. Outputs of the same class have
     * similar image quality over the operating points that are valid for that class.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #bitrateClass} will
     * return {@link Xavc4kProfileBitrateClass#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #bitrateClassAsString}.
     * </p>
     * 
     * @return Specify the XAVC 4k (Long GOP) Bitrate Class to set the bitrate of your output. Outputs of the same class
     *         have similar image quality over the operating points that are valid for that class.
     * @see Xavc4kProfileBitrateClass
     */
    public final String bitrateClassAsString() {
        return bitrateClass;
    }

    /**
     * Specify the codec profile for this output. Choose High, 8-bit, 4:2:0 (HIGH) or High, 10-bit, 4:2:2 (HIGH_422).
     * These profiles are specified in ITU-T H.264.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #codecProfile} will
     * return {@link Xavc4kProfileCodecProfile#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #codecProfileAsString}.
     * </p>
     * 
     * @return Specify the codec profile for this output. Choose High, 8-bit, 4:2:0 (HIGH) or High, 10-bit, 4:2:2
     *         (HIGH_422). These profiles are specified in ITU-T H.264.
     * @see Xavc4kProfileCodecProfile
     */
    public final Xavc4kProfileCodecProfile codecProfile() {
        return Xavc4kProfileCodecProfile.fromValue(codecProfile);
    }

    /**
     * Specify the codec profile for this output. Choose High, 8-bit, 4:2:0 (HIGH) or High, 10-bit, 4:2:2 (HIGH_422).
     * These profiles are specified in ITU-T H.264.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #codecProfile} will
     * return {@link Xavc4kProfileCodecProfile#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #codecProfileAsString}.
     * </p>
     * 
     * @return Specify the codec profile for this output. Choose High, 8-bit, 4:2:0 (HIGH) or High, 10-bit, 4:2:2
     *         (HIGH_422). These profiles are specified in ITU-T H.264.
     * @see Xavc4kProfileCodecProfile
     */
    public final String codecProfileAsString() {
        return codecProfile;
    }

    /**
     * The best way to set up adaptive quantization is to keep the default value, Auto, for the setting Adaptive
     * quantization. When you do so, MediaConvert automatically applies the best types of quantization for your video
     * content. Include this setting in your JSON job specification only when you choose to change the default value for
     * Adaptive quantization. Enable this setting to have the encoder reduce I-frame pop. I-frame pop appears as a
     * visual flicker that can arise when the encoder saves bits by copying some macroblocks many times from frame to
     * frame, and then refreshes them at the I-frame. When you enable this setting, the encoder updates these
     * macroblocks slightly more often to smooth out the flicker. This setting is disabled by default. Related setting:
     * In addition to enabling this setting, you must also set Adaptive quantization to a value other than Off or Auto.
     * Use Adaptive quantization to adjust the degree of smoothing that Flicker adaptive quantization provides.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #flickerAdaptiveQuantization} will return {@link XavcFlickerAdaptiveQuantization#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #flickerAdaptiveQuantizationAsString}.
     * </p>
     * 
     * @return The best way to set up adaptive quantization is to keep the default value, Auto, for the setting Adaptive
     *         quantization. When you do so, MediaConvert automatically applies the best types of quantization for your
     *         video content. Include this setting in your JSON job specification only when you choose to change the
     *         default value for Adaptive quantization. Enable this setting to have the encoder reduce I-frame pop.
     *         I-frame pop appears as a visual flicker that can arise when the encoder saves bits by copying some
     *         macroblocks many times from frame to frame, and then refreshes them at the I-frame. When you enable this
     *         setting, the encoder updates these macroblocks slightly more often to smooth out the flicker. This
     *         setting is disabled by default. Related setting: In addition to enabling this setting, you must also set
     *         Adaptive quantization to a value other than Off or Auto. Use Adaptive quantization to adjust the degree
     *         of smoothing that Flicker adaptive quantization provides.
     * @see XavcFlickerAdaptiveQuantization
     */
    public final XavcFlickerAdaptiveQuantization flickerAdaptiveQuantization() {
        return XavcFlickerAdaptiveQuantization.fromValue(flickerAdaptiveQuantization);
    }

    /**
     * The best way to set up adaptive quantization is to keep the default value, Auto, for the setting Adaptive
     * quantization. When you do so, MediaConvert automatically applies the best types of quantization for your video
     * content. Include this setting in your JSON job specification only when you choose to change the default value for
     * Adaptive quantization. Enable this setting to have the encoder reduce I-frame pop. I-frame pop appears as a
     * visual flicker that can arise when the encoder saves bits by copying some macroblocks many times from frame to
     * frame, and then refreshes them at the I-frame. When you enable this setting, the encoder updates these
     * macroblocks slightly more often to smooth out the flicker. This setting is disabled by default. Related setting:
     * In addition to enabling this setting, you must also set Adaptive quantization to a value other than Off or Auto.
     * Use Adaptive quantization to adjust the degree of smoothing that Flicker adaptive quantization provides.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #flickerAdaptiveQuantization} will return {@link XavcFlickerAdaptiveQuantization#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #flickerAdaptiveQuantizationAsString}.
     * </p>
     * 
     * @return The best way to set up adaptive quantization is to keep the default value, Auto, for the setting Adaptive
     *         quantization. When you do so, MediaConvert automatically applies the best types of quantization for your
     *         video content. Include this setting in your JSON job specification only when you choose to change the
     *         default value for Adaptive quantization. Enable this setting to have the encoder reduce I-frame pop.
     *         I-frame pop appears as a visual flicker that can arise when the encoder saves bits by copying some
     *         macroblocks many times from frame to frame, and then refreshes them at the I-frame. When you enable this
     *         setting, the encoder updates these macroblocks slightly more often to smooth out the flicker. This
     *         setting is disabled by default. Related setting: In addition to enabling this setting, you must also set
     *         Adaptive quantization to a value other than Off or Auto. Use Adaptive quantization to adjust the degree
     *         of smoothing that Flicker adaptive quantization provides.
     * @see XavcFlickerAdaptiveQuantization
     */
    public final String flickerAdaptiveQuantizationAsString() {
        return flickerAdaptiveQuantization;
    }

    /**
     * Specify whether the encoder uses B-frames as reference frames for other pictures in the same GOP. Choose Allow to
     * allow the encoder to use B-frames as reference frames. Choose Don't allow to prevent the encoder from using
     * B-frames as reference frames.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #gopBReference}
     * will return {@link XavcGopBReference#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #gopBReferenceAsString}.
     * </p>
     * 
     * @return Specify whether the encoder uses B-frames as reference frames for other pictures in the same GOP. Choose
     *         Allow to allow the encoder to use B-frames as reference frames. Choose Don't allow to prevent the encoder
     *         from using B-frames as reference frames.
     * @see XavcGopBReference
     */
    public final XavcGopBReference gopBReference() {
        return XavcGopBReference.fromValue(gopBReference);
    }

    /**
     * Specify whether the encoder uses B-frames as reference frames for other pictures in the same GOP. Choose Allow to
     * allow the encoder to use B-frames as reference frames. Choose Don't allow to prevent the encoder from using
     * B-frames as reference frames.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #gopBReference}
     * will return {@link XavcGopBReference#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #gopBReferenceAsString}.
     * </p>
     * 
     * @return Specify whether the encoder uses B-frames as reference frames for other pictures in the same GOP. Choose
     *         Allow to allow the encoder to use B-frames as reference frames. Choose Don't allow to prevent the encoder
     *         from using B-frames as reference frames.
     * @see XavcGopBReference
     */
    public final String gopBReferenceAsString() {
        return gopBReference;
    }

    /**
     * Frequency of closed GOPs. In streaming applications, it is recommended that this be set to 1 so a decoder joining
     * mid-stream will receive an IDR frame as quickly as possible. Setting this value to 0 will break output
     * segmenting.
     * 
     * @return Frequency of closed GOPs. In streaming applications, it is recommended that this be set to 1 so a decoder
     *         joining mid-stream will receive an IDR frame as quickly as possible. Setting this value to 0 will break
     *         output segmenting.
     */
    public final Integer gopClosedCadence() {
        return gopClosedCadence;
    }

    /**
     * Specify the size of the buffer that MediaConvert uses in the HRD buffer model for this output. Specify this value
     * in bits; for example, enter five megabits as 5000000. When you don't set this value, or you set it to zero,
     * MediaConvert calculates the default by doubling the bitrate of this output point.
     * 
     * @return Specify the size of the buffer that MediaConvert uses in the HRD buffer model for this output. Specify
     *         this value in bits; for example, enter five megabits as 5000000. When you don't set this value, or you
     *         set it to zero, MediaConvert calculates the default by doubling the bitrate of this output point.
     */
    public final Integer hrdBufferSize() {
        return hrdBufferSize;
    }

    /**
     * Optional. Use Quality tuning level to choose how you want to trade off encoding speed for output video quality.
     * The default behavior is faster, lower quality, single-pass encoding.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #qualityTuningLevel} will return {@link Xavc4kProfileQualityTuningLevel#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #qualityTuningLevelAsString}.
     * </p>
     * 
     * @return Optional. Use Quality tuning level to choose how you want to trade off encoding speed for output video
     *         quality. The default behavior is faster, lower quality, single-pass encoding.
     * @see Xavc4kProfileQualityTuningLevel
     */
    public final Xavc4kProfileQualityTuningLevel qualityTuningLevel() {
        return Xavc4kProfileQualityTuningLevel.fromValue(qualityTuningLevel);
    }

    /**
     * Optional. Use Quality tuning level to choose how you want to trade off encoding speed for output video quality.
     * The default behavior is faster, lower quality, single-pass encoding.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #qualityTuningLevel} will return {@link Xavc4kProfileQualityTuningLevel#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #qualityTuningLevelAsString}.
     * </p>
     * 
     * @return Optional. Use Quality tuning level to choose how you want to trade off encoding speed for output video
     *         quality. The default behavior is faster, lower quality, single-pass encoding.
     * @see Xavc4kProfileQualityTuningLevel
     */
    public final String qualityTuningLevelAsString() {
        return qualityTuningLevel;
    }

    /**
     * Number of slices per picture. Must be less than or equal to the number of macroblock rows for progressive
     * pictures, and less than or equal to half the number of macroblock rows for interlaced pictures.
     * 
     * @return Number of slices per picture. Must be less than or equal to the number of macroblock rows for progressive
     *         pictures, and less than or equal to half the number of macroblock rows for interlaced pictures.
     */
    public final Integer slices() {
        return slices;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(bitrateClassAsString());
        hashCode = 31 * hashCode + Objects.hashCode(codecProfileAsString());
        hashCode = 31 * hashCode + Objects.hashCode(flickerAdaptiveQuantizationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(gopBReferenceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(gopClosedCadence());
        hashCode = 31 * hashCode + Objects.hashCode(hrdBufferSize());
        hashCode = 31 * hashCode + Objects.hashCode(qualityTuningLevelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(slices());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Xavc4kProfileSettings)) {
            return false;
        }
        Xavc4kProfileSettings other = (Xavc4kProfileSettings) obj;
        return Objects.equals(bitrateClassAsString(), other.bitrateClassAsString())
                && Objects.equals(codecProfileAsString(), other.codecProfileAsString())
                && Objects.equals(flickerAdaptiveQuantizationAsString(), other.flickerAdaptiveQuantizationAsString())
                && Objects.equals(gopBReferenceAsString(), other.gopBReferenceAsString())
                && Objects.equals(gopClosedCadence(), other.gopClosedCadence())
                && Objects.equals(hrdBufferSize(), other.hrdBufferSize())
                && Objects.equals(qualityTuningLevelAsString(), other.qualityTuningLevelAsString())
                && Objects.equals(slices(), other.slices());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Xavc4kProfileSettings").add("BitrateClass", bitrateClassAsString())
                .add("CodecProfile", codecProfileAsString())
                .add("FlickerAdaptiveQuantization", flickerAdaptiveQuantizationAsString())
                .add("GopBReference", gopBReferenceAsString()).add("GopClosedCadence", gopClosedCadence())
                .add("HrdBufferSize", hrdBufferSize()).add("QualityTuningLevel", qualityTuningLevelAsString())
                .add("Slices", slices()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BitrateClass":
            return Optional.ofNullable(clazz.cast(bitrateClassAsString()));
        case "CodecProfile":
            return Optional.ofNullable(clazz.cast(codecProfileAsString()));
        case "FlickerAdaptiveQuantization":
            return Optional.ofNullable(clazz.cast(flickerAdaptiveQuantizationAsString()));
        case "GopBReference":
            return Optional.ofNullable(clazz.cast(gopBReferenceAsString()));
        case "GopClosedCadence":
            return Optional.ofNullable(clazz.cast(gopClosedCadence()));
        case "HrdBufferSize":
            return Optional.ofNullable(clazz.cast(hrdBufferSize()));
        case "QualityTuningLevel":
            return Optional.ofNullable(clazz.cast(qualityTuningLevelAsString()));
        case "Slices":
            return Optional.ofNullable(clazz.cast(slices()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("bitrateClass", BITRATE_CLASS_FIELD);
        map.put("codecProfile", CODEC_PROFILE_FIELD);
        map.put("flickerAdaptiveQuantization", FLICKER_ADAPTIVE_QUANTIZATION_FIELD);
        map.put("gopBReference", GOP_B_REFERENCE_FIELD);
        map.put("gopClosedCadence", GOP_CLOSED_CADENCE_FIELD);
        map.put("hrdBufferSize", HRD_BUFFER_SIZE_FIELD);
        map.put("qualityTuningLevel", QUALITY_TUNING_LEVEL_FIELD);
        map.put("slices", SLICES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Xavc4kProfileSettings, T> g) {
        return obj -> g.apply((Xavc4kProfileSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Xavc4kProfileSettings> {
        /**
         * Specify the XAVC 4k (Long GOP) Bitrate Class to set the bitrate of your output. Outputs of the same class
         * have similar image quality over the operating points that are valid for that class.
         * 
         * @param bitrateClass
         *        Specify the XAVC 4k (Long GOP) Bitrate Class to set the bitrate of your output. Outputs of the same
         *        class have similar image quality over the operating points that are valid for that class.
         * @see Xavc4kProfileBitrateClass
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Xavc4kProfileBitrateClass
         */
        Builder bitrateClass(String bitrateClass);

        /**
         * Specify the XAVC 4k (Long GOP) Bitrate Class to set the bitrate of your output. Outputs of the same class
         * have similar image quality over the operating points that are valid for that class.
         * 
         * @param bitrateClass
         *        Specify the XAVC 4k (Long GOP) Bitrate Class to set the bitrate of your output. Outputs of the same
         *        class have similar image quality over the operating points that are valid for that class.
         * @see Xavc4kProfileBitrateClass
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Xavc4kProfileBitrateClass
         */
        Builder bitrateClass(Xavc4kProfileBitrateClass bitrateClass);

        /**
         * Specify the codec profile for this output. Choose High, 8-bit, 4:2:0 (HIGH) or High, 10-bit, 4:2:2
         * (HIGH_422). These profiles are specified in ITU-T H.264.
         * 
         * @param codecProfile
         *        Specify the codec profile for this output. Choose High, 8-bit, 4:2:0 (HIGH) or High, 10-bit, 4:2:2
         *        (HIGH_422). These profiles are specified in ITU-T H.264.
         * @see Xavc4kProfileCodecProfile
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Xavc4kProfileCodecProfile
         */
        Builder codecProfile(String codecProfile);

        /**
         * Specify the codec profile for this output. Choose High, 8-bit, 4:2:0 (HIGH) or High, 10-bit, 4:2:2
         * (HIGH_422). These profiles are specified in ITU-T H.264.
         * 
         * @param codecProfile
         *        Specify the codec profile for this output. Choose High, 8-bit, 4:2:0 (HIGH) or High, 10-bit, 4:2:2
         *        (HIGH_422). These profiles are specified in ITU-T H.264.
         * @see Xavc4kProfileCodecProfile
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Xavc4kProfileCodecProfile
         */
        Builder codecProfile(Xavc4kProfileCodecProfile codecProfile);

        /**
         * The best way to set up adaptive quantization is to keep the default value, Auto, for the setting Adaptive
         * quantization. When you do so, MediaConvert automatically applies the best types of quantization for your
         * video content. Include this setting in your JSON job specification only when you choose to change the default
         * value for Adaptive quantization. Enable this setting to have the encoder reduce I-frame pop. I-frame pop
         * appears as a visual flicker that can arise when the encoder saves bits by copying some macroblocks many times
         * from frame to frame, and then refreshes them at the I-frame. When you enable this setting, the encoder
         * updates these macroblocks slightly more often to smooth out the flicker. This setting is disabled by default.
         * Related setting: In addition to enabling this setting, you must also set Adaptive quantization to a value
         * other than Off or Auto. Use Adaptive quantization to adjust the degree of smoothing that Flicker adaptive
         * quantization provides.
         * 
         * @param flickerAdaptiveQuantization
         *        The best way to set up adaptive quantization is to keep the default value, Auto, for the setting
         *        Adaptive quantization. When you do so, MediaConvert automatically applies the best types of
         *        quantization for your video content. Include this setting in your JSON job specification only when you
         *        choose to change the default value for Adaptive quantization. Enable this setting to have the encoder
         *        reduce I-frame pop. I-frame pop appears as a visual flicker that can arise when the encoder saves bits
         *        by copying some macroblocks many times from frame to frame, and then refreshes them at the I-frame.
         *        When you enable this setting, the encoder updates these macroblocks slightly more often to smooth out
         *        the flicker. This setting is disabled by default. Related setting: In addition to enabling this
         *        setting, you must also set Adaptive quantization to a value other than Off or Auto. Use Adaptive
         *        quantization to adjust the degree of smoothing that Flicker adaptive quantization provides.
         * @see XavcFlickerAdaptiveQuantization
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see XavcFlickerAdaptiveQuantization
         */
        Builder flickerAdaptiveQuantization(String flickerAdaptiveQuantization);

        /**
         * The best way to set up adaptive quantization is to keep the default value, Auto, for the setting Adaptive
         * quantization. When you do so, MediaConvert automatically applies the best types of quantization for your
         * video content. Include this setting in your JSON job specification only when you choose to change the default
         * value for Adaptive quantization. Enable this setting to have the encoder reduce I-frame pop. I-frame pop
         * appears as a visual flicker that can arise when the encoder saves bits by copying some macroblocks many times
         * from frame to frame, and then refreshes them at the I-frame. When you enable this setting, the encoder
         * updates these macroblocks slightly more often to smooth out the flicker. This setting is disabled by default.
         * Related setting: In addition to enabling this setting, you must also set Adaptive quantization to a value
         * other than Off or Auto. Use Adaptive quantization to adjust the degree of smoothing that Flicker adaptive
         * quantization provides.
         * 
         * @param flickerAdaptiveQuantization
         *        The best way to set up adaptive quantization is to keep the default value, Auto, for the setting
         *        Adaptive quantization. When you do so, MediaConvert automatically applies the best types of
         *        quantization for your video content. Include this setting in your JSON job specification only when you
         *        choose to change the default value for Adaptive quantization. Enable this setting to have the encoder
         *        reduce I-frame pop. I-frame pop appears as a visual flicker that can arise when the encoder saves bits
         *        by copying some macroblocks many times from frame to frame, and then refreshes them at the I-frame.
         *        When you enable this setting, the encoder updates these macroblocks slightly more often to smooth out
         *        the flicker. This setting is disabled by default. Related setting: In addition to enabling this
         *        setting, you must also set Adaptive quantization to a value other than Off or Auto. Use Adaptive
         *        quantization to adjust the degree of smoothing that Flicker adaptive quantization provides.
         * @see XavcFlickerAdaptiveQuantization
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see XavcFlickerAdaptiveQuantization
         */
        Builder flickerAdaptiveQuantization(XavcFlickerAdaptiveQuantization flickerAdaptiveQuantization);

        /**
         * Specify whether the encoder uses B-frames as reference frames for other pictures in the same GOP. Choose
         * Allow to allow the encoder to use B-frames as reference frames. Choose Don't allow to prevent the encoder
         * from using B-frames as reference frames.
         * 
         * @param gopBReference
         *        Specify whether the encoder uses B-frames as reference frames for other pictures in the same GOP.
         *        Choose Allow to allow the encoder to use B-frames as reference frames. Choose Don't allow to prevent
         *        the encoder from using B-frames as reference frames.
         * @see XavcGopBReference
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see XavcGopBReference
         */
        Builder gopBReference(String gopBReference);

        /**
         * Specify whether the encoder uses B-frames as reference frames for other pictures in the same GOP. Choose
         * Allow to allow the encoder to use B-frames as reference frames. Choose Don't allow to prevent the encoder
         * from using B-frames as reference frames.
         * 
         * @param gopBReference
         *        Specify whether the encoder uses B-frames as reference frames for other pictures in the same GOP.
         *        Choose Allow to allow the encoder to use B-frames as reference frames. Choose Don't allow to prevent
         *        the encoder from using B-frames as reference frames.
         * @see XavcGopBReference
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see XavcGopBReference
         */
        Builder gopBReference(XavcGopBReference gopBReference);

        /**
         * Frequency of closed GOPs. In streaming applications, it is recommended that this be set to 1 so a decoder
         * joining mid-stream will receive an IDR frame as quickly as possible. Setting this value to 0 will break
         * output segmenting.
         * 
         * @param gopClosedCadence
         *        Frequency of closed GOPs. In streaming applications, it is recommended that this be set to 1 so a
         *        decoder joining mid-stream will receive an IDR frame as quickly as possible. Setting this value to 0
         *        will break output segmenting.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gopClosedCadence(Integer gopClosedCadence);

        /**
         * Specify the size of the buffer that MediaConvert uses in the HRD buffer model for this output. Specify this
         * value in bits; for example, enter five megabits as 5000000. When you don't set this value, or you set it to
         * zero, MediaConvert calculates the default by doubling the bitrate of this output point.
         * 
         * @param hrdBufferSize
         *        Specify the size of the buffer that MediaConvert uses in the HRD buffer model for this output. Specify
         *        this value in bits; for example, enter five megabits as 5000000. When you don't set this value, or you
         *        set it to zero, MediaConvert calculates the default by doubling the bitrate of this output point.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hrdBufferSize(Integer hrdBufferSize);

        /**
         * Optional. Use Quality tuning level to choose how you want to trade off encoding speed for output video
         * quality. The default behavior is faster, lower quality, single-pass encoding.
         * 
         * @param qualityTuningLevel
         *        Optional. Use Quality tuning level to choose how you want to trade off encoding speed for output video
         *        quality. The default behavior is faster, lower quality, single-pass encoding.
         * @see Xavc4kProfileQualityTuningLevel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Xavc4kProfileQualityTuningLevel
         */
        Builder qualityTuningLevel(String qualityTuningLevel);

        /**
         * Optional. Use Quality tuning level to choose how you want to trade off encoding speed for output video
         * quality. The default behavior is faster, lower quality, single-pass encoding.
         * 
         * @param qualityTuningLevel
         *        Optional. Use Quality tuning level to choose how you want to trade off encoding speed for output video
         *        quality. The default behavior is faster, lower quality, single-pass encoding.
         * @see Xavc4kProfileQualityTuningLevel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Xavc4kProfileQualityTuningLevel
         */
        Builder qualityTuningLevel(Xavc4kProfileQualityTuningLevel qualityTuningLevel);

        /**
         * Number of slices per picture. Must be less than or equal to the number of macroblock rows for progressive
         * pictures, and less than or equal to half the number of macroblock rows for interlaced pictures.
         * 
         * @param slices
         *        Number of slices per picture. Must be less than or equal to the number of macroblock rows for
         *        progressive pictures, and less than or equal to half the number of macroblock rows for interlaced
         *        pictures.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder slices(Integer slices);
    }

    static final class BuilderImpl implements Builder {
        private String bitrateClass;

        private String codecProfile;

        private String flickerAdaptiveQuantization;

        private String gopBReference;

        private Integer gopClosedCadence;

        private Integer hrdBufferSize;

        private String qualityTuningLevel;

        private Integer slices;

        private BuilderImpl() {
        }

        private BuilderImpl(Xavc4kProfileSettings model) {
            bitrateClass(model.bitrateClass);
            codecProfile(model.codecProfile);
            flickerAdaptiveQuantization(model.flickerAdaptiveQuantization);
            gopBReference(model.gopBReference);
            gopClosedCadence(model.gopClosedCadence);
            hrdBufferSize(model.hrdBufferSize);
            qualityTuningLevel(model.qualityTuningLevel);
            slices(model.slices);
        }

        public final String getBitrateClass() {
            return bitrateClass;
        }

        public final void setBitrateClass(String bitrateClass) {
            this.bitrateClass = bitrateClass;
        }

        @Override
        public final Builder bitrateClass(String bitrateClass) {
            this.bitrateClass = bitrateClass;
            return this;
        }

        @Override
        public final Builder bitrateClass(Xavc4kProfileBitrateClass bitrateClass) {
            this.bitrateClass(bitrateClass == null ? null : bitrateClass.toString());
            return this;
        }

        public final String getCodecProfile() {
            return codecProfile;
        }

        public final void setCodecProfile(String codecProfile) {
            this.codecProfile = codecProfile;
        }

        @Override
        public final Builder codecProfile(String codecProfile) {
            this.codecProfile = codecProfile;
            return this;
        }

        @Override
        public final Builder codecProfile(Xavc4kProfileCodecProfile codecProfile) {
            this.codecProfile(codecProfile == null ? null : codecProfile.toString());
            return this;
        }

        public final String getFlickerAdaptiveQuantization() {
            return flickerAdaptiveQuantization;
        }

        public final void setFlickerAdaptiveQuantization(String flickerAdaptiveQuantization) {
            this.flickerAdaptiveQuantization = flickerAdaptiveQuantization;
        }

        @Override
        public final Builder flickerAdaptiveQuantization(String flickerAdaptiveQuantization) {
            this.flickerAdaptiveQuantization = flickerAdaptiveQuantization;
            return this;
        }

        @Override
        public final Builder flickerAdaptiveQuantization(XavcFlickerAdaptiveQuantization flickerAdaptiveQuantization) {
            this.flickerAdaptiveQuantization(flickerAdaptiveQuantization == null ? null : flickerAdaptiveQuantization.toString());
            return this;
        }

        public final String getGopBReference() {
            return gopBReference;
        }

        public final void setGopBReference(String gopBReference) {
            this.gopBReference = gopBReference;
        }

        @Override
        public final Builder gopBReference(String gopBReference) {
            this.gopBReference = gopBReference;
            return this;
        }

        @Override
        public final Builder gopBReference(XavcGopBReference gopBReference) {
            this.gopBReference(gopBReference == null ? null : gopBReference.toString());
            return this;
        }

        public final Integer getGopClosedCadence() {
            return gopClosedCadence;
        }

        public final void setGopClosedCadence(Integer gopClosedCadence) {
            this.gopClosedCadence = gopClosedCadence;
        }

        @Override
        public final Builder gopClosedCadence(Integer gopClosedCadence) {
            this.gopClosedCadence = gopClosedCadence;
            return this;
        }

        public final Integer getHrdBufferSize() {
            return hrdBufferSize;
        }

        public final void setHrdBufferSize(Integer hrdBufferSize) {
            this.hrdBufferSize = hrdBufferSize;
        }

        @Override
        public final Builder hrdBufferSize(Integer hrdBufferSize) {
            this.hrdBufferSize = hrdBufferSize;
            return this;
        }

        public final String getQualityTuningLevel() {
            return qualityTuningLevel;
        }

        public final void setQualityTuningLevel(String qualityTuningLevel) {
            this.qualityTuningLevel = qualityTuningLevel;
        }

        @Override
        public final Builder qualityTuningLevel(String qualityTuningLevel) {
            this.qualityTuningLevel = qualityTuningLevel;
            return this;
        }

        @Override
        public final Builder qualityTuningLevel(Xavc4kProfileQualityTuningLevel qualityTuningLevel) {
            this.qualityTuningLevel(qualityTuningLevel == null ? null : qualityTuningLevel.toString());
            return this;
        }

        public final Integer getSlices() {
            return slices;
        }

        public final void setSlices(Integer slices) {
            this.slices = slices;
        }

        @Override
        public final Builder slices(Integer slices) {
            this.slices = slices;
            return this;
        }

        @Override
        public Xavc4kProfileSettings build() {
            return new Xavc4kProfileSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
