/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class ___listOfColorConversion3DLUTSettingCopier {
    static List<ColorConversion3DLUTSetting> copy(
            Collection<? extends ColorConversion3DLUTSetting> __listOfColorConversion3DLUTSettingParam) {
        List<ColorConversion3DLUTSetting> list;
        if (__listOfColorConversion3DLUTSettingParam == null
                || __listOfColorConversion3DLUTSettingParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<ColorConversion3DLUTSetting> modifiableList = new ArrayList<>(__listOfColorConversion3DLUTSettingParam.size());
            __listOfColorConversion3DLUTSettingParam.forEach(entry -> {
                modifiableList.add(entry);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<ColorConversion3DLUTSetting> copyFromBuilder(
            Collection<? extends ColorConversion3DLUTSetting.Builder> __listOfColorConversion3DLUTSettingParam) {
        List<ColorConversion3DLUTSetting> list;
        if (__listOfColorConversion3DLUTSettingParam == null
                || __listOfColorConversion3DLUTSettingParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<ColorConversion3DLUTSetting> modifiableList = new ArrayList<>(__listOfColorConversion3DLUTSettingParam.size());
            __listOfColorConversion3DLUTSettingParam.forEach(entry -> {
                ColorConversion3DLUTSetting member = entry == null ? null : entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<ColorConversion3DLUTSetting.Builder> copyToBuilder(
            Collection<? extends ColorConversion3DLUTSetting> __listOfColorConversion3DLUTSettingParam) {
        List<ColorConversion3DLUTSetting.Builder> list;
        if (__listOfColorConversion3DLUTSettingParam == null
                || __listOfColorConversion3DLUTSettingParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<ColorConversion3DLUTSetting.Builder> modifiableList = new ArrayList<>(
                    __listOfColorConversion3DLUTSettingParam.size());
            __listOfColorConversion3DLUTSettingParam.forEach(entry -> {
                ColorConversion3DLUTSetting.Builder member = entry == null ? null : entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
