/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class ___listOfOutputCopier {
    static List<Output> copy(Collection<? extends Output> __listOfOutputParam) {
        List<Output> list;
        if (__listOfOutputParam == null || __listOfOutputParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<Output> modifiableList = new ArrayList<>(__listOfOutputParam.size());
            __listOfOutputParam.forEach(entry -> {
                modifiableList.add(entry);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<Output> copyFromBuilder(Collection<? extends Output.Builder> __listOfOutputParam) {
        List<Output> list;
        if (__listOfOutputParam == null || __listOfOutputParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<Output> modifiableList = new ArrayList<>(__listOfOutputParam.size());
            __listOfOutputParam.forEach(entry -> {
                Output member = entry == null ? null : entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<Output.Builder> copyToBuilder(Collection<? extends Output> __listOfOutputParam) {
        List<Output.Builder> list;
        if (__listOfOutputParam == null || __listOfOutputParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<Output.Builder> modifiableList = new ArrayList<>(__listOfOutputParam.size());
            __listOfOutputParam.forEach(entry -> {
                Output.Builder member = entry == null ? null : entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
