/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Metadata
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Metadata> {
    private static final SdkField<String> E_TAG_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ETag").getter(Metadata.getter(Metadata::eTag)).setter(Metadata.setter(Builder::eTag)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eTag").build()}).build();
    private static final SdkField<Long> FILE_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("FileSize").getter(Metadata.getter(Metadata::fileSize)).setter(Metadata.setter(Builder::fileSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fileSize").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastModified").getter(Metadata.getter(Metadata::lastModified)).setter(Metadata.setter(Builder::lastModified)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastModified").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.UNIX_TIMESTAMP)}).build();
    private static final SdkField<String> MIME_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MimeType").getter(Metadata.getter(Metadata::mimeType)).setter(Metadata.setter(Builder::mimeType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mimeType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(E_TAG_FIELD, FILE_SIZE_FIELD, LAST_MODIFIED_FIELD, MIME_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Metadata.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String eTag;
    private final Long fileSize;
    private final Instant lastModified;
    private final String mimeType;

    private Metadata(BuilderImpl builder) {
        this.eTag = builder.eTag;
        this.fileSize = builder.fileSize;
        this.lastModified = builder.lastModified;
        this.mimeType = builder.mimeType;
    }

    public final String eTag() {
        return this.eTag;
    }

    public final Long fileSize() {
        return this.fileSize;
    }

    public final Instant lastModified() {
        return this.lastModified;
    }

    public final String mimeType() {
        return this.mimeType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.eTag());
        hashCode = 31 * hashCode + Objects.hashCode(this.fileSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModified());
        hashCode = 31 * hashCode + Objects.hashCode(this.mimeType());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Metadata)) {
            return false;
        }
        Metadata other = (Metadata)obj;
        return Objects.equals(this.eTag(), other.eTag()) && Objects.equals(this.fileSize(), other.fileSize()) && Objects.equals(this.lastModified(), other.lastModified()) && Objects.equals(this.mimeType(), other.mimeType());
    }

    public final String toString() {
        return ToString.builder((String)"Metadata").add("ETag", (Object)this.eTag()).add("FileSize", (Object)this.fileSize()).add("LastModified", (Object)this.lastModified()).add("MimeType", (Object)this.mimeType()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ETag": {
                return Optional.ofNullable(clazz.cast(this.eTag()));
            }
            case "FileSize": {
                return Optional.ofNullable(clazz.cast(this.fileSize()));
            }
            case "LastModified": {
                return Optional.ofNullable(clazz.cast(this.lastModified()));
            }
            case "MimeType": {
                return Optional.ofNullable(clazz.cast(this.mimeType()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("eTag", E_TAG_FIELD);
        map.put("fileSize", FILE_SIZE_FIELD);
        map.put("lastModified", LAST_MODIFIED_FIELD);
        map.put("mimeType", MIME_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Metadata, T> g) {
        return obj -> g.apply((Metadata)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String eTag;
        private Long fileSize;
        private Instant lastModified;
        private String mimeType;

        private BuilderImpl() {
        }

        private BuilderImpl(Metadata model) {
            this.eTag(model.eTag);
            this.fileSize(model.fileSize);
            this.lastModified(model.lastModified);
            this.mimeType(model.mimeType);
        }

        public final String getETag() {
            return this.eTag;
        }

        public final void setETag(String eTag) {
            this.eTag = eTag;
        }

        @Override
        public final Builder eTag(String eTag) {
            this.eTag = eTag;
            return this;
        }

        public final Long getFileSize() {
            return this.fileSize;
        }

        public final void setFileSize(Long fileSize) {
            this.fileSize = fileSize;
        }

        @Override
        public final Builder fileSize(Long fileSize) {
            this.fileSize = fileSize;
            return this;
        }

        public final Instant getLastModified() {
            return this.lastModified;
        }

        public final void setLastModified(Instant lastModified) {
            this.lastModified = lastModified;
        }

        @Override
        public final Builder lastModified(Instant lastModified) {
            this.lastModified = lastModified;
            return this;
        }

        public final String getMimeType() {
            return this.mimeType;
        }

        public final void setMimeType(String mimeType) {
            this.mimeType = mimeType;
        }

        @Override
        public final Builder mimeType(String mimeType) {
            this.mimeType = mimeType;
            return this;
        }

        public Metadata build() {
            return new Metadata(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Metadata> {
        public Builder eTag(String var1);

        public Builder fileSize(Long var1);

        public Builder lastModified(Instant var1);

        public Builder mimeType(String var1);
    }
}

