/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mediaconvert.model.ColorPrimaries;
import software.amazon.awssdk.services.mediaconvert.model.FrameRate;
import software.amazon.awssdk.services.mediaconvert.model.MatrixCoefficients;
import software.amazon.awssdk.services.mediaconvert.model.TransferCharacteristics;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CodecMetadata
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CodecMetadata> {
    private static final SdkField<Integer> BIT_DEPTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("BitDepth").getter(CodecMetadata.getter(CodecMetadata::bitDepth)).setter(CodecMetadata.setter(Builder::bitDepth)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bitDepth").build()}).build();
    private static final SdkField<String> CHROMA_SUBSAMPLING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ChromaSubsampling").getter(CodecMetadata.getter(CodecMetadata::chromaSubsampling)).setter(CodecMetadata.setter(Builder::chromaSubsampling)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("chromaSubsampling").build()}).build();
    private static final SdkField<FrameRate> CODED_FRAME_RATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CodedFrameRate").getter(CodecMetadata.getter(CodecMetadata::codedFrameRate)).setter(CodecMetadata.setter(Builder::codedFrameRate)).constructor(FrameRate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("codedFrameRate").build()}).build();
    private static final SdkField<String> COLOR_PRIMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ColorPrimaries").getter(CodecMetadata.getter(CodecMetadata::colorPrimariesAsString)).setter(CodecMetadata.setter(Builder::colorPrimaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("colorPrimaries").build()}).build();
    private static final SdkField<Integer> HEIGHT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Height").getter(CodecMetadata.getter(CodecMetadata::height)).setter(CodecMetadata.setter(Builder::height)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("height").build()}).build();
    private static final SdkField<String> LEVEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Level").getter(CodecMetadata.getter(CodecMetadata::level)).setter(CodecMetadata.setter(Builder::level)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("level").build()}).build();
    private static final SdkField<String> MATRIX_COEFFICIENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MatrixCoefficients").getter(CodecMetadata.getter(CodecMetadata::matrixCoefficientsAsString)).setter(CodecMetadata.setter(Builder::matrixCoefficients)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("matrixCoefficients").build()}).build();
    private static final SdkField<String> PROFILE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Profile").getter(CodecMetadata.getter(CodecMetadata::profile)).setter(CodecMetadata.setter(Builder::profile)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("profile").build()}).build();
    private static final SdkField<String> SCAN_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ScanType").getter(CodecMetadata.getter(CodecMetadata::scanType)).setter(CodecMetadata.setter(Builder::scanType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scanType").build()}).build();
    private static final SdkField<String> TRANSFER_CHARACTERISTICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TransferCharacteristics").getter(CodecMetadata.getter(CodecMetadata::transferCharacteristicsAsString)).setter(CodecMetadata.setter(Builder::transferCharacteristics)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("transferCharacteristics").build()}).build();
    private static final SdkField<Integer> WIDTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Width").getter(CodecMetadata.getter(CodecMetadata::width)).setter(CodecMetadata.setter(Builder::width)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("width").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BIT_DEPTH_FIELD, CHROMA_SUBSAMPLING_FIELD, CODED_FRAME_RATE_FIELD, COLOR_PRIMARIES_FIELD, HEIGHT_FIELD, LEVEL_FIELD, MATRIX_COEFFICIENTS_FIELD, PROFILE_FIELD, SCAN_TYPE_FIELD, TRANSFER_CHARACTERISTICS_FIELD, WIDTH_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CodecMetadata.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Integer bitDepth;
    private final String chromaSubsampling;
    private final FrameRate codedFrameRate;
    private final String colorPrimaries;
    private final Integer height;
    private final String level;
    private final String matrixCoefficients;
    private final String profile;
    private final String scanType;
    private final String transferCharacteristics;
    private final Integer width;

    private CodecMetadata(BuilderImpl builder) {
        this.bitDepth = builder.bitDepth;
        this.chromaSubsampling = builder.chromaSubsampling;
        this.codedFrameRate = builder.codedFrameRate;
        this.colorPrimaries = builder.colorPrimaries;
        this.height = builder.height;
        this.level = builder.level;
        this.matrixCoefficients = builder.matrixCoefficients;
        this.profile = builder.profile;
        this.scanType = builder.scanType;
        this.transferCharacteristics = builder.transferCharacteristics;
        this.width = builder.width;
    }

    public final Integer bitDepth() {
        return this.bitDepth;
    }

    public final String chromaSubsampling() {
        return this.chromaSubsampling;
    }

    public final FrameRate codedFrameRate() {
        return this.codedFrameRate;
    }

    public final ColorPrimaries colorPrimaries() {
        return ColorPrimaries.fromValue(this.colorPrimaries);
    }

    public final String colorPrimariesAsString() {
        return this.colorPrimaries;
    }

    public final Integer height() {
        return this.height;
    }

    public final String level() {
        return this.level;
    }

    public final MatrixCoefficients matrixCoefficients() {
        return MatrixCoefficients.fromValue(this.matrixCoefficients);
    }

    public final String matrixCoefficientsAsString() {
        return this.matrixCoefficients;
    }

    public final String profile() {
        return this.profile;
    }

    public final String scanType() {
        return this.scanType;
    }

    public final TransferCharacteristics transferCharacteristics() {
        return TransferCharacteristics.fromValue(this.transferCharacteristics);
    }

    public final String transferCharacteristicsAsString() {
        return this.transferCharacteristics;
    }

    public final Integer width() {
        return this.width;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.bitDepth());
        hashCode = 31 * hashCode + Objects.hashCode(this.chromaSubsampling());
        hashCode = 31 * hashCode + Objects.hashCode(this.codedFrameRate());
        hashCode = 31 * hashCode + Objects.hashCode(this.colorPrimariesAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.height());
        hashCode = 31 * hashCode + Objects.hashCode(this.level());
        hashCode = 31 * hashCode + Objects.hashCode(this.matrixCoefficientsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.profile());
        hashCode = 31 * hashCode + Objects.hashCode(this.scanType());
        hashCode = 31 * hashCode + Objects.hashCode(this.transferCharacteristicsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.width());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CodecMetadata)) {
            return false;
        }
        CodecMetadata other = (CodecMetadata)obj;
        return Objects.equals(this.bitDepth(), other.bitDepth()) && Objects.equals(this.chromaSubsampling(), other.chromaSubsampling()) && Objects.equals(this.codedFrameRate(), other.codedFrameRate()) && Objects.equals(this.colorPrimariesAsString(), other.colorPrimariesAsString()) && Objects.equals(this.height(), other.height()) && Objects.equals(this.level(), other.level()) && Objects.equals(this.matrixCoefficientsAsString(), other.matrixCoefficientsAsString()) && Objects.equals(this.profile(), other.profile()) && Objects.equals(this.scanType(), other.scanType()) && Objects.equals(this.transferCharacteristicsAsString(), other.transferCharacteristicsAsString()) && Objects.equals(this.width(), other.width());
    }

    public final String toString() {
        return ToString.builder((String)"CodecMetadata").add("BitDepth", (Object)this.bitDepth()).add("ChromaSubsampling", (Object)this.chromaSubsampling()).add("CodedFrameRate", (Object)this.codedFrameRate()).add("ColorPrimaries", (Object)this.colorPrimariesAsString()).add("Height", (Object)this.height()).add("Level", (Object)this.level()).add("MatrixCoefficients", (Object)this.matrixCoefficientsAsString()).add("Profile", (Object)this.profile()).add("ScanType", (Object)this.scanType()).add("TransferCharacteristics", (Object)this.transferCharacteristicsAsString()).add("Width", (Object)this.width()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BitDepth": {
                return Optional.ofNullable(clazz.cast(this.bitDepth()));
            }
            case "ChromaSubsampling": {
                return Optional.ofNullable(clazz.cast(this.chromaSubsampling()));
            }
            case "CodedFrameRate": {
                return Optional.ofNullable(clazz.cast(this.codedFrameRate()));
            }
            case "ColorPrimaries": {
                return Optional.ofNullable(clazz.cast(this.colorPrimariesAsString()));
            }
            case "Height": {
                return Optional.ofNullable(clazz.cast(this.height()));
            }
            case "Level": {
                return Optional.ofNullable(clazz.cast(this.level()));
            }
            case "MatrixCoefficients": {
                return Optional.ofNullable(clazz.cast(this.matrixCoefficientsAsString()));
            }
            case "Profile": {
                return Optional.ofNullable(clazz.cast(this.profile()));
            }
            case "ScanType": {
                return Optional.ofNullable(clazz.cast(this.scanType()));
            }
            case "TransferCharacteristics": {
                return Optional.ofNullable(clazz.cast(this.transferCharacteristicsAsString()));
            }
            case "Width": {
                return Optional.ofNullable(clazz.cast(this.width()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("bitDepth", BIT_DEPTH_FIELD);
        map.put("chromaSubsampling", CHROMA_SUBSAMPLING_FIELD);
        map.put("codedFrameRate", CODED_FRAME_RATE_FIELD);
        map.put("colorPrimaries", COLOR_PRIMARIES_FIELD);
        map.put("height", HEIGHT_FIELD);
        map.put("level", LEVEL_FIELD);
        map.put("matrixCoefficients", MATRIX_COEFFICIENTS_FIELD);
        map.put("profile", PROFILE_FIELD);
        map.put("scanType", SCAN_TYPE_FIELD);
        map.put("transferCharacteristics", TRANSFER_CHARACTERISTICS_FIELD);
        map.put("width", WIDTH_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CodecMetadata, T> g) {
        return obj -> g.apply((CodecMetadata)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer bitDepth;
        private String chromaSubsampling;
        private FrameRate codedFrameRate;
        private String colorPrimaries;
        private Integer height;
        private String level;
        private String matrixCoefficients;
        private String profile;
        private String scanType;
        private String transferCharacteristics;
        private Integer width;

        private BuilderImpl() {
        }

        private BuilderImpl(CodecMetadata model) {
            this.bitDepth(model.bitDepth);
            this.chromaSubsampling(model.chromaSubsampling);
            this.codedFrameRate(model.codedFrameRate);
            this.colorPrimaries(model.colorPrimaries);
            this.height(model.height);
            this.level(model.level);
            this.matrixCoefficients(model.matrixCoefficients);
            this.profile(model.profile);
            this.scanType(model.scanType);
            this.transferCharacteristics(model.transferCharacteristics);
            this.width(model.width);
        }

        public final Integer getBitDepth() {
            return this.bitDepth;
        }

        public final void setBitDepth(Integer bitDepth) {
            this.bitDepth = bitDepth;
        }

        @Override
        public final Builder bitDepth(Integer bitDepth) {
            this.bitDepth = bitDepth;
            return this;
        }

        public final String getChromaSubsampling() {
            return this.chromaSubsampling;
        }

        public final void setChromaSubsampling(String chromaSubsampling) {
            this.chromaSubsampling = chromaSubsampling;
        }

        @Override
        public final Builder chromaSubsampling(String chromaSubsampling) {
            this.chromaSubsampling = chromaSubsampling;
            return this;
        }

        public final FrameRate.Builder getCodedFrameRate() {
            return this.codedFrameRate != null ? this.codedFrameRate.toBuilder() : null;
        }

        public final void setCodedFrameRate(FrameRate.BuilderImpl codedFrameRate) {
            this.codedFrameRate = codedFrameRate != null ? codedFrameRate.build() : null;
        }

        @Override
        public final Builder codedFrameRate(FrameRate codedFrameRate) {
            this.codedFrameRate = codedFrameRate;
            return this;
        }

        public final String getColorPrimaries() {
            return this.colorPrimaries;
        }

        public final void setColorPrimaries(String colorPrimaries) {
            this.colorPrimaries = colorPrimaries;
        }

        @Override
        public final Builder colorPrimaries(String colorPrimaries) {
            this.colorPrimaries = colorPrimaries;
            return this;
        }

        @Override
        public final Builder colorPrimaries(ColorPrimaries colorPrimaries) {
            this.colorPrimaries(colorPrimaries == null ? null : colorPrimaries.toString());
            return this;
        }

        public final Integer getHeight() {
            return this.height;
        }

        public final void setHeight(Integer height) {
            this.height = height;
        }

        @Override
        public final Builder height(Integer height) {
            this.height = height;
            return this;
        }

        public final String getLevel() {
            return this.level;
        }

        public final void setLevel(String level) {
            this.level = level;
        }

        @Override
        public final Builder level(String level) {
            this.level = level;
            return this;
        }

        public final String getMatrixCoefficients() {
            return this.matrixCoefficients;
        }

        public final void setMatrixCoefficients(String matrixCoefficients) {
            this.matrixCoefficients = matrixCoefficients;
        }

        @Override
        public final Builder matrixCoefficients(String matrixCoefficients) {
            this.matrixCoefficients = matrixCoefficients;
            return this;
        }

        @Override
        public final Builder matrixCoefficients(MatrixCoefficients matrixCoefficients) {
            this.matrixCoefficients(matrixCoefficients == null ? null : matrixCoefficients.toString());
            return this;
        }

        public final String getProfile() {
            return this.profile;
        }

        public final void setProfile(String profile) {
            this.profile = profile;
        }

        @Override
        public final Builder profile(String profile) {
            this.profile = profile;
            return this;
        }

        public final String getScanType() {
            return this.scanType;
        }

        public final void setScanType(String scanType) {
            this.scanType = scanType;
        }

        @Override
        public final Builder scanType(String scanType) {
            this.scanType = scanType;
            return this;
        }

        public final String getTransferCharacteristics() {
            return this.transferCharacteristics;
        }

        public final void setTransferCharacteristics(String transferCharacteristics) {
            this.transferCharacteristics = transferCharacteristics;
        }

        @Override
        public final Builder transferCharacteristics(String transferCharacteristics) {
            this.transferCharacteristics = transferCharacteristics;
            return this;
        }

        @Override
        public final Builder transferCharacteristics(TransferCharacteristics transferCharacteristics) {
            this.transferCharacteristics(transferCharacteristics == null ? null : transferCharacteristics.toString());
            return this;
        }

        public final Integer getWidth() {
            return this.width;
        }

        public final void setWidth(Integer width) {
            this.width = width;
        }

        @Override
        public final Builder width(Integer width) {
            this.width = width;
            return this;
        }

        public CodecMetadata build() {
            return new CodecMetadata(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CodecMetadata> {
        public Builder bitDepth(Integer var1);

        public Builder chromaSubsampling(String var1);

        public Builder codedFrameRate(FrameRate var1);

        default public Builder codedFrameRate(Consumer<FrameRate.Builder> codedFrameRate) {
            return this.codedFrameRate((FrameRate)((FrameRate.Builder)FrameRate.builder().applyMutation(codedFrameRate)).build());
        }

        public Builder colorPrimaries(String var1);

        public Builder colorPrimaries(ColorPrimaries var1);

        public Builder height(Integer var1);

        public Builder level(String var1);

        public Builder matrixCoefficients(String var1);

        public Builder matrixCoefficients(MatrixCoefficients var1);

        public Builder profile(String var1);

        public Builder scanType(String var1);

        public Builder transferCharacteristics(String var1);

        public Builder transferCharacteristics(TransferCharacteristics var1);

        public Builder width(Integer var1);
    }
}

