/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class VorbisSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, VorbisSettings> {
    private static final SdkField<Integer> CHANNELS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Channels").getter(VorbisSettings.getter(VorbisSettings::channels)).setter(VorbisSettings.setter(Builder::channels)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("channels").build()}).build();
    private static final SdkField<Integer> SAMPLE_RATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("SampleRate").getter(VorbisSettings.getter(VorbisSettings::sampleRate)).setter(VorbisSettings.setter(Builder::sampleRate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sampleRate").build()}).build();
    private static final SdkField<Integer> VBR_QUALITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("VbrQuality").getter(VorbisSettings.getter(VorbisSettings::vbrQuality)).setter(VorbisSettings.setter(Builder::vbrQuality)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vbrQuality").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANNELS_FIELD, SAMPLE_RATE_FIELD, VBR_QUALITY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = VorbisSettings.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Integer channels;
    private final Integer sampleRate;
    private final Integer vbrQuality;

    private VorbisSettings(BuilderImpl builder) {
        this.channels = builder.channels;
        this.sampleRate = builder.sampleRate;
        this.vbrQuality = builder.vbrQuality;
    }

    public final Integer channels() {
        return this.channels;
    }

    public final Integer sampleRate() {
        return this.sampleRate;
    }

    public final Integer vbrQuality() {
        return this.vbrQuality;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.channels());
        hashCode = 31 * hashCode + Objects.hashCode(this.sampleRate());
        hashCode = 31 * hashCode + Objects.hashCode(this.vbrQuality());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VorbisSettings)) {
            return false;
        }
        VorbisSettings other = (VorbisSettings)obj;
        return Objects.equals(this.channels(), other.channels()) && Objects.equals(this.sampleRate(), other.sampleRate()) && Objects.equals(this.vbrQuality(), other.vbrQuality());
    }

    public final String toString() {
        return ToString.builder((String)"VorbisSettings").add("Channels", (Object)this.channels()).add("SampleRate", (Object)this.sampleRate()).add("VbrQuality", (Object)this.vbrQuality()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Channels": {
                return Optional.ofNullable(clazz.cast(this.channels()));
            }
            case "SampleRate": {
                return Optional.ofNullable(clazz.cast(this.sampleRate()));
            }
            case "VbrQuality": {
                return Optional.ofNullable(clazz.cast(this.vbrQuality()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<Integer>> map = new HashMap<String, SdkField<Integer>>();
        map.put("channels", CHANNELS_FIELD);
        map.put("sampleRate", SAMPLE_RATE_FIELD);
        map.put("vbrQuality", VBR_QUALITY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<VorbisSettings, T> g) {
        return obj -> g.apply((VorbisSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer channels;
        private Integer sampleRate;
        private Integer vbrQuality;

        private BuilderImpl() {
        }

        private BuilderImpl(VorbisSettings model) {
            this.channels(model.channels);
            this.sampleRate(model.sampleRate);
            this.vbrQuality(model.vbrQuality);
        }

        public final Integer getChannels() {
            return this.channels;
        }

        public final void setChannels(Integer channels) {
            this.channels = channels;
        }

        @Override
        public final Builder channels(Integer channels) {
            this.channels = channels;
            return this;
        }

        public final Integer getSampleRate() {
            return this.sampleRate;
        }

        public final void setSampleRate(Integer sampleRate) {
            this.sampleRate = sampleRate;
        }

        @Override
        public final Builder sampleRate(Integer sampleRate) {
            this.sampleRate = sampleRate;
            return this;
        }

        public final Integer getVbrQuality() {
            return this.vbrQuality;
        }

        public final void setVbrQuality(Integer vbrQuality) {
            this.vbrQuality = vbrQuality;
        }

        @Override
        public final Builder vbrQuality(Integer vbrQuality) {
            this.vbrQuality = vbrQuality;
            return this;
        }

        public VorbisSettings build() {
            return new VorbisSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, VorbisSettings> {
        public Builder channels(Integer var1);

        public Builder sampleRate(Integer var1);

        public Builder vbrQuality(Integer var1);
    }
}

