/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.mediaconvert.model.CmafAdditionalManifest;
import software.amazon.awssdk.services.mediaconvert.model.CmafClientCache;
import software.amazon.awssdk.services.mediaconvert.model.CmafCodecSpecification;
import software.amazon.awssdk.services.mediaconvert.model.CmafEncryptionSettings;
import software.amazon.awssdk.services.mediaconvert.model.CmafImageBasedTrickPlay;
import software.amazon.awssdk.services.mediaconvert.model.CmafImageBasedTrickPlaySettings;
import software.amazon.awssdk.services.mediaconvert.model.CmafManifestCompression;
import software.amazon.awssdk.services.mediaconvert.model.CmafManifestDurationFormat;
import software.amazon.awssdk.services.mediaconvert.model.CmafMpdManifestBandwidthType;
import software.amazon.awssdk.services.mediaconvert.model.CmafMpdProfile;
import software.amazon.awssdk.services.mediaconvert.model.CmafPtsOffsetHandlingForBFrames;
import software.amazon.awssdk.services.mediaconvert.model.CmafSegmentControl;
import software.amazon.awssdk.services.mediaconvert.model.CmafSegmentLengthControl;
import software.amazon.awssdk.services.mediaconvert.model.CmafStreamInfResolution;
import software.amazon.awssdk.services.mediaconvert.model.CmafTargetDurationCompatibilityMode;
import software.amazon.awssdk.services.mediaconvert.model.CmafVideoCompositionOffsets;
import software.amazon.awssdk.services.mediaconvert.model.CmafWriteDASHManifest;
import software.amazon.awssdk.services.mediaconvert.model.CmafWriteHLSManifest;
import software.amazon.awssdk.services.mediaconvert.model.CmafWriteSegmentTimelineInRepresentation;
import software.amazon.awssdk.services.mediaconvert.model.DashManifestStyle;
import software.amazon.awssdk.services.mediaconvert.model.DestinationSettings;
import software.amazon.awssdk.services.mediaconvert.model.___listOfCmafAdditionalManifestCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CmafGroupSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CmafGroupSettings> {
    private static final SdkField<List<CmafAdditionalManifest>> ADDITIONAL_MANIFESTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AdditionalManifests").getter(CmafGroupSettings.getter(CmafGroupSettings::additionalManifests)).setter(CmafGroupSettings.setter(Builder::additionalManifests)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("additionalManifests").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CmafAdditionalManifest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> BASE_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BaseUrl").getter(CmafGroupSettings.getter(CmafGroupSettings::baseUrl)).setter(CmafGroupSettings.setter(Builder::baseUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("baseUrl").build()}).build();
    private static final SdkField<String> CLIENT_CACHE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientCache").getter(CmafGroupSettings.getter(CmafGroupSettings::clientCacheAsString)).setter(CmafGroupSettings.setter(Builder::clientCache)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientCache").build()}).build();
    private static final SdkField<String> CODEC_SPECIFICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CodecSpecification").getter(CmafGroupSettings.getter(CmafGroupSettings::codecSpecificationAsString)).setter(CmafGroupSettings.setter(Builder::codecSpecification)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("codecSpecification").build()}).build();
    private static final SdkField<String> DASH_I_FRAME_TRICK_PLAY_NAME_MODIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DashIFrameTrickPlayNameModifier").getter(CmafGroupSettings.getter(CmafGroupSettings::dashIFrameTrickPlayNameModifier)).setter(CmafGroupSettings.setter(Builder::dashIFrameTrickPlayNameModifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dashIFrameTrickPlayNameModifier").build()}).build();
    private static final SdkField<String> DASH_MANIFEST_STYLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DashManifestStyle").getter(CmafGroupSettings.getter(CmafGroupSettings::dashManifestStyleAsString)).setter(CmafGroupSettings.setter(Builder::dashManifestStyle)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dashManifestStyle").build()}).build();
    private static final SdkField<String> DESTINATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Destination").getter(CmafGroupSettings.getter(CmafGroupSettings::destination)).setter(CmafGroupSettings.setter(Builder::destination)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destination").build()}).build();
    private static final SdkField<DestinationSettings> DESTINATION_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DestinationSettings").getter(CmafGroupSettings.getter(CmafGroupSettings::destinationSettings)).setter(CmafGroupSettings.setter(Builder::destinationSettings)).constructor(DestinationSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationSettings").build()}).build();
    private static final SdkField<CmafEncryptionSettings> ENCRYPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Encryption").getter(CmafGroupSettings.getter(CmafGroupSettings::encryption)).setter(CmafGroupSettings.setter(Builder::encryption)).constructor(CmafEncryptionSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encryption").build()}).build();
    private static final SdkField<Integer> FRAGMENT_LENGTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("FragmentLength").getter(CmafGroupSettings.getter(CmafGroupSettings::fragmentLength)).setter(CmafGroupSettings.setter(Builder::fragmentLength)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fragmentLength").build()}).build();
    private static final SdkField<String> IMAGE_BASED_TRICK_PLAY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ImageBasedTrickPlay").getter(CmafGroupSettings.getter(CmafGroupSettings::imageBasedTrickPlayAsString)).setter(CmafGroupSettings.setter(Builder::imageBasedTrickPlay)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageBasedTrickPlay").build()}).build();
    private static final SdkField<CmafImageBasedTrickPlaySettings> IMAGE_BASED_TRICK_PLAY_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ImageBasedTrickPlaySettings").getter(CmafGroupSettings.getter(CmafGroupSettings::imageBasedTrickPlaySettings)).setter(CmafGroupSettings.setter(Builder::imageBasedTrickPlaySettings)).constructor(CmafImageBasedTrickPlaySettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageBasedTrickPlaySettings").build()}).build();
    private static final SdkField<String> MANIFEST_COMPRESSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ManifestCompression").getter(CmafGroupSettings.getter(CmafGroupSettings::manifestCompressionAsString)).setter(CmafGroupSettings.setter(Builder::manifestCompression)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("manifestCompression").build()}).build();
    private static final SdkField<String> MANIFEST_DURATION_FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ManifestDurationFormat").getter(CmafGroupSettings.getter(CmafGroupSettings::manifestDurationFormatAsString)).setter(CmafGroupSettings.setter(Builder::manifestDurationFormat)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("manifestDurationFormat").build()}).build();
    private static final SdkField<Integer> MIN_BUFFER_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MinBufferTime").getter(CmafGroupSettings.getter(CmafGroupSettings::minBufferTime)).setter(CmafGroupSettings.setter(Builder::minBufferTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("minBufferTime").build()}).build();
    private static final SdkField<Double> MIN_FINAL_SEGMENT_LENGTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("MinFinalSegmentLength").getter(CmafGroupSettings.getter(CmafGroupSettings::minFinalSegmentLength)).setter(CmafGroupSettings.setter(Builder::minFinalSegmentLength)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("minFinalSegmentLength").build()}).build();
    private static final SdkField<String> MPD_MANIFEST_BANDWIDTH_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MpdManifestBandwidthType").getter(CmafGroupSettings.getter(CmafGroupSettings::mpdManifestBandwidthTypeAsString)).setter(CmafGroupSettings.setter(Builder::mpdManifestBandwidthType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mpdManifestBandwidthType").build()}).build();
    private static final SdkField<String> MPD_PROFILE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MpdProfile").getter(CmafGroupSettings.getter(CmafGroupSettings::mpdProfileAsString)).setter(CmafGroupSettings.setter(Builder::mpdProfile)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mpdProfile").build()}).build();
    private static final SdkField<String> PTS_OFFSET_HANDLING_FOR_B_FRAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PtsOffsetHandlingForBFrames").getter(CmafGroupSettings.getter(CmafGroupSettings::ptsOffsetHandlingForBFramesAsString)).setter(CmafGroupSettings.setter(Builder::ptsOffsetHandlingForBFrames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ptsOffsetHandlingForBFrames").build()}).build();
    private static final SdkField<String> SEGMENT_CONTROL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SegmentControl").getter(CmafGroupSettings.getter(CmafGroupSettings::segmentControlAsString)).setter(CmafGroupSettings.setter(Builder::segmentControl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("segmentControl").build()}).build();
    private static final SdkField<Integer> SEGMENT_LENGTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("SegmentLength").getter(CmafGroupSettings.getter(CmafGroupSettings::segmentLength)).setter(CmafGroupSettings.setter(Builder::segmentLength)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("segmentLength").build()}).build();
    private static final SdkField<String> SEGMENT_LENGTH_CONTROL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SegmentLengthControl").getter(CmafGroupSettings.getter(CmafGroupSettings::segmentLengthControlAsString)).setter(CmafGroupSettings.setter(Builder::segmentLengthControl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("segmentLengthControl").build()}).build();
    private static final SdkField<String> STREAM_INF_RESOLUTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StreamInfResolution").getter(CmafGroupSettings.getter(CmafGroupSettings::streamInfResolutionAsString)).setter(CmafGroupSettings.setter(Builder::streamInfResolution)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("streamInfResolution").build()}).build();
    private static final SdkField<String> TARGET_DURATION_COMPATIBILITY_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TargetDurationCompatibilityMode").getter(CmafGroupSettings.getter(CmafGroupSettings::targetDurationCompatibilityModeAsString)).setter(CmafGroupSettings.setter(Builder::targetDurationCompatibilityMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetDurationCompatibilityMode").build()}).build();
    private static final SdkField<String> VIDEO_COMPOSITION_OFFSETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VideoCompositionOffsets").getter(CmafGroupSettings.getter(CmafGroupSettings::videoCompositionOffsetsAsString)).setter(CmafGroupSettings.setter(Builder::videoCompositionOffsets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("videoCompositionOffsets").build()}).build();
    private static final SdkField<String> WRITE_DASH_MANIFEST_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WriteDashManifest").getter(CmafGroupSettings.getter(CmafGroupSettings::writeDashManifestAsString)).setter(CmafGroupSettings.setter(Builder::writeDashManifest)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("writeDashManifest").build()}).build();
    private static final SdkField<String> WRITE_HLS_MANIFEST_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WriteHlsManifest").getter(CmafGroupSettings.getter(CmafGroupSettings::writeHlsManifestAsString)).setter(CmafGroupSettings.setter(Builder::writeHlsManifest)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("writeHlsManifest").build()}).build();
    private static final SdkField<String> WRITE_SEGMENT_TIMELINE_IN_REPRESENTATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WriteSegmentTimelineInRepresentation").getter(CmafGroupSettings.getter(CmafGroupSettings::writeSegmentTimelineInRepresentationAsString)).setter(CmafGroupSettings.setter(Builder::writeSegmentTimelineInRepresentation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("writeSegmentTimelineInRepresentation").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADDITIONAL_MANIFESTS_FIELD, BASE_URL_FIELD, CLIENT_CACHE_FIELD, CODEC_SPECIFICATION_FIELD, DASH_I_FRAME_TRICK_PLAY_NAME_MODIFIER_FIELD, DASH_MANIFEST_STYLE_FIELD, DESTINATION_FIELD, DESTINATION_SETTINGS_FIELD, ENCRYPTION_FIELD, FRAGMENT_LENGTH_FIELD, IMAGE_BASED_TRICK_PLAY_FIELD, IMAGE_BASED_TRICK_PLAY_SETTINGS_FIELD, MANIFEST_COMPRESSION_FIELD, MANIFEST_DURATION_FORMAT_FIELD, MIN_BUFFER_TIME_FIELD, MIN_FINAL_SEGMENT_LENGTH_FIELD, MPD_MANIFEST_BANDWIDTH_TYPE_FIELD, MPD_PROFILE_FIELD, PTS_OFFSET_HANDLING_FOR_B_FRAMES_FIELD, SEGMENT_CONTROL_FIELD, SEGMENT_LENGTH_FIELD, SEGMENT_LENGTH_CONTROL_FIELD, STREAM_INF_RESOLUTION_FIELD, TARGET_DURATION_COMPATIBILITY_MODE_FIELD, VIDEO_COMPOSITION_OFFSETS_FIELD, WRITE_DASH_MANIFEST_FIELD, WRITE_HLS_MANIFEST_FIELD, WRITE_SEGMENT_TIMELINE_IN_REPRESENTATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CmafGroupSettings.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<CmafAdditionalManifest> additionalManifests;
    private final String baseUrl;
    private final String clientCache;
    private final String codecSpecification;
    private final String dashIFrameTrickPlayNameModifier;
    private final String dashManifestStyle;
    private final String destination;
    private final DestinationSettings destinationSettings;
    private final CmafEncryptionSettings encryption;
    private final Integer fragmentLength;
    private final String imageBasedTrickPlay;
    private final CmafImageBasedTrickPlaySettings imageBasedTrickPlaySettings;
    private final String manifestCompression;
    private final String manifestDurationFormat;
    private final Integer minBufferTime;
    private final Double minFinalSegmentLength;
    private final String mpdManifestBandwidthType;
    private final String mpdProfile;
    private final String ptsOffsetHandlingForBFrames;
    private final String segmentControl;
    private final Integer segmentLength;
    private final String segmentLengthControl;
    private final String streamInfResolution;
    private final String targetDurationCompatibilityMode;
    private final String videoCompositionOffsets;
    private final String writeDashManifest;
    private final String writeHlsManifest;
    private final String writeSegmentTimelineInRepresentation;

    private CmafGroupSettings(BuilderImpl builder) {
        this.additionalManifests = builder.additionalManifests;
        this.baseUrl = builder.baseUrl;
        this.clientCache = builder.clientCache;
        this.codecSpecification = builder.codecSpecification;
        this.dashIFrameTrickPlayNameModifier = builder.dashIFrameTrickPlayNameModifier;
        this.dashManifestStyle = builder.dashManifestStyle;
        this.destination = builder.destination;
        this.destinationSettings = builder.destinationSettings;
        this.encryption = builder.encryption;
        this.fragmentLength = builder.fragmentLength;
        this.imageBasedTrickPlay = builder.imageBasedTrickPlay;
        this.imageBasedTrickPlaySettings = builder.imageBasedTrickPlaySettings;
        this.manifestCompression = builder.manifestCompression;
        this.manifestDurationFormat = builder.manifestDurationFormat;
        this.minBufferTime = builder.minBufferTime;
        this.minFinalSegmentLength = builder.minFinalSegmentLength;
        this.mpdManifestBandwidthType = builder.mpdManifestBandwidthType;
        this.mpdProfile = builder.mpdProfile;
        this.ptsOffsetHandlingForBFrames = builder.ptsOffsetHandlingForBFrames;
        this.segmentControl = builder.segmentControl;
        this.segmentLength = builder.segmentLength;
        this.segmentLengthControl = builder.segmentLengthControl;
        this.streamInfResolution = builder.streamInfResolution;
        this.targetDurationCompatibilityMode = builder.targetDurationCompatibilityMode;
        this.videoCompositionOffsets = builder.videoCompositionOffsets;
        this.writeDashManifest = builder.writeDashManifest;
        this.writeHlsManifest = builder.writeHlsManifest;
        this.writeSegmentTimelineInRepresentation = builder.writeSegmentTimelineInRepresentation;
    }

    public final boolean hasAdditionalManifests() {
        return this.additionalManifests != null && !(this.additionalManifests instanceof SdkAutoConstructList);
    }

    public final List<CmafAdditionalManifest> additionalManifests() {
        return this.additionalManifests;
    }

    public final String baseUrl() {
        return this.baseUrl;
    }

    public final CmafClientCache clientCache() {
        return CmafClientCache.fromValue(this.clientCache);
    }

    public final String clientCacheAsString() {
        return this.clientCache;
    }

    public final CmafCodecSpecification codecSpecification() {
        return CmafCodecSpecification.fromValue(this.codecSpecification);
    }

    public final String codecSpecificationAsString() {
        return this.codecSpecification;
    }

    public final String dashIFrameTrickPlayNameModifier() {
        return this.dashIFrameTrickPlayNameModifier;
    }

    public final DashManifestStyle dashManifestStyle() {
        return DashManifestStyle.fromValue(this.dashManifestStyle);
    }

    public final String dashManifestStyleAsString() {
        return this.dashManifestStyle;
    }

    public final String destination() {
        return this.destination;
    }

    public final DestinationSettings destinationSettings() {
        return this.destinationSettings;
    }

    public final CmafEncryptionSettings encryption() {
        return this.encryption;
    }

    public final Integer fragmentLength() {
        return this.fragmentLength;
    }

    public final CmafImageBasedTrickPlay imageBasedTrickPlay() {
        return CmafImageBasedTrickPlay.fromValue(this.imageBasedTrickPlay);
    }

    public final String imageBasedTrickPlayAsString() {
        return this.imageBasedTrickPlay;
    }

    public final CmafImageBasedTrickPlaySettings imageBasedTrickPlaySettings() {
        return this.imageBasedTrickPlaySettings;
    }

    public final CmafManifestCompression manifestCompression() {
        return CmafManifestCompression.fromValue(this.manifestCompression);
    }

    public final String manifestCompressionAsString() {
        return this.manifestCompression;
    }

    public final CmafManifestDurationFormat manifestDurationFormat() {
        return CmafManifestDurationFormat.fromValue(this.manifestDurationFormat);
    }

    public final String manifestDurationFormatAsString() {
        return this.manifestDurationFormat;
    }

    public final Integer minBufferTime() {
        return this.minBufferTime;
    }

    public final Double minFinalSegmentLength() {
        return this.minFinalSegmentLength;
    }

    public final CmafMpdManifestBandwidthType mpdManifestBandwidthType() {
        return CmafMpdManifestBandwidthType.fromValue(this.mpdManifestBandwidthType);
    }

    public final String mpdManifestBandwidthTypeAsString() {
        return this.mpdManifestBandwidthType;
    }

    public final CmafMpdProfile mpdProfile() {
        return CmafMpdProfile.fromValue(this.mpdProfile);
    }

    public final String mpdProfileAsString() {
        return this.mpdProfile;
    }

    public final CmafPtsOffsetHandlingForBFrames ptsOffsetHandlingForBFrames() {
        return CmafPtsOffsetHandlingForBFrames.fromValue(this.ptsOffsetHandlingForBFrames);
    }

    public final String ptsOffsetHandlingForBFramesAsString() {
        return this.ptsOffsetHandlingForBFrames;
    }

    public final CmafSegmentControl segmentControl() {
        return CmafSegmentControl.fromValue(this.segmentControl);
    }

    public final String segmentControlAsString() {
        return this.segmentControl;
    }

    public final Integer segmentLength() {
        return this.segmentLength;
    }

    public final CmafSegmentLengthControl segmentLengthControl() {
        return CmafSegmentLengthControl.fromValue(this.segmentLengthControl);
    }

    public final String segmentLengthControlAsString() {
        return this.segmentLengthControl;
    }

    public final CmafStreamInfResolution streamInfResolution() {
        return CmafStreamInfResolution.fromValue(this.streamInfResolution);
    }

    public final String streamInfResolutionAsString() {
        return this.streamInfResolution;
    }

    public final CmafTargetDurationCompatibilityMode targetDurationCompatibilityMode() {
        return CmafTargetDurationCompatibilityMode.fromValue(this.targetDurationCompatibilityMode);
    }

    public final String targetDurationCompatibilityModeAsString() {
        return this.targetDurationCompatibilityMode;
    }

    public final CmafVideoCompositionOffsets videoCompositionOffsets() {
        return CmafVideoCompositionOffsets.fromValue(this.videoCompositionOffsets);
    }

    public final String videoCompositionOffsetsAsString() {
        return this.videoCompositionOffsets;
    }

    public final CmafWriteDASHManifest writeDashManifest() {
        return CmafWriteDASHManifest.fromValue(this.writeDashManifest);
    }

    public final String writeDashManifestAsString() {
        return this.writeDashManifest;
    }

    public final CmafWriteHLSManifest writeHlsManifest() {
        return CmafWriteHLSManifest.fromValue(this.writeHlsManifest);
    }

    public final String writeHlsManifestAsString() {
        return this.writeHlsManifest;
    }

    public final CmafWriteSegmentTimelineInRepresentation writeSegmentTimelineInRepresentation() {
        return CmafWriteSegmentTimelineInRepresentation.fromValue(this.writeSegmentTimelineInRepresentation);
    }

    public final String writeSegmentTimelineInRepresentationAsString() {
        return this.writeSegmentTimelineInRepresentation;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAdditionalManifests() ? this.additionalManifests() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.baseUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientCacheAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.codecSpecificationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.dashIFrameTrickPlayNameModifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.dashManifestStyleAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.destination());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryption());
        hashCode = 31 * hashCode + Objects.hashCode(this.fragmentLength());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageBasedTrickPlayAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageBasedTrickPlaySettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.manifestCompressionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.manifestDurationFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.minBufferTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.minFinalSegmentLength());
        hashCode = 31 * hashCode + Objects.hashCode(this.mpdManifestBandwidthTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.mpdProfileAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.ptsOffsetHandlingForBFramesAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.segmentControlAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.segmentLength());
        hashCode = 31 * hashCode + Objects.hashCode(this.segmentLengthControlAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.streamInfResolutionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetDurationCompatibilityModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.videoCompositionOffsetsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.writeDashManifestAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.writeHlsManifestAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.writeSegmentTimelineInRepresentationAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CmafGroupSettings)) {
            return false;
        }
        CmafGroupSettings other = (CmafGroupSettings)obj;
        return this.hasAdditionalManifests() == other.hasAdditionalManifests() && Objects.equals(this.additionalManifests(), other.additionalManifests()) && Objects.equals(this.baseUrl(), other.baseUrl()) && Objects.equals(this.clientCacheAsString(), other.clientCacheAsString()) && Objects.equals(this.codecSpecificationAsString(), other.codecSpecificationAsString()) && Objects.equals(this.dashIFrameTrickPlayNameModifier(), other.dashIFrameTrickPlayNameModifier()) && Objects.equals(this.dashManifestStyleAsString(), other.dashManifestStyleAsString()) && Objects.equals(this.destination(), other.destination()) && Objects.equals(this.destinationSettings(), other.destinationSettings()) && Objects.equals(this.encryption(), other.encryption()) && Objects.equals(this.fragmentLength(), other.fragmentLength()) && Objects.equals(this.imageBasedTrickPlayAsString(), other.imageBasedTrickPlayAsString()) && Objects.equals(this.imageBasedTrickPlaySettings(), other.imageBasedTrickPlaySettings()) && Objects.equals(this.manifestCompressionAsString(), other.manifestCompressionAsString()) && Objects.equals(this.manifestDurationFormatAsString(), other.manifestDurationFormatAsString()) && Objects.equals(this.minBufferTime(), other.minBufferTime()) && Objects.equals(this.minFinalSegmentLength(), other.minFinalSegmentLength()) && Objects.equals(this.mpdManifestBandwidthTypeAsString(), other.mpdManifestBandwidthTypeAsString()) && Objects.equals(this.mpdProfileAsString(), other.mpdProfileAsString()) && Objects.equals(this.ptsOffsetHandlingForBFramesAsString(), other.ptsOffsetHandlingForBFramesAsString()) && Objects.equals(this.segmentControlAsString(), other.segmentControlAsString()) && Objects.equals(this.segmentLength(), other.segmentLength()) && Objects.equals(this.segmentLengthControlAsString(), other.segmentLengthControlAsString()) && Objects.equals(this.streamInfResolutionAsString(), other.streamInfResolutionAsString()) && Objects.equals(this.targetDurationCompatibilityModeAsString(), other.targetDurationCompatibilityModeAsString()) && Objects.equals(this.videoCompositionOffsetsAsString(), other.videoCompositionOffsetsAsString()) && Objects.equals(this.writeDashManifestAsString(), other.writeDashManifestAsString()) && Objects.equals(this.writeHlsManifestAsString(), other.writeHlsManifestAsString()) && Objects.equals(this.writeSegmentTimelineInRepresentationAsString(), other.writeSegmentTimelineInRepresentationAsString());
    }

    public final String toString() {
        return ToString.builder((String)"CmafGroupSettings").add("AdditionalManifests", this.hasAdditionalManifests() ? this.additionalManifests() : null).add("BaseUrl", (Object)this.baseUrl()).add("ClientCache", (Object)this.clientCacheAsString()).add("CodecSpecification", (Object)this.codecSpecificationAsString()).add("DashIFrameTrickPlayNameModifier", (Object)this.dashIFrameTrickPlayNameModifier()).add("DashManifestStyle", (Object)this.dashManifestStyleAsString()).add("Destination", (Object)this.destination()).add("DestinationSettings", (Object)this.destinationSettings()).add("Encryption", (Object)this.encryption()).add("FragmentLength", (Object)this.fragmentLength()).add("ImageBasedTrickPlay", (Object)this.imageBasedTrickPlayAsString()).add("ImageBasedTrickPlaySettings", (Object)this.imageBasedTrickPlaySettings()).add("ManifestCompression", (Object)this.manifestCompressionAsString()).add("ManifestDurationFormat", (Object)this.manifestDurationFormatAsString()).add("MinBufferTime", (Object)this.minBufferTime()).add("MinFinalSegmentLength", (Object)this.minFinalSegmentLength()).add("MpdManifestBandwidthType", (Object)this.mpdManifestBandwidthTypeAsString()).add("MpdProfile", (Object)this.mpdProfileAsString()).add("PtsOffsetHandlingForBFrames", (Object)this.ptsOffsetHandlingForBFramesAsString()).add("SegmentControl", (Object)this.segmentControlAsString()).add("SegmentLength", (Object)this.segmentLength()).add("SegmentLengthControl", (Object)this.segmentLengthControlAsString()).add("StreamInfResolution", (Object)this.streamInfResolutionAsString()).add("TargetDurationCompatibilityMode", (Object)this.targetDurationCompatibilityModeAsString()).add("VideoCompositionOffsets", (Object)this.videoCompositionOffsetsAsString()).add("WriteDashManifest", (Object)this.writeDashManifestAsString()).add("WriteHlsManifest", (Object)this.writeHlsManifestAsString()).add("WriteSegmentTimelineInRepresentation", (Object)this.writeSegmentTimelineInRepresentationAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AdditionalManifests": {
                return Optional.ofNullable(clazz.cast(this.additionalManifests()));
            }
            case "BaseUrl": {
                return Optional.ofNullable(clazz.cast(this.baseUrl()));
            }
            case "ClientCache": {
                return Optional.ofNullable(clazz.cast(this.clientCacheAsString()));
            }
            case "CodecSpecification": {
                return Optional.ofNullable(clazz.cast(this.codecSpecificationAsString()));
            }
            case "DashIFrameTrickPlayNameModifier": {
                return Optional.ofNullable(clazz.cast(this.dashIFrameTrickPlayNameModifier()));
            }
            case "DashManifestStyle": {
                return Optional.ofNullable(clazz.cast(this.dashManifestStyleAsString()));
            }
            case "Destination": {
                return Optional.ofNullable(clazz.cast(this.destination()));
            }
            case "DestinationSettings": {
                return Optional.ofNullable(clazz.cast(this.destinationSettings()));
            }
            case "Encryption": {
                return Optional.ofNullable(clazz.cast(this.encryption()));
            }
            case "FragmentLength": {
                return Optional.ofNullable(clazz.cast(this.fragmentLength()));
            }
            case "ImageBasedTrickPlay": {
                return Optional.ofNullable(clazz.cast(this.imageBasedTrickPlayAsString()));
            }
            case "ImageBasedTrickPlaySettings": {
                return Optional.ofNullable(clazz.cast(this.imageBasedTrickPlaySettings()));
            }
            case "ManifestCompression": {
                return Optional.ofNullable(clazz.cast(this.manifestCompressionAsString()));
            }
            case "ManifestDurationFormat": {
                return Optional.ofNullable(clazz.cast(this.manifestDurationFormatAsString()));
            }
            case "MinBufferTime": {
                return Optional.ofNullable(clazz.cast(this.minBufferTime()));
            }
            case "MinFinalSegmentLength": {
                return Optional.ofNullable(clazz.cast(this.minFinalSegmentLength()));
            }
            case "MpdManifestBandwidthType": {
                return Optional.ofNullable(clazz.cast(this.mpdManifestBandwidthTypeAsString()));
            }
            case "MpdProfile": {
                return Optional.ofNullable(clazz.cast(this.mpdProfileAsString()));
            }
            case "PtsOffsetHandlingForBFrames": {
                return Optional.ofNullable(clazz.cast(this.ptsOffsetHandlingForBFramesAsString()));
            }
            case "SegmentControl": {
                return Optional.ofNullable(clazz.cast(this.segmentControlAsString()));
            }
            case "SegmentLength": {
                return Optional.ofNullable(clazz.cast(this.segmentLength()));
            }
            case "SegmentLengthControl": {
                return Optional.ofNullable(clazz.cast(this.segmentLengthControlAsString()));
            }
            case "StreamInfResolution": {
                return Optional.ofNullable(clazz.cast(this.streamInfResolutionAsString()));
            }
            case "TargetDurationCompatibilityMode": {
                return Optional.ofNullable(clazz.cast(this.targetDurationCompatibilityModeAsString()));
            }
            case "VideoCompositionOffsets": {
                return Optional.ofNullable(clazz.cast(this.videoCompositionOffsetsAsString()));
            }
            case "WriteDashManifest": {
                return Optional.ofNullable(clazz.cast(this.writeDashManifestAsString()));
            }
            case "WriteHlsManifest": {
                return Optional.ofNullable(clazz.cast(this.writeHlsManifestAsString()));
            }
            case "WriteSegmentTimelineInRepresentation": {
                return Optional.ofNullable(clazz.cast(this.writeSegmentTimelineInRepresentationAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("additionalManifests", ADDITIONAL_MANIFESTS_FIELD);
        map.put("baseUrl", BASE_URL_FIELD);
        map.put("clientCache", CLIENT_CACHE_FIELD);
        map.put("codecSpecification", CODEC_SPECIFICATION_FIELD);
        map.put("dashIFrameTrickPlayNameModifier", DASH_I_FRAME_TRICK_PLAY_NAME_MODIFIER_FIELD);
        map.put("dashManifestStyle", DASH_MANIFEST_STYLE_FIELD);
        map.put("destination", DESTINATION_FIELD);
        map.put("destinationSettings", DESTINATION_SETTINGS_FIELD);
        map.put("encryption", ENCRYPTION_FIELD);
        map.put("fragmentLength", FRAGMENT_LENGTH_FIELD);
        map.put("imageBasedTrickPlay", IMAGE_BASED_TRICK_PLAY_FIELD);
        map.put("imageBasedTrickPlaySettings", IMAGE_BASED_TRICK_PLAY_SETTINGS_FIELD);
        map.put("manifestCompression", MANIFEST_COMPRESSION_FIELD);
        map.put("manifestDurationFormat", MANIFEST_DURATION_FORMAT_FIELD);
        map.put("minBufferTime", MIN_BUFFER_TIME_FIELD);
        map.put("minFinalSegmentLength", MIN_FINAL_SEGMENT_LENGTH_FIELD);
        map.put("mpdManifestBandwidthType", MPD_MANIFEST_BANDWIDTH_TYPE_FIELD);
        map.put("mpdProfile", MPD_PROFILE_FIELD);
        map.put("ptsOffsetHandlingForBFrames", PTS_OFFSET_HANDLING_FOR_B_FRAMES_FIELD);
        map.put("segmentControl", SEGMENT_CONTROL_FIELD);
        map.put("segmentLength", SEGMENT_LENGTH_FIELD);
        map.put("segmentLengthControl", SEGMENT_LENGTH_CONTROL_FIELD);
        map.put("streamInfResolution", STREAM_INF_RESOLUTION_FIELD);
        map.put("targetDurationCompatibilityMode", TARGET_DURATION_COMPATIBILITY_MODE_FIELD);
        map.put("videoCompositionOffsets", VIDEO_COMPOSITION_OFFSETS_FIELD);
        map.put("writeDashManifest", WRITE_DASH_MANIFEST_FIELD);
        map.put("writeHlsManifest", WRITE_HLS_MANIFEST_FIELD);
        map.put("writeSegmentTimelineInRepresentation", WRITE_SEGMENT_TIMELINE_IN_REPRESENTATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CmafGroupSettings, T> g) {
        return obj -> g.apply((CmafGroupSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<CmafAdditionalManifest> additionalManifests = DefaultSdkAutoConstructList.getInstance();
        private String baseUrl;
        private String clientCache;
        private String codecSpecification;
        private String dashIFrameTrickPlayNameModifier;
        private String dashManifestStyle;
        private String destination;
        private DestinationSettings destinationSettings;
        private CmafEncryptionSettings encryption;
        private Integer fragmentLength;
        private String imageBasedTrickPlay;
        private CmafImageBasedTrickPlaySettings imageBasedTrickPlaySettings;
        private String manifestCompression;
        private String manifestDurationFormat;
        private Integer minBufferTime;
        private Double minFinalSegmentLength;
        private String mpdManifestBandwidthType;
        private String mpdProfile;
        private String ptsOffsetHandlingForBFrames;
        private String segmentControl;
        private Integer segmentLength;
        private String segmentLengthControl;
        private String streamInfResolution;
        private String targetDurationCompatibilityMode;
        private String videoCompositionOffsets;
        private String writeDashManifest;
        private String writeHlsManifest;
        private String writeSegmentTimelineInRepresentation;

        private BuilderImpl() {
        }

        private BuilderImpl(CmafGroupSettings model) {
            this.additionalManifests(model.additionalManifests);
            this.baseUrl(model.baseUrl);
            this.clientCache(model.clientCache);
            this.codecSpecification(model.codecSpecification);
            this.dashIFrameTrickPlayNameModifier(model.dashIFrameTrickPlayNameModifier);
            this.dashManifestStyle(model.dashManifestStyle);
            this.destination(model.destination);
            this.destinationSettings(model.destinationSettings);
            this.encryption(model.encryption);
            this.fragmentLength(model.fragmentLength);
            this.imageBasedTrickPlay(model.imageBasedTrickPlay);
            this.imageBasedTrickPlaySettings(model.imageBasedTrickPlaySettings);
            this.manifestCompression(model.manifestCompression);
            this.manifestDurationFormat(model.manifestDurationFormat);
            this.minBufferTime(model.minBufferTime);
            this.minFinalSegmentLength(model.minFinalSegmentLength);
            this.mpdManifestBandwidthType(model.mpdManifestBandwidthType);
            this.mpdProfile(model.mpdProfile);
            this.ptsOffsetHandlingForBFrames(model.ptsOffsetHandlingForBFrames);
            this.segmentControl(model.segmentControl);
            this.segmentLength(model.segmentLength);
            this.segmentLengthControl(model.segmentLengthControl);
            this.streamInfResolution(model.streamInfResolution);
            this.targetDurationCompatibilityMode(model.targetDurationCompatibilityMode);
            this.videoCompositionOffsets(model.videoCompositionOffsets);
            this.writeDashManifest(model.writeDashManifest);
            this.writeHlsManifest(model.writeHlsManifest);
            this.writeSegmentTimelineInRepresentation(model.writeSegmentTimelineInRepresentation);
        }

        public final List<CmafAdditionalManifest.Builder> getAdditionalManifests() {
            List<CmafAdditionalManifest.Builder> result = ___listOfCmafAdditionalManifestCopier.copyToBuilder(this.additionalManifests);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAdditionalManifests(Collection<CmafAdditionalManifest.BuilderImpl> additionalManifests) {
            this.additionalManifests = ___listOfCmafAdditionalManifestCopier.copyFromBuilder(additionalManifests);
        }

        @Override
        public final Builder additionalManifests(Collection<CmafAdditionalManifest> additionalManifests) {
            this.additionalManifests = ___listOfCmafAdditionalManifestCopier.copy(additionalManifests);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalManifests(CmafAdditionalManifest ... additionalManifests) {
            this.additionalManifests(Arrays.asList(additionalManifests));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalManifests(Consumer<CmafAdditionalManifest.Builder> ... additionalManifests) {
            this.additionalManifests(Stream.of(additionalManifests).map(c -> (CmafAdditionalManifest)((CmafAdditionalManifest.Builder)CmafAdditionalManifest.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getBaseUrl() {
            return this.baseUrl;
        }

        public final void setBaseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
        }

        @Override
        public final Builder baseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
            return this;
        }

        public final String getClientCache() {
            return this.clientCache;
        }

        public final void setClientCache(String clientCache) {
            this.clientCache = clientCache;
        }

        @Override
        public final Builder clientCache(String clientCache) {
            this.clientCache = clientCache;
            return this;
        }

        @Override
        public final Builder clientCache(CmafClientCache clientCache) {
            this.clientCache(clientCache == null ? null : clientCache.toString());
            return this;
        }

        public final String getCodecSpecification() {
            return this.codecSpecification;
        }

        public final void setCodecSpecification(String codecSpecification) {
            this.codecSpecification = codecSpecification;
        }

        @Override
        public final Builder codecSpecification(String codecSpecification) {
            this.codecSpecification = codecSpecification;
            return this;
        }

        @Override
        public final Builder codecSpecification(CmafCodecSpecification codecSpecification) {
            this.codecSpecification(codecSpecification == null ? null : codecSpecification.toString());
            return this;
        }

        public final String getDashIFrameTrickPlayNameModifier() {
            return this.dashIFrameTrickPlayNameModifier;
        }

        public final void setDashIFrameTrickPlayNameModifier(String dashIFrameTrickPlayNameModifier) {
            this.dashIFrameTrickPlayNameModifier = dashIFrameTrickPlayNameModifier;
        }

        @Override
        public final Builder dashIFrameTrickPlayNameModifier(String dashIFrameTrickPlayNameModifier) {
            this.dashIFrameTrickPlayNameModifier = dashIFrameTrickPlayNameModifier;
            return this;
        }

        public final String getDashManifestStyle() {
            return this.dashManifestStyle;
        }

        public final void setDashManifestStyle(String dashManifestStyle) {
            this.dashManifestStyle = dashManifestStyle;
        }

        @Override
        public final Builder dashManifestStyle(String dashManifestStyle) {
            this.dashManifestStyle = dashManifestStyle;
            return this;
        }

        @Override
        public final Builder dashManifestStyle(DashManifestStyle dashManifestStyle) {
            this.dashManifestStyle(dashManifestStyle == null ? null : dashManifestStyle.toString());
            return this;
        }

        public final String getDestination() {
            return this.destination;
        }

        public final void setDestination(String destination) {
            this.destination = destination;
        }

        @Override
        public final Builder destination(String destination) {
            this.destination = destination;
            return this;
        }

        public final DestinationSettings.Builder getDestinationSettings() {
            return this.destinationSettings != null ? this.destinationSettings.toBuilder() : null;
        }

        public final void setDestinationSettings(DestinationSettings.BuilderImpl destinationSettings) {
            this.destinationSettings = destinationSettings != null ? destinationSettings.build() : null;
        }

        @Override
        public final Builder destinationSettings(DestinationSettings destinationSettings) {
            this.destinationSettings = destinationSettings;
            return this;
        }

        public final CmafEncryptionSettings.Builder getEncryption() {
            return this.encryption != null ? this.encryption.toBuilder() : null;
        }

        public final void setEncryption(CmafEncryptionSettings.BuilderImpl encryption) {
            this.encryption = encryption != null ? encryption.build() : null;
        }

        @Override
        public final Builder encryption(CmafEncryptionSettings encryption) {
            this.encryption = encryption;
            return this;
        }

        public final Integer getFragmentLength() {
            return this.fragmentLength;
        }

        public final void setFragmentLength(Integer fragmentLength) {
            this.fragmentLength = fragmentLength;
        }

        @Override
        public final Builder fragmentLength(Integer fragmentLength) {
            this.fragmentLength = fragmentLength;
            return this;
        }

        public final String getImageBasedTrickPlay() {
            return this.imageBasedTrickPlay;
        }

        public final void setImageBasedTrickPlay(String imageBasedTrickPlay) {
            this.imageBasedTrickPlay = imageBasedTrickPlay;
        }

        @Override
        public final Builder imageBasedTrickPlay(String imageBasedTrickPlay) {
            this.imageBasedTrickPlay = imageBasedTrickPlay;
            return this;
        }

        @Override
        public final Builder imageBasedTrickPlay(CmafImageBasedTrickPlay imageBasedTrickPlay) {
            this.imageBasedTrickPlay(imageBasedTrickPlay == null ? null : imageBasedTrickPlay.toString());
            return this;
        }

        public final CmafImageBasedTrickPlaySettings.Builder getImageBasedTrickPlaySettings() {
            return this.imageBasedTrickPlaySettings != null ? this.imageBasedTrickPlaySettings.toBuilder() : null;
        }

        public final void setImageBasedTrickPlaySettings(CmafImageBasedTrickPlaySettings.BuilderImpl imageBasedTrickPlaySettings) {
            this.imageBasedTrickPlaySettings = imageBasedTrickPlaySettings != null ? imageBasedTrickPlaySettings.build() : null;
        }

        @Override
        public final Builder imageBasedTrickPlaySettings(CmafImageBasedTrickPlaySettings imageBasedTrickPlaySettings) {
            this.imageBasedTrickPlaySettings = imageBasedTrickPlaySettings;
            return this;
        }

        public final String getManifestCompression() {
            return this.manifestCompression;
        }

        public final void setManifestCompression(String manifestCompression) {
            this.manifestCompression = manifestCompression;
        }

        @Override
        public final Builder manifestCompression(String manifestCompression) {
            this.manifestCompression = manifestCompression;
            return this;
        }

        @Override
        public final Builder manifestCompression(CmafManifestCompression manifestCompression) {
            this.manifestCompression(manifestCompression == null ? null : manifestCompression.toString());
            return this;
        }

        public final String getManifestDurationFormat() {
            return this.manifestDurationFormat;
        }

        public final void setManifestDurationFormat(String manifestDurationFormat) {
            this.manifestDurationFormat = manifestDurationFormat;
        }

        @Override
        public final Builder manifestDurationFormat(String manifestDurationFormat) {
            this.manifestDurationFormat = manifestDurationFormat;
            return this;
        }

        @Override
        public final Builder manifestDurationFormat(CmafManifestDurationFormat manifestDurationFormat) {
            this.manifestDurationFormat(manifestDurationFormat == null ? null : manifestDurationFormat.toString());
            return this;
        }

        public final Integer getMinBufferTime() {
            return this.minBufferTime;
        }

        public final void setMinBufferTime(Integer minBufferTime) {
            this.minBufferTime = minBufferTime;
        }

        @Override
        public final Builder minBufferTime(Integer minBufferTime) {
            this.minBufferTime = minBufferTime;
            return this;
        }

        public final Double getMinFinalSegmentLength() {
            return this.minFinalSegmentLength;
        }

        public final void setMinFinalSegmentLength(Double minFinalSegmentLength) {
            this.minFinalSegmentLength = minFinalSegmentLength;
        }

        @Override
        public final Builder minFinalSegmentLength(Double minFinalSegmentLength) {
            this.minFinalSegmentLength = minFinalSegmentLength;
            return this;
        }

        public final String getMpdManifestBandwidthType() {
            return this.mpdManifestBandwidthType;
        }

        public final void setMpdManifestBandwidthType(String mpdManifestBandwidthType) {
            this.mpdManifestBandwidthType = mpdManifestBandwidthType;
        }

        @Override
        public final Builder mpdManifestBandwidthType(String mpdManifestBandwidthType) {
            this.mpdManifestBandwidthType = mpdManifestBandwidthType;
            return this;
        }

        @Override
        public final Builder mpdManifestBandwidthType(CmafMpdManifestBandwidthType mpdManifestBandwidthType) {
            this.mpdManifestBandwidthType(mpdManifestBandwidthType == null ? null : mpdManifestBandwidthType.toString());
            return this;
        }

        public final String getMpdProfile() {
            return this.mpdProfile;
        }

        public final void setMpdProfile(String mpdProfile) {
            this.mpdProfile = mpdProfile;
        }

        @Override
        public final Builder mpdProfile(String mpdProfile) {
            this.mpdProfile = mpdProfile;
            return this;
        }

        @Override
        public final Builder mpdProfile(CmafMpdProfile mpdProfile) {
            this.mpdProfile(mpdProfile == null ? null : mpdProfile.toString());
            return this;
        }

        public final String getPtsOffsetHandlingForBFrames() {
            return this.ptsOffsetHandlingForBFrames;
        }

        public final void setPtsOffsetHandlingForBFrames(String ptsOffsetHandlingForBFrames) {
            this.ptsOffsetHandlingForBFrames = ptsOffsetHandlingForBFrames;
        }

        @Override
        public final Builder ptsOffsetHandlingForBFrames(String ptsOffsetHandlingForBFrames) {
            this.ptsOffsetHandlingForBFrames = ptsOffsetHandlingForBFrames;
            return this;
        }

        @Override
        public final Builder ptsOffsetHandlingForBFrames(CmafPtsOffsetHandlingForBFrames ptsOffsetHandlingForBFrames) {
            this.ptsOffsetHandlingForBFrames(ptsOffsetHandlingForBFrames == null ? null : ptsOffsetHandlingForBFrames.toString());
            return this;
        }

        public final String getSegmentControl() {
            return this.segmentControl;
        }

        public final void setSegmentControl(String segmentControl) {
            this.segmentControl = segmentControl;
        }

        @Override
        public final Builder segmentControl(String segmentControl) {
            this.segmentControl = segmentControl;
            return this;
        }

        @Override
        public final Builder segmentControl(CmafSegmentControl segmentControl) {
            this.segmentControl(segmentControl == null ? null : segmentControl.toString());
            return this;
        }

        public final Integer getSegmentLength() {
            return this.segmentLength;
        }

        public final void setSegmentLength(Integer segmentLength) {
            this.segmentLength = segmentLength;
        }

        @Override
        public final Builder segmentLength(Integer segmentLength) {
            this.segmentLength = segmentLength;
            return this;
        }

        public final String getSegmentLengthControl() {
            return this.segmentLengthControl;
        }

        public final void setSegmentLengthControl(String segmentLengthControl) {
            this.segmentLengthControl = segmentLengthControl;
        }

        @Override
        public final Builder segmentLengthControl(String segmentLengthControl) {
            this.segmentLengthControl = segmentLengthControl;
            return this;
        }

        @Override
        public final Builder segmentLengthControl(CmafSegmentLengthControl segmentLengthControl) {
            this.segmentLengthControl(segmentLengthControl == null ? null : segmentLengthControl.toString());
            return this;
        }

        public final String getStreamInfResolution() {
            return this.streamInfResolution;
        }

        public final void setStreamInfResolution(String streamInfResolution) {
            this.streamInfResolution = streamInfResolution;
        }

        @Override
        public final Builder streamInfResolution(String streamInfResolution) {
            this.streamInfResolution = streamInfResolution;
            return this;
        }

        @Override
        public final Builder streamInfResolution(CmafStreamInfResolution streamInfResolution) {
            this.streamInfResolution(streamInfResolution == null ? null : streamInfResolution.toString());
            return this;
        }

        public final String getTargetDurationCompatibilityMode() {
            return this.targetDurationCompatibilityMode;
        }

        public final void setTargetDurationCompatibilityMode(String targetDurationCompatibilityMode) {
            this.targetDurationCompatibilityMode = targetDurationCompatibilityMode;
        }

        @Override
        public final Builder targetDurationCompatibilityMode(String targetDurationCompatibilityMode) {
            this.targetDurationCompatibilityMode = targetDurationCompatibilityMode;
            return this;
        }

        @Override
        public final Builder targetDurationCompatibilityMode(CmafTargetDurationCompatibilityMode targetDurationCompatibilityMode) {
            this.targetDurationCompatibilityMode(targetDurationCompatibilityMode == null ? null : targetDurationCompatibilityMode.toString());
            return this;
        }

        public final String getVideoCompositionOffsets() {
            return this.videoCompositionOffsets;
        }

        public final void setVideoCompositionOffsets(String videoCompositionOffsets) {
            this.videoCompositionOffsets = videoCompositionOffsets;
        }

        @Override
        public final Builder videoCompositionOffsets(String videoCompositionOffsets) {
            this.videoCompositionOffsets = videoCompositionOffsets;
            return this;
        }

        @Override
        public final Builder videoCompositionOffsets(CmafVideoCompositionOffsets videoCompositionOffsets) {
            this.videoCompositionOffsets(videoCompositionOffsets == null ? null : videoCompositionOffsets.toString());
            return this;
        }

        public final String getWriteDashManifest() {
            return this.writeDashManifest;
        }

        public final void setWriteDashManifest(String writeDashManifest) {
            this.writeDashManifest = writeDashManifest;
        }

        @Override
        public final Builder writeDashManifest(String writeDashManifest) {
            this.writeDashManifest = writeDashManifest;
            return this;
        }

        @Override
        public final Builder writeDashManifest(CmafWriteDASHManifest writeDashManifest) {
            this.writeDashManifest(writeDashManifest == null ? null : writeDashManifest.toString());
            return this;
        }

        public final String getWriteHlsManifest() {
            return this.writeHlsManifest;
        }

        public final void setWriteHlsManifest(String writeHlsManifest) {
            this.writeHlsManifest = writeHlsManifest;
        }

        @Override
        public final Builder writeHlsManifest(String writeHlsManifest) {
            this.writeHlsManifest = writeHlsManifest;
            return this;
        }

        @Override
        public final Builder writeHlsManifest(CmafWriteHLSManifest writeHlsManifest) {
            this.writeHlsManifest(writeHlsManifest == null ? null : writeHlsManifest.toString());
            return this;
        }

        public final String getWriteSegmentTimelineInRepresentation() {
            return this.writeSegmentTimelineInRepresentation;
        }

        public final void setWriteSegmentTimelineInRepresentation(String writeSegmentTimelineInRepresentation) {
            this.writeSegmentTimelineInRepresentation = writeSegmentTimelineInRepresentation;
        }

        @Override
        public final Builder writeSegmentTimelineInRepresentation(String writeSegmentTimelineInRepresentation) {
            this.writeSegmentTimelineInRepresentation = writeSegmentTimelineInRepresentation;
            return this;
        }

        @Override
        public final Builder writeSegmentTimelineInRepresentation(CmafWriteSegmentTimelineInRepresentation writeSegmentTimelineInRepresentation) {
            this.writeSegmentTimelineInRepresentation(writeSegmentTimelineInRepresentation == null ? null : writeSegmentTimelineInRepresentation.toString());
            return this;
        }

        public CmafGroupSettings build() {
            return new CmafGroupSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CmafGroupSettings> {
        public Builder additionalManifests(Collection<CmafAdditionalManifest> var1);

        public Builder additionalManifests(CmafAdditionalManifest ... var1);

        public Builder additionalManifests(Consumer<CmafAdditionalManifest.Builder> ... var1);

        public Builder baseUrl(String var1);

        public Builder clientCache(String var1);

        public Builder clientCache(CmafClientCache var1);

        public Builder codecSpecification(String var1);

        public Builder codecSpecification(CmafCodecSpecification var1);

        public Builder dashIFrameTrickPlayNameModifier(String var1);

        public Builder dashManifestStyle(String var1);

        public Builder dashManifestStyle(DashManifestStyle var1);

        public Builder destination(String var1);

        public Builder destinationSettings(DestinationSettings var1);

        default public Builder destinationSettings(Consumer<DestinationSettings.Builder> destinationSettings) {
            return this.destinationSettings((DestinationSettings)((DestinationSettings.Builder)DestinationSettings.builder().applyMutation(destinationSettings)).build());
        }

        public Builder encryption(CmafEncryptionSettings var1);

        default public Builder encryption(Consumer<CmafEncryptionSettings.Builder> encryption) {
            return this.encryption((CmafEncryptionSettings)((CmafEncryptionSettings.Builder)CmafEncryptionSettings.builder().applyMutation(encryption)).build());
        }

        public Builder fragmentLength(Integer var1);

        public Builder imageBasedTrickPlay(String var1);

        public Builder imageBasedTrickPlay(CmafImageBasedTrickPlay var1);

        public Builder imageBasedTrickPlaySettings(CmafImageBasedTrickPlaySettings var1);

        default public Builder imageBasedTrickPlaySettings(Consumer<CmafImageBasedTrickPlaySettings.Builder> imageBasedTrickPlaySettings) {
            return this.imageBasedTrickPlaySettings((CmafImageBasedTrickPlaySettings)((CmafImageBasedTrickPlaySettings.Builder)CmafImageBasedTrickPlaySettings.builder().applyMutation(imageBasedTrickPlaySettings)).build());
        }

        public Builder manifestCompression(String var1);

        public Builder manifestCompression(CmafManifestCompression var1);

        public Builder manifestDurationFormat(String var1);

        public Builder manifestDurationFormat(CmafManifestDurationFormat var1);

        public Builder minBufferTime(Integer var1);

        public Builder minFinalSegmentLength(Double var1);

        public Builder mpdManifestBandwidthType(String var1);

        public Builder mpdManifestBandwidthType(CmafMpdManifestBandwidthType var1);

        public Builder mpdProfile(String var1);

        public Builder mpdProfile(CmafMpdProfile var1);

        public Builder ptsOffsetHandlingForBFrames(String var1);

        public Builder ptsOffsetHandlingForBFrames(CmafPtsOffsetHandlingForBFrames var1);

        public Builder segmentControl(String var1);

        public Builder segmentControl(CmafSegmentControl var1);

        public Builder segmentLength(Integer var1);

        public Builder segmentLengthControl(String var1);

        public Builder segmentLengthControl(CmafSegmentLengthControl var1);

        public Builder streamInfResolution(String var1);

        public Builder streamInfResolution(CmafStreamInfResolution var1);

        public Builder targetDurationCompatibilityMode(String var1);

        public Builder targetDurationCompatibilityMode(CmafTargetDurationCompatibilityMode var1);

        public Builder videoCompositionOffsets(String var1);

        public Builder videoCompositionOffsets(CmafVideoCompositionOffsets var1);

        public Builder writeDashManifest(String var1);

        public Builder writeDashManifest(CmafWriteDASHManifest var1);

        public Builder writeHlsManifest(String var1);

        public Builder writeHlsManifest(CmafWriteHLSManifest var1);

        public Builder writeSegmentTimelineInRepresentation(String var1);

        public Builder writeSegmentTimelineInRepresentation(CmafWriteSegmentTimelineInRepresentation var1);
    }
}

