/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum JobsQueryFilterKey {
    QUEUE("queue"),
    STATUS("status"),
    FILE_INPUT("fileInput"),
    JOB_ENGINE_VERSION_REQUESTED("jobEngineVersionRequested"),
    JOB_ENGINE_VERSION_USED("jobEngineVersionUsed"),
    AUDIO_CODEC("audioCodec"),
    VIDEO_CODEC("videoCodec"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, JobsQueryFilterKey> VALUE_MAP;
    private final String value;

    private JobsQueryFilterKey(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static JobsQueryFilterKey fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<JobsQueryFilterKey> knownValues() {
        EnumSet<JobsQueryFilterKey> knownValues = EnumSet.allOf(JobsQueryFilterKey.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(JobsQueryFilterKey.class, JobsQueryFilterKey::toString);
    }
}

