/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mediaconvert.model.MxfXavcDurationMode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MxfXavcProfileSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MxfXavcProfileSettings> {
    private static final SdkField<String> DURATION_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DurationMode").getter(MxfXavcProfileSettings.getter(MxfXavcProfileSettings::durationModeAsString)).setter(MxfXavcProfileSettings.setter(Builder::durationMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("durationMode").build()}).build();
    private static final SdkField<Integer> MAX_ANC_DATA_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxAncDataSize").getter(MxfXavcProfileSettings.getter(MxfXavcProfileSettings::maxAncDataSize)).setter(MxfXavcProfileSettings.setter(Builder::maxAncDataSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxAncDataSize").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DURATION_MODE_FIELD, MAX_ANC_DATA_SIZE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = MxfXavcProfileSettings.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String durationMode;
    private final Integer maxAncDataSize;

    private MxfXavcProfileSettings(BuilderImpl builder) {
        this.durationMode = builder.durationMode;
        this.maxAncDataSize = builder.maxAncDataSize;
    }

    public final MxfXavcDurationMode durationMode() {
        return MxfXavcDurationMode.fromValue(this.durationMode);
    }

    public final String durationModeAsString() {
        return this.durationMode;
    }

    public final Integer maxAncDataSize() {
        return this.maxAncDataSize;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.durationModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxAncDataSize());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MxfXavcProfileSettings)) {
            return false;
        }
        MxfXavcProfileSettings other = (MxfXavcProfileSettings)obj;
        return Objects.equals(this.durationModeAsString(), other.durationModeAsString()) && Objects.equals(this.maxAncDataSize(), other.maxAncDataSize());
    }

    public final String toString() {
        return ToString.builder((String)"MxfXavcProfileSettings").add("DurationMode", (Object)this.durationModeAsString()).add("MaxAncDataSize", (Object)this.maxAncDataSize()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DurationMode": {
                return Optional.ofNullable(clazz.cast(this.durationModeAsString()));
            }
            case "MaxAncDataSize": {
                return Optional.ofNullable(clazz.cast(this.maxAncDataSize()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("durationMode", DURATION_MODE_FIELD);
        map.put("maxAncDataSize", MAX_ANC_DATA_SIZE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MxfXavcProfileSettings, T> g) {
        return obj -> g.apply((MxfXavcProfileSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String durationMode;
        private Integer maxAncDataSize;

        private BuilderImpl() {
        }

        private BuilderImpl(MxfXavcProfileSettings model) {
            this.durationMode(model.durationMode);
            this.maxAncDataSize(model.maxAncDataSize);
        }

        public final String getDurationMode() {
            return this.durationMode;
        }

        public final void setDurationMode(String durationMode) {
            this.durationMode = durationMode;
        }

        @Override
        public final Builder durationMode(String durationMode) {
            this.durationMode = durationMode;
            return this;
        }

        @Override
        public final Builder durationMode(MxfXavcDurationMode durationMode) {
            this.durationMode(durationMode == null ? null : durationMode.toString());
            return this;
        }

        public final Integer getMaxAncDataSize() {
            return this.maxAncDataSize;
        }

        public final void setMaxAncDataSize(Integer maxAncDataSize) {
            this.maxAncDataSize = maxAncDataSize;
        }

        @Override
        public final Builder maxAncDataSize(Integer maxAncDataSize) {
            this.maxAncDataSize = maxAncDataSize;
            return this;
        }

        public MxfXavcProfileSettings build() {
            return new MxfXavcProfileSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MxfXavcProfileSettings> {
        public Builder durationMode(String var1);

        public Builder durationMode(MxfXavcDurationMode var1);

        public Builder maxAncDataSize(Integer var1);
    }
}

