/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.medialive.model.MediaLiveResponse;
import software.amazon.awssdk.services.medialive.model.MultiplexProgramSummary;
import software.amazon.awssdk.services.medialive.model.___listOfMultiplexProgramSummaryCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListMultiplexProgramsResponse
extends MediaLiveResponse
implements ToCopyableBuilder<Builder, ListMultiplexProgramsResponse> {
    private static final SdkField<List<MultiplexProgramSummary>> MULTIPLEX_PROGRAMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("MultiplexPrograms").getter(ListMultiplexProgramsResponse.getter(ListMultiplexProgramsResponse::multiplexPrograms)).setter(ListMultiplexProgramsResponse.setter(Builder::multiplexPrograms)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("multiplexPrograms").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MultiplexProgramSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListMultiplexProgramsResponse.getter(ListMultiplexProgramsResponse::nextToken)).setter(ListMultiplexProgramsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MULTIPLEX_PROGRAMS_FIELD, NEXT_TOKEN_FIELD));
    private final List<MultiplexProgramSummary> multiplexPrograms;
    private final String nextToken;

    private ListMultiplexProgramsResponse(BuilderImpl builder) {
        super(builder);
        this.multiplexPrograms = builder.multiplexPrograms;
        this.nextToken = builder.nextToken;
    }

    public boolean hasMultiplexPrograms() {
        return this.multiplexPrograms != null && !(this.multiplexPrograms instanceof SdkAutoConstructList);
    }

    public List<MultiplexProgramSummary> multiplexPrograms() {
        return this.multiplexPrograms;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMultiplexPrograms() ? this.multiplexPrograms() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListMultiplexProgramsResponse)) {
            return false;
        }
        ListMultiplexProgramsResponse other = (ListMultiplexProgramsResponse)((Object)obj);
        return this.hasMultiplexPrograms() == other.hasMultiplexPrograms() && Objects.equals(this.multiplexPrograms(), other.multiplexPrograms()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListMultiplexProgramsResponse").add("MultiplexPrograms", this.hasMultiplexPrograms() ? this.multiplexPrograms() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MultiplexPrograms": {
                return Optional.ofNullable(clazz.cast(this.multiplexPrograms()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListMultiplexProgramsResponse, T> g) {
        return obj -> g.apply((ListMultiplexProgramsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MediaLiveResponse.BuilderImpl
    implements Builder {
        private List<MultiplexProgramSummary> multiplexPrograms = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListMultiplexProgramsResponse model) {
            super(model);
            this.multiplexPrograms(model.multiplexPrograms);
            this.nextToken(model.nextToken);
        }

        public final Collection<MultiplexProgramSummary.Builder> getMultiplexPrograms() {
            if (this.multiplexPrograms instanceof SdkAutoConstructList) {
                return null;
            }
            return this.multiplexPrograms != null ? (Collection)this.multiplexPrograms.stream().map(MultiplexProgramSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder multiplexPrograms(Collection<MultiplexProgramSummary> multiplexPrograms) {
            this.multiplexPrograms = ___listOfMultiplexProgramSummaryCopier.copy(multiplexPrograms);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder multiplexPrograms(MultiplexProgramSummary ... multiplexPrograms) {
            this.multiplexPrograms(Arrays.asList(multiplexPrograms));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder multiplexPrograms(Consumer<MultiplexProgramSummary.Builder> ... multiplexPrograms) {
            this.multiplexPrograms(Stream.of(multiplexPrograms).map(c -> (MultiplexProgramSummary)((MultiplexProgramSummary.Builder)MultiplexProgramSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setMultiplexPrograms(Collection<MultiplexProgramSummary.BuilderImpl> multiplexPrograms) {
            this.multiplexPrograms = ___listOfMultiplexProgramSummaryCopier.copyFromBuilder(multiplexPrograms);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListMultiplexProgramsResponse build() {
            return new ListMultiplexProgramsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends MediaLiveResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListMultiplexProgramsResponse> {
        public Builder multiplexPrograms(Collection<MultiplexProgramSummary> var1);

        public Builder multiplexPrograms(MultiplexProgramSummary ... var1);

        public Builder multiplexPrograms(Consumer<MultiplexProgramSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

