/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Audio Selector
 */
@Generated("software.amazon.awssdk:codegen")
public final class AudioSelector implements SdkPojo, Serializable, ToCopyableBuilder<AudioSelector.Builder, AudioSelector> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(AudioSelector::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<AudioSelectorSettings> SELECTOR_SETTINGS_FIELD = SdkField
            .<AudioSelectorSettings> builder(MarshallingType.SDK_POJO).memberName("SelectorSettings")
            .getter(getter(AudioSelector::selectorSettings)).setter(setter(Builder::selectorSettings))
            .constructor(AudioSelectorSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("selectorSettings").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD,
            SELECTOR_SETTINGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final AudioSelectorSettings selectorSettings;

    private AudioSelector(BuilderImpl builder) {
        this.name = builder.name;
        this.selectorSettings = builder.selectorSettings;
    }

    /**
     * The name of this AudioSelector. AudioDescriptions will use this name to uniquely identify this Selector. Selector
     * names should be unique per input.
     * 
     * @return The name of this AudioSelector. AudioDescriptions will use this name to uniquely identify this Selector.
     *         Selector names should be unique per input.
     */
    public final String name() {
        return name;
    }

    /**
     * The audio selector settings.
     * 
     * @return The audio selector settings.
     */
    public final AudioSelectorSettings selectorSettings() {
        return selectorSettings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(selectorSettings());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AudioSelector)) {
            return false;
        }
        AudioSelector other = (AudioSelector) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(selectorSettings(), other.selectorSettings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AudioSelector").add("Name", name()).add("SelectorSettings", selectorSettings()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "SelectorSettings":
            return Optional.ofNullable(clazz.cast(selectorSettings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AudioSelector, T> g) {
        return obj -> g.apply((AudioSelector) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AudioSelector> {
        /**
         * The name of this AudioSelector. AudioDescriptions will use this name to uniquely identify this Selector.
         * Selector names should be unique per input.
         * 
         * @param name
         *        The name of this AudioSelector. AudioDescriptions will use this name to uniquely identify this
         *        Selector. Selector names should be unique per input.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * The audio selector settings.
         * 
         * @param selectorSettings
         *        The audio selector settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder selectorSettings(AudioSelectorSettings selectorSettings);

        /**
         * The audio selector settings. This is a convenience that creates an instance of the
         * {@link AudioSelectorSettings.Builder} avoiding the need to create one manually via
         * {@link AudioSelectorSettings#builder()}.
         *
         * When the {@link Consumer} completes, {@link AudioSelectorSettings.Builder#build()} is called immediately and
         * its result is passed to {@link #selectorSettings(AudioSelectorSettings)}.
         * 
         * @param selectorSettings
         *        a consumer that will call methods on {@link AudioSelectorSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #selectorSettings(AudioSelectorSettings)
         */
        default Builder selectorSettings(Consumer<AudioSelectorSettings.Builder> selectorSettings) {
            return selectorSettings(AudioSelectorSettings.builder().applyMutation(selectorSettings).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private AudioSelectorSettings selectorSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(AudioSelector model) {
            name(model.name);
            selectorSettings(model.selectorSettings);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final AudioSelectorSettings.Builder getSelectorSettings() {
            return selectorSettings != null ? selectorSettings.toBuilder() : null;
        }

        @Override
        public final Builder selectorSettings(AudioSelectorSettings selectorSettings) {
            this.selectorSettings = selectorSettings;
            return this;
        }

        public final void setSelectorSettings(AudioSelectorSettings.BuilderImpl selectorSettings) {
            this.selectorSettings = selectorSettings != null ? selectorSettings.build() : null;
        }

        @Override
        public AudioSelector build() {
            return new AudioSelector(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
