/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Placeholder documentation for AudioSilenceFailoverSettings
 */
@Generated("software.amazon.awssdk:codegen")
public final class AudioSilenceFailoverSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<AudioSilenceFailoverSettings.Builder, AudioSilenceFailoverSettings> {
    private static final SdkField<String> AUDIO_SELECTOR_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AudioSelectorName").getter(getter(AudioSilenceFailoverSettings::audioSelectorName))
            .setter(setter(Builder::audioSelectorName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("audioSelectorName").build()).build();

    private static final SdkField<Integer> AUDIO_SILENCE_THRESHOLD_MSEC_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER).memberName("AudioSilenceThresholdMsec")
            .getter(getter(AudioSilenceFailoverSettings::audioSilenceThresholdMsec))
            .setter(setter(Builder::audioSilenceThresholdMsec))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("audioSilenceThresholdMsec").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUDIO_SELECTOR_NAME_FIELD,
            AUDIO_SILENCE_THRESHOLD_MSEC_FIELD));

    private static final long serialVersionUID = 1L;

    private final String audioSelectorName;

    private final Integer audioSilenceThresholdMsec;

    private AudioSilenceFailoverSettings(BuilderImpl builder) {
        this.audioSelectorName = builder.audioSelectorName;
        this.audioSilenceThresholdMsec = builder.audioSilenceThresholdMsec;
    }

    /**
     * The name of the audio selector in the input that MediaLive should monitor to detect silence. Select your most
     * important rendition. If you didn't create an audio selector in this input, leave blank.
     * 
     * @return The name of the audio selector in the input that MediaLive should monitor to detect silence. Select your
     *         most important rendition. If you didn't create an audio selector in this input, leave blank.
     */
    public final String audioSelectorName() {
        return audioSelectorName;
    }

    /**
     * The amount of time (in milliseconds) that the active input must be silent before automatic input failover occurs.
     * Silence is defined as audio loss or audio quieter than -50 dBFS.
     * 
     * @return The amount of time (in milliseconds) that the active input must be silent before automatic input failover
     *         occurs. Silence is defined as audio loss or audio quieter than -50 dBFS.
     */
    public final Integer audioSilenceThresholdMsec() {
        return audioSilenceThresholdMsec;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(audioSelectorName());
        hashCode = 31 * hashCode + Objects.hashCode(audioSilenceThresholdMsec());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AudioSilenceFailoverSettings)) {
            return false;
        }
        AudioSilenceFailoverSettings other = (AudioSilenceFailoverSettings) obj;
        return Objects.equals(audioSelectorName(), other.audioSelectorName())
                && Objects.equals(audioSilenceThresholdMsec(), other.audioSilenceThresholdMsec());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AudioSilenceFailoverSettings").add("AudioSelectorName", audioSelectorName())
                .add("AudioSilenceThresholdMsec", audioSilenceThresholdMsec()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AudioSelectorName":
            return Optional.ofNullable(clazz.cast(audioSelectorName()));
        case "AudioSilenceThresholdMsec":
            return Optional.ofNullable(clazz.cast(audioSilenceThresholdMsec()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AudioSilenceFailoverSettings, T> g) {
        return obj -> g.apply((AudioSilenceFailoverSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AudioSilenceFailoverSettings> {
        /**
         * The name of the audio selector in the input that MediaLive should monitor to detect silence. Select your most
         * important rendition. If you didn't create an audio selector in this input, leave blank.
         * 
         * @param audioSelectorName
         *        The name of the audio selector in the input that MediaLive should monitor to detect silence. Select
         *        your most important rendition. If you didn't create an audio selector in this input, leave blank.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder audioSelectorName(String audioSelectorName);

        /**
         * The amount of time (in milliseconds) that the active input must be silent before automatic input failover
         * occurs. Silence is defined as audio loss or audio quieter than -50 dBFS.
         * 
         * @param audioSilenceThresholdMsec
         *        The amount of time (in milliseconds) that the active input must be silent before automatic input
         *        failover occurs. Silence is defined as audio loss or audio quieter than -50 dBFS.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder audioSilenceThresholdMsec(Integer audioSilenceThresholdMsec);
    }

    static final class BuilderImpl implements Builder {
        private String audioSelectorName;

        private Integer audioSilenceThresholdMsec;

        private BuilderImpl() {
        }

        private BuilderImpl(AudioSilenceFailoverSettings model) {
            audioSelectorName(model.audioSelectorName);
            audioSilenceThresholdMsec(model.audioSilenceThresholdMsec);
        }

        public final String getAudioSelectorName() {
            return audioSelectorName;
        }

        @Override
        public final Builder audioSelectorName(String audioSelectorName) {
            this.audioSelectorName = audioSelectorName;
            return this;
        }

        public final void setAudioSelectorName(String audioSelectorName) {
            this.audioSelectorName = audioSelectorName;
        }

        public final Integer getAudioSilenceThresholdMsec() {
            return audioSilenceThresholdMsec;
        }

        @Override
        public final Builder audioSilenceThresholdMsec(Integer audioSilenceThresholdMsec) {
            this.audioSilenceThresholdMsec = audioSilenceThresholdMsec;
            return this;
        }

        public final void setAudioSilenceThresholdMsec(Integer audioSilenceThresholdMsec) {
            this.audioSilenceThresholdMsec = audioSilenceThresholdMsec;
        }

        @Override
        public AudioSilenceFailoverSettings build() {
            return new AudioSilenceFailoverSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
