/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Audio Track Selection
 */
@Generated("software.amazon.awssdk:codegen")
public final class AudioTrackSelection implements SdkPojo, Serializable,
        ToCopyableBuilder<AudioTrackSelection.Builder, AudioTrackSelection> {
    private static final SdkField<List<AudioTrack>> TRACKS_FIELD = SdkField
            .<List<AudioTrack>> builder(MarshallingType.LIST)
            .memberName("Tracks")
            .getter(getter(AudioTrackSelection::tracks))
            .setter(setter(Builder::tracks))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tracks").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AudioTrack> builder(MarshallingType.SDK_POJO)
                                            .constructor(AudioTrack::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRACKS_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<AudioTrack> tracks;

    private AudioTrackSelection(BuilderImpl builder) {
        this.tracks = builder.tracks;
    }

    /**
     * Returns true if the Tracks property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasTracks() {
        return tracks != null && !(tracks instanceof SdkAutoConstructList);
    }

    /**
     * Selects one or more unique audio tracks from within a source.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTracks()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Selects one or more unique audio tracks from within a source.
     */
    public final List<AudioTrack> tracks() {
        return tracks;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasTracks() ? tracks() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AudioTrackSelection)) {
            return false;
        }
        AudioTrackSelection other = (AudioTrackSelection) obj;
        return hasTracks() == other.hasTracks() && Objects.equals(tracks(), other.tracks());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AudioTrackSelection").add("Tracks", hasTracks() ? tracks() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Tracks":
            return Optional.ofNullable(clazz.cast(tracks()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AudioTrackSelection, T> g) {
        return obj -> g.apply((AudioTrackSelection) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AudioTrackSelection> {
        /**
         * Selects one or more unique audio tracks from within a source.
         * 
         * @param tracks
         *        Selects one or more unique audio tracks from within a source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tracks(Collection<AudioTrack> tracks);

        /**
         * Selects one or more unique audio tracks from within a source.
         * 
         * @param tracks
         *        Selects one or more unique audio tracks from within a source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tracks(AudioTrack... tracks);

        /**
         * Selects one or more unique audio tracks from within a source. This is a convenience that creates an instance
         * of the {@link List<AudioTrack>.Builder} avoiding the need to create one manually via {@link List
         * <AudioTrack>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AudioTrack>.Builder#build()} is called immediately and its
         * result is passed to {@link #tracks(List<AudioTrack>)}.
         * 
         * @param tracks
         *        a consumer that will call methods on {@link List<AudioTrack>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tracks(List<AudioTrack>)
         */
        Builder tracks(Consumer<AudioTrack.Builder>... tracks);
    }

    static final class BuilderImpl implements Builder {
        private List<AudioTrack> tracks = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AudioTrackSelection model) {
            tracks(model.tracks);
        }

        public final List<AudioTrack.Builder> getTracks() {
            List<AudioTrack.Builder> result = ___listOfAudioTrackCopier.copyToBuilder(this.tracks);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder tracks(Collection<AudioTrack> tracks) {
            this.tracks = ___listOfAudioTrackCopier.copy(tracks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tracks(AudioTrack... tracks) {
            tracks(Arrays.asList(tracks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tracks(Consumer<AudioTrack.Builder>... tracks) {
            tracks(Stream.of(tracks).map(c -> AudioTrack.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTracks(Collection<AudioTrack.BuilderImpl> tracks) {
            this.tracks = ___listOfAudioTrackCopier.copyFromBuilder(tracks);
        }

        @Override
        public AudioTrackSelection build() {
            return new AudioTrackSelection(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
